//  SHA1Hash: a1229aa14c68226f90318cbf8b925c8549d795d0
/*
 * Copyright (C) 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

template<>
auto LLIntGenerator::addOp<OpType::I32Add>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Add::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Sub>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Sub::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Mul>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Mul::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32DivS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32DivS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32DivU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32DivU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32RemS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32RemS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32RemU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32RemU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32And>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32And::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Or>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Or::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Xor>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Xor::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Shl>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Shl::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32ShrU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32ShrU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32ShrS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32ShrS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Rotr>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Rotr::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Rotl>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Rotl::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Eq>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Eq::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Ne>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Ne::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32LtS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32LtS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32LeS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32LeS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32LtU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32LtU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32LeU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32LeU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32GtS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32GtS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32GeS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32GeS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32GtU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32GtU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32GeU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32GeU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Clz>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Clz::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Ctz>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Ctz::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Popcnt>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Popcnt::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32Eqz>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32Eqz::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Add>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Add::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Sub>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Sub::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Mul>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Mul::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64DivS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64DivS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64DivU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64DivU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64RemS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64RemS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64RemU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64RemU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64And>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64And::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Or>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Or::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Xor>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Xor::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Shl>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Shl::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64ShrU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64ShrU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64ShrS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64ShrS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Rotr>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Rotr::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Rotl>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Rotl::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Eq>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Eq::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Ne>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Ne::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64LtS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64LtS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64LeS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64LeS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64LtU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64LtU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64LeU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64LeU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64GtS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64GtS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64GeS>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64GeS::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64GtU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64GtU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64GeU>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64GeU::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Clz>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Clz::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Ctz>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Ctz::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Popcnt>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Popcnt::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64Eqz>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64Eqz::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Add>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Add::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Sub>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Sub::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Mul>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Mul::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Div>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Div::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Min>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Min::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Max>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Max::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Abs>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Abs::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Neg>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Neg::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Copysign>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Copysign::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Ceil>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Ceil::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Floor>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Floor::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Trunc>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Trunc::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Nearest>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Nearest::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Sqrt>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Sqrt::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Eq>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Eq::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Ne>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Ne::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Lt>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Lt::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Le>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Le::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Gt>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Gt::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32Ge>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32Ge::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Add>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Add::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Sub>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Sub::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Mul>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Mul::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Div>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Div::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Min>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Min::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Max>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Max::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Abs>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Abs::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Neg>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Neg::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Copysign>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Copysign::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Ceil>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Ceil::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Floor>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Floor::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Trunc>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Trunc::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Nearest>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Nearest::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Sqrt>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Sqrt::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Eq>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Eq::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Ne>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Ne::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Lt>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Lt::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Le>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Le::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Gt>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Gt::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64Ge>(ExpressionType lhs, ExpressionType rhs, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64Ge::emit(this, result, lhs, rhs);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32TruncSF32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32TruncSF32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32TruncSF64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32TruncSF64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32TruncUF32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32TruncUF32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32TruncUF64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32TruncUF64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32WrapI64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32WrapI64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64TruncSF32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64TruncSF32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64TruncSF64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64TruncSF64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64TruncUF32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64TruncUF32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64TruncUF64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64TruncUF64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64ExtendSI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64ExtendSI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64ExtendUI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64ExtendUI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32ConvertSI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32ConvertSI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32ConvertUI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32ConvertUI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32ConvertSI64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32ConvertSI64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32ConvertUI64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32ConvertUI64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32DemoteF64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32DemoteF64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F32ReinterpretI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF32ReinterpretI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64ConvertSI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64ConvertSI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64ConvertUI32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64ConvertUI32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64ConvertSI64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64ConvertSI64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64ConvertUI64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64ConvertUI64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64PromoteF32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64PromoteF32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::F64ReinterpretI64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmF64ReinterpretI64::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I32ReinterpretF32>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI32ReinterpretF32::emit(this, result, operand);
    return { };
}

template<>
auto LLIntGenerator::addOp<OpType::I64ReinterpretF64>(ExpressionType operand, ExpressionType& result) -> PartialResult
{
    result = push();
    WasmI64ReinterpretF64::emit(this, result, operand);
    return { };
}

