/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "InspectorProtocolObjects.h"

#include <wtf/Optional.h>
#include <wtf/text/CString.h>

namespace Inspector {

namespace Protocol {

namespace InspectorHelpers {

static const char* const enum_constant_values[] = {
    "ready",
    "delayed",
    "active",
    "canceled",
    "done",
    "normal",
    "reverse",
    "alternate",
    "alternate-reverse",
    "none",
    "forwards",
    "backwards",
    "both",
    "auto",
    "main",
    "webkit",
    "user",
    "user-agent",
    "inspector",
    "regular",
    "first-line",
    "first-letter",
    "highlight",
    "marker",
    "before",
    "after",
    "selection",
    "scrollbar",
    "scrollbar-thumb",
    "scrollbar-button",
    "scrollbar-track",
    "scrollbar-track-piece",
    "scrollbar-corner",
    "resizer",
    "inactive",
    "disabled",
    "style",
    "media-rule",
    "media-import-rule",
    "media-link-node",
    "media-style-node",
    "supports-rule",
    "canvas-2d",
    "bitmaprenderer",
    "webgl",
    "webgl2",
    "webgpu",
    "compute",
    "render",
    "fragment",
    "vertex",
    "xml",
    "javascript",
    "network",
    "console-api",
    "storage",
    "appcache",
    "rendering",
    "css",
    "security",
    "content-blocker",
    "media",
    "mediasource",
    "webrtc",
    "other",
    "off",
    "basic",
    "verbose",
    "log",
    "info",
    "warning",
    "error",
    "debug",
    "dir",
    "dirxml",
    "table",
    "trace",
    "clear",
    "startGroup",
    "startGroupCollapsed",
    "endGroup",
    "assert",
    "timing",
    "profile",
    "profileEnd",
    "image",
    "open",
    "closed",
    "builtin",
    "custom",
    "waiting",
    "failed",
    "additions",
    "removals",
    "text",
    "true",
    "false",
    "mixed",
    "page",
    "step",
    "location",
    "date",
    "time",
    "grammar",
    "spelling",
    "assertive",
    "polite",
    "subtree-modified",
    "attribute-modified",
    "node-removed",
    "animation-frame",
    "interval",
    "listener",
    "timeout",
    "evaluate",
    "sound",
    "probe",
    "global",
    "with",
    "closure",
    "catch",
    "functionName",
    "globalLexicalEnvironment",
    "nestedLexical",
    "full",
    "partial",
    "number",
    "string",
    "array",
    "null",
    "jit",
    "images",
    "layers",
    "unknown",
    "memory-cache",
    "disk-cache",
    "service-worker",
    "inspector-override",
    "low",
    "medium",
    "high",
    "Document",
    "StyleSheet",
    "Image",
    "Font",
    "Script",
    "XHR",
    "Fetch",
    "Ping",
    "Beacon",
    "WebSocket",
    "Other",
    "parser",
    "script",
    "response",
    "AuthorAndUserStylesEnabled",
    "ICECandidateFilteringEnabled",
    "ImagesEnabled",
    "MediaCaptureRequiresSecureConnection",
    "MockCaptureDevicesEnabled",
    "NeedsSiteSpecificQuirks",
    "ScriptEnabled",
    "ShowDebugBorders",
    "ShowRepaintCounter",
    "WebRTCEncryptionEnabled",
    "WebSecurityEnabled",
    "Viewport",
    "Page",
    "None",
    "Lax",
    "Strict",
    "Light",
    "Dark",
    "canvas-bitmaprenderer",
    "canvas-webgl",
    "canvas-webgl2",
    "frontend",
    "console",
    "auto-capture",
    "object",
    "function",
    "undefined",
    "boolean",
    "symbol",
    "bigint",
    "node",
    "regexp",
    "map",
    "set",
    "weakmap",
    "weakset",
    "iterator",
    "class",
    "proxy",
    "accessor",
    "internal",
    "irrecoverable",
    "unterminated-literal",
    "recoverable",
    "API",
    "Microtask",
    "worker",
    "EventDispatch",
    "ScheduleStyleRecalculation",
    "RecalculateStyles",
    "InvalidateLayout",
    "Layout",
    "Paint",
    "Composite",
    "RenderingFrame",
    "TimerInstall",
    "TimerRemove",
    "TimerFire",
    "EvaluateScript",
    "TimeStamp",
    "Time",
    "TimeEnd",
    "FunctionCall",
    "ProbeSample",
    "ConsoleProfile",
    "RequestAnimationFrame",
    "CancelAnimationFrame",
    "FireAnimationFrame",
    "ObserverCallback",
    "ScriptProfiler",
    "Timeline",
    "CPU",
    "Memory",
    "Heap",
    "Animation",
    "DOM",
    "AnimationFrame",
    "Interval",
    "Listener",
    "Timeout",
    "exception",
    "CSPViolation",
    "DebuggerStatement",
    "Breakpoint",
    "PauseOnNextStatement",
    "BlackboxedScript",
    "critical",
    "non-critical",
    "uncaught",
    "all",
};

String getEnumConstantValue(int code) {
    return enum_constant_values[code];
}

// Enums in the 'Animation' Domain
template<>
Optional<Inspector::Protocol::Animation::AnimationState> parseEnumValueFromString<Inspector::Protocol::Animation::AnimationState>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Animation::AnimationState::Ready,
        (size_t)Inspector::Protocol::Animation::AnimationState::Delayed,
        (size_t)Inspector::Protocol::Animation::AnimationState::Active,
        (size_t)Inspector::Protocol::Animation::AnimationState::Canceled,
        (size_t)Inspector::Protocol::Animation::AnimationState::Done,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Animation::AnimationState)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Animation::PlaybackDirection> parseEnumValueFromString<Inspector::Protocol::Animation::PlaybackDirection>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Animation::PlaybackDirection::Normal,
        (size_t)Inspector::Protocol::Animation::PlaybackDirection::Reverse,
        (size_t)Inspector::Protocol::Animation::PlaybackDirection::Alternate,
        (size_t)Inspector::Protocol::Animation::PlaybackDirection::AlternateReverse,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Animation::PlaybackDirection)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Animation::FillMode> parseEnumValueFromString<Inspector::Protocol::Animation::FillMode>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Animation::FillMode::None,
        (size_t)Inspector::Protocol::Animation::FillMode::Forwards,
        (size_t)Inspector::Protocol::Animation::FillMode::Backwards,
        (size_t)Inspector::Protocol::Animation::FillMode::Both,
        (size_t)Inspector::Protocol::Animation::FillMode::Auto,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Animation::FillMode)constantValues[i];

    return WTF::nullopt;
}


#if ENABLE(RESOURCE_USAGE)
// Enums in the 'CPUProfiler' Domain
template<>
Optional<Inspector::Protocol::CPUProfiler::ThreadInfo::Type> parseEnumValueFromString<Inspector::Protocol::CPUProfiler::ThreadInfo::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::CPUProfiler::ThreadInfo::Type::Main,
        (size_t)Inspector::Protocol::CPUProfiler::ThreadInfo::Type::WebKit,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::CPUProfiler::ThreadInfo::Type)constantValues[i];

    return WTF::nullopt;
}

#endif // ENABLE(RESOURCE_USAGE)

// Enums in the 'CSS' Domain
template<>
Optional<Inspector::Protocol::CSS::StyleSheetOrigin> parseEnumValueFromString<Inspector::Protocol::CSS::StyleSheetOrigin>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::CSS::StyleSheetOrigin::User,
        (size_t)Inspector::Protocol::CSS::StyleSheetOrigin::UserAgent,
        (size_t)Inspector::Protocol::CSS::StyleSheetOrigin::Inspector,
        (size_t)Inspector::Protocol::CSS::StyleSheetOrigin::Regular,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::CSS::StyleSheetOrigin)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::CSS::PseudoId> parseEnumValueFromString<Inspector::Protocol::CSS::PseudoId>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::CSS::PseudoId::FirstLine,
        (size_t)Inspector::Protocol::CSS::PseudoId::FirstLetter,
        (size_t)Inspector::Protocol::CSS::PseudoId::Highlight,
        (size_t)Inspector::Protocol::CSS::PseudoId::Marker,
        (size_t)Inspector::Protocol::CSS::PseudoId::Before,
        (size_t)Inspector::Protocol::CSS::PseudoId::After,
        (size_t)Inspector::Protocol::CSS::PseudoId::Selection,
        (size_t)Inspector::Protocol::CSS::PseudoId::Scrollbar,
        (size_t)Inspector::Protocol::CSS::PseudoId::ScrollbarThumb,
        (size_t)Inspector::Protocol::CSS::PseudoId::ScrollbarButton,
        (size_t)Inspector::Protocol::CSS::PseudoId::ScrollbarTrack,
        (size_t)Inspector::Protocol::CSS::PseudoId::ScrollbarTrackPiece,
        (size_t)Inspector::Protocol::CSS::PseudoId::ScrollbarCorner,
        (size_t)Inspector::Protocol::CSS::PseudoId::Resizer,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::CSS::PseudoId)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::CSS::CSSPropertyStatus> parseEnumValueFromString<Inspector::Protocol::CSS::CSSPropertyStatus>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::CSS::CSSPropertyStatus::Active,
        (size_t)Inspector::Protocol::CSS::CSSPropertyStatus::Inactive,
        (size_t)Inspector::Protocol::CSS::CSSPropertyStatus::Disabled,
        (size_t)Inspector::Protocol::CSS::CSSPropertyStatus::Style,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::CSS::CSSPropertyStatus)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::CSS::Grouping::Type> parseEnumValueFromString<Inspector::Protocol::CSS::Grouping::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::CSS::Grouping::Type::MediaRule,
        (size_t)Inspector::Protocol::CSS::Grouping::Type::MediaImportRule,
        (size_t)Inspector::Protocol::CSS::Grouping::Type::MediaLinkNode,
        (size_t)Inspector::Protocol::CSS::Grouping::Type::MediaStyleNode,
        (size_t)Inspector::Protocol::CSS::Grouping::Type::SupportsRule,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::CSS::Grouping::Type)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Canvas' Domain
template<>
Optional<Inspector::Protocol::Canvas::ContextType> parseEnumValueFromString<Inspector::Protocol::Canvas::ContextType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Canvas::ContextType::Canvas2D,
        (size_t)Inspector::Protocol::Canvas::ContextType::BitmapRenderer,
        (size_t)Inspector::Protocol::Canvas::ContextType::WebGL,
        (size_t)Inspector::Protocol::Canvas::ContextType::WebGL2,
        (size_t)Inspector::Protocol::Canvas::ContextType::WebGPU,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Canvas::ContextType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Canvas::ProgramType> parseEnumValueFromString<Inspector::Protocol::Canvas::ProgramType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Canvas::ProgramType::Compute,
        (size_t)Inspector::Protocol::Canvas::ProgramType::Render,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Canvas::ProgramType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Canvas::ShaderType> parseEnumValueFromString<Inspector::Protocol::Canvas::ShaderType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Canvas::ShaderType::Compute,
        (size_t)Inspector::Protocol::Canvas::ShaderType::Fragment,
        (size_t)Inspector::Protocol::Canvas::ShaderType::Vertex,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Canvas::ShaderType)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Console' Domain
template<>
Optional<Inspector::Protocol::Console::ChannelSource> parseEnumValueFromString<Inspector::Protocol::Console::ChannelSource>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Console::ChannelSource::XML,
        (size_t)Inspector::Protocol::Console::ChannelSource::JavaScript,
        (size_t)Inspector::Protocol::Console::ChannelSource::Network,
        (size_t)Inspector::Protocol::Console::ChannelSource::ConsoleAPI,
        (size_t)Inspector::Protocol::Console::ChannelSource::Storage,
        (size_t)Inspector::Protocol::Console::ChannelSource::Appcache,
        (size_t)Inspector::Protocol::Console::ChannelSource::Rendering,
        (size_t)Inspector::Protocol::Console::ChannelSource::CSS,
        (size_t)Inspector::Protocol::Console::ChannelSource::Security,
        (size_t)Inspector::Protocol::Console::ChannelSource::ContentBlocker,
        (size_t)Inspector::Protocol::Console::ChannelSource::Media,
        (size_t)Inspector::Protocol::Console::ChannelSource::MediaSource,
        (size_t)Inspector::Protocol::Console::ChannelSource::WebRTC,
        (size_t)Inspector::Protocol::Console::ChannelSource::Other,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Console::ChannelSource)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Console::ChannelLevel> parseEnumValueFromString<Inspector::Protocol::Console::ChannelLevel>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Console::ChannelLevel::Off,
        (size_t)Inspector::Protocol::Console::ChannelLevel::Basic,
        (size_t)Inspector::Protocol::Console::ChannelLevel::Verbose,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Console::ChannelLevel)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Console::ConsoleMessage::Level> parseEnumValueFromString<Inspector::Protocol::Console::ConsoleMessage::Level>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Level::Log,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Level::Info,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Level::Warning,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Level::Error,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Level::Debug,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Console::ConsoleMessage::Level)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Console::ConsoleMessage::Type> parseEnumValueFromString<Inspector::Protocol::Console::ConsoleMessage::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Log,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Dir,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::DirXML,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Table,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Trace,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Clear,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::StartGroup,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::StartGroupCollapsed,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::EndGroup,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Assert,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Timing,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Profile,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::ProfileEnd,
        (size_t)Inspector::Protocol::Console::ConsoleMessage::Type::Image,
    };
    for (size_t i = 0; i < 14; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Console::ConsoleMessage::Type)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'DOM' Domain
template<>
Optional<Inspector::Protocol::DOM::PseudoType> parseEnumValueFromString<Inspector::Protocol::DOM::PseudoType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::PseudoType::Before,
        (size_t)Inspector::Protocol::DOM::PseudoType::After,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::PseudoType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::ShadowRootType> parseEnumValueFromString<Inspector::Protocol::DOM::ShadowRootType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::ShadowRootType::UserAgent,
        (size_t)Inspector::Protocol::DOM::ShadowRootType::Open,
        (size_t)Inspector::Protocol::DOM::ShadowRootType::Closed,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::ShadowRootType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::CustomElementState> parseEnumValueFromString<Inspector::Protocol::DOM::CustomElementState>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::CustomElementState::Builtin,
        (size_t)Inspector::Protocol::DOM::CustomElementState::Custom,
        (size_t)Inspector::Protocol::DOM::CustomElementState::Waiting,
        (size_t)Inspector::Protocol::DOM::CustomElementState::Failed,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::CustomElementState)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::LiveRegionRelevant> parseEnumValueFromString<Inspector::Protocol::DOM::LiveRegionRelevant>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::LiveRegionRelevant::Additions,
        (size_t)Inspector::Protocol::DOM::LiveRegionRelevant::Removals,
        (size_t)Inspector::Protocol::DOM::LiveRegionRelevant::Text,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::LiveRegionRelevant)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::AccessibilityProperties::Checked> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::Checked>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Checked::True,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Checked::False,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Checked::Mixed,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::AccessibilityProperties::Checked)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::AccessibilityProperties::Current> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::Current>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::True,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::False,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::Page,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::Step,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::Location,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::Date,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Current::Time,
    };
    for (size_t i = 0; i < 7; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::AccessibilityProperties::Current)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::AccessibilityProperties::Invalid> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::Invalid>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Invalid::True,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Invalid::False,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Invalid::Grammar,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::Invalid::Spelling,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::AccessibilityProperties::Invalid)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus> parseEnumValueFromString<Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus::Assertive,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus::Polite,
        (size_t)Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus::Off,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOM::AccessibilityProperties::LiveRegionStatus)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'DOMDebugger' Domain
template<>
Optional<Inspector::Protocol::DOMDebugger::DOMBreakpointType> parseEnumValueFromString<Inspector::Protocol::DOMDebugger::DOMBreakpointType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOMDebugger::DOMBreakpointType::SubtreeModified,
        (size_t)Inspector::Protocol::DOMDebugger::DOMBreakpointType::AttributeModified,
        (size_t)Inspector::Protocol::DOMDebugger::DOMBreakpointType::NodeRemoved,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOMDebugger::DOMBreakpointType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::DOMDebugger::EventBreakpointType> parseEnumValueFromString<Inspector::Protocol::DOMDebugger::EventBreakpointType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::DOMDebugger::EventBreakpointType::AnimationFrame,
        (size_t)Inspector::Protocol::DOMDebugger::EventBreakpointType::Interval,
        (size_t)Inspector::Protocol::DOMDebugger::EventBreakpointType::Listener,
        (size_t)Inspector::Protocol::DOMDebugger::EventBreakpointType::Timeout,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::DOMDebugger::EventBreakpointType)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Debugger' Domain
template<>
Optional<Inspector::Protocol::Debugger::BreakpointAction::Type> parseEnumValueFromString<Inspector::Protocol::Debugger::BreakpointAction::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Debugger::BreakpointAction::Type::Log,
        (size_t)Inspector::Protocol::Debugger::BreakpointAction::Type::Evaluate,
        (size_t)Inspector::Protocol::Debugger::BreakpointAction::Type::Sound,
        (size_t)Inspector::Protocol::Debugger::BreakpointAction::Type::Probe,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Debugger::BreakpointAction::Type)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Debugger::Scope::Type> parseEnumValueFromString<Inspector::Protocol::Debugger::Scope::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Debugger::Scope::Type::Global,
        (size_t)Inspector::Protocol::Debugger::Scope::Type::With,
        (size_t)Inspector::Protocol::Debugger::Scope::Type::Closure,
        (size_t)Inspector::Protocol::Debugger::Scope::Type::Catch,
        (size_t)Inspector::Protocol::Debugger::Scope::Type::FunctionName,
        (size_t)Inspector::Protocol::Debugger::Scope::Type::GlobalLexicalEnvironment,
        (size_t)Inspector::Protocol::Debugger::Scope::Type::NestedLexical,
    };
    for (size_t i = 0; i < 7; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Debugger::Scope::Type)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Heap' Domain
template<>
Optional<Inspector::Protocol::Heap::GarbageCollection::Type> parseEnumValueFromString<Inspector::Protocol::Heap::GarbageCollection::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Heap::GarbageCollection::Type::Full,
        (size_t)Inspector::Protocol::Heap::GarbageCollection::Type::Partial,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Heap::GarbageCollection::Type)constantValues[i];

    return WTF::nullopt;
}


#if ENABLE(INDEXED_DATABASE)
// Enums in the 'IndexedDB' Domain
template<>
Optional<Inspector::Protocol::IndexedDB::Key::Type> parseEnumValueFromString<Inspector::Protocol::IndexedDB::Key::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::IndexedDB::Key::Type::Number,
        (size_t)Inspector::Protocol::IndexedDB::Key::Type::String,
        (size_t)Inspector::Protocol::IndexedDB::Key::Type::Date,
        (size_t)Inspector::Protocol::IndexedDB::Key::Type::Array,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::IndexedDB::Key::Type)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::IndexedDB::KeyPath::Type> parseEnumValueFromString<Inspector::Protocol::IndexedDB::KeyPath::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::IndexedDB::KeyPath::Type::Null,
        (size_t)Inspector::Protocol::IndexedDB::KeyPath::Type::String,
        (size_t)Inspector::Protocol::IndexedDB::KeyPath::Type::Array,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::IndexedDB::KeyPath::Type)constantValues[i];

    return WTF::nullopt;
}

#endif // ENABLE(INDEXED_DATABASE)

#if ENABLE(RESOURCE_USAGE)
// Enums in the 'Memory' Domain
template<>
Optional<Inspector::Protocol::Memory::CategoryData::Type> parseEnumValueFromString<Inspector::Protocol::Memory::CategoryData::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Memory::CategoryData::Type::JavaScript,
        (size_t)Inspector::Protocol::Memory::CategoryData::Type::JIT,
        (size_t)Inspector::Protocol::Memory::CategoryData::Type::Images,
        (size_t)Inspector::Protocol::Memory::CategoryData::Type::Layers,
        (size_t)Inspector::Protocol::Memory::CategoryData::Type::Page,
        (size_t)Inspector::Protocol::Memory::CategoryData::Type::Other,
    };
    for (size_t i = 0; i < 6; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Memory::CategoryData::Type)constantValues[i];

    return WTF::nullopt;
}

#endif // ENABLE(RESOURCE_USAGE)

// Enums in the 'Network' Domain
template<>
Optional<Inspector::Protocol::Network::NetworkStage> parseEnumValueFromString<Inspector::Protocol::Network::NetworkStage>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Network::NetworkStage::Response,
    };
    for (size_t i = 0; i < 1; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Network::NetworkStage)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Network::Response::Source> parseEnumValueFromString<Inspector::Protocol::Network::Response::Source>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Network::Response::Source::Unknown,
        (size_t)Inspector::Protocol::Network::Response::Source::Network,
        (size_t)Inspector::Protocol::Network::Response::Source::MemoryCache,
        (size_t)Inspector::Protocol::Network::Response::Source::DiskCache,
        (size_t)Inspector::Protocol::Network::Response::Source::ServiceWorker,
        (size_t)Inspector::Protocol::Network::Response::Source::InspectorOverride,
    };
    for (size_t i = 0; i < 6; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Network::Response::Source)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Network::Metrics::Priority> parseEnumValueFromString<Inspector::Protocol::Network::Metrics::Priority>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Network::Metrics::Priority::Low,
        (size_t)Inspector::Protocol::Network::Metrics::Priority::Medium,
        (size_t)Inspector::Protocol::Network::Metrics::Priority::High,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Network::Metrics::Priority)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Network::Initiator::Type> parseEnumValueFromString<Inspector::Protocol::Network::Initiator::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Network::Initiator::Type::Parser,
        (size_t)Inspector::Protocol::Network::Initiator::Type::Script,
        (size_t)Inspector::Protocol::Network::Initiator::Type::Other,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Network::Initiator::Type)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Page' Domain
template<>
Optional<Inspector::Protocol::Page::Setting> parseEnumValueFromString<Inspector::Protocol::Page::Setting>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Page::Setting::AuthorAndUserStylesEnabled,
        (size_t)Inspector::Protocol::Page::Setting::ICECandidateFilteringEnabled,
        (size_t)Inspector::Protocol::Page::Setting::ImagesEnabled,
        (size_t)Inspector::Protocol::Page::Setting::MediaCaptureRequiresSecureConnection,
        (size_t)Inspector::Protocol::Page::Setting::MockCaptureDevicesEnabled,
        (size_t)Inspector::Protocol::Page::Setting::NeedsSiteSpecificQuirks,
        (size_t)Inspector::Protocol::Page::Setting::ScriptEnabled,
        (size_t)Inspector::Protocol::Page::Setting::ShowDebugBorders,
        (size_t)Inspector::Protocol::Page::Setting::ShowRepaintCounter,
        (size_t)Inspector::Protocol::Page::Setting::WebRTCEncryptionEnabled,
        (size_t)Inspector::Protocol::Page::Setting::WebSecurityEnabled,
    };
    for (size_t i = 0; i < 11; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Page::Setting)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Page::ResourceType> parseEnumValueFromString<Inspector::Protocol::Page::ResourceType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Page::ResourceType::Document,
        (size_t)Inspector::Protocol::Page::ResourceType::StyleSheet,
        (size_t)Inspector::Protocol::Page::ResourceType::Image,
        (size_t)Inspector::Protocol::Page::ResourceType::Font,
        (size_t)Inspector::Protocol::Page::ResourceType::Script,
        (size_t)Inspector::Protocol::Page::ResourceType::XHR,
        (size_t)Inspector::Protocol::Page::ResourceType::Fetch,
        (size_t)Inspector::Protocol::Page::ResourceType::Ping,
        (size_t)Inspector::Protocol::Page::ResourceType::Beacon,
        (size_t)Inspector::Protocol::Page::ResourceType::WebSocket,
        (size_t)Inspector::Protocol::Page::ResourceType::Other,
    };
    for (size_t i = 0; i < 11; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Page::ResourceType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Page::CoordinateSystem> parseEnumValueFromString<Inspector::Protocol::Page::CoordinateSystem>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Page::CoordinateSystem::Viewport,
        (size_t)Inspector::Protocol::Page::CoordinateSystem::Page,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Page::CoordinateSystem)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Page::CookieSameSitePolicy> parseEnumValueFromString<Inspector::Protocol::Page::CookieSameSitePolicy>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Page::CookieSameSitePolicy::None,
        (size_t)Inspector::Protocol::Page::CookieSameSitePolicy::Lax,
        (size_t)Inspector::Protocol::Page::CookieSameSitePolicy::Strict,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Page::CookieSameSitePolicy)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Page::Appearance> parseEnumValueFromString<Inspector::Protocol::Page::Appearance>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Page::Appearance::Light,
        (size_t)Inspector::Protocol::Page::Appearance::Dark,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Page::Appearance)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Recording' Domain
template<>
Optional<Inspector::Protocol::Recording::Type> parseEnumValueFromString<Inspector::Protocol::Recording::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Recording::Type::Canvas2D,
        (size_t)Inspector::Protocol::Recording::Type::CanvasBitmapRenderer,
        (size_t)Inspector::Protocol::Recording::Type::CanvasWebGL,
        (size_t)Inspector::Protocol::Recording::Type::CanvasWebGL2,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Recording::Type)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Recording::Initiator> parseEnumValueFromString<Inspector::Protocol::Recording::Initiator>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Recording::Initiator::Frontend,
        (size_t)Inspector::Protocol::Recording::Initiator::Console,
        (size_t)Inspector::Protocol::Recording::Initiator::AutoCapture,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Recording::Initiator)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Runtime' Domain
template<>
Optional<Inspector::Protocol::Runtime::ExecutionContextType> parseEnumValueFromString<Inspector::Protocol::Runtime::ExecutionContextType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::ExecutionContextType::Normal,
        (size_t)Inspector::Protocol::Runtime::ExecutionContextType::User,
        (size_t)Inspector::Protocol::Runtime::ExecutionContextType::Internal,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::ExecutionContextType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::SyntaxErrorType> parseEnumValueFromString<Inspector::Protocol::Runtime::SyntaxErrorType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::SyntaxErrorType::None,
        (size_t)Inspector::Protocol::Runtime::SyntaxErrorType::Irrecoverable,
        (size_t)Inspector::Protocol::Runtime::SyntaxErrorType::UnterminatedLiteral,
        (size_t)Inspector::Protocol::Runtime::SyntaxErrorType::Recoverable,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::SyntaxErrorType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::RemoteObject::Type> parseEnumValueFromString<Inspector::Protocol::Runtime::RemoteObject::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Object,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Function,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Undefined,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::String,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Number,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Boolean,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Symbol,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Type::Bigint,
    };
    for (size_t i = 0; i < 8; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::RemoteObject::Type)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::RemoteObject::Subtype> parseEnumValueFromString<Inspector::Protocol::Runtime::RemoteObject::Subtype>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Array,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Null,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Node,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Regexp,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Date,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Error,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Map,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Set,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Weakmap,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Weakset,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Iterator,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Class,
        (size_t)Inspector::Protocol::Runtime::RemoteObject::Subtype::Proxy,
    };
    for (size_t i = 0; i < 13; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::RemoteObject::Subtype)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::ObjectPreview::Type> parseEnumValueFromString<Inspector::Protocol::Runtime::ObjectPreview::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Object,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Function,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Undefined,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::String,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Number,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Boolean,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Symbol,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Type::Bigint,
    };
    for (size_t i = 0; i < 8; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::ObjectPreview::Type)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::ObjectPreview::Subtype> parseEnumValueFromString<Inspector::Protocol::Runtime::ObjectPreview::Subtype>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Array,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Null,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Node,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Regexp,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Date,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Error,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Map,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Set,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Weakmap,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Weakset,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Iterator,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Class,
        (size_t)Inspector::Protocol::Runtime::ObjectPreview::Subtype::Proxy,
    };
    for (size_t i = 0; i < 13; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::ObjectPreview::Subtype)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::PropertyPreview::Type> parseEnumValueFromString<Inspector::Protocol::Runtime::PropertyPreview::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Object,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Function,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Undefined,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::String,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Number,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Boolean,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Symbol,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Bigint,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Type::Accessor,
    };
    for (size_t i = 0; i < 9; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::PropertyPreview::Type)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Runtime::PropertyPreview::Subtype> parseEnumValueFromString<Inspector::Protocol::Runtime::PropertyPreview::Subtype>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Array,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Null,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Node,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Regexp,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Date,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Error,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Map,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Set,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Weakmap,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Weakset,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Iterator,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Class,
        (size_t)Inspector::Protocol::Runtime::PropertyPreview::Subtype::Proxy,
    };
    for (size_t i = 0; i < 13; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Runtime::PropertyPreview::Subtype)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'ScriptProfiler' Domain
template<>
Optional<Inspector::Protocol::ScriptProfiler::EventType> parseEnumValueFromString<Inspector::Protocol::ScriptProfiler::EventType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::ScriptProfiler::EventType::API,
        (size_t)Inspector::Protocol::ScriptProfiler::EventType::Microtask,
        (size_t)Inspector::Protocol::ScriptProfiler::EventType::Other,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::ScriptProfiler::EventType)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Target' Domain
template<>
Optional<Inspector::Protocol::Target::TargetInfo::Type> parseEnumValueFromString<Inspector::Protocol::Target::TargetInfo::Type>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Target::TargetInfo::Type::Page,
        (size_t)Inspector::Protocol::Target::TargetInfo::Type::ServiceWorker,
        (size_t)Inspector::Protocol::Target::TargetInfo::Type::Worker,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Target::TargetInfo::Type)constantValues[i];

    return WTF::nullopt;
}


// Enums in the 'Timeline' Domain
template<>
Optional<Inspector::Protocol::Timeline::EventType> parseEnumValueFromString<Inspector::Protocol::Timeline::EventType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Timeline::EventType::EventDispatch,
        (size_t)Inspector::Protocol::Timeline::EventType::ScheduleStyleRecalculation,
        (size_t)Inspector::Protocol::Timeline::EventType::RecalculateStyles,
        (size_t)Inspector::Protocol::Timeline::EventType::InvalidateLayout,
        (size_t)Inspector::Protocol::Timeline::EventType::Layout,
        (size_t)Inspector::Protocol::Timeline::EventType::Paint,
        (size_t)Inspector::Protocol::Timeline::EventType::Composite,
        (size_t)Inspector::Protocol::Timeline::EventType::RenderingFrame,
        (size_t)Inspector::Protocol::Timeline::EventType::TimerInstall,
        (size_t)Inspector::Protocol::Timeline::EventType::TimerRemove,
        (size_t)Inspector::Protocol::Timeline::EventType::TimerFire,
        (size_t)Inspector::Protocol::Timeline::EventType::EvaluateScript,
        (size_t)Inspector::Protocol::Timeline::EventType::TimeStamp,
        (size_t)Inspector::Protocol::Timeline::EventType::Time,
        (size_t)Inspector::Protocol::Timeline::EventType::TimeEnd,
        (size_t)Inspector::Protocol::Timeline::EventType::FunctionCall,
        (size_t)Inspector::Protocol::Timeline::EventType::ProbeSample,
        (size_t)Inspector::Protocol::Timeline::EventType::ConsoleProfile,
        (size_t)Inspector::Protocol::Timeline::EventType::RequestAnimationFrame,
        (size_t)Inspector::Protocol::Timeline::EventType::CancelAnimationFrame,
        (size_t)Inspector::Protocol::Timeline::EventType::FireAnimationFrame,
        (size_t)Inspector::Protocol::Timeline::EventType::ObserverCallback,
    };
    for (size_t i = 0; i < 22; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Timeline::EventType)constantValues[i];

    return WTF::nullopt;
}

template<>
Optional<Inspector::Protocol::Timeline::Instrument> parseEnumValueFromString<Inspector::Protocol::Timeline::Instrument>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Inspector::Protocol::Timeline::Instrument::ScriptProfiler,
        (size_t)Inspector::Protocol::Timeline::Instrument::Timeline,
        (size_t)Inspector::Protocol::Timeline::Instrument::CPU,
        (size_t)Inspector::Protocol::Timeline::Instrument::Memory,
        (size_t)Inspector::Protocol::Timeline::Instrument::Heap,
        (size_t)Inspector::Protocol::Timeline::Instrument::Animation,
    };
    for (size_t i = 0; i < 6; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Inspector::Protocol::Timeline::Instrument)constantValues[i];

    return WTF::nullopt;
}


} // namespace InspectorHelpers

const char* Inspector::Protocol::CSS::CSSProperty::Implicit = "implicit";
const char* Inspector::Protocol::CSS::CSSProperty::Name = "name";
const char* Inspector::Protocol::CSS::CSSProperty::ParsedOk = "parsedOk";
const char* Inspector::Protocol::CSS::CSSProperty::Priority = "priority";
const char* Inspector::Protocol::CSS::CSSProperty::Range = "range";
const char* Inspector::Protocol::CSS::CSSProperty::Status = "status";
const char* Inspector::Protocol::CSS::CSSProperty::Text = "text";
const char* Inspector::Protocol::CSS::CSSProperty::Value = "value";
const char* Inspector::Protocol::Network::Response::MimeType = "mimeType";
const char* Inspector::Protocol::Timeline::TimelineEvent::Children = "children";
const char* Inspector::Protocol::Timeline::TimelineEvent::Data = "data";
const char* Inspector::Protocol::Timeline::TimelineEvent::Type = "type";

void BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto scriptIdPos = object->find("scriptId"_s);
        ASSERT(scriptIdPos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(scriptIdPos->value.get());
    }
    {
        auto lineNumberPos = object->find("lineNumber"_s);
        ASSERT(lineNumberPos != object->end());
        BindingTraits<int>::assertValueHasExpectedType(lineNumberPos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        auto columnNumberPos = object->find("columnNumber"_s);
        if (columnNumberPos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(columnNumberPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Debugger::FunctionDetails>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto locationPos = object->find("location"_s);
        ASSERT(locationPos != object->end());
        BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        auto namePos = object->find("name"_s);
        if (namePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto displayNamePos = object->find("displayName"_s);
        if (displayNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(displayNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto scopeChainPos = object->find("scopeChain"_s);
        if (scopeChainPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Inspector::Protocol::Debugger::Scope>>::assertValueHasExpectedType(scopeChainPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Debugger::FunctionDetails> BindingTraits<Inspector::Protocol::Debugger::FunctionDetails>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Debugger::FunctionDetails>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Debugger::FunctionDetails) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Debugger::FunctionDetails*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Debugger::CallFrame>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto callFrameIdPos = object->find("callFrameId"_s);
        ASSERT(callFrameIdPos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(callFrameIdPos->value.get());
    }
    {
        auto functionNamePos = object->find("functionName"_s);
        ASSERT(functionNamePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(functionNamePos->value.get());
    }
    {
        auto locationPos = object->find("location"_s);
        ASSERT(locationPos != object->end());
        BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.get());
    }
    {
        auto scopeChainPos = object->find("scopeChain"_s);
        ASSERT(scopeChainPos != object->end());
        BindingTraits<JSON::ArrayOf<Inspector::Protocol::Debugger::Scope>>::assertValueHasExpectedType(scopeChainPos->value.get());
    }
    {
        auto thisPos = object->find("this"_s);
        ASSERT(thisPos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(thisPos->value.get());
    }
    {
        auto isTailDeletedPos = object->find("isTailDeleted"_s);
        ASSERT(isTailDeletedPos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(isTailDeletedPos->value.get());
    }

    int foundPropertiesCount = 6;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Debugger::CallFrame> BindingTraits<Inspector::Protocol::Debugger::CallFrame>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Debugger::CallFrame>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Debugger::CallFrame) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Debugger::CallFrame*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Debugger::Scope::Type>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "global" || result == "with" || result == "closure" || result == "catch" || result == "functionName" || result == "globalLexicalEnvironment" || result == "nestedLexical");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Debugger::Scope>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto objectPos = object->find("object"_s);
        ASSERT(objectPos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(objectPos->value.get());
    }
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Debugger::Scope::Type>::assertValueHasExpectedType(typePos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        auto namePos = object->find("name"_s);
        if (namePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto locationPos = object->find("location"_s);
        if (locationPos != object->end()) {
            BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto emptyPos = object->find("empty"_s);
        if (emptyPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(emptyPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Type>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "object" || result == "function" || result == "undefined" || result == "string" || result == "number" || result == "boolean" || result == "symbol" || result == "bigint");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Subtype>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "array" || result == "null" || result == "node" || result == "regexp" || result == "date" || result == "error" || result == "map" || result == "set" || result == "weakmap" || result == "weakset" || result == "iterator" || result == "class" || result == "proxy");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Type>::assertValueHasExpectedType(typePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        auto subtypePos = object->find("subtype"_s);
        if (subtypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Subtype>::assertValueHasExpectedType(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto classNamePos = object->find("className"_s);
        if (classNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(classNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<JSON::Value>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto descriptionPos = object->find("description"_s);
        if (descriptionPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(descriptionPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto objectIdPos = object->find("objectId"_s);
        if (objectIdPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(objectIdPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto sizePos = object->find("size"_s);
        if (sizePos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(sizePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto classPrototypePos = object->find("classPrototype"_s);
        if (classPrototypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(classPrototypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto previewPos = object->find("preview"_s);
        if (previewPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(previewPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Runtime::RemoteObject> BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::RemoteObject) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::RemoteObject*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Type>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "object" || result == "function" || result == "undefined" || result == "string" || result == "number" || result == "boolean" || result == "symbol" || result == "bigint");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Subtype>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "array" || result == "null" || result == "node" || result == "regexp" || result == "date" || result == "error" || result == "map" || result == "set" || result == "weakmap" || result == "weakset" || result == "iterator" || result == "class" || result == "proxy");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Type>::assertValueHasExpectedType(typePos->value.get());
    }
    {
        auto losslessPos = object->find("lossless"_s);
        ASSERT(losslessPos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(losslessPos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        auto subtypePos = object->find("subtype"_s);
        if (subtypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Subtype>::assertValueHasExpectedType(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto descriptionPos = object->find("description"_s);
        if (descriptionPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(descriptionPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto overflowPos = object->find("overflow"_s);
        if (overflowPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(overflowPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto propertiesPos = object->find("properties"_s);
        if (propertiesPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Inspector::Protocol::Runtime::PropertyPreview>>::assertValueHasExpectedType(propertiesPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto entriesPos = object->find("entries"_s);
        if (entriesPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Inspector::Protocol::Runtime::EntryPreview>>::assertValueHasExpectedType(entriesPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto sizePos = object->find("size"_s);
        if (sizePos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(sizePos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Runtime::ObjectPreview> BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::ObjectPreview) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::ObjectPreview*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Type>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "object" || result == "function" || result == "undefined" || result == "string" || result == "number" || result == "boolean" || result == "symbol" || result == "bigint" || result == "accessor");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Subtype>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "array" || result == "null" || result == "node" || result == "regexp" || result == "date" || result == "error" || result == "map" || result == "set" || result == "weakmap" || result == "weakset" || result == "iterator" || result == "class" || result == "proxy");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::PropertyPreview>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto namePos = object->find("name"_s);
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
    }
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Type>::assertValueHasExpectedType(typePos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        auto subtypePos = object->find("subtype"_s);
        if (subtypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Subtype>::assertValueHasExpectedType(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto valuePreviewPos = object->find("valuePreview"_s);
        if (valuePreviewPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(valuePreviewPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto internalPos = object->find("internal"_s);
        if (internalPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(internalPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::EntryPreview>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto valuePos = object->find("value"_s);
        ASSERT(valuePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(valuePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        auto keyPos = object->find("key"_s);
        if (keyPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(keyPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Runtime::CollectionEntry>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto valuePos = object->find("value"_s);
        ASSERT(valuePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        auto keyPos = object->find("key"_s);
        if (keyPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(keyPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Runtime::CollectionEntry> BindingTraits<Inspector::Protocol::Runtime::CollectionEntry>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Runtime::CollectionEntry>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::CollectionEntry) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::CollectionEntry*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto namePos = object->find("name"_s);
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto writablePos = object->find("writable"_s);
        if (writablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(writablePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto getPos = object->find("get"_s);
        if (getPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(getPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto setPos = object->find("set"_s);
        if (setPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(setPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto wasThrownPos = object->find("wasThrown"_s);
        if (wasThrownPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(wasThrownPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto configurablePos = object->find("configurable"_s);
        if (configurablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(configurablePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto enumerablePos = object->find("enumerable"_s);
        if (enumerablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(enumerablePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto isOwnPos = object->find("isOwn"_s);
        if (isOwnPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(isOwnPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto symbolPos = object->find("symbol"_s);
        if (symbolPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(symbolPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        auto nativeGetterPos = object->find("nativeGetter"_s);
        if (nativeGetterPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(nativeGetterPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Runtime::PropertyDescriptor> BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::PropertyDescriptor) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::PropertyDescriptor*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto namePos = object->find("name"_s);
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        auto valuePos = object->find("value"_s);
        if (valuePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Runtime::InternalPropertyDescriptor> BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::InternalPropertyDescriptor) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::InternalPropertyDescriptor*>(static_cast<JSON::ObjectBase*>(result.get()));
}


void BindingTraits<Inspector::Protocol::Timeline::EventType>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "EventDispatch" || result == "ScheduleStyleRecalculation" || result == "RecalculateStyles" || result == "InvalidateLayout" || result == "Layout" || result == "Paint" || result == "Composite" || result == "RenderingFrame" || result == "TimerInstall" || result == "TimerRemove" || result == "TimerFire" || result == "EvaluateScript" || result == "TimeStamp" || result == "Time" || result == "TimeEnd" || result == "FunctionCall" || result == "ProbeSample" || result == "ConsoleProfile" || result == "RequestAnimationFrame" || result == "CancelAnimationFrame" || result == "FireAnimationFrame" || result == "ObserverCallback");
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

void BindingTraits<Inspector::Protocol::Timeline::TimelineEvent>::assertValueHasExpectedType(JSON::Value* value)
{
#if ASSERT_ENABLED
    ASSERT_ARG(value, value);
    RefPtr<JSON::Object> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        auto typePos = object->find("type"_s);
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Timeline::EventType>::assertValueHasExpectedType(typePos->value.get());
    }
    {
        auto dataPos = object->find("data"_s);
        ASSERT(dataPos != object->end());
        BindingTraits<JSON::Object>::assertValueHasExpectedType(dataPos->value.get());
    }
    {
        auto childrenPos = object->find("children"_s);
        if (childrenPos != object->end()) {
            BindingTraits<JSON::ArrayOf<Inspector::Protocol::Timeline::TimelineEvent>>::assertValueHasExpectedType(childrenPos->value.get());
        }
    }
#else // ASSERT_ENABLED
    UNUSED_PARAM(value);
#endif // ASSERT_ENABLED
}

RefPtr<Inspector::Protocol::Timeline::TimelineEvent> BindingTraits<Inspector::Protocol::Timeline::TimelineEvent>::runtimeCast(RefPtr<JSON::Value>&& value)
{
    RefPtr<JSON::Object> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    BindingTraits<Inspector::Protocol::Timeline::TimelineEvent>::assertValueHasExpectedType(result.get());
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Timeline::TimelineEvent) == sizeof(JSON::ObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Timeline::TimelineEvent*>(static_cast<JSON::ObjectBase*>(result.get()));
}


} // namespace Protocol

} // namespace Inspector
