/* libjpeg-turbo build number */
#define BUILD  "20210827"

/* Compiler's inline keyword */
#undef inline

/* How to obtain function inlining. */

#ifdef _MSC_VER
#if _MSC_VER > 1900
// With VS2017, on x64 platforms, the '__forceinline' directive has lost all practical utility.
// To account for Microsoft's unique approach to forced inlining, we are disabling it for those platforms.
// This should improve compile times, EXE sizes, and, paradoxically, runtime performance.
// References:
// * VS2017 Blog post: https://blogs.msdn.microsoft.com/vcblog/2018/01/04/visual-studio-2017-throughput-improvements-and-advice/
// * XFest 2018 Session: "Optimizing Build and Iteration Times" (link not yet available)
// * GDC 2018 Session: "Modern C++ Game Development on Microsoft Platforms" (link not yet available)
// * In person discussion with Andrew Farrier & Chuck Walburn @MS.
#define INLINE			inline
#else // #if _MSC_VER > 1900
#define INLINE			__forceinline
#endif // #else // #if _MSC_VER > 1900
#define ALWAYS_FORCE_INLINE		__forceinline // WARNING: Only use this if you have verified it is beneficial to all platforms.
#define NEVER_INLINE			__declspec( noinline )
#define NONSTANDARD_ALIGN( alignment ) __declspec( align( alignment ) )
#define NO_VTABLE				__declspec( novtable )
#define EXPECT( expr, hint ) ( expr )
#elif defined( __clang__ ) || defined( __GNUC__ )
#define INLINE			inline __attribute__( ( __always_inline__ ) )
#define INLINE		inline __attribute__( ( __always_inline__ ) ) // WARNING: Only use this if you have verified it is beneficial to all platforms.
#define NEVER_INLINE			__attribute__( ( __noinline__ ) )
#define NONSTANDARD_ALIGN( alignment ) __attribute__( ( aligned( alignment ) ) )
#define NO_VTABLE
#define EXPECT( expr, hint )	__builtin_expect( expr, hint )
#else
#error "Unknown compiler"
#endif

/* How to obtain thread-local storage */
#define THREAD_LOCAL  __declspec(thread)

/* Define to the full name of this package. */
#define PACKAGE_NAME  "libjpeg-turbo"

/* Version number of package */
#define VERSION  "2.1.1"

/* The size of `size_t', as computed by sizeof. */
#define SIZEOF_SIZE_T  8

/* Define if your compiler has __builtin_ctzl() and sizeof(unsigned long) == sizeof(size_t). */
/* #undef HAVE_BUILTIN_CTZL */

/* Define to 1 if you have the <intrin.h> header file. */
#ifdef _MSC_VER
#define HAVE_INTRIN_H

#if defined(_MSC_VER) && defined(HAVE_INTRIN_H)
#if (SIZEOF_SIZE_T == 8)
#define HAVE_BITSCANFORWARD64
#elif (SIZEOF_SIZE_T == 4)
#define HAVE_BITSCANFORWARD
#endif
#endif
#endif // #ifdef _MSC_VER

#if defined(__has_attribute)
#if __has_attribute(fallthrough)
#define FALLTHROUGH  __attribute__((fallthrough));
#else
#define FALLTHROUGH
#endif
#else
#define FALLTHROUGH
#endif
