/*
 * Summary: text writing API for XML
 * Description: text writing API for XML
 *
 * Copy: See Copyright for the status of this software.
 *
 * Author: Alfred Mickautsch <alfred@mickautsch.de>
 */

#ifndef __XML_XMLWRITER_H__
#define __XML_XMLWRITER_H__

#include <libxml/xmlversion.h>

#ifdef LIBXML_WRITER_ENABLED

#include <stdarg.h>
#include <libxml/xmlIO.h>
#include <libxml/list.h>
#include <libxml/xmlstring.h>

#ifdef __cplusplus
extern "C" {
#endif

    typedef struct _xmlTextWriter xmlTextWriter;
    typedef xmlTextWriter *xmlTextWriterPtr;

/*
 * Constructors & Destructor
 */
    XMLPUBFUN xmlTextWriterPtr XMLCALL
        xmlNewTextWriter(xmlOutputBufferPtr out);
    XMLPUBFUN xmlTextWriterPtr XMLCALL
        xmlNewTextWriterFilename(const char *uri, int compression);
    XMLPUBFUN xmlTextWriterPtr XMLCALL
        xmlNewTextWriterMemory(xmlBufferPtr buf, int compression);
    XMLPUBFUN xmlTextWriterPtr XMLCALL
        xmlNewTextWriterPushParser(xmlParserCtxtPtr ctxt, int compression);
    XMLPUBFUN xmlTextWriterPtr XMLCALL
        xmlNewTextWriterDoc(xmlDocPtr * doc, int compression);
    XMLPUBFUN xmlTextWriterPtr XMLCALL
        xmlNewTextWriterTree(xmlDocPtr doc, xmlNodePtr node,
                             int compression);
    XMLPUBFUN void XMLCALL xmlFreeTextWriter(xmlTextWriterPtr writer);

/*
 * Functions
 */


/*
 * Document
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartDocument(xmlTextWriterPtr writer,
                                   const char *version,
                                   const char *encoding,
                                   const char *standalone);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndDocument(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                   writer);

/*
 * Comments
 */
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterStartComment(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                    writer);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndComment(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatComment(xmlTextWriterPtr writer,
                                        const char *format, ...)
					LIBXML_ATTR_FORMAT(2,3);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatComment(xmlTextWriterPtr writer,
                                         const char *format,
                                         va_list argptr)
					 LIBXML_ATTR_FORMAT(2,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteComment(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                    writer,
                                                    const xmlChar *
                                                    content);

/*
 * Elements
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartElement(xmlTextWriterPtr writer,
                                  const xmlChar * name);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterStartElementNS(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                      writer,
                                                      const xmlChar *
                                                      prefix,
                                                      const xmlChar * name,
                                                      const xmlChar *
                                                      namespaceURI);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndElement(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterFullEndElement(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                      writer);

/*
 * Elements conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatElement(xmlTextWriterPtr writer,
                                        const xmlChar * name,
                                        const char *format, ...)
					LIBXML_ATTR_FORMAT(3,4);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatElement(xmlTextWriterPtr writer,
                                         const xmlChar * name,
                                         const char *format,
                                         va_list argptr)
					 LIBXML_ATTR_FORMAT(3,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteElement(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                    writer,
                                                    const xmlChar * name,
                                                    const xmlChar *
                                                    content);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatElementNS(xmlTextWriterPtr writer,
                                          const xmlChar * prefix,
                                          const xmlChar * name,
                                          const xmlChar * namespaceURI,
                                          const char *format, ...)
					  LIBXML_ATTR_FORMAT(5,6);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatElementNS(xmlTextWriterPtr writer,
                                           const xmlChar * prefix,
                                           const xmlChar * name,
                                           const xmlChar * namespaceURI,
                                           const char *format,
                                           va_list argptr)
					   LIBXML_ATTR_FORMAT(5,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteElementNS(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                      writer,
                                                      const xmlChar *
                                                      prefix,
                                                      const xmlChar * name,
                                                      const xmlChar *
                                                      namespaceURI,
                                                      const xmlChar *
                                                      content);

/*
 * Text
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatRaw(xmlTextWriterPtr writer,
                                    const char *format, ...)
				    LIBXML_ATTR_FORMAT(2,3);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatRaw(xmlTextWriterPtr writer,
                                     const char *format, va_list argptr)
				     LIBXML_ATTR_FORMAT(2,0);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteRawLen(xmlTextWriterPtr writer,
                                 const xmlChar * content, ptrdiff_t len);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteRaw(xmlTextWriterPtr writer,
                              const xmlChar * content);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteFormatString(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                         writer,
                                                         const char
                                                         *format, ...)
							 LIBXML_ATTR_FORMAT(2,3);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteVFormatString(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                          writer,
                                                          const char
                                                          *format,
                                                          va_list argptr)
							  LIBXML_ATTR_FORMAT(2,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteString(xmlTextWriterPtr writer,/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                   const xmlChar *
                                                   content);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteBase64(xmlTextWriterPtr writer,/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                   const char *data,
                                                   ptrdiff_t start, ptrdiff_t len);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteBinHex(xmlTextWriterPtr writer,
                                                   const char *data,
                                                   ptrdiff_t start, ptrdiff_t len);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/

/*
 * Attributes
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartAttribute(xmlTextWriterPtr writer,
                                    const xmlChar * name);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterStartAttributeNS(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                        writer,
                                                        const xmlChar *
                                                        prefix,
                                                        const xmlChar *
                                                        name,
                                                        const xmlChar *
                                                        namespaceURI);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndAttribute(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                    writer);

/*
 * Attributes conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatAttribute(xmlTextWriterPtr writer,
                                          const xmlChar * name,
                                          const char *format, ...)
					  LIBXML_ATTR_FORMAT(3,4);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatAttribute(xmlTextWriterPtr writer,
                                           const xmlChar * name,
                                           const char *format,
                                           va_list argptr)
					   LIBXML_ATTR_FORMAT(3,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteAttribute(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                      writer,
                                                      const xmlChar * name,
                                                      const xmlChar *
                                                      content);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatAttributeNS(xmlTextWriterPtr writer,
                                            const xmlChar * prefix,
                                            const xmlChar * name,
                                            const xmlChar * namespaceURI,
                                            const char *format, ...)
					    LIBXML_ATTR_FORMAT(5,6);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatAttributeNS(xmlTextWriterPtr writer,
                                             const xmlChar * prefix,
                                             const xmlChar * name,
                                             const xmlChar * namespaceURI,
                                             const char *format,
                                             va_list argptr)
					     LIBXML_ATTR_FORMAT(5,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteAttributeNS(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                        writer,
                                                        const xmlChar *
                                                        prefix,
                                                        const xmlChar *
                                                        name,
                                                        const xmlChar *
                                                        namespaceURI,
                                                        const xmlChar *
                                                        content);

/*
 * PI's
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartPI(xmlTextWriterPtr writer,
                             const xmlChar * target);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndPI(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/

/*
 * PI conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatPI(xmlTextWriterPtr writer,
                                   const xmlChar * target,
                                   const char *format, ...)
				   LIBXML_ATTR_FORMAT(3,4);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatPI(xmlTextWriterPtr writer,
                                    const xmlChar * target,
                                    const char *format, va_list argptr)
				    LIBXML_ATTR_FORMAT(3,0);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWritePI(xmlTextWriterPtr writer,
                             const xmlChar * target,
                             const xmlChar * content);

/**
 * xmlTextWriterWriteProcessingInstruction:
 *
 * This macro maps to xmlTextWriterWritePI
 */
#define xmlTextWriterWriteProcessingInstruction xmlTextWriterWritePI

/*
 * CDATA
 */
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterStartCDATA(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndCDATA(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/

/*
 * CDATA conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatCDATA(xmlTextWriterPtr writer,
                                      const char *format, ...)
				      LIBXML_ATTR_FORMAT(2,3);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatCDATA(xmlTextWriterPtr writer,
                                       const char *format, va_list argptr)
				       LIBXML_ATTR_FORMAT(2,0);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteCDATA(xmlTextWriterPtr writer,
                                const xmlChar * content);

/*
 * DTD
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartDTD(xmlTextWriterPtr writer,
                              const xmlChar * name,
                              const xmlChar * pubid,
                              const xmlChar * sysid);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndDTD(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/

/*
 * DTD conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatDTD(xmlTextWriterPtr writer,
                                    const xmlChar * name,
                                    const xmlChar * pubid,
                                    const xmlChar * sysid,
                                    const char *format, ...)
				    LIBXML_ATTR_FORMAT(5,6);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatDTD(xmlTextWriterPtr writer,
                                     const xmlChar * name,
                                     const xmlChar * pubid,
                                     const xmlChar * sysid,
                                     const char *format, va_list argptr)
				     LIBXML_ATTR_FORMAT(5,0);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteDTD(xmlTextWriterPtr writer,
                              const xmlChar * name,
                              const xmlChar * pubid,
                              const xmlChar * sysid,
                              const xmlChar * subset);

/**
 * xmlTextWriterWriteDocType:
 *
 * this macro maps to xmlTextWriterWriteDTD
 */
#define xmlTextWriterWriteDocType xmlTextWriterWriteDTD

/*
 * DTD element definition
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartDTDElement(xmlTextWriterPtr writer,
                                     const xmlChar * name);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndDTDElement(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                     writer);

/*
 * DTD element definition conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatDTDElement(xmlTextWriterPtr writer,
                                           const xmlChar * name,
                                           const char *format, ...)
					   LIBXML_ATTR_FORMAT(3,4);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatDTDElement(xmlTextWriterPtr writer,
                                            const xmlChar * name,
                                            const char *format,
                                            va_list argptr)
					    LIBXML_ATTR_FORMAT(3,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteDTDElement(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                       writer,
                                                       const xmlChar *
                                                       name,
                                                       const xmlChar *
                                                       content);

/*
 * DTD attribute list definition
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartDTDAttlist(xmlTextWriterPtr writer,
                                     const xmlChar * name);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndDTDAttlist(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                     writer);

/*
 * DTD attribute list definition conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatDTDAttlist(xmlTextWriterPtr writer,
                                           const xmlChar * name,
                                           const char *format, ...)
					   LIBXML_ATTR_FORMAT(3,4);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatDTDAttlist(xmlTextWriterPtr writer,
                                            const xmlChar * name,
                                            const char *format,
                                            va_list argptr)
					    LIBXML_ATTR_FORMAT(3,0);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteDTDAttlist(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                       writer,
                                                       const xmlChar *
                                                       name,
                                                       const xmlChar *
                                                       content);

/*
 * DTD entity definition
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterStartDTDEntity(xmlTextWriterPtr writer,
                                    int pe, const xmlChar * name);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterEndDTDEntity(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                    writer);

/*
 * DTD entity definition conveniency functions
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteFormatDTDInternalEntity(xmlTextWriterPtr writer,
                                                  int pe,
                                                  const xmlChar * name,
                                                  const char *format, ...)
						  LIBXML_ATTR_FORMAT(4,5);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteVFormatDTDInternalEntity(xmlTextWriterPtr writer,
                                                   int pe,
                                                   const xmlChar * name,
                                                   const char *format,
                                                   va_list argptr)
						   LIBXML_ATTR_FORMAT(4,0);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteDTDInternalEntity(xmlTextWriterPtr writer,
                                            int pe,
                                            const xmlChar * name,
                                            const xmlChar * content);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteDTDExternalEntity(xmlTextWriterPtr writer,
                                            int pe,
                                            const xmlChar * name,
                                            const xmlChar * pubid,
                                            const xmlChar * sysid,
                                            const xmlChar * ndataid);
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteDTDExternalEntityContents(xmlTextWriterPtr
                                                    writer,
                                                    const xmlChar * pubid,
                                                    const xmlChar * sysid,
                                                    const xmlChar *
                                                    ndataid);
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterWriteDTDEntity(xmlTextWriterPtr/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
                                                      writer, int pe,
                                                      const xmlChar * name,
                                                      const xmlChar *
                                                      pubid,
                                                      const xmlChar *
                                                      sysid,
                                                      const xmlChar *
                                                      ndataid,
                                                      const xmlChar *
                                                      content);

/*
 * DTD notation definition
 */
    XMLPUBFUN ptrdiff_t XMLCALL/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/
        xmlTextWriterWriteDTDNotation(xmlTextWriterPtr writer,
                                      const xmlChar * name,
                                      const xmlChar * pubid,
                                      const xmlChar * sysid);

/*
 * Indentation
 */
    XMLPUBFUN int XMLCALL
        xmlTextWriterSetIndent(xmlTextWriterPtr writer, int indent);
    XMLPUBFUN int XMLCALL
        xmlTextWriterSetIndentString(xmlTextWriterPtr writer,
                                     const xmlChar * str);

    XMLPUBFUN int XMLCALL
        xmlTextWriterSetQuoteChar(xmlTextWriterPtr writer, xmlChar quotechar);


/*
 * misc
 */
    XMLPUBFUN ptrdiff_t XMLCALL xmlTextWriterFlush(xmlTextWriterPtr writer);/*TELESCOPE_LIB_CHANGES 3/12/2020  port libxml2 project to x64 platform, refactor code to adapt to 64-bit pointer type*/

#ifdef __cplusplus
}
#endif

#endif /* LIBXML_WRITER_ENABLED */

#endif                          /* __XML_XMLWRITER_H__ */
