/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "HTMLElementFactory.h"

#include "HTMLNames.h"

#include "HTMLAnchorElement.h"
#include "HTMLElement.h"
#include "HTMLAppletElement.h"
#include "HTMLAreaElement.h"
#include "HTMLBaseElement.h"
#include "HTMLBDIElement.h"
#include "HTMLUnknownElement.h"
#include "HTMLQuoteElement.h"
#include "HTMLBodyElement.h"
#include "HTMLBRElement.h"
#include "HTMLButtonElement.h"
#include "HTMLCanvasElement.h"
#include "HTMLTableCaptionElement.h"
#include "HTMLTableColElement.h"
#include "HTMLDataElement.h"
#include "HTMLModElement.h"
#include "HTMLDetailsElement.h"
#include "HTMLDialogElement.h"
#include "HTMLDirectoryElement.h"
#include "HTMLDivElement.h"
#include "HTMLDListElement.h"
#include "HTMLEmbedElement.h"
#include "HTMLFieldSetElement.h"
#include "HTMLFontElement.h"
#include "HTMLFormElement.h"
#include "HTMLFrameElement.h"
#include "HTMLFrameSetElement.h"
#include "HTMLHeadingElement.h"
#include "HTMLHeadElement.h"
#include "HTMLHRElement.h"
#include "HTMLHtmlElement.h"
#include "HTMLIFrameElement.h"
#include "HTMLImageElement.h"
#include "HTMLInputElement.h"
#include "HTMLKeygenElement.h"
#include "HTMLLabelElement.h"
#include "HTMLLegendElement.h"
#include "HTMLLIElement.h"
#include "HTMLLinkElement.h"
#include "HTMLPreElement.h"
#include "HTMLMapElement.h"
#include "HTMLMarqueeElement.h"
#include "HTMLMenuElement.h"
#include "HTMLMenuItemElement.h"
#include "HTMLMetaElement.h"
#include "HTMLObjectElement.h"
#include "HTMLOListElement.h"
#include "HTMLOptGroupElement.h"
#include "HTMLOptionElement.h"
#include "HTMLOutputElement.h"
#include "HTMLParagraphElement.h"
#include "HTMLParamElement.h"
#include "HTMLPictureElement.h"
#include "HTMLProgressElement.h"
#include "RubyTextElement.h"
#include "RubyElement.h"
#include "HTMLScriptElement.h"
#include "HTMLSelectElement.h"
#include "HTMLSlotElement.h"
#include "HTMLSourceElement.h"
#include "HTMLSpanElement.h"
#include "HTMLStyleElement.h"
#include "HTMLSummaryElement.h"
#include "HTMLTableElement.h"
#include "HTMLTableSectionElement.h"
#include "HTMLTableCellElement.h"
#include "HTMLTemplateElement.h"
#include "HTMLTextAreaElement.h"
#include "HTMLTimeElement.h"
#include "HTMLTitleElement.h"
#include "HTMLTableRowElement.h"
#include "HTMLUListElement.h"
#include "HTMLWBRElement.h"
#include "HTMLUnknownElement.h"

#if ENABLE(ATTACHMENT_ELEMENT)
#include "HTMLAttachmentElement.h"
#endif

#if ENABLE(DATALIST_ELEMENT)
#include "HTMLDataListElement.h"
#endif

#if ENABLE(METER_ELEMENT)
#include "HTMLMeterElement.h"
#endif

#if ENABLE(VIDEO)
#include "HTMLAudioElement.h"
#include "HTMLVideoElement.h"
#endif

#if ENABLE(VIDEO_TRACK)
#include "HTMLTrackElement.h"
#endif

#include "Document.h"
#include "RuntimeEnabledFeatures.h"
#include "Settings.h"
#include <wtf/HashMap.h>
#include <wtf/NeverDestroyed.h>

namespace WebCore {

typedef Ref<HTMLElement> (*HTMLConstructorFunction)(const QualifiedName&, Document&, HTMLFormElement*, bool createdByParser);

static Ref<HTMLElement> anchorConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAnchorElement::create(tagName, document);
}

static Ref<HTMLElement> Constructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLElement::create(tagName, document);
}

static Ref<HTMLElement> appletConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAppletElement::create(tagName, document);
}

static Ref<HTMLElement> areaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLAreaElement::create(tagName, document);
}

#if ENABLE(ATTACHMENT_ELEMENT)
static Ref<HTMLElement> attachmentConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!RuntimeEnabledFeatures::sharedFeatures().attachmentElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLAttachmentElement::create(tagName, document);
}
#endif

#if ENABLE(VIDEO)
static Ref<HTMLElement> audioConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    if (!document.settings().mediaEnabled())
        return HTMLUnknownElement::create(tagName, document);
    
    return HTMLAudioElement::create(tagName, document, createdByParser);
}
#endif

static Ref<HTMLElement> baseConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBaseElement::create(tagName, document);
}

static Ref<HTMLElement> bdiConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBDIElement::create(tagName, document);
}

static Ref<HTMLElement> unknownConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLUnknownElement::create(tagName, document);
}

static Ref<HTMLElement> quoteConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLQuoteElement::create(tagName, document);
}

static Ref<HTMLElement> bodyConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBodyElement::create(tagName, document);
}

static Ref<HTMLElement> brConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLBRElement::create(tagName, document);
}

static Ref<HTMLElement> buttonConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLButtonElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> canvasConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLCanvasElement::create(tagName, document);
}

static Ref<HTMLElement> tablecaptionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableCaptionElement::create(tagName, document);
}

static Ref<HTMLElement> tablecolConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableColElement::create(tagName, document);
}

static Ref<HTMLElement> dataConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDataElement::create(tagName, document);
}

#if ENABLE(DATALIST_ELEMENT)
static Ref<HTMLElement> datalistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!RuntimeEnabledFeatures::sharedFeatures().dataListElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLDataListElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> modConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLModElement::create(tagName, document);
}

static Ref<HTMLElement> detailsConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDetailsElement::create(tagName, document);
}

static Ref<HTMLElement> dialogConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!RuntimeEnabledFeatures::sharedFeatures().dialogElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLDialogElement::create(tagName, document);
}

static Ref<HTMLElement> directoryConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDirectoryElement::create(tagName, document);
}

static Ref<HTMLElement> divConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDivElement::create(tagName, document);
}

static Ref<HTMLElement> dlistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLDListElement::create(tagName, document);
}

static Ref<HTMLElement> embedConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLEmbedElement::create(tagName, document);
}

static Ref<HTMLElement> fieldsetConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLFieldSetElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> fontConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFontElement::create(tagName, document);
}

static Ref<HTMLElement> formConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFormElement::create(tagName, document);
}

static Ref<HTMLElement> frameConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFrameElement::create(tagName, document);
}

static Ref<HTMLElement> framesetConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLFrameSetElement::create(tagName, document);
}

static Ref<HTMLElement> headingConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHeadingElement::create(tagName, document);
}

static Ref<HTMLElement> headConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHeadElement::create(tagName, document);
}

static Ref<HTMLElement> hrConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHRElement::create(tagName, document);
}

static Ref<HTMLElement> htmlConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLHtmlElement::create(tagName, document);
}

static Ref<HTMLElement> iframeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLIFrameElement::create(tagName, document);
}

static Ref<HTMLElement> imageConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return HTMLImageElement::create(tagName, document, formElement, createdByParser);
}

static Ref<HTMLElement> inputConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    return HTMLInputElement::create(tagName, document, formElement, createdByParser);
}

static Ref<HTMLElement> keygenConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    if (!RuntimeEnabledFeatures::sharedFeatures().keygenElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLKeygenElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> labelConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLabelElement::create(tagName, document);
}

static Ref<HTMLElement> legendConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLegendElement::create(tagName, document);
}

static Ref<HTMLElement> liConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLLIElement::create(tagName, document);
}

static Ref<HTMLElement> linkConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLLinkElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> preConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLPreElement::create(tagName, document);
}

static Ref<HTMLElement> mapConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMapElement::create(tagName, document);
}

static Ref<HTMLElement> marqueeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMarqueeElement::create(tagName, document);
}

static Ref<HTMLElement> menuConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMenuElement::create(tagName, document);
}

static Ref<HTMLElement> menuitemConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!RuntimeEnabledFeatures::sharedFeatures().menuItemElementEnabled())
        return HTMLUnknownElement::create(tagName, document);
    return HTMLMenuItemElement::create(tagName, document);
}

static Ref<HTMLElement> metaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMetaElement::create(tagName, document);
}

#if ENABLE(METER_ELEMENT)
static Ref<HTMLElement> meterConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLMeterElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> objectConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLObjectElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> olistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOListElement::create(tagName, document);
}

static Ref<HTMLElement> optgroupConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOptGroupElement::create(tagName, document);
}

static Ref<HTMLElement> optionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLOptionElement::create(tagName, document);
}

static Ref<HTMLElement> outputConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLOutputElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> paragraphConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLParagraphElement::create(tagName, document);
}

static Ref<HTMLElement> paramConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLParamElement::create(tagName, document);
}

static Ref<HTMLElement> pictureConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLPictureElement::create(tagName, document);
}

static Ref<HTMLElement> progressConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLProgressElement::create(tagName, document);
}

static Ref<HTMLElement> rubytextelementConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return RubyTextElement::create(tagName, document);
}

static Ref<HTMLElement> rubyelementConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return RubyElement::create(tagName, document);
}

static Ref<HTMLElement> scriptConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLScriptElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> selectConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLSelectElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> slotConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSlotElement::create(tagName, document);
}

static Ref<HTMLElement> sourceConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSourceElement::create(tagName, document);
}

static Ref<HTMLElement> spanConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSpanElement::create(tagName, document);
}

static Ref<HTMLElement> styleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    return HTMLStyleElement::create(tagName, document, createdByParser);
}

static Ref<HTMLElement> summaryConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLSummaryElement::create(tagName, document);
}

static Ref<HTMLElement> tableConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableElement::create(tagName, document);
}

static Ref<HTMLElement> tablesectionConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableSectionElement::create(tagName, document);
}

static Ref<HTMLElement> tablecellConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableCellElement::create(tagName, document);
}

static Ref<HTMLElement> templateConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTemplateElement::create(tagName, document);
}

static Ref<HTMLElement> textareaConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement* formElement, bool)
{
    return HTMLTextAreaElement::create(tagName, document, formElement);
}

static Ref<HTMLElement> timeConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTimeElement::create(tagName, document);
}

static Ref<HTMLElement> titleConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTitleElement::create(tagName, document);
}

static Ref<HTMLElement> tablerowConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLTableRowElement::create(tagName, document);
}

#if ENABLE(VIDEO_TRACK)
static Ref<HTMLElement> trackConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    if (!document.settings().mediaEnabled())
        return HTMLUnknownElement::create(tagName, document);
    
    return HTMLTrackElement::create(tagName, document);
}
#endif

static Ref<HTMLElement> ulistConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLUListElement::create(tagName, document);
}

#if ENABLE(VIDEO)
static Ref<HTMLElement> videoConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool createdByParser)
{
    if (!document.settings().mediaEnabled())
        return HTMLUnknownElement::create(tagName, document);
    
    return HTMLVideoElement::create(tagName, document, createdByParser);
}
#endif

static Ref<HTMLElement> wbrConstructor(const QualifiedName& tagName, Document& document, HTMLFormElement*, bool)
{
    return HTMLWBRElement::create(tagName, document);
}


struct HTMLConstructorFunctionMapEntry {
    HTMLConstructorFunctionMapEntry(HTMLConstructorFunction function, const QualifiedName& name)
        : function(function)
        , qualifiedName(&name)
    { }

    HTMLConstructorFunctionMapEntry()
        : function(nullptr)
        , qualifiedName(nullptr)
    { }

    HTMLConstructorFunction function;
    const QualifiedName* qualifiedName; // Use pointer instead of reference so that emptyValue() in HashMap is cheap to create.
};

static NEVER_INLINE HashMap<AtomStringImpl*, HTMLConstructorFunctionMapEntry> createHTMLFactoryMap()
{
    struct TableEntry {
        const QualifiedName& name;
        HTMLConstructorFunction function;
    };

    static const TableEntry table[] = {
        { HTMLNames::aTag, anchorConstructor },
        { HTMLNames::abbrTag, Constructor },
        { HTMLNames::acronymTag, Constructor },
        { HTMLNames::addressTag, Constructor },
        { HTMLNames::appletTag, appletConstructor },
        { HTMLNames::areaTag, areaConstructor },
        { HTMLNames::articleTag, Constructor },
        { HTMLNames::asideTag, Constructor },
#if ENABLE(ATTACHMENT_ELEMENT)
        { HTMLNames::attachmentTag, attachmentConstructor },
#endif
#if ENABLE(VIDEO)
        { HTMLNames::audioTag, audioConstructor },
#endif
        { HTMLNames::bTag, Constructor },
        { HTMLNames::baseTag, baseConstructor },
        { HTMLNames::basefontTag, Constructor },
        { HTMLNames::bdiTag, bdiConstructor },
        { HTMLNames::bdoTag, Constructor },
        { HTMLNames::bgsoundTag, unknownConstructor },
        { HTMLNames::bigTag, Constructor },
        { HTMLNames::blockquoteTag, quoteConstructor },
        { HTMLNames::bodyTag, bodyConstructor },
        { HTMLNames::brTag, brConstructor },
        { HTMLNames::buttonTag, buttonConstructor },
        { HTMLNames::canvasTag, canvasConstructor },
        { HTMLNames::captionTag, tablecaptionConstructor },
        { HTMLNames::centerTag, Constructor },
        { HTMLNames::citeTag, Constructor },
        { HTMLNames::codeTag, Constructor },
        { HTMLNames::colTag, tablecolConstructor },
        { HTMLNames::colgroupTag, tablecolConstructor },
        { HTMLNames::commandTag, unknownConstructor },
        { HTMLNames::dataTag, dataConstructor },
#if ENABLE(DATALIST_ELEMENT)
        { HTMLNames::datalistTag, datalistConstructor },
#endif
        { HTMLNames::ddTag, Constructor },
        { HTMLNames::delTag, modConstructor },
        { HTMLNames::detailsTag, detailsConstructor },
        { HTMLNames::dfnTag, Constructor },
        { HTMLNames::dialogTag, dialogConstructor },
        { HTMLNames::dirTag, directoryConstructor },
        { HTMLNames::divTag, divConstructor },
        { HTMLNames::dlTag, dlistConstructor },
        { HTMLNames::dtTag, Constructor },
        { HTMLNames::emTag, Constructor },
        { HTMLNames::embedTag, embedConstructor },
        { HTMLNames::fieldsetTag, fieldsetConstructor },
        { HTMLNames::figcaptionTag, Constructor },
        { HTMLNames::figureTag, Constructor },
        { HTMLNames::fontTag, fontConstructor },
        { HTMLNames::footerTag, Constructor },
        { HTMLNames::formTag, formConstructor },
        { HTMLNames::frameTag, frameConstructor },
        { HTMLNames::framesetTag, framesetConstructor },
        { HTMLNames::h1Tag, headingConstructor },
        { HTMLNames::h2Tag, headingConstructor },
        { HTMLNames::h3Tag, headingConstructor },
        { HTMLNames::h4Tag, headingConstructor },
        { HTMLNames::h5Tag, headingConstructor },
        { HTMLNames::h6Tag, headingConstructor },
        { HTMLNames::headTag, headConstructor },
        { HTMLNames::headerTag, Constructor },
        { HTMLNames::hgroupTag, Constructor },
        { HTMLNames::hrTag, hrConstructor },
        { HTMLNames::htmlTag, htmlConstructor },
        { HTMLNames::iTag, Constructor },
        { HTMLNames::iframeTag, iframeConstructor },
        { HTMLNames::imageTag, unknownConstructor },
        { HTMLNames::imgTag, imageConstructor },
        { HTMLNames::inputTag, inputConstructor },
        { HTMLNames::insTag, modConstructor },
        { HTMLNames::kbdTag, Constructor },
        { HTMLNames::keygenTag, keygenConstructor },
        { HTMLNames::labelTag, labelConstructor },
        { HTMLNames::layerTag, Constructor },
        { HTMLNames::legendTag, legendConstructor },
        { HTMLNames::liTag, liConstructor },
        { HTMLNames::linkTag, linkConstructor },
        { HTMLNames::listingTag, preConstructor },
        { HTMLNames::mainTag, Constructor },
        { HTMLNames::mapTag, mapConstructor },
        { HTMLNames::markTag, Constructor },
        { HTMLNames::marqueeTag, marqueeConstructor },
        { HTMLNames::menuTag, menuConstructor },
        { HTMLNames::menuitemTag, menuitemConstructor },
        { HTMLNames::metaTag, metaConstructor },
#if ENABLE(METER_ELEMENT)
        { HTMLNames::meterTag, meterConstructor },
#endif
        { HTMLNames::navTag, Constructor },
        { HTMLNames::nobrTag, Constructor },
        { HTMLNames::noembedTag, Constructor },
        { HTMLNames::noframesTag, Constructor },
        { HTMLNames::nolayerTag, Constructor },
        { HTMLNames::noscriptTag, Constructor },
        { HTMLNames::objectTag, objectConstructor },
        { HTMLNames::olTag, olistConstructor },
        { HTMLNames::optgroupTag, optgroupConstructor },
        { HTMLNames::optionTag, optionConstructor },
        { HTMLNames::outputTag, outputConstructor },
        { HTMLNames::pTag, paragraphConstructor },
        { HTMLNames::paramTag, paramConstructor },
        { HTMLNames::pictureTag, pictureConstructor },
        { HTMLNames::plaintextTag, Constructor },
        { HTMLNames::preTag, preConstructor },
        { HTMLNames::progressTag, progressConstructor },
        { HTMLNames::qTag, quoteConstructor },
        { HTMLNames::rbTag, Constructor },
        { HTMLNames::rpTag, Constructor },
        { HTMLNames::rtTag, rubytextelementConstructor },
        { HTMLNames::rtcTag, Constructor },
        { HTMLNames::rubyTag, rubyelementConstructor },
        { HTMLNames::sTag, Constructor },
        { HTMLNames::sampTag, Constructor },
        { HTMLNames::scriptTag, scriptConstructor },
        { HTMLNames::sectionTag, Constructor },
        { HTMLNames::selectTag, selectConstructor },
        { HTMLNames::slotTag, slotConstructor },
        { HTMLNames::smallTag, Constructor },
        { HTMLNames::sourceTag, sourceConstructor },
        { HTMLNames::spanTag, spanConstructor },
        { HTMLNames::strikeTag, Constructor },
        { HTMLNames::strongTag, Constructor },
        { HTMLNames::styleTag, styleConstructor },
        { HTMLNames::subTag, Constructor },
        { HTMLNames::summaryTag, summaryConstructor },
        { HTMLNames::supTag, Constructor },
        { HTMLNames::tableTag, tableConstructor },
        { HTMLNames::tbodyTag, tablesectionConstructor },
        { HTMLNames::tdTag, tablecellConstructor },
        { HTMLNames::templateTag, templateConstructor },
        { HTMLNames::textareaTag, textareaConstructor },
        { HTMLNames::tfootTag, tablesectionConstructor },
        { HTMLNames::thTag, tablecellConstructor },
        { HTMLNames::theadTag, tablesectionConstructor },
        { HTMLNames::timeTag, timeConstructor },
        { HTMLNames::titleTag, titleConstructor },
        { HTMLNames::trTag, tablerowConstructor },
#if ENABLE(VIDEO_TRACK)
        { HTMLNames::trackTag, trackConstructor },
#endif
        { HTMLNames::ttTag, Constructor },
        { HTMLNames::uTag, Constructor },
        { HTMLNames::ulTag, ulistConstructor },
        { HTMLNames::varTag, Constructor },
#if ENABLE(VIDEO)
        { HTMLNames::videoTag, videoConstructor },
#endif
        { HTMLNames::wbrTag, wbrConstructor },
        { HTMLNames::xmpTag, preConstructor },
    };

    HashMap<AtomStringImpl*, HTMLConstructorFunctionMapEntry> map;
    for (auto& entry : table)
        map.add(entry.name.localName().impl(), HTMLConstructorFunctionMapEntry(entry.function, entry.name));
    return map;
}

static HTMLConstructorFunctionMapEntry findHTMLElementConstructorFunction(const AtomString& localName)
{
    static const auto map = makeNeverDestroyed(createHTMLFactoryMap());
    return map.get().get(localName.impl());
}

RefPtr<HTMLElement> HTMLElementFactory::createKnownElement(const AtomString& localName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    const HTMLConstructorFunctionMapEntry& entry = findHTMLElementConstructorFunction(localName);
    if (LIKELY(entry.function)) {
        ASSERT(entry.qualifiedName);
        const auto& name = *entry.qualifiedName;
        return entry.function(name, document, formElement, createdByParser);
    }
    return nullptr;
}

RefPtr<HTMLElement> HTMLElementFactory::createKnownElement(const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    const HTMLConstructorFunctionMapEntry& entry = findHTMLElementConstructorFunction(name.localName());
    if (LIKELY(entry.function))
        return entry.function(name, document, formElement, createdByParser);
    return nullptr;
}

Ref<HTMLElement> HTMLElementFactory::createElement(const AtomString& localName, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    const HTMLConstructorFunctionMapEntry& entry = findHTMLElementConstructorFunction(localName);
    if (LIKELY(entry.function)) {
        ASSERT(entry.qualifiedName);
        const auto& name = *entry.qualifiedName;
        return entry.function(name, document, formElement, createdByParser);
    }
    return HTMLUnknownElement::create(QualifiedName(nullAtom(), localName, HTMLNames::xhtmlNamespaceURI), document);
}

Ref<HTMLElement> HTMLElementFactory::createElement(const QualifiedName& name, Document& document, HTMLFormElement* formElement, bool createdByParser)
{
    const HTMLConstructorFunctionMapEntry& entry = findHTMLElementConstructorFunction(name.localName());
    if (LIKELY(entry.function))
        return entry.function(name, document, formElement, createdByParser);
    return HTMLUnknownElement::create(name, document);
}

} // namespace WebCore

