/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAnalyserNode.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetFloatFrequencyData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteFrequencyData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteTimeDomainData(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsAnalyserNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnalyserNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeFftSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnalyserNodeFftSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeFrequencyBinCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAnalyserNodeMinDecibels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnalyserNodeMinDecibels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeMaxDecibels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnalyserNodeMaxDecibels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnalyserNodeSmoothingTimeConstant(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnalyserNodeSmoothingTimeConstant(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAnalyserNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnalyserNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnalyserNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAnalyserNodePrototype>(vm.heap)) JSAnalyserNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnalyserNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnalyserNodePrototype, JSAnalyserNodePrototype::Base);

using JSAnalyserNodeConstructor = JSDOMConstructorNotConstructable<JSAnalyserNode>;

template<> JSValue JSAnalyserNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAnalyserNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAnalyserNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AnalyserNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAnalyserNodeConstructor::s_info = { "AnalyserNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnalyserNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAnalyserNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeConstructor) } },
    { "fftSize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeFftSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeFftSize) } },
    { "frequencyBinCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeFrequencyBinCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "minDecibels", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeMinDecibels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeMinDecibels) } },
    { "maxDecibels", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeMaxDecibels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeMaxDecibels) } },
    { "smoothingTimeConstant", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeSmoothingTimeConstant), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnalyserNodeSmoothingTimeConstant) } },
    { "getFloatFrequencyData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAnalyserNodePrototypeFunctionGetFloatFrequencyData), (intptr_t) (1) } },
    { "getByteFrequencyData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAnalyserNodePrototypeFunctionGetByteFrequencyData), (intptr_t) (1) } },
    { "getByteTimeDomainData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAnalyserNodePrototypeFunctionGetByteTimeDomainData), (intptr_t) (1) } },
};

const ClassInfo JSAnalyserNodePrototype::s_info = { "AnalyserNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnalyserNodePrototype) };

void JSAnalyserNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnalyserNode::info(), JSAnalyserNodePrototypeTableValues, *this);
}

const ClassInfo JSAnalyserNode::s_info = { "AnalyserNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnalyserNode) };

JSAnalyserNode::JSAnalyserNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnalyserNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSAnalyserNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AnalyserNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAnalyserNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAnalyserNodePrototype::create(vm, &globalObject, JSAnalyserNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSAnalyserNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnalyserNode>(vm, globalObject);
}

JSValue JSAnalyserNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnalyserNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAnalyserNode* IDLAttribute<JSAnalyserNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAnalyserNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSAnalyserNode* IDLOperation<JSAnalyserNode>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSAnalyserNode*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsAnalyserNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnalyserNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnalyserNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAnalyserNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnalyserNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAnalyserNodeFftSizeGetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.fftSize());
    return result;
}

EncodedJSValue jsAnalyserNodeFftSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnalyserNode>::get<jsAnalyserNodeFftSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fftSize");
}

static inline bool setJSAnalyserNodeFftSizeSetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFftSize(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAnalyserNodeFftSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAnalyserNode>::set<setJSAnalyserNodeFftSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "fftSize");
}

static inline JSValue jsAnalyserNodeFrequencyBinCountGetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.frequencyBinCount());
    return result;
}

EncodedJSValue jsAnalyserNodeFrequencyBinCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnalyserNode>::get<jsAnalyserNodeFrequencyBinCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "frequencyBinCount");
}

static inline JSValue jsAnalyserNodeMinDecibelsGetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.minDecibels());
    return result;
}

EncodedJSValue jsAnalyserNodeMinDecibels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnalyserNode>::get<jsAnalyserNodeMinDecibelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "minDecibels");
}

static inline bool setJSAnalyserNodeMinDecibelsSetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinDecibels(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAnalyserNodeMinDecibels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAnalyserNode>::set<setJSAnalyserNodeMinDecibelsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "minDecibels");
}

static inline JSValue jsAnalyserNodeMaxDecibelsGetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.maxDecibels());
    return result;
}

EncodedJSValue jsAnalyserNodeMaxDecibels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnalyserNode>::get<jsAnalyserNodeMaxDecibelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "maxDecibels");
}

static inline bool setJSAnalyserNodeMaxDecibelsSetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxDecibels(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAnalyserNodeMaxDecibels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAnalyserNode>::set<setJSAnalyserNodeMaxDecibelsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "maxDecibels");
}

static inline JSValue jsAnalyserNodeSmoothingTimeConstantGetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.smoothingTimeConstant());
    return result;
}

EncodedJSValue jsAnalyserNodeSmoothingTimeConstant(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnalyserNode>::get<jsAnalyserNodeSmoothingTimeConstantGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "smoothingTimeConstant");
}

static inline bool setJSAnalyserNodeSmoothingTimeConstantSetter(JSGlobalObject& lexicalGlobalObject, JSAnalyserNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSmoothingTimeConstant(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAnalyserNodeSmoothingTimeConstant(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAnalyserNode>::set<setJSAnalyserNodeSmoothingTimeConstantSetter>(*lexicalGlobalObject, thisValue, encodedValue, "smoothingTimeConstant");
}

static inline JSC::EncodedJSValue jsAnalyserNodePrototypeFunctionGetFloatFrequencyDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnalyserNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array = convert<IDLNullable<IDLFloat32Array>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array", "AnalyserNode", "getFloatFrequencyData", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getFloatFrequencyData(WTFMove(array));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetFloatFrequencyData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAnalyserNode>::call<jsAnalyserNodePrototypeFunctionGetFloatFrequencyDataBody>(*lexicalGlobalObject, *callFrame, "getFloatFrequencyData");
}

static inline JSC::EncodedJSValue jsAnalyserNodePrototypeFunctionGetByteFrequencyDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnalyserNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array = convert<IDLNullable<IDLUint8Array>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array", "AnalyserNode", "getByteFrequencyData", "Uint8Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getByteFrequencyData(WTFMove(array));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteFrequencyData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAnalyserNode>::call<jsAnalyserNodePrototypeFunctionGetByteFrequencyDataBody>(*lexicalGlobalObject, *callFrame, "getByteFrequencyData");
}

static inline JSC::EncodedJSValue jsAnalyserNodePrototypeFunctionGetByteTimeDomainDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnalyserNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array = convert<IDLNullable<IDLUint8Array>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array", "AnalyserNode", "getByteTimeDomainData", "Uint8Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getByteTimeDomainData(WTFMove(array));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteTimeDomainData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAnalyserNode>::call<jsAnalyserNodePrototypeFunctionGetByteTimeDomainDataBody>(*lexicalGlobalObject, *callFrame, "getByteTimeDomainData");
}

void JSAnalyserNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnalyserNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AnalyserNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AnalyserNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AnalyserNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AnalyserNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12AnalyserNodeE[2];
#endif

    // If this fails AnalyserNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AnalyserNode>::value, "AnalyserNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AnalyserNode has subclasses. If AnalyserNode has subclasses that get passed
    // to toJS() we currently require AnalyserNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AnalyserNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AnalyserNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
