/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationEffect.h"

#include "ActiveDOMObject.h"
#include "JSComputedEffectTiming.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEffectTiming.h"
#include "JSOptionalEffectTiming.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAnimationEffectPrototypeFunctionGetTiming(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAnimationEffectPrototypeFunctionGetComputedTiming(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAnimationEffectPrototypeFunctionUpdateTiming(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsAnimationEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnimationEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAnimationEffectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationEffectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationEffectPrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationEffectPrototype>(vm.heap)) JSAnimationEffectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationEffectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationEffectPrototype, JSAnimationEffectPrototype::Base);

using JSAnimationEffectConstructor = JSDOMConstructorNotConstructable<JSAnimationEffect>;

template<> JSValue JSAnimationEffectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAnimationEffectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAnimationEffect::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AnimationEffect"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAnimationEffectConstructor::s_info = { "AnimationEffect", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEffectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAnimationEffectPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationEffectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnimationEffectConstructor) } },
    { "getTiming", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAnimationEffectPrototypeFunctionGetTiming), (intptr_t) (0) } },
    { "getComputedTiming", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAnimationEffectPrototypeFunctionGetComputedTiming), (intptr_t) (0) } },
    { "updateTiming", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAnimationEffectPrototypeFunctionUpdateTiming), (intptr_t) (0) } },
};

const ClassInfo JSAnimationEffectPrototype::s_info = { "AnimationEffectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEffectPrototype) };

void JSAnimationEffectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationEffect::info(), JSAnimationEffectPrototypeTableValues, *this);
}

const ClassInfo JSAnimationEffect::s_info = { "AnimationEffect", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEffect) };

JSAnimationEffect::JSAnimationEffect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationEffect>&& impl)
    : JSDOMWrapper<AnimationEffect>(structure, globalObject, WTFMove(impl))
{
}

void JSAnimationEffect::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AnimationEffect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAnimationEffect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAnimationEffectPrototype::create(vm, &globalObject, JSAnimationEffectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSAnimationEffect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationEffect>(vm, globalObject);
}

JSValue JSAnimationEffect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationEffectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAnimationEffect::destroy(JSC::JSCell* cell)
{
    JSAnimationEffect* thisObject = static_cast<JSAnimationEffect*>(cell);
    thisObject->JSAnimationEffect::~JSAnimationEffect();
}

template<> inline JSAnimationEffect* IDLOperation<JSAnimationEffect>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSAnimationEffect*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsAnimationEffectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationEffectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationEffect::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAnimationEffectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationEffectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsAnimationEffectPrototypeFunctionGetTimingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnimationEffect>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<EffectTiming>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTiming()));
}

EncodedJSValue JSC_HOST_CALL jsAnimationEffectPrototypeFunctionGetTiming(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAnimationEffect>::call<jsAnimationEffectPrototypeFunctionGetTimingBody>(*lexicalGlobalObject, *callFrame, "getTiming");
}

static inline JSC::EncodedJSValue jsAnimationEffectPrototypeFunctionGetComputedTimingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnimationEffect>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<ComputedEffectTiming>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getComputedTiming()));
}

EncodedJSValue JSC_HOST_CALL jsAnimationEffectPrototypeFunctionGetComputedTiming(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAnimationEffect>::call<jsAnimationEffectPrototypeFunctionGetComputedTimingBody>(*lexicalGlobalObject, *callFrame, "getComputedTiming");
}

static inline JSC::EncodedJSValue jsAnimationEffectPrototypeFunctionUpdateTimingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAnimationEffect>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto timing = convert<IDLDictionary<OptionalEffectTiming>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.updateTiming(WTFMove(timing)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnimationEffectPrototypeFunctionUpdateTiming(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAnimationEffect>::call<jsAnimationEffectPrototypeFunctionUpdateTimingBody>(*lexicalGlobalObject, *callFrame, "updateTiming");
}

void JSAnimationEffect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationEffect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAnimationEffectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAnimationEffectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAnimationEffect = static_cast<JSAnimationEffect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAnimationEffect->wrapped(), jsAnimationEffect);
}

AnimationEffect* JSAnimationEffect::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAnimationEffect*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
