/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationPlaybackEvent.h"

#include "ActiveDOMObject.h"
#include "JSAnimationPlaybackEventInit.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAnimationPlaybackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnimationPlaybackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnimationPlaybackEventCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAnimationPlaybackEventTimelineTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAnimationPlaybackEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationPlaybackEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationPlaybackEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationPlaybackEventPrototype>(vm.heap)) JSAnimationPlaybackEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationPlaybackEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationPlaybackEventPrototype, JSAnimationPlaybackEventPrototype::Base);

using JSAnimationPlaybackEventConstructor = JSDOMConstructor<JSAnimationPlaybackEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSAnimationPlaybackEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSAnimationPlaybackEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<AnimationPlaybackEventInit>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = AnimationPlaybackEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<AnimationPlaybackEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSAnimationPlaybackEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSAnimationPlaybackEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAnimationPlaybackEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AnimationPlaybackEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAnimationPlaybackEventConstructor::s_info = { "AnimationPlaybackEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationPlaybackEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAnimationPlaybackEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationPlaybackEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnimationPlaybackEventConstructor) } },
    { "currentTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationPlaybackEventCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timelineTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationPlaybackEventTimelineTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAnimationPlaybackEventPrototype::s_info = { "AnimationPlaybackEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationPlaybackEventPrototype) };

void JSAnimationPlaybackEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationPlaybackEvent::info(), JSAnimationPlaybackEventPrototypeTableValues, *this);
}

const ClassInfo JSAnimationPlaybackEvent::s_info = { "AnimationPlaybackEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationPlaybackEvent) };

JSAnimationPlaybackEvent::JSAnimationPlaybackEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationPlaybackEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSAnimationPlaybackEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AnimationPlaybackEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAnimationPlaybackEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAnimationPlaybackEventPrototype::create(vm, &globalObject, JSAnimationPlaybackEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSAnimationPlaybackEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationPlaybackEvent>(vm, globalObject);
}

JSValue JSAnimationPlaybackEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationPlaybackEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAnimationPlaybackEvent* IDLAttribute<JSAnimationPlaybackEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAnimationPlaybackEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAnimationPlaybackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationPlaybackEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationPlaybackEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAnimationPlaybackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationPlaybackEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAnimationPlaybackEventCurrentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationPlaybackEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.bindingsCurrentTime());
    return result;
}

EncodedJSValue jsAnimationPlaybackEventCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnimationPlaybackEvent>::get<jsAnimationPlaybackEventCurrentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentTime");
}

static inline JSValue jsAnimationPlaybackEventTimelineTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationPlaybackEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.bindingsTimelineTime());
    return result;
}

EncodedJSValue jsAnimationPlaybackEventTimelineTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnimationPlaybackEvent>::get<jsAnimationPlaybackEventTimelineTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "timelineTime");
}

void JSAnimationPlaybackEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationPlaybackEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AnimationPlaybackEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22AnimationPlaybackEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AnimationPlaybackEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AnimationPlaybackEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22AnimationPlaybackEventE[2];
#endif

    // If this fails AnimationPlaybackEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AnimationPlaybackEvent>::value, "AnimationPlaybackEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AnimationPlaybackEvent has subclasses. If AnimationPlaybackEvent has subclasses that get passed
    // to toJS() we currently require AnimationPlaybackEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AnimationPlaybackEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AnimationPlaybackEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
