/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAudioConfiguration.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> AudioConfiguration convertDictionary<AudioConfiguration>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AudioConfiguration result;
    JSValue bitrateValue;
    if (isNullOrUndefined)
        bitrateValue = jsUndefined();
    else {
        bitrateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitrate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitrateValue.isUndefined()) {
        result.bitrate = convert<IDLUnsignedLongLong>(lexicalGlobalObject, bitrateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue channelsValue;
    if (isNullOrUndefined)
        channelsValue = jsUndefined();
    else {
        channelsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channels"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!channelsValue.isUndefined()) {
        result.channels = convert<IDLDOMString>(lexicalGlobalObject, channelsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue contentTypeValue;
    if (isNullOrUndefined)
        contentTypeValue = jsUndefined();
    else {
        contentTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "contentType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!contentTypeValue.isUndefined()) {
        result.contentType = convert<IDLDOMString>(lexicalGlobalObject, contentTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "contentType", "AudioConfiguration", "DOMString");
        return { };
    }
    JSValue samplerateValue;
    if (isNullOrUndefined)
        samplerateValue = jsUndefined();
    else {
        samplerateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "samplerate"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!samplerateValue.isUndefined()) {
        result.samplerate = convert<IDLUnsignedLong>(lexicalGlobalObject, samplerateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const AudioConfiguration& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnsignedLongLong::isNullValue(dictionary.bitrate)) {
        auto bitrateValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.bitrate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitrate"), bitrateValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.channels)) {
        auto channelsValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.channels));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "channels"), channelsValue);
    }
    auto contentTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.contentType);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "contentType"), contentTypeValue);
    if (!IDLUnsignedLong::isNullValue(dictionary.samplerate)) {
        auto samplerateValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.samplerate));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "samplerate"), samplerateValue);
    }
    return result;
}

} // namespace WebCore
