/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioContext.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSAnalyserNode.h"
#include "JSAudioBuffer.h"
#include "JSAudioBufferCallback.h"
#include "JSAudioBufferSourceNode.h"
#include "JSAudioDestinationNode.h"
#include "JSAudioListener.h"
#include "JSBiquadFilterNode.h"
#include "JSChannelMergerNode.h"
#include "JSChannelSplitterNode.h"
#include "JSConvolverNode.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSDelayNode.h"
#include "JSDynamicsCompressorNode.h"
#include "JSEventListener.h"
#include "JSGainNode.h"
#include "JSOscillatorNode.h"
#include "JSPannerNode.h"
#include "JSPeriodicWave.h"
#include "JSScriptProcessorNode.h"
#include "JSWaveShaperNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(MEDIA_STREAM)
#include "JSMediaStream.h"
#include "JSMediaStreamAudioDestinationNode.h"
#include "JSMediaStreamAudioSourceNode.h"
#endif

#if ENABLE(VIDEO)
#include "JSHTMLMediaElement.h"
#include "JSMediaElementAudioSourceNode.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(AudioContext::State enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("suspended"),
        MAKE_STATIC_STRING_IMPL("running"),
        MAKE_STATIC_STRING_IMPL("interrupted"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(AudioContext::State::Suspended) == 0, "AudioContext::State::Suspended is not 0 as expected");
    static_assert(static_cast<size_t>(AudioContext::State::Running) == 1, "AudioContext::State::Running is not 1 as expected");
    static_assert(static_cast<size_t>(AudioContext::State::Interrupted) == 2, "AudioContext::State::Interrupted is not 2 as expected");
    static_assert(static_cast<size_t>(AudioContext::State::Closed) == 3, "AudioContext::State::Closed is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, AudioContext::State enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<AudioContext::State> parseEnumeration<AudioContext::State>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "suspended")
        return AudioContext::State::Suspended;
    if (stringValue == "running")
        return AudioContext::State::Running;
    if (stringValue == "interrupted")
        return AudioContext::State::Interrupted;
    if (stringValue == "closed")
        return AudioContext::State::Closed;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<AudioContext::State>()
{
    return "\"suspended\", \"running\", \"interrupted\", \"closed\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionSuspend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionResume(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionDecodeAudioData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBufferSource(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaElementSource(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaStreamSource(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaStreamDestination(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGain(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelay(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBiquadFilter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateWaveShaper(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePanner(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateConvolver(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDynamicsCompressor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateAnalyser(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateScriptProcessor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateOscillator(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePeriodicWave(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelSplitter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelMerger(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionStartRendering(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsAudioContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioContextDestination(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextSampleRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextListener(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextOnstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioContextOnstatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioContextActiveSourceCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioContextOncomplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioContextOncomplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioContextPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioContextPrototype>(vm.heap)) JSAudioContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioContextPrototype, JSAudioContextPrototype::Base);

using JSAudioContextConstructor = JSDOMConstructor<JSAudioContext>;

template<> EncodedJSValue JSC_HOST_CALL JSAudioContextConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSAudioContextConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "webkitAudioContext");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto object = AudioContext::create(document);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<AudioContext>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSAudioContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSAudioContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioContext::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("webkitAudioContext"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAudioContextConstructor::s_info = { "webkitAudioContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioContextPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioContextConstructor) } },
    { "destination", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextDestination), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sampleRate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextSampleRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "listener", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextListener), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "state", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onstatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextOnstatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioContextOnstatechange) } },
    { "activeSourceCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextActiveSourceCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oncomplete", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioContextOncomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioContextOncomplete) } },
    { "suspend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionSuspend), (intptr_t) (0) } },
    { "resume", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionResume), (intptr_t) (0) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionClose), (intptr_t) (0) } },
    { "createBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateBuffer), (intptr_t) (2) } },
    { "decodeAudioData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionDecodeAudioData), (intptr_t) (2) } },
    { "createBufferSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateBufferSource), (intptr_t) (0) } },
#if ENABLE(VIDEO)
    { "createMediaElementSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateMediaElementSource), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "createMediaStreamSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateMediaStreamSource), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "createMediaStreamDestination", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateMediaStreamDestination), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "createGain", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateGain), (intptr_t) (0) } },
    { "createDelay", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateDelay), (intptr_t) (0) } },
    { "createBiquadFilter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateBiquadFilter), (intptr_t) (0) } },
    { "createWaveShaper", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateWaveShaper), (intptr_t) (0) } },
    { "createPanner", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreatePanner), (intptr_t) (0) } },
    { "createConvolver", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateConvolver), (intptr_t) (0) } },
    { "createDynamicsCompressor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateDynamicsCompressor), (intptr_t) (0) } },
    { "createAnalyser", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateAnalyser), (intptr_t) (0) } },
    { "createScriptProcessor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateScriptProcessor), (intptr_t) (0) } },
    { "createOscillator", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateOscillator), (intptr_t) (0) } },
    { "createPeriodicWave", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreatePeriodicWave), (intptr_t) (2) } },
    { "createChannelSplitter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateChannelSplitter), (intptr_t) (0) } },
    { "createChannelMerger", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionCreateChannelMerger), (intptr_t) (0) } },
    { "startRendering", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioContextPrototypeFunctionStartRendering), (intptr_t) (0) } },
};

const ClassInfo JSAudioContextPrototype::s_info = { "webkitAudioContextPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioContextPrototype) };

void JSAudioContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioContext::info(), JSAudioContextPrototypeTableValues, *this);
}

const ClassInfo JSAudioContext::s_info = { "webkitAudioContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioContext) };

JSAudioContext::JSAudioContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioContext>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSAudioContext::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, AudioContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSAudioContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAudioContextPrototype::create(vm, &globalObject, JSAudioContextPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSAudioContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioContext>(vm, globalObject);
}

JSValue JSAudioContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAudioContext* IDLAttribute<JSAudioContext>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAudioContext*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSAudioContext* IDLOperation<JSAudioContext>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSAudioContext*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsAudioContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAudioContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAudioContextDestinationGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioDestinationNode>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.destination());
    return result;
}

EncodedJSValue jsAudioContextDestination(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextDestinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "destination");
}

static inline JSValue jsAudioContextCurrentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.currentTime());
    return result;
}

EncodedJSValue jsAudioContextCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextCurrentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentTime");
}

static inline JSValue jsAudioContextSampleRateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.sampleRate());
    return result;
}

EncodedJSValue jsAudioContextSampleRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextSampleRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sampleRate");
}

static inline JSValue jsAudioContextListenerGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioListener>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.listener());
    return result;
}

EncodedJSValue jsAudioContextListener(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextListenerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "listener");
}

static inline JSValue jsAudioContextStateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<AudioContext::State>>(lexicalGlobalObject, throwScope, impl.state());
    return result;
}

EncodedJSValue jsAudioContextState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "state");
}

static inline JSValue jsAudioContextOnstatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().statechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsAudioContextOnstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextOnstatechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstatechange");
}

static inline bool setJSAudioContextOnstatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().statechangeEvent, value);
    return true;
}

bool setJSAudioContextOnstatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioContext>::set<setJSAudioContextOnstatechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstatechange");
}

static inline JSValue jsAudioContextActiveSourceCountGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.activeSourceCount());
    return result;
}

EncodedJSValue jsAudioContextActiveSourceCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextActiveSourceCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "activeSourceCount");
}

static inline JSValue jsAudioContextOncompleteGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().completeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsAudioContextOncomplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContextOncompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncomplete");
}

static inline bool setJSAudioContextOncompleteSetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().completeEvent, value);
    return true;
}

bool setJSAudioContextOncomplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioContext>::set<setJSAudioContextOncompleteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncomplete");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionSuspendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.suspendRendering(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionSuspend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSAudioContext>::call<jsAudioContextPrototypeFunctionSuspendBody>(*lexicalGlobalObject, *callFrame, "suspend");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionResumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.resumeRendering(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionResume(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSAudioContext>::call<jsAudioContextPrototypeFunctionResumeBody>(*lexicalGlobalObject, *callFrame, "resume");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.close(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSAudioContext>::call<jsAudioContextPrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateBuffer1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto numberOfChannels = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto numberOfFrames = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sampleRate = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<AudioBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBuffer(WTFMove(numberOfChannels), WTFMove(numberOfFrames), WTFMove(sampleRate))));
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateBuffer2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto buffer = convert<IDLArrayBuffer>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "webkitAudioContext", "createBuffer", "ArrayBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto mixToMono = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<AudioBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBuffer(*buffer, WTFMove(mixToMono))));
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateBufferOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsAudioContextPrototypeFunctionCreateBuffer2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsAudioContextPrototypeFunctionCreateBuffer1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateBufferOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "createBuffer");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionDecodeAudioDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto audioData = convert<IDLArrayBuffer>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "audioData", "webkitAudioContext", "decodeAudioData", "ArrayBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto successCallback = convert<IDLNullable<IDLCallbackFunction<JSAudioBufferCallback>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "successCallback", "webkitAudioContext", "decodeAudioData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSAudioBufferCallback>>>(*lexicalGlobalObject, callFrame->argument(2), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "errorCallback", "webkitAudioContext", "decodeAudioData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.decodeAudioData(*audioData, WTFMove(successCallback), WTFMove(errorCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionDecodeAudioData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionDecodeAudioDataBody>(*lexicalGlobalObject, *callFrame, "decodeAudioData");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateBufferSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<AudioBufferSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBufferSource()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBufferSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateBufferSourceBody>(*lexicalGlobalObject, *callFrame, "createBufferSource");
}

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateMediaElementSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaElement = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaElement", "webkitAudioContext", "createMediaElementSource", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<MediaElementAudioSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createMediaElementSource(*mediaElement)));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaElementSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateMediaElementSourceBody>(*lexicalGlobalObject, *callFrame, "createMediaElementSource");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateMediaStreamSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaStream = convert<IDLInterface<MediaStream>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaStream", "webkitAudioContext", "createMediaStreamSource", "MediaStream"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<MediaStreamAudioSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createMediaStreamSource(*mediaStream)));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaStreamSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateMediaStreamSourceBody>(*lexicalGlobalObject, *callFrame, "createMediaStreamSource");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateMediaStreamDestinationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<MediaStreamAudioDestinationNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createMediaStreamDestination()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateMediaStreamDestination(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateMediaStreamDestinationBody>(*lexicalGlobalObject, *callFrame, "createMediaStreamDestination");
}

#endif

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateGainBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<GainNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createGain()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateGain(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateGainBody>(*lexicalGlobalObject, *callFrame, "createGain");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateDelayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto maxDelayTime = callFrame->argument(0).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DelayNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDelay(WTFMove(maxDelayTime))));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDelay(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateDelayBody>(*lexicalGlobalObject, *callFrame, "createDelay");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateBiquadFilterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<BiquadFilterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createBiquadFilter()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateBiquadFilter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateBiquadFilterBody>(*lexicalGlobalObject, *callFrame, "createBiquadFilter");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateWaveShaperBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<WaveShaperNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createWaveShaper()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateWaveShaper(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateWaveShaperBody>(*lexicalGlobalObject, *callFrame, "createWaveShaper");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreatePannerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<PannerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPanner()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePanner(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreatePannerBody>(*lexicalGlobalObject, *callFrame, "createPanner");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateConvolverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<ConvolverNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createConvolver()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateConvolver(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateConvolverBody>(*lexicalGlobalObject, *callFrame, "createConvolver");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateDynamicsCompressorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DynamicsCompressorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDynamicsCompressor()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateDynamicsCompressor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateDynamicsCompressorBody>(*lexicalGlobalObject, *callFrame, "createDynamicsCompressor");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateAnalyserBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<AnalyserNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAnalyser()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateAnalyser(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateAnalyserBody>(*lexicalGlobalObject, *callFrame, "createAnalyser");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateScriptProcessorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto bufferSize = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto numberOfInputChannels = callFrame->argument(1).isUndefined() ? 2 : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto numberOfOutputChannels = callFrame->argument(2).isUndefined() ? 2 : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ScriptProcessorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createScriptProcessor(WTFMove(bufferSize), WTFMove(numberOfInputChannels), WTFMove(numberOfOutputChannels))));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateScriptProcessor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateScriptProcessorBody>(*lexicalGlobalObject, *callFrame, "createScriptProcessor");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateOscillatorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<OscillatorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createOscillator()));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateOscillator(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateOscillatorBody>(*lexicalGlobalObject, *callFrame, "createOscillator");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreatePeriodicWaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto real = convert<IDLFloat32Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "real", "webkitAudioContext", "createPeriodicWave", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto imag = convert<IDLFloat32Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "imag", "webkitAudioContext", "createPeriodicWave", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<PeriodicWave>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPeriodicWave(real.releaseNonNull(), imag.releaseNonNull())));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreatePeriodicWave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreatePeriodicWaveBody>(*lexicalGlobalObject, *callFrame, "createPeriodicWave");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateChannelSplitterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto numberOfOutputs = callFrame->argument(0).isUndefined() ? 6 : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ChannelSplitterNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createChannelSplitter(WTFMove(numberOfOutputs))));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelSplitter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateChannelSplitterBody>(*lexicalGlobalObject, *callFrame, "createChannelSplitter");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionCreateChannelMergerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto numberOfInputs = callFrame->argument(0).isUndefined() ? 6 : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ChannelMergerNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createChannelMerger(WTFMove(numberOfInputs))));
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionCreateChannelMerger(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionCreateChannelMergerBody>(*lexicalGlobalObject, *callFrame, "createChannelMerger");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunctionStartRenderingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.startRendering();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioContextPrototypeFunctionStartRendering(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunctionStartRenderingBody>(*lexicalGlobalObject, *callFrame, "startRendering");
}

void JSAudioContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsAudioContext = jsCast<JSAudioContext*>(handle.slot()->asCell());
    if (jsAudioContext->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsAudioContext->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioContext = static_cast<JSAudioContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioContext->wrapped(), jsAudioContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AudioContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioContext>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AudioContext@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12AudioContextE[2];
#endif

    // If this fails AudioContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AudioContext>::value, "AudioContext is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AudioContext has subclasses. If AudioContext has subclasses that get passed
    // to toJS() we currently require AudioContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AudioContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioContext* JSAudioContext::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioContext*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
