/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioNode.h"

#include "ActiveDOMObject.h"
#include "JSAudioContext.h"
#include "JSAudioNode.h"
#include "JSAudioParam.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionConnect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionDisconnect(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsAudioNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioNodeContext(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioNodeNumberOfInputs(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioNodeNumberOfOutputs(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioNodeChannelCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioNodeChannelCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioNodeChannelCountMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioNodeChannelCountMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioNodeChannelInterpretation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioNodeChannelInterpretation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioNodePrototype>(vm.heap)) JSAudioNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioNodePrototype, JSAudioNodePrototype::Base);

using JSAudioNodeConstructor = JSDOMConstructorNotConstructable<JSAudioNode>;

template<> JSValue JSAudioNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSAudioNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AudioNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAudioNodeConstructor::s_info = { "AudioNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeConstructor) } },
    { "context", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeContext), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "numberOfInputs", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeNumberOfInputs), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "numberOfOutputs", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeNumberOfOutputs), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "channelCount", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeChannelCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeChannelCount) } },
    { "channelCountMode", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeChannelCountMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeChannelCountMode) } },
    { "channelInterpretation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioNodeChannelInterpretation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioNodeChannelInterpretation) } },
    { "connect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioNodePrototypeFunctionConnect), (intptr_t) (1) } },
    { "disconnect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioNodePrototypeFunctionDisconnect), (intptr_t) (0) } },
};

const ClassInfo JSAudioNodePrototype::s_info = { "AudioNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioNodePrototype) };

void JSAudioNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioNode::info(), JSAudioNodePrototypeTableValues, *this);
}

const ClassInfo JSAudioNode::s_info = { "AudioNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioNode) };

JSAudioNode::JSAudioNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioNode>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSAudioNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AudioNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAudioNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAudioNodePrototype::create(vm, &globalObject, JSAudioNodePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSAudioNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioNode>(vm, globalObject);
}

JSValue JSAudioNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAudioNode* IDLAttribute<JSAudioNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAudioNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSAudioNode* IDLOperation<JSAudioNode>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSAudioNode*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsAudioNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAudioNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAudioNodeContextGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioContext>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.context());
    return result;
}

EncodedJSValue jsAudioNodeContext(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNodeContextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "context");
}

static inline JSValue jsAudioNodeNumberOfInputsGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfInputs());
    return result;
}

EncodedJSValue jsAudioNodeNumberOfInputs(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNodeNumberOfInputsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "numberOfInputs");
}

static inline JSValue jsAudioNodeNumberOfOutputsGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfOutputs());
    return result;
}

EncodedJSValue jsAudioNodeNumberOfOutputs(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNodeNumberOfOutputsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "numberOfOutputs");
}

static inline JSValue jsAudioNodeChannelCountGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.channelCount());
    return result;
}

EncodedJSValue jsAudioNodeChannelCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNodeChannelCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "channelCount");
}

static inline bool setJSAudioNodeChannelCountSetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setChannelCount(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioNodeChannelCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioNode>::set<setJSAudioNodeChannelCountSetter>(*lexicalGlobalObject, thisValue, encodedValue, "channelCount");
}

static inline JSValue jsAudioNodeChannelCountModeGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.channelCountMode());
    return result;
}

EncodedJSValue jsAudioNodeChannelCountMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNodeChannelCountModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "channelCountMode");
}

static inline bool setJSAudioNodeChannelCountModeSetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setChannelCountMode(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioNodeChannelCountMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioNode>::set<setJSAudioNodeChannelCountModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "channelCountMode");
}

static inline JSValue jsAudioNodeChannelInterpretationGetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.channelInterpretation());
    return result;
}

EncodedJSValue jsAudioNodeChannelInterpretation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioNode>::get<jsAudioNodeChannelInterpretationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "channelInterpretation");
}

static inline bool setJSAudioNodeChannelInterpretationSetter(JSGlobalObject& lexicalGlobalObject, JSAudioNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setChannelInterpretation(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioNodeChannelInterpretation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioNode>::set<setJSAudioNodeChannelInterpretationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "channelInterpretation");
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunctionConnect1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto returnValue = callFrame->uncheckedArgument(0);
    auto destination = convert<IDLInterface<AudioNode>>(*lexicalGlobalObject, returnValue, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destination", "AudioNode", "connect", "AudioNode"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto output = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto input = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.connect(*destination, WTFMove(output), WTFMove(input)));
    return JSValue::encode(returnValue);
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunctionConnect2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto destination = convert<IDLInterface<AudioParam>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "destination", "AudioNode", "connect", "AudioParam"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto output = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.connect(*destination, WTFMove(output)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunctionConnectOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioNode>(vm))
            return jsAudioNodePrototypeFunctionConnect1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioParam>(vm))
            return jsAudioNodePrototypeFunctionConnect2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioNode>(vm))
            return jsAudioNodePrototypeFunctionConnect1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioParam>(vm))
            return jsAudioNodePrototypeFunctionConnect2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsAudioNodePrototypeFunctionConnect1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionConnect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioNode>::call<jsAudioNodePrototypeFunctionConnectOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "connect");
}

static inline JSC::EncodedJSValue jsAudioNodePrototypeFunctionDisconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto output = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.disconnect(WTFMove(output)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioNodePrototypeFunctionDisconnect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioNode>::call<jsAudioNodePrototypeFunctionDisconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

void JSAudioNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9AudioNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AudioNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9AudioNodeE[2];
#endif

    // If this fails AudioNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AudioNode>::value, "AudioNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AudioNode has subclasses. If AudioNode has subclasses that get passed
    // to toJS() we currently require AudioNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AudioNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioNode* JSAudioNode::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioNode*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
