/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSAuthenticatorAttestationResponse.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAuthenticatorAttestationResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAuthenticatorAttestationResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAuthenticatorAttestationResponseAttestationObject(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAuthenticatorAttestationResponsePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAuthenticatorAttestationResponsePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAuthenticatorAttestationResponsePrototype* ptr = new (NotNull, JSC::allocateCell<JSAuthenticatorAttestationResponsePrototype>(vm.heap)) JSAuthenticatorAttestationResponsePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAuthenticatorAttestationResponsePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAuthenticatorAttestationResponsePrototype, JSAuthenticatorAttestationResponsePrototype::Base);

using JSAuthenticatorAttestationResponseConstructor = JSDOMConstructorNotConstructable<JSAuthenticatorAttestationResponse>;

template<> JSValue JSAuthenticatorAttestationResponseConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAuthenticatorResponse::getConstructor(vm, &globalObject);
}

template<> void JSAuthenticatorAttestationResponseConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAuthenticatorAttestationResponse::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AuthenticatorAttestationResponse"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAuthenticatorAttestationResponseConstructor::s_info = { "AuthenticatorAttestationResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorAttestationResponseConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAuthenticatorAttestationResponsePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorAttestationResponseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAuthenticatorAttestationResponseConstructor) } },
    { "attestationObject", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorAttestationResponseAttestationObject), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAuthenticatorAttestationResponsePrototype::s_info = { "AuthenticatorAttestationResponsePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorAttestationResponsePrototype) };

void JSAuthenticatorAttestationResponsePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAuthenticatorAttestationResponse::info(), JSAuthenticatorAttestationResponsePrototypeTableValues, *this);
}

const ClassInfo JSAuthenticatorAttestationResponse::s_info = { "AuthenticatorAttestationResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorAttestationResponse) };

JSAuthenticatorAttestationResponse::JSAuthenticatorAttestationResponse(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AuthenticatorAttestationResponse>&& impl)
    : JSAuthenticatorResponse(structure, globalObject, WTFMove(impl))
{
}

void JSAuthenticatorAttestationResponse::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AuthenticatorAttestationResponse>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAuthenticatorAttestationResponse::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAuthenticatorAttestationResponsePrototype::create(vm, &globalObject, JSAuthenticatorAttestationResponsePrototype::createStructure(vm, &globalObject, JSAuthenticatorResponse::prototype(vm, globalObject)));
}

JSObject* JSAuthenticatorAttestationResponse::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAuthenticatorAttestationResponse>(vm, globalObject);
}

JSValue JSAuthenticatorAttestationResponse::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAuthenticatorAttestationResponseConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAuthenticatorAttestationResponse* IDLAttribute<JSAuthenticatorAttestationResponse>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAuthenticatorAttestationResponse*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAuthenticatorAttestationResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAuthenticatorAttestationResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAuthenticatorAttestationResponse::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAuthenticatorAttestationResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAuthenticatorAttestationResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAuthenticatorAttestationResponseAttestationObjectGetter(JSGlobalObject& lexicalGlobalObject, JSAuthenticatorAttestationResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLArrayBuffer>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.attestationObject());
    return result;
}

EncodedJSValue jsAuthenticatorAttestationResponseAttestationObject(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAuthenticatorAttestationResponse>::get<jsAuthenticatorAttestationResponseAttestationObjectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "attestationObject");
}

void JSAuthenticatorAttestationResponse::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAuthenticatorAttestationResponse*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(WEB_AUTHN)
