/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSAuthenticatorResponse.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAuthenticatorResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAuthenticatorResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAuthenticatorResponseClientDataJSON(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAuthenticatorResponsePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAuthenticatorResponsePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAuthenticatorResponsePrototype* ptr = new (NotNull, JSC::allocateCell<JSAuthenticatorResponsePrototype>(vm.heap)) JSAuthenticatorResponsePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAuthenticatorResponsePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAuthenticatorResponsePrototype, JSAuthenticatorResponsePrototype::Base);

using JSAuthenticatorResponseConstructor = JSDOMConstructorNotConstructable<JSAuthenticatorResponse>;

template<> JSValue JSAuthenticatorResponseConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAuthenticatorResponseConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAuthenticatorResponse::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AuthenticatorResponse"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAuthenticatorResponseConstructor::s_info = { "AuthenticatorResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorResponseConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAuthenticatorResponsePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorResponseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAuthenticatorResponseConstructor) } },
    { "clientDataJSON", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorResponseClientDataJSON), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAuthenticatorResponsePrototype::s_info = { "AuthenticatorResponsePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorResponsePrototype) };

void JSAuthenticatorResponsePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAuthenticatorResponse::info(), JSAuthenticatorResponsePrototypeTableValues, *this);
}

const ClassInfo JSAuthenticatorResponse::s_info = { "AuthenticatorResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorResponse) };

JSAuthenticatorResponse::JSAuthenticatorResponse(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AuthenticatorResponse>&& impl)
    : JSDOMWrapper<AuthenticatorResponse>(structure, globalObject, WTFMove(impl))
{
}

void JSAuthenticatorResponse::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AuthenticatorResponse>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAuthenticatorResponse::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAuthenticatorResponsePrototype::create(vm, &globalObject, JSAuthenticatorResponsePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSAuthenticatorResponse::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAuthenticatorResponse>(vm, globalObject);
}

JSValue JSAuthenticatorResponse::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAuthenticatorResponseConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAuthenticatorResponse::destroy(JSC::JSCell* cell)
{
    JSAuthenticatorResponse* thisObject = static_cast<JSAuthenticatorResponse*>(cell);
    thisObject->JSAuthenticatorResponse::~JSAuthenticatorResponse();
}

template<> inline JSAuthenticatorResponse* IDLAttribute<JSAuthenticatorResponse>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAuthenticatorResponse*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAuthenticatorResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAuthenticatorResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAuthenticatorResponse::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAuthenticatorResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAuthenticatorResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAuthenticatorResponseClientDataJSONGetter(JSGlobalObject& lexicalGlobalObject, JSAuthenticatorResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLArrayBuffer>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.clientDataJSON());
    return result;
}

EncodedJSValue jsAuthenticatorResponseClientDataJSON(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAuthenticatorResponse>::get<jsAuthenticatorResponseClientDataJSONGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientDataJSON");
}

void JSAuthenticatorResponse::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAuthenticatorResponse*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAuthenticatorResponseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAuthenticatorResponseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAuthenticatorResponse = static_cast<JSAuthenticatorResponse*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAuthenticatorResponse->wrapped(), jsAuthenticatorResponse);
}

AuthenticatorResponse* JSAuthenticatorResponse::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAuthenticatorResponse*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUTHN)
