/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSBiquadFilterNode.h"

#include "ActiveDOMObject.h"
#include "JSAudioParam.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

String convertEnumerationToString(BiquadFilterType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("lowpass"),
        MAKE_STATIC_STRING_IMPL("highpass"),
        MAKE_STATIC_STRING_IMPL("bandpass"),
        MAKE_STATIC_STRING_IMPL("lowshelf"),
        MAKE_STATIC_STRING_IMPL("highshelf"),
        MAKE_STATIC_STRING_IMPL("peaking"),
        MAKE_STATIC_STRING_IMPL("notch"),
        MAKE_STATIC_STRING_IMPL("allpass"),
    };
    static_assert(static_cast<size_t>(BiquadFilterType::Lowpass) == 0, "BiquadFilterType::Lowpass is not 0 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Highpass) == 1, "BiquadFilterType::Highpass is not 1 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Bandpass) == 2, "BiquadFilterType::Bandpass is not 2 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Lowshelf) == 3, "BiquadFilterType::Lowshelf is not 3 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Highshelf) == 4, "BiquadFilterType::Highshelf is not 4 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Peaking) == 5, "BiquadFilterType::Peaking is not 5 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Notch) == 6, "BiquadFilterType::Notch is not 6 as expected");
    static_assert(static_cast<size_t>(BiquadFilterType::Allpass) == 7, "BiquadFilterType::Allpass is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, BiquadFilterType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<BiquadFilterType> parseEnumeration<BiquadFilterType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "lowpass")
        return BiquadFilterType::Lowpass;
    if (stringValue == "highpass")
        return BiquadFilterType::Highpass;
    if (stringValue == "bandpass")
        return BiquadFilterType::Bandpass;
    if (stringValue == "lowshelf")
        return BiquadFilterType::Lowshelf;
    if (stringValue == "highshelf")
        return BiquadFilterType::Highshelf;
    if (stringValue == "peaking")
        return BiquadFilterType::Peaking;
    if (stringValue == "notch")
        return BiquadFilterType::Notch;
    if (stringValue == "allpass")
        return BiquadFilterType::Allpass;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<BiquadFilterType>()
{
    return "\"lowpass\", \"highpass\", \"bandpass\", \"lowshelf\", \"highshelf\", \"peaking\", \"notch\", \"allpass\"";
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsBiquadFilterNodePrototypeFunctionGetFrequencyResponse(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsBiquadFilterNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSBiquadFilterNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsBiquadFilterNodeType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSBiquadFilterNodeType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsBiquadFilterNodeFrequency(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeDetune(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeQ(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsBiquadFilterNodeGain(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSBiquadFilterNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSBiquadFilterNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSBiquadFilterNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSBiquadFilterNodePrototype>(vm.heap)) JSBiquadFilterNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSBiquadFilterNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSBiquadFilterNodePrototype, JSBiquadFilterNodePrototype::Base);

using JSBiquadFilterNodeConstructor = JSDOMConstructorNotConstructable<JSBiquadFilterNode>;

template<> JSValue JSBiquadFilterNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSBiquadFilterNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSBiquadFilterNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("BiquadFilterNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSBiquadFilterNodeConstructor::s_info = { "BiquadFilterNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBiquadFilterNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSBiquadFilterNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBiquadFilterNodeConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSBiquadFilterNodeType) } },
    { "frequency", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeFrequency), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "detune", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeDetune), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "Q", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeQ), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gain", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBiquadFilterNodeGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getFrequencyResponse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsBiquadFilterNodePrototypeFunctionGetFrequencyResponse), (intptr_t) (3) } },
};

const ClassInfo JSBiquadFilterNodePrototype::s_info = { "BiquadFilterNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBiquadFilterNodePrototype) };

void JSBiquadFilterNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSBiquadFilterNode::info(), JSBiquadFilterNodePrototypeTableValues, *this);
}

const ClassInfo JSBiquadFilterNode::s_info = { "BiquadFilterNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSBiquadFilterNode) };

JSBiquadFilterNode::JSBiquadFilterNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<BiquadFilterNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSBiquadFilterNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, BiquadFilterNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSBiquadFilterNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSBiquadFilterNodePrototype::create(vm, &globalObject, JSBiquadFilterNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSBiquadFilterNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSBiquadFilterNode>(vm, globalObject);
}

JSValue JSBiquadFilterNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBiquadFilterNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSBiquadFilterNode* IDLAttribute<JSBiquadFilterNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSBiquadFilterNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSBiquadFilterNode* IDLOperation<JSBiquadFilterNode>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSBiquadFilterNode*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsBiquadFilterNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBiquadFilterNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSBiquadFilterNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSBiquadFilterNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSBiquadFilterNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsBiquadFilterNodeTypeGetter(JSGlobalObject& lexicalGlobalObject, JSBiquadFilterNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<BiquadFilterType>>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsBiquadFilterNodeType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSBiquadFilterNode>::get<jsBiquadFilterNodeTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline bool setJSBiquadFilterNodeTypeSetter(JSGlobalObject& lexicalGlobalObject, JSBiquadFilterNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<BiquadFilterType>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setType(WTFMove(nativeValue));
    });
    return true;
}

bool setJSBiquadFilterNodeType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSBiquadFilterNode>::set<setJSBiquadFilterNodeTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "type");
}

static inline JSValue jsBiquadFilterNodeFrequencyGetter(JSGlobalObject& lexicalGlobalObject, JSBiquadFilterNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.frequency());
    return result;
}

EncodedJSValue jsBiquadFilterNodeFrequency(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSBiquadFilterNode>::get<jsBiquadFilterNodeFrequencyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "frequency");
}

static inline JSValue jsBiquadFilterNodeDetuneGetter(JSGlobalObject& lexicalGlobalObject, JSBiquadFilterNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.detune());
    return result;
}

EncodedJSValue jsBiquadFilterNodeDetune(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSBiquadFilterNode>::get<jsBiquadFilterNodeDetuneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "detune");
}

static inline JSValue jsBiquadFilterNodeQGetter(JSGlobalObject& lexicalGlobalObject, JSBiquadFilterNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.q());
    return result;
}

EncodedJSValue jsBiquadFilterNodeQ(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSBiquadFilterNode>::get<jsBiquadFilterNodeQGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "Q");
}

static inline JSValue jsBiquadFilterNodeGainGetter(JSGlobalObject& lexicalGlobalObject, JSBiquadFilterNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.gain());
    return result;
}

EncodedJSValue jsBiquadFilterNodeGain(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSBiquadFilterNode>::get<jsBiquadFilterNodeGainGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "gain");
}

static inline JSC::EncodedJSValue jsBiquadFilterNodePrototypeFunctionGetFrequencyResponseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSBiquadFilterNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto frequencyHz = convert<IDLNullable<IDLFloat32Array>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "frequencyHz", "BiquadFilterNode", "getFrequencyResponse", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto magResponse = convert<IDLNullable<IDLFloat32Array>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "magResponse", "BiquadFilterNode", "getFrequencyResponse", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto phaseResponse = convert<IDLNullable<IDLFloat32Array>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "phaseResponse", "BiquadFilterNode", "getFrequencyResponse", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getFrequencyResponse(WTFMove(frequencyHz), WTFMove(magResponse), WTFMove(phaseResponse));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsBiquadFilterNodePrototypeFunctionGetFrequencyResponse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSBiquadFilterNode>::call<jsBiquadFilterNodePrototypeFunctionGetFrequencyResponseBody>(*lexicalGlobalObject, *callFrame, "getFrequencyResponse");
}

void JSBiquadFilterNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSBiquadFilterNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7BiquadFilterNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16BiquadFilterNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<BiquadFilterNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7BiquadFilterNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16BiquadFilterNodeE[2];
#endif

    // If this fails BiquadFilterNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<BiquadFilterNode>::value, "BiquadFilterNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // BiquadFilterNode has subclasses. If BiquadFilterNode has subclasses that get passed
    // to toJS() we currently require BiquadFilterNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<BiquadFilterNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, BiquadFilterNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
