/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleSheet.h"

#include "ActiveDOMObject.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionInsertRule(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionDeleteRule(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionAddRule(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionRemoveRule(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsCSSStyleSheetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCSSStyleSheetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSStyleSheetOwnerRule(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSStyleSheetCssRules(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSStyleSheetRules(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSCSSStyleSheetPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStyleSheetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleSheetPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleSheetPrototype>(vm.heap)) JSCSSStyleSheetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleSheetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleSheetPrototype, JSCSSStyleSheetPrototype::Base);

using JSCSSStyleSheetConstructor = JSDOMConstructorNotConstructable<JSCSSStyleSheet>;

template<> JSValue JSCSSStyleSheetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSStyleSheet::getConstructor(vm, &globalObject);
}

template<> void JSCSSStyleSheetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleSheet::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSStyleSheet"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCSSStyleSheetConstructor::s_info = { "CSSStyleSheet", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleSheetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSStyleSheetPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSStyleSheetConstructor) } },
    { "ownerRule", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetOwnerRule), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cssRules", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetCssRules), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rules", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleSheetRules), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "insertRule", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCSSStyleSheetPrototypeFunctionInsertRule), (intptr_t) (1) } },
    { "deleteRule", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCSSStyleSheetPrototypeFunctionDeleteRule), (intptr_t) (1) } },
    { "addRule", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCSSStyleSheetPrototypeFunctionAddRule), (intptr_t) (0) } },
    { "removeRule", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCSSStyleSheetPrototypeFunctionRemoveRule), (intptr_t) (0) } },
};

const ClassInfo JSCSSStyleSheetPrototype::s_info = { "CSSStyleSheetPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleSheetPrototype) };

void JSCSSStyleSheetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleSheet::info(), JSCSSStyleSheetPrototypeTableValues, *this);
}

const ClassInfo JSCSSStyleSheet::s_info = { "CSSStyleSheet", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleSheet) };

JSCSSStyleSheet::JSCSSStyleSheet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleSheet>&& impl)
    : JSStyleSheet(structure, globalObject, WTFMove(impl))
{
}

void JSCSSStyleSheet::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleSheet>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCSSStyleSheet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleSheetPrototype::create(vm, &globalObject, JSCSSStyleSheetPrototype::createStructure(vm, &globalObject, JSStyleSheet::prototype(vm, globalObject)));
}

JSObject* JSCSSStyleSheet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleSheet>(vm, globalObject);
}

JSValue JSCSSStyleSheet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleSheetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSCSSStyleSheet* IDLAttribute<JSCSSStyleSheet>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCSSStyleSheet*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSCSSStyleSheet* IDLOperation<JSCSSStyleSheet>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCSSStyleSheet*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsCSSStyleSheetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleSheetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleSheet::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCSSStyleSheetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleSheetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsCSSStyleSheetOwnerRuleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleSheet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<CSSRule>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ownerRule());
    return result;
}

EncodedJSValue jsCSSStyleSheetOwnerRule(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSStyleSheet>::get<jsCSSStyleSheetOwnerRuleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ownerRule");
}

static inline JSValue jsCSSStyleSheetCssRulesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleSheet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<CSSRuleList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssRules());
    return result;
}

EncodedJSValue jsCSSStyleSheetCssRules(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSStyleSheet>::get<jsCSSStyleSheetCssRulesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cssRules");
}

static inline JSValue jsCSSStyleSheetRulesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleSheet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<CSSRuleList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rules());
    return result;
}

EncodedJSValue jsCSSStyleSheetRules(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSStyleSheet>::get<jsCSSStyleSheetRulesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rules");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunctionInsertRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto rule = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.insertRule(WTFMove(rule), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionInsertRule(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunctionInsertRuleBody>(*lexicalGlobalObject, *callFrame, "insertRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunctionDeleteRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.deleteRule(WTFMove(index)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionDeleteRule(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunctionDeleteRuleBody>(*lexicalGlobalObject, *callFrame, "deleteRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunctionAddRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto selector = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto style = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = callFrame->argument(2).isUndefined() ? Optional<Converter<IDLUnsignedLong>::ReturnType>() : Optional<Converter<IDLUnsignedLong>::ReturnType>(convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.addRule(WTFMove(selector), WTFMove(style), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionAddRule(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunctionAddRuleBody>(*lexicalGlobalObject, *callFrame, "addRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunctionRemoveRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.removeRule(WTFMove(index)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSStyleSheetPrototypeFunctionRemoveRule(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunctionRemoveRuleBody>(*lexicalGlobalObject, *callFrame, "removeRule");
}

void JSCSSStyleSheet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleSheet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
