/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSUnknownRule.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSCSSUnknownRulePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSUnknownRulePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSUnknownRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSUnknownRulePrototype>(vm.heap)) JSCSSUnknownRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSUnknownRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSUnknownRulePrototype, JSCSSUnknownRulePrototype::Base);

/* Hash table for prototype */
const ClassInfo JSCSSUnknownRulePrototype::s_info = { "CSSUnknownRulePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSUnknownRulePrototype) };

const ClassInfo JSCSSUnknownRule::s_info = { "CSSUnknownRule", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSUnknownRule) };

JSCSSUnknownRule::JSCSSUnknownRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSUnknownRule>&& impl)
    : JSCSSRule(structure, globalObject, WTFMove(impl))
{
}

void JSCSSUnknownRule::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CSSUnknownRule>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCSSUnknownRule::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCSSUnknownRulePrototype::create(vm, &globalObject, JSCSSUnknownRulePrototype::createStructure(vm, &globalObject, JSCSSRule::prototype(vm, globalObject)));
}

JSObject* JSCSSUnknownRule::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSUnknownRule>(vm, globalObject);
}

void JSCSSUnknownRule::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSUnknownRule*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
