/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSCanvasCaptureMediaStreamTrack.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCanvasCaptureMediaStreamTrackPrototypeFunctionRequestFrame(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsCanvasCaptureMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasCaptureMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasCaptureMediaStreamTrackCanvas(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSCanvasCaptureMediaStreamTrackPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCanvasCaptureMediaStreamTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasCaptureMediaStreamTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasCaptureMediaStreamTrackPrototype>(vm.heap)) JSCanvasCaptureMediaStreamTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasCaptureMediaStreamTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasCaptureMediaStreamTrackPrototype, JSCanvasCaptureMediaStreamTrackPrototype::Base);

using JSCanvasCaptureMediaStreamTrackConstructor = JSDOMConstructorNotConstructable<JSCanvasCaptureMediaStreamTrack>;

template<> JSValue JSCanvasCaptureMediaStreamTrackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMediaStreamTrack::getConstructor(vm, &globalObject);
}

template<> void JSCanvasCaptureMediaStreamTrackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCanvasCaptureMediaStreamTrack::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CanvasCaptureMediaStreamTrack"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCanvasCaptureMediaStreamTrackConstructor::s_info = { "CanvasCaptureMediaStreamTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasCaptureMediaStreamTrackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCanvasCaptureMediaStreamTrackPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasCaptureMediaStreamTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasCaptureMediaStreamTrackConstructor) } },
    { "canvas", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasCaptureMediaStreamTrackCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "requestFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasCaptureMediaStreamTrackPrototypeFunctionRequestFrame), (intptr_t) (0) } },
};

const ClassInfo JSCanvasCaptureMediaStreamTrackPrototype::s_info = { "CanvasCaptureMediaStreamTrackPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasCaptureMediaStreamTrackPrototype) };

void JSCanvasCaptureMediaStreamTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasCaptureMediaStreamTrack::info(), JSCanvasCaptureMediaStreamTrackPrototypeTableValues, *this);
}

const ClassInfo JSCanvasCaptureMediaStreamTrack::s_info = { "CanvasCaptureMediaStreamTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasCaptureMediaStreamTrack) };

JSCanvasCaptureMediaStreamTrack::JSCanvasCaptureMediaStreamTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasCaptureMediaStreamTrack>&& impl)
    : JSMediaStreamTrack(structure, globalObject, WTFMove(impl))
{
}

void JSCanvasCaptureMediaStreamTrack::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, CanvasCaptureMediaStreamTrack>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSCanvasCaptureMediaStreamTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCanvasCaptureMediaStreamTrackPrototype::create(vm, &globalObject, JSCanvasCaptureMediaStreamTrackPrototype::createStructure(vm, &globalObject, JSMediaStreamTrack::prototype(vm, globalObject)));
}

JSObject* JSCanvasCaptureMediaStreamTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCanvasCaptureMediaStreamTrack>(vm, globalObject);
}

JSValue JSCanvasCaptureMediaStreamTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasCaptureMediaStreamTrackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSCanvasCaptureMediaStreamTrack* IDLAttribute<JSCanvasCaptureMediaStreamTrack>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCanvasCaptureMediaStreamTrack*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSCanvasCaptureMediaStreamTrack* IDLOperation<JSCanvasCaptureMediaStreamTrack>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCanvasCaptureMediaStreamTrack*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsCanvasCaptureMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasCaptureMediaStreamTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCanvasCaptureMediaStreamTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCanvasCaptureMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasCaptureMediaStreamTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsCanvasCaptureMediaStreamTrackCanvasGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasCaptureMediaStreamTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCanvasElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas());
    return result;
}

EncodedJSValue jsCanvasCaptureMediaStreamTrackCanvas(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasCaptureMediaStreamTrack>::get<jsCanvasCaptureMediaStreamTrackCanvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canvas");
}

static inline JSC::EncodedJSValue jsCanvasCaptureMediaStreamTrackPrototypeFunctionRequestFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasCaptureMediaStreamTrack>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.requestFrame();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasCaptureMediaStreamTrackPrototypeFunctionRequestFrame(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasCaptureMediaStreamTrack>::call<jsCanvasCaptureMediaStreamTrackPrototypeFunctionRequestFrameBody>(*lexicalGlobalObject, *callFrame, "requestFrame");
}

void JSCanvasCaptureMediaStreamTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCanvasCaptureMediaStreamTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCanvasCaptureMediaStreamTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsCanvasCaptureMediaStreamTrack = jsCast<JSCanvasCaptureMediaStreamTrack*>(handle.slot()->asCell());
    if (jsCanvasCaptureMediaStreamTrack->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsCanvasCaptureMediaStreamTrack->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCanvasCaptureMediaStreamTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasCaptureMediaStreamTrack = static_cast<JSCanvasCaptureMediaStreamTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasCaptureMediaStreamTrack->wrapped(), jsCanvasCaptureMediaStreamTrack);
}


}

#endif // ENABLE(MEDIA_STREAM)
