/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasLineCap.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CanvasLineCap enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("butt"),
        MAKE_STATIC_STRING_IMPL("round"),
        MAKE_STATIC_STRING_IMPL("square"),
    };
    static_assert(static_cast<size_t>(CanvasLineCap::Butt) == 0, "CanvasLineCap::Butt is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasLineCap::Round) == 1, "CanvasLineCap::Round is not 1 as expected");
    static_assert(static_cast<size_t>(CanvasLineCap::Square) == 2, "CanvasLineCap::Square is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, CanvasLineCap enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<CanvasLineCap> parseEnumeration<CanvasLineCap>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "butt")
        return CanvasLineCap::Butt;
    if (stringValue == "round")
        return CanvasLineCap::Round;
    if (stringValue == "square")
        return CanvasLineCap::Square;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<CanvasLineCap>()
{
    return "\"butt\", \"round\", \"square\"";
}

} // namespace WebCore
