/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSColorGamut.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ColorGamut enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("srgb"),
        MAKE_STATIC_STRING_IMPL("p3"),
        MAKE_STATIC_STRING_IMPL("rec2020"),
    };
    static_assert(static_cast<size_t>(ColorGamut::SRGB) == 0, "ColorGamut::SRGB is not 0 as expected");
    static_assert(static_cast<size_t>(ColorGamut::P3) == 1, "ColorGamut::P3 is not 1 as expected");
    static_assert(static_cast<size_t>(ColorGamut::Rec2020) == 2, "ColorGamut::Rec2020 is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, ColorGamut enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<ColorGamut> parseEnumeration<ColorGamut>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "srgb")
        return ColorGamut::SRGB;
    if (stringValue == "p3")
        return ColorGamut::P3;
    if (stringValue == "rec2020")
        return ColorGamut::Rec2020;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<ColorGamut>()
{
    return "\"srgb\", \"p3\", \"rec2020\"";
}

} // namespace WebCore
