/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCompositionEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> CompositionEvent::Init convertDictionary<CompositionEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CompositionEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataValue.isUndefined()) {
        result.data = convert<IDLDOMString>(lexicalGlobalObject, dataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.data = emptyString();
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCompositionEventPrototypeFunctionInitCompositionEvent(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsCompositionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCompositionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCompositionEventData(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSCompositionEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCompositionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCompositionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSCompositionEventPrototype>(vm.heap)) JSCompositionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCompositionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCompositionEventPrototype, JSCompositionEventPrototype::Base);

using JSCompositionEventConstructor = JSDOMConstructor<JSCompositionEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSCompositionEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSCompositionEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<CompositionEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = CompositionEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<CompositionEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSCompositionEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSCompositionEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCompositionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CompositionEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCompositionEventConstructor::s_info = { "CompositionEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCompositionEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCompositionEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCompositionEventConstructor) } },
    { "data", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "initCompositionEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCompositionEventPrototypeFunctionInitCompositionEvent), (intptr_t) (0) } },
};

const ClassInfo JSCompositionEventPrototype::s_info = { "CompositionEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCompositionEventPrototype) };

void JSCompositionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCompositionEvent::info(), JSCompositionEventPrototypeTableValues, *this);
}

const ClassInfo JSCompositionEvent::s_info = { "CompositionEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCompositionEvent) };

JSCompositionEvent::JSCompositionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CompositionEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

void JSCompositionEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CompositionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCompositionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCompositionEventPrototype::create(vm, &globalObject, JSCompositionEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject)));
}

JSObject* JSCompositionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCompositionEvent>(vm, globalObject);
}

JSValue JSCompositionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCompositionEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSCompositionEvent* IDLAttribute<JSCompositionEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCompositionEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSCompositionEvent* IDLOperation<JSCompositionEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCompositionEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsCompositionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCompositionEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCompositionEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCompositionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCompositionEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsCompositionEventDataGetter(JSGlobalObject& lexicalGlobalObject, JSCompositionEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.data());
    return result;
}

EncodedJSValue jsCompositionEventData(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCompositionEvent>::get<jsCompositionEventDataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "data");
}

static inline JSC::EncodedJSValue jsCompositionEventPrototypeFunctionInitCompositionEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCompositionEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto typeArg = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto canBubbleArg = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cancelableArg = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto viewArg = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, callFrame->argument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "viewArg", "CompositionEvent", "initCompositionEvent", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dataArg = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initCompositionEvent(WTFMove(typeArg), WTFMove(canBubbleArg), WTFMove(cancelableArg), WTFMove(viewArg), WTFMove(dataArg));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCompositionEventPrototypeFunctionInitCompositionEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCompositionEvent>::call<jsCompositionEventPrototypeFunctionInitCompositionEventBody>(*lexicalGlobalObject, *callFrame, "initCompositionEvent");
}

void JSCompositionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCompositionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CompositionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16CompositionEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CompositionEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7CompositionEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16CompositionEventE[2];
#endif

    // If this fails CompositionEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<CompositionEvent>::value, "CompositionEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // CompositionEvent has subclasses. If CompositionEvent has subclasses that get passed
    // to toJS() we currently require CompositionEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<CompositionEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CompositionEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
