/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSCredentialRequestOptions.h"

#include "JSAbortSignal.h"
#include "JSDOMConvertInterface.h"
#include "JSPublicKeyCredentialRequestOptions.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUTHN)

template<> CredentialRequestOptions convertDictionary<CredentialRequestOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CredentialRequestOptions result;
    JSValue mediationValue;
    if (isNullOrUndefined)
        mediationValue = jsUndefined();
    else {
        mediationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mediation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mediationValue.isUndefined()) {
        result.mediation = convert<IDLEnumeration<CredentialRequestOptions::MediationRequirement>>(lexicalGlobalObject, mediationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mediation = CredentialRequestOptions::MediationRequirement::Optional;
    JSValue publicKeyValue;
    if (isNullOrUndefined)
        publicKeyValue = jsUndefined();
    else {
        publicKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "publicKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!publicKeyValue.isUndefined()) {
        result.publicKey = convert<IDLDictionary<PublicKeyCredentialRequestOptions>>(lexicalGlobalObject, publicKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!signalValue.isUndefined()) {
        result.signal = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

#if ENABLE(WEB_AUTHN)

String convertEnumerationToString(CredentialRequestOptions::MediationRequirement enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("silent"),
        MAKE_STATIC_STRING_IMPL("optional"),
        MAKE_STATIC_STRING_IMPL("required"),
    };
    static_assert(static_cast<size_t>(CredentialRequestOptions::MediationRequirement::Silent) == 0, "CredentialRequestOptions::MediationRequirement::Silent is not 0 as expected");
    static_assert(static_cast<size_t>(CredentialRequestOptions::MediationRequirement::Optional) == 1, "CredentialRequestOptions::MediationRequirement::Optional is not 1 as expected");
    static_assert(static_cast<size_t>(CredentialRequestOptions::MediationRequirement::Required) == 2, "CredentialRequestOptions::MediationRequirement::Required is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, CredentialRequestOptions::MediationRequirement enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<CredentialRequestOptions::MediationRequirement> parseEnumeration<CredentialRequestOptions::MediationRequirement>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "silent")
        return CredentialRequestOptions::MediationRequirement::Silent;
    if (stringValue == "optional")
        return CredentialRequestOptions::MediationRequirement::Optional;
    if (stringValue == "required")
        return CredentialRequestOptions::MediationRequirement::Required;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<CredentialRequestOptions::MediationRequirement>()
{
    return "\"silent\", \"optional\", \"required\"";
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUTHN)
