/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CRYPTO)

#include "JSCryptoKey.h"

#include "ActiveDOMObject.h"
#include "JSCryptoAesKeyAlgorithm.h"
#include "JSCryptoEcKeyAlgorithm.h"
#include "JSCryptoHmacKeyAlgorithm.h"
#include "JSCryptoKeyAlgorithm.h"
#include "JSCryptoKeyUsage.h"
#include "JSCryptoRsaHashedKeyAlgorithm.h"
#include "JSCryptoRsaKeyAlgorithm.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CryptoKey::Type enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("public"),
        MAKE_STATIC_STRING_IMPL("private"),
        MAKE_STATIC_STRING_IMPL("secret"),
    };
    static_assert(static_cast<size_t>(CryptoKey::Type::Public) == 0, "CryptoKey::Type::Public is not 0 as expected");
    static_assert(static_cast<size_t>(CryptoKey::Type::Private) == 1, "CryptoKey::Type::Private is not 1 as expected");
    static_assert(static_cast<size_t>(CryptoKey::Type::Secret) == 2, "CryptoKey::Type::Secret is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, CryptoKey::Type enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<CryptoKey::Type> parseEnumeration<CryptoKey::Type>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "public")
        return CryptoKey::Type::Public;
    if (stringValue == "private")
        return CryptoKey::Type::Private;
    if (stringValue == "secret")
        return CryptoKey::Type::Secret;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<CryptoKey::Type>()
{
    return "\"public\", \"private\", \"secret\"";
}

// Attributes

JSC::EncodedJSValue jsCryptoKeyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCryptoKeyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCryptoKeyType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCryptoKeyExtractable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCryptoKeyAlgorithm(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCryptoKeyUsages(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSCryptoKeyPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCryptoKeyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCryptoKeyPrototype* ptr = new (NotNull, JSC::allocateCell<JSCryptoKeyPrototype>(vm.heap)) JSCryptoKeyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCryptoKeyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCryptoKeyPrototype, JSCryptoKeyPrototype::Base);

using JSCryptoKeyConstructor = JSDOMConstructorNotConstructable<JSCryptoKey>;

template<> JSValue JSCryptoKeyConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCryptoKeyConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCryptoKey::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CryptoKey"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCryptoKeyConstructor::s_info = { "CryptoKey", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCryptoKeyConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCryptoKeyPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoKeyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCryptoKeyConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoKeyType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "extractable", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoKeyExtractable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "algorithm", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoKeyAlgorithm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "usages", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoKeyUsages), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSCryptoKeyPrototype::s_info = { "CryptoKeyPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCryptoKeyPrototype) };

void JSCryptoKeyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCryptoKey::info(), JSCryptoKeyPrototypeTableValues, *this);
}

const ClassInfo JSCryptoKey::s_info = { "CryptoKey", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCryptoKey) };

JSCryptoKey::JSCryptoKey(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CryptoKey>&& impl)
    : JSDOMWrapper<CryptoKey>(structure, globalObject, WTFMove(impl))
{
}

void JSCryptoKey::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CryptoKey>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCryptoKey::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCryptoKeyPrototype::create(vm, &globalObject, JSCryptoKeyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSCryptoKey::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCryptoKey>(vm, globalObject);
}

JSValue JSCryptoKey::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCryptoKeyConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCryptoKey::destroy(JSC::JSCell* cell)
{
    JSCryptoKey* thisObject = static_cast<JSCryptoKey*>(cell);
    thisObject->JSCryptoKey::~JSCryptoKey();
}

template<> inline JSCryptoKey* IDLAttribute<JSCryptoKey>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCryptoKey*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsCryptoKeyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCryptoKeyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCryptoKey::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCryptoKeyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCryptoKeyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsCryptoKeyTypeGetter(JSGlobalObject& lexicalGlobalObject, JSCryptoKey& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<CryptoKey::Type>>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsCryptoKeyType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCryptoKey>::get<jsCryptoKeyTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsCryptoKeyExtractableGetter(JSGlobalObject& lexicalGlobalObject, JSCryptoKey& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.extractable());
    return result;
}

EncodedJSValue jsCryptoKeyExtractable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCryptoKey>::get<jsCryptoKeyExtractableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "extractable");
}

static inline JSValue jsCryptoKeyAlgorithmGetter(JSGlobalObject& lexicalGlobalObject, JSCryptoKey& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (JSValue cachedValue = thisObject.m_algorithm.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnion<IDLDictionary<CryptoKeyAlgorithm>, IDLDictionary<CryptoAesKeyAlgorithm>, IDLDictionary<CryptoEcKeyAlgorithm>, IDLDictionary<CryptoHmacKeyAlgorithm>, IDLDictionary<CryptoRsaHashedKeyAlgorithm>, IDLDictionary<CryptoRsaKeyAlgorithm>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.algorithm());
    thisObject.m_algorithm.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

EncodedJSValue jsCryptoKeyAlgorithm(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCryptoKey>::get<jsCryptoKeyAlgorithmGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "algorithm");
}

static inline JSValue jsCryptoKeyUsagesGetter(JSGlobalObject& lexicalGlobalObject, JSCryptoKey& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (JSValue cachedValue = thisObject.m_usages.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLSequence<IDLEnumeration<CryptoKeyUsage>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.usages());
    thisObject.m_usages.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

EncodedJSValue jsCryptoKeyUsages(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCryptoKey>::get<jsCryptoKeyUsagesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "usages");
}

void JSCryptoKey::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCryptoKey*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_algorithm);
    visitor.append(thisObject->m_usages);
}

void JSCryptoKey::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCryptoKey*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCryptoKeyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsCryptoKey = jsCast<JSCryptoKey*>(handle.slot()->asCell());
    CryptoKey* root = &jsCryptoKey->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from CryptoKey";
    return visitor.containsOpaqueRoot(root);
}

void JSCryptoKeyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCryptoKey = static_cast<JSCryptoKey*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCryptoKey->wrapped(), jsCryptoKey);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CryptoKey>&& impl)
{
    return createWrapper<CryptoKey>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CryptoKey& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CryptoKey* JSCryptoKey::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCryptoKey*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CRYPTO)
