/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CRYPTO)

#include "JSCryptoRsaHashedKeyAlgorithm.h"

#include "JSCryptoKeyAlgorithm.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CRYPTO)

template<> CryptoRsaHashedKeyAlgorithm convertDictionary<CryptoRsaHashedKeyAlgorithm>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CryptoRsaHashedKeyAlgorithm result;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "CryptoRsaHashedKeyAlgorithm", "DOMString");
        return { };
    }
    JSValue modulusLengthValue;
    if (isNullOrUndefined)
        modulusLengthValue = jsUndefined();
    else {
        modulusLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modulusLength"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modulusLengthValue.isUndefined()) {
        result.modulusLength = convert<IDLUnsignedLong>(lexicalGlobalObject, modulusLengthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "modulusLength", "CryptoRsaHashedKeyAlgorithm", "unsigned long");
        return { };
    }
    JSValue publicExponentValue;
    if (isNullOrUndefined)
        publicExponentValue = jsUndefined();
    else {
        publicExponentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "publicExponent"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!publicExponentValue.isUndefined()) {
        result.publicExponent = convert<IDLUint8Array>(lexicalGlobalObject, publicExponentValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "publicExponent", "CryptoRsaHashedKeyAlgorithm", "Uint8Array");
        return { };
    }
    JSValue hashValue;
    if (isNullOrUndefined)
        hashValue = jsUndefined();
    else {
        hashValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hash"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hashValue.isUndefined()) {
        result.hash = convert<IDLDictionary<CryptoKeyAlgorithm>>(lexicalGlobalObject, hashValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "hash", "CryptoRsaHashedKeyAlgorithm", "CryptoKeyAlgorithm");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CryptoRsaHashedKeyAlgorithm& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto nameValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.name);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "name"), nameValue);
    auto modulusLengthValue = toJS<IDLUnsignedLong>(dictionary.modulusLength);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "modulusLength"), modulusLengthValue);
    auto publicExponentValue = toJS<IDLUint8Array>(lexicalGlobalObject, globalObject, dictionary.publicExponent);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "publicExponent"), publicExponentValue);
    auto hashValue = toJS<IDLDictionary<CryptoKeyAlgorithm>>(lexicalGlobalObject, globalObject, dictionary.hash);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "hash"), hashValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_CRYPTO)
