/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMApplicationCache.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMApplicationCachePrototypeFunctionUpdate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMApplicationCachePrototypeFunctionSwapCache(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMApplicationCachePrototypeFunctionAbort(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMApplicationCacheConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMApplicationCacheOnchecking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOnchecking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOnnoupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOnnoupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOndownloading(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOndownloading(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOnupdateready(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOnupdateready(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOncached(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOncached(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMApplicationCacheOnobsolete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMApplicationCacheOnobsolete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMApplicationCachePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMApplicationCachePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMApplicationCachePrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMApplicationCachePrototype>(vm.heap)) JSDOMApplicationCachePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMApplicationCachePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMApplicationCachePrototype, JSDOMApplicationCachePrototype::Base);

using JSDOMApplicationCacheConstructor = JSDOMConstructorNotConstructable<JSDOMApplicationCache>;

/* Hash table for constructor */

static const HashTableValue JSDOMApplicationCacheConstructorTableValues[] =
{
    { "UNCACHED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "IDLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CHECKING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "DOWNLOADING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "UPDATEREADY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "OBSOLETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
};

template<> JSValue JSDOMApplicationCacheConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSDOMApplicationCacheConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMApplicationCache::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ApplicationCache"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMApplicationCache::info(), JSDOMApplicationCacheConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMApplicationCacheConstructor::s_info = { "ApplicationCache", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMApplicationCacheConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMApplicationCachePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheConstructor) } },
    { "status", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onchecking", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOnchecking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOnchecking) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOnerror) } },
    { "onnoupdate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOnnoupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOnnoupdate) } },
    { "ondownloading", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOndownloading), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOndownloading) } },
    { "onprogress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOnprogress) } },
    { "onupdateready", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOnupdateready), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOnupdateready) } },
    { "oncached", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOncached), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOncached) } },
    { "onobsolete", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMApplicationCacheOnobsolete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMApplicationCacheOnobsolete) } },
    { "update", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMApplicationCachePrototypeFunctionUpdate), (intptr_t) (0) } },
    { "swapCache", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMApplicationCachePrototypeFunctionSwapCache), (intptr_t) (0) } },
    { "abort", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMApplicationCachePrototypeFunctionAbort), (intptr_t) (0) } },
    { "UNCACHED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "IDLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CHECKING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "DOWNLOADING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "UPDATEREADY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "OBSOLETE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
};

const ClassInfo JSDOMApplicationCachePrototype::s_info = { "ApplicationCachePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMApplicationCachePrototype) };

void JSDOMApplicationCachePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMApplicationCache::info(), JSDOMApplicationCachePrototypeTableValues, *this);
}

const ClassInfo JSDOMApplicationCache::s_info = { "ApplicationCache", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMApplicationCache) };

JSDOMApplicationCache::JSDOMApplicationCache(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMApplicationCache>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSDOMApplicationCache::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMApplicationCache>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMApplicationCache::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMApplicationCachePrototype::create(vm, &globalObject, JSDOMApplicationCachePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSDOMApplicationCache::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMApplicationCache>(vm, globalObject);
}

JSValue JSDOMApplicationCache::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMApplicationCacheConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDOMApplicationCache* IDLAttribute<JSDOMApplicationCache>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMApplicationCache*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMApplicationCache* IDLOperation<JSDOMApplicationCache>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMApplicationCache*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMApplicationCacheConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMApplicationCachePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMApplicationCache::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMApplicationCacheConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMApplicationCachePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMApplicationCacheStatusGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.status());
    return result;
}

EncodedJSValue jsDOMApplicationCacheStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheStatusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "status");
}

static inline JSValue jsDOMApplicationCacheOncheckingGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().checkingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOnchecking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOncheckingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onchecking");
}

static inline bool setJSDOMApplicationCacheOncheckingSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().checkingEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOnchecking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOncheckingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onchecking");
}

static inline JSValue jsDOMApplicationCacheOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSDOMApplicationCacheOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsDOMApplicationCacheOnnoupdateGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().noupdateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOnnoupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOnnoupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onnoupdate");
}

static inline bool setJSDOMApplicationCacheOnnoupdateSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().noupdateEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOnnoupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOnnoupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onnoupdate");
}

static inline JSValue jsDOMApplicationCacheOndownloadingGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().downloadingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOndownloading(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOndownloadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondownloading");
}

static inline bool setJSDOMApplicationCacheOndownloadingSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().downloadingEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOndownloading(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOndownloadingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondownloading");
}

static inline JSValue jsDOMApplicationCacheOnprogressGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOnprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onprogress");
}

static inline bool setJSDOMApplicationCacheOnprogressSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().progressEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOnprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onprogress");
}

static inline JSValue jsDOMApplicationCacheOnupdatereadyGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().updatereadyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOnupdateready(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOnupdatereadyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onupdateready");
}

static inline bool setJSDOMApplicationCacheOnupdatereadySetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().updatereadyEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOnupdateready(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOnupdatereadySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onupdateready");
}

static inline JSValue jsDOMApplicationCacheOncachedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cachedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOncached(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOncachedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncached");
}

static inline bool setJSDOMApplicationCacheOncachedSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cachedEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOncached(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOncachedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncached");
}

static inline JSValue jsDOMApplicationCacheOnobsoleteGetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().obsoleteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMApplicationCacheOnobsolete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMApplicationCache>::get<jsDOMApplicationCacheOnobsoleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onobsolete");
}

static inline bool setJSDOMApplicationCacheOnobsoleteSetter(JSGlobalObject& lexicalGlobalObject, JSDOMApplicationCache& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().obsoleteEvent, value);
    return true;
}

bool setJSDOMApplicationCacheOnobsolete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMApplicationCache>::set<setJSDOMApplicationCacheOnobsoleteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onobsolete");
}

static inline JSC::EncodedJSValue jsDOMApplicationCachePrototypeFunctionUpdateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMApplicationCache>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.update());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMApplicationCachePrototypeFunctionUpdate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMApplicationCache>::call<jsDOMApplicationCachePrototypeFunctionUpdateBody>(*lexicalGlobalObject, *callFrame, "update");
}

static inline JSC::EncodedJSValue jsDOMApplicationCachePrototypeFunctionSwapCacheBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMApplicationCache>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.swapCache());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMApplicationCachePrototypeFunctionSwapCache(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMApplicationCache>::call<jsDOMApplicationCachePrototypeFunctionSwapCacheBody>(*lexicalGlobalObject, *callFrame, "swapCache");
}

static inline JSC::EncodedJSValue jsDOMApplicationCachePrototypeFunctionAbortBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMApplicationCache>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.abort();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMApplicationCachePrototypeFunctionAbort(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMApplicationCache>::call<jsDOMApplicationCachePrototypeFunctionAbortBody>(*lexicalGlobalObject, *callFrame, "abort");
}

void JSDOMApplicationCache::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMApplicationCache*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMApplicationCacheOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsDOMApplicationCache = jsCast<JSDOMApplicationCache*>(handle.slot()->asCell());
    if (jsDOMApplicationCache->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    auto* root = WTF::getPtr(jsDOMApplicationCache->wrapped().window());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Window";
    return visitor.containsOpaqueRoot(root);
}

void JSDOMApplicationCacheOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMApplicationCache = static_cast<JSDOMApplicationCache*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMApplicationCache->wrapped(), jsDOMApplicationCache);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMApplicationCache@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19DOMApplicationCacheE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMApplicationCache>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7DOMApplicationCache@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19DOMApplicationCacheE[2];
#endif

    // If this fails DOMApplicationCache does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<DOMApplicationCache>::value, "DOMApplicationCache is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // DOMApplicationCache has subclasses. If DOMApplicationCache has subclasses that get passed
    // to toJS() we currently require DOMApplicationCache you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<DOMApplicationCache>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMApplicationCache& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMApplicationCache* JSDOMApplicationCache::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMApplicationCache*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
