/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Apple Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "JSDOMBindingInternalsBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_jsDOMBindingInternalsForEachWrapperCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsDOMBindingInternalsForEachWrapperCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsDOMBindingInternalsForEachWrapperCodeLength = 170;
static const JSC::Intrinsic s_jsDOMBindingInternalsForEachWrapperCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsDOMBindingInternalsForEachWrapperCode =
    "(function (mapLikeOrSetLike, callback)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    mapLikeOrSetLike.forEach((value, key, backingMapOrSet) => {\n" \
    "        callback(value, key, this);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_jsDOMBindingInternalsGetUserMediaShimCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_jsDOMBindingInternalsGetUserMediaShimCodeConstructorKind = JSC::ConstructorKind::None;
const int s_jsDOMBindingInternalsGetUserMediaShimCodeLength = 147;
static const JSC::Intrinsic s_jsDOMBindingInternalsGetUserMediaShimCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_jsDOMBindingInternalsGetUserMediaShimCode =
    "(function (constraints, successCallback, errorCallback)\n" \
    "{\n" \
    "    this.mediaDevices.getUserMedia(constraints).then(successCallback, errorCallback);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().jsDOMBindingInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().jsDOMBindingInternalsBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_JSDOMBINDINGINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
