/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCSSCustomPropertyDescriptor.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> DOMCSSCustomPropertyDescriptor convertDictionary<DOMCSSCustomPropertyDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DOMCSSCustomPropertyDescriptor result;
    JSValue inheritsValue;
    if (isNullOrUndefined)
        inheritsValue = jsUndefined();
    else {
        inheritsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inherits"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!inheritsValue.isUndefined()) {
        result.inherits = convert<IDLBoolean>(lexicalGlobalObject, inheritsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "inherits", "DOMCSSCustomPropertyDescriptor", "boolean");
        return { };
    }
    JSValue initialValueValue;
    if (isNullOrUndefined)
        initialValueValue = jsUndefined();
    else {
        initialValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "initialValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!initialValueValue.isUndefined()) {
        result.initialValue = convert<IDLDOMString>(lexicalGlobalObject, initialValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "DOMCSSCustomPropertyDescriptor", "DOMString");
        return { };
    }
    JSValue syntaxValue;
    if (isNullOrUndefined)
        syntaxValue = jsUndefined();
    else {
        syntaxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "syntax"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!syntaxValue.isUndefined()) {
        result.syntax = convert<IDLDOMString>(lexicalGlobalObject, syntaxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.syntax = "*"_s;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const DOMCSSCustomPropertyDescriptor& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto inheritsValue = toJS<IDLBoolean>(dictionary.inherits);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "inherits"), inheritsValue);
    if (!IDLDOMString::isNullValue(dictionary.initialValue)) {
        auto initialValueValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.initialValue));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "initialValue"), initialValueValue);
    }
    auto nameValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.name);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "name"), nameValue);
    auto syntaxValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.syntax);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "syntax"), syntaxValue);
    return result;
}

} // namespace WebCore
