/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCSSNamespace.h"

#include "ActiveDOMObject.h"
#include "DOMCSSRegisterCustomProperty.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMCSSCustomPropertyDescriptor.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHighlightMap.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(CSS_PAINTING_API)
#include "DOMCSSPaintWorklet.h"
#include "JSWorklet.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMCSSNamespaceConstructorFunctionSupports(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMCSSNamespaceConstructorFunctionEscape(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMCSSNamespaceConstructorFunctionRegisterProperty(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMCSSNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMCSSNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMCSSNamespaceConstructorHighlights(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(CSS_PAINTING_API)
JSC::EncodedJSValue jsDOMCSSNamespaceConstructorPaintWorklet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSDOMCSSNamespacePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMCSSNamespacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMCSSNamespacePrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMCSSNamespacePrototype>(vm.heap)) JSDOMCSSNamespacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMCSSNamespacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMCSSNamespacePrototype, JSDOMCSSNamespacePrototype::Base);

using JSDOMCSSNamespaceConstructor = JSDOMConstructorNotConstructable<JSDOMCSSNamespace>;

/* Hash table for constructor */

static const HashTableValue JSDOMCSSNamespaceConstructorTableValues[] =
{
    { "highlights", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCSSNamespaceConstructorHighlights), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(CSS_PAINTING_API)
    { "paintWorklet", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCSSNamespaceConstructorPaintWorklet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "supports", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMCSSNamespaceConstructorFunctionSupports), (intptr_t) (1) } },
    { "escape", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMCSSNamespaceConstructorFunctionEscape), (intptr_t) (1) } },
    { "registerProperty", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMCSSNamespaceConstructorFunctionRegisterProperty), (intptr_t) (1) } },
};

template<> JSValue JSDOMCSSNamespaceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMCSSNamespaceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMCSSNamespace::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSS"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMCSSNamespace::info(), JSDOMCSSNamespaceConstructorTableValues, *this);
    if (!RuntimeEnabledFeatures::sharedFeatures().highlightAPIEnabled()) {
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("highlights"), strlen("highlights"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, &globalObject, propertyName);
    }
#if ENABLE(CSS_PAINTING_API)
    if (!RuntimeEnabledFeatures::sharedFeatures().cssPaintingAPIEnabled()) {
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("paintWorklet"), strlen("paintWorklet"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, &globalObject, propertyName);
    }
#endif
    if (!RuntimeEnabledFeatures::sharedFeatures().cssCustomPropertiesAndValuesEnabled()) {
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("registerProperty"), strlen("registerProperty"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, &globalObject, propertyName);
    }
}

template<> const ClassInfo JSDOMCSSNamespaceConstructor::s_info = { "CSS", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespaceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMCSSNamespacePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMCSSNamespaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMCSSNamespaceConstructor) } },
};

const ClassInfo JSDOMCSSNamespacePrototype::s_info = { "CSSPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespacePrototype) };

void JSDOMCSSNamespacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMCSSNamespace::info(), JSDOMCSSNamespacePrototypeTableValues, *this);
}

const ClassInfo JSDOMCSSNamespace::s_info = { "CSS", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMCSSNamespace) };

JSDOMCSSNamespace::JSDOMCSSNamespace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMCSSNamespace>&& impl)
    : JSDOMWrapper<DOMCSSNamespace>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMCSSNamespace::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMCSSNamespace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMCSSNamespace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMCSSNamespacePrototype::create(vm, &globalObject, JSDOMCSSNamespacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMCSSNamespace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMCSSNamespace>(vm, globalObject);
}

JSValue JSDOMCSSNamespace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMCSSNamespaceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMCSSNamespace::destroy(JSC::JSCell* cell)
{
    JSDOMCSSNamespace* thisObject = static_cast<JSDOMCSSNamespace*>(cell);
    thisObject->JSDOMCSSNamespace::~JSDOMCSSNamespace();
}

template<> inline JSDOMCSSNamespace* IDLAttribute<JSDOMCSSNamespace>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMCSSNamespace*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMCSSNamespace* IDLOperation<JSDOMCSSNamespace>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMCSSNamespace*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMCSSNamespaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMCSSNamespacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMCSSNamespace::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMCSSNamespaceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMCSSNamespacePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMCSSNamespaceConstructorHighlightsGetter(JSGlobalObject& lexicalGlobalObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    JSValue result = toJS<IDLInterface<HighlightMap>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, DOMCSSNamespace::highlights(document));
    return result;
}

EncodedJSValue jsDOMCSSNamespaceConstructorHighlights(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMCSSNamespace>::getStatic<jsDOMCSSNamespaceConstructorHighlightsGetter>(*lexicalGlobalObject, thisValue, "highlights");
}

#if ENABLE(CSS_PAINTING_API)
static inline JSValue jsDOMCSSNamespaceConstructorPaintWorkletGetter(JSGlobalObject& lexicalGlobalObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    JSValue result = toJS<IDLInterface<Worklet>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, WebCore::DOMCSSPaintWorklet::ensurePaintWorklet(document));
    return result;
}

EncodedJSValue jsDOMCSSNamespaceConstructorPaintWorklet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMCSSNamespace>::getStatic<jsDOMCSSNamespaceConstructorPaintWorkletGetter>(*lexicalGlobalObject, thisValue, "paintWorklet");
}

#endif

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunctionSupports1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto property = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto value = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(DOMCSSNamespace::supports(document, WTFMove(property), WTFMove(value))));
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunctionSupports2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto conditionText = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(DOMCSSNamespace::supports(document, WTFMove(conditionText))));
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunctionSupportsOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        return jsDOMCSSNamespaceConstructorFunctionSupports2Body(lexicalGlobalObject, callFrame, throwScope);
    }
    if (argsCount == 2) {
        return jsDOMCSSNamespaceConstructorFunctionSupports1Body(lexicalGlobalObject, callFrame, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsDOMCSSNamespaceConstructorFunctionSupports(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunctionSupportsOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "supports");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunctionEscapeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto ident = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, DOMCSSNamespace::escape(WTFMove(ident))));
}

EncodedJSValue JSC_HOST_CALL jsDOMCSSNamespaceConstructorFunctionEscape(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunctionEscapeBody>(*lexicalGlobalObject, *callFrame, "escape");
}

static inline JSC::EncodedJSValue jsDOMCSSNamespaceConstructorFunctionRegisterPropertyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto descriptor = convert<IDLDictionary<DOMCSSCustomPropertyDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, WebCore::DOMCSSRegisterCustomProperty::registerProperty(document, WTFMove(descriptor)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMCSSNamespaceConstructorFunctionRegisterProperty(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMCSSNamespace>::callStatic<jsDOMCSSNamespaceConstructorFunctionRegisterPropertyBody>(*lexicalGlobalObject, *callFrame, "registerProperty");
}

void JSDOMCSSNamespace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMCSSNamespace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMCSSNamespaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMCSSNamespaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMCSSNamespace = static_cast<JSDOMCSSNamespace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMCSSNamespace->wrapped(), jsDOMCSSNamespace);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMCSSNamespace>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMCSSNamespace.
    static_assert(!std::is_polymorphic<DOMCSSNamespace>::value, "DOMCSSNamespace is polymorphic but the IDL claims it is not");
    return createWrapper<DOMCSSNamespace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMCSSNamespace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMCSSNamespace* JSDOMCSSNamespace::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMCSSNamespace*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
