/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrixReadOnly.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixInit.h"
#include "JSDOMMatrixReadOnly.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyConstructorFunctionFromMatrix(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyConstructorFunctionFromFloat32Array(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyConstructorFunctionFromFloat64Array(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionTranslate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionScale(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionScale3d(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionRotate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionRotateFromVector(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionRotateAxisAngle(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionSkewX(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionSkewY(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionMultiply(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionFlipX(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionFlipY(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionInverse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionTransformPoint(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToFloat32Array(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToFloat64Array(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToString(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixReadOnlyA(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyC(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyD(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyE(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyF(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM11(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM12(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM13(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM14(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM21(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM22(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM23(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM24(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM31(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM32(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM33(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM34(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM41(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM42(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM43(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyM44(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyIs2D(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMatrixReadOnlyIsIdentity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDOMMatrixReadOnlyPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMMatrixReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMatrixReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMatrixReadOnlyPrototype>(vm.heap)) JSDOMMatrixReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMatrixReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMatrixReadOnlyPrototype, JSDOMMatrixReadOnlyPrototype::Base);

using JSDOMMatrixReadOnlyConstructor = JSDOMConstructor<JSDOMMatrixReadOnly>;

/* Hash table for constructor */

static const HashTableValue JSDOMMatrixReadOnlyConstructorTableValues[] =
{
    { "fromMatrix", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyConstructorFunctionFromMatrix), (intptr_t) (0) } },
    { "fromFloat32Array", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyConstructorFunctionFromFloat32Array), (intptr_t) (1) } },
    { "fromFloat64Array", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyConstructorFunctionFromFloat64Array), (intptr_t) (1) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSDOMMatrixReadOnlyConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMMatrixReadOnlyConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "DOMMatrixReadOnly");
    auto init = callFrame->argument(0).isUndefined() ? Optional<Converter<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>::ReturnType>() : Optional<Converter<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>::ReturnType>(convert<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMMatrixReadOnly::create(*context, WTFMove(init));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSDOMMatrixReadOnlyConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMMatrixReadOnlyConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMMatrixReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMMatrixReadOnly"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMMatrixReadOnly::info(), JSDOMMatrixReadOnlyConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMMatrixReadOnlyConstructor::s_info = { "DOMMatrixReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixReadOnlyConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMMatrixReadOnlyPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixReadOnlyConstructor) } },
    { "a", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyA), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "b", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "c", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyC), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "d", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyD), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "e", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyE), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "f", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyF), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m11", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM11), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m12", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM12), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m13", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM13), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m14", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM14), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m21", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM21), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m22", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM22), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m23", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM23), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m24", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM24), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m31", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM31), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m32", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM32), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m33", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM33), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m34", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM34), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m41", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM41), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m42", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM42), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m43", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM43), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "m44", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyM44), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "is2D", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyIs2D), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isIdentity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixReadOnlyIsIdentity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "translate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionTranslate), (intptr_t) (0) } },
    { "scale", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionScale), (intptr_t) (0) } },
    { "scale3d", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionScale3d), (intptr_t) (0) } },
    { "rotate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionRotate), (intptr_t) (0) } },
    { "rotateFromVector", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionRotateFromVector), (intptr_t) (0) } },
    { "rotateAxisAngle", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionRotateAxisAngle), (intptr_t) (0) } },
    { "skewX", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionSkewX), (intptr_t) (0) } },
    { "skewY", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionSkewY), (intptr_t) (0) } },
    { "multiply", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionMultiply), (intptr_t) (0) } },
    { "flipX", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionFlipX), (intptr_t) (0) } },
    { "flipY", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionFlipY), (intptr_t) (0) } },
    { "inverse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionInverse), (intptr_t) (0) } },
    { "transformPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionTransformPoint), (intptr_t) (0) } },
    { "toFloat32Array", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionToFloat32Array), (intptr_t) (0) } },
    { "toFloat64Array", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionToFloat64Array), (intptr_t) (0) } },
    { "toString", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionToString), (intptr_t) (0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixReadOnlyPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSDOMMatrixReadOnlyPrototype::s_info = { "DOMMatrixReadOnlyPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixReadOnlyPrototype) };

void JSDOMMatrixReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMatrixReadOnly::info(), JSDOMMatrixReadOnlyPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isDocument()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("toString"), strlen("toString"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSDOMMatrixReadOnly::s_info = { "DOMMatrixReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixReadOnly) };

JSDOMMatrixReadOnly::JSDOMMatrixReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMatrixReadOnly>&& impl)
    : JSDOMWrapper<DOMMatrixReadOnly>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMMatrixReadOnly::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMMatrixReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMMatrixReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMMatrixReadOnlyPrototype::create(vm, &globalObject, JSDOMMatrixReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMMatrixReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMMatrixReadOnly>(vm, globalObject);
}

JSValue JSDOMMatrixReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMatrixReadOnlyConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMMatrixReadOnly::destroy(JSC::JSCell* cell)
{
    JSDOMMatrixReadOnly* thisObject = static_cast<JSDOMMatrixReadOnly*>(cell);
    thisObject->JSDOMMatrixReadOnly::~JSDOMMatrixReadOnly();
}

template<> inline JSDOMMatrixReadOnly* IDLAttribute<JSDOMMatrixReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMMatrixReadOnly*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMMatrixReadOnly* IDLOperation<JSDOMMatrixReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMMatrixReadOnly*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMMatrixReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMatrixReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMMatrixReadOnly::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMMatrixReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMatrixReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMMatrixReadOnlyAGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.a());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyA(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyAGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "a");
}

static inline JSValue jsDOMMatrixReadOnlyBGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.b());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyBGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "b");
}

static inline JSValue jsDOMMatrixReadOnlyCGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.c());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyC(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyCGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "c");
}

static inline JSValue jsDOMMatrixReadOnlyDGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.d());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyD(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyDGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "d");
}

static inline JSValue jsDOMMatrixReadOnlyEGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.e());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyE(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyEGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "e");
}

static inline JSValue jsDOMMatrixReadOnlyFGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.f());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyF(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyFGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "f");
}

static inline JSValue jsDOMMatrixReadOnlyM11Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m11());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM11(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM11Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m11");
}

static inline JSValue jsDOMMatrixReadOnlyM12Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m12());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM12(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM12Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m12");
}

static inline JSValue jsDOMMatrixReadOnlyM13Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m13());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM13(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM13Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m13");
}

static inline JSValue jsDOMMatrixReadOnlyM14Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m14());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM14(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM14Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m14");
}

static inline JSValue jsDOMMatrixReadOnlyM21Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m21());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM21(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM21Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m21");
}

static inline JSValue jsDOMMatrixReadOnlyM22Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m22());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM22(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM22Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m22");
}

static inline JSValue jsDOMMatrixReadOnlyM23Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m23());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM23(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM23Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m23");
}

static inline JSValue jsDOMMatrixReadOnlyM24Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m24());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM24(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM24Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m24");
}

static inline JSValue jsDOMMatrixReadOnlyM31Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m31());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM31(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM31Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m31");
}

static inline JSValue jsDOMMatrixReadOnlyM32Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m32());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM32(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM32Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m32");
}

static inline JSValue jsDOMMatrixReadOnlyM33Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m33());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM33(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM33Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m33");
}

static inline JSValue jsDOMMatrixReadOnlyM34Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m34());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM34(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM34Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m34");
}

static inline JSValue jsDOMMatrixReadOnlyM41Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m41());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM41(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM41Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m41");
}

static inline JSValue jsDOMMatrixReadOnlyM42Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m42());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM42(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM42Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m42");
}

static inline JSValue jsDOMMatrixReadOnlyM43Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m43());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM43(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM43Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m43");
}

static inline JSValue jsDOMMatrixReadOnlyM44Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m44());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyM44(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyM44Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m44");
}

static inline JSValue jsDOMMatrixReadOnlyIs2DGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.is2D());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyIs2D(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyIs2DGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "is2D");
}

static inline JSValue jsDOMMatrixReadOnlyIsIdentityGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isIdentity());
    return result;
}

EncodedJSValue jsDOMMatrixReadOnlyIsIdentity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrixReadOnly>::get<jsDOMMatrixReadOnlyIsIdentityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isIdentity");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructorFunctionFromMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrixReadOnly::fromMatrix(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyConstructorFunctionFromMatrix(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::callStatic<jsDOMMatrixReadOnlyConstructorFunctionFromMatrixBody>(*lexicalGlobalObject, *callFrame, "fromMatrix");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructorFunctionFromFloat32ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array32 = convert<IDLFloat32Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array32", "DOMMatrixReadOnly", "fromFloat32Array", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrixReadOnly::fromFloat32Array(array32.releaseNonNull())));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyConstructorFunctionFromFloat32Array(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::callStatic<jsDOMMatrixReadOnlyConstructorFunctionFromFloat32ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat32Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyConstructorFunctionFromFloat64ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array64 = convert<IDLFloat64Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array64", "DOMMatrixReadOnly", "fromFloat64Array", "Float64Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrixReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrixReadOnly::fromFloat64Array(array64.releaseNonNull())));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyConstructorFunctionFromFloat64Array(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::callStatic<jsDOMMatrixReadOnlyConstructorFunctionFromFloat64ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat64Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionTranslateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto tx = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ty = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto tz = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.translate(WTFMove(tx), WTFMove(ty), WTFMove(tz))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionTranslate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionTranslateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionScaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto scaleX = callFrame->argument(0).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scaleY = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scaleZ = callFrame->argument(2).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originX = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originY = callFrame->argument(4).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originZ = callFrame->argument(5).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.scale(WTFMove(scaleX), WTFMove(scaleY), WTFMove(scaleZ), WTFMove(originX), WTFMove(originY), WTFMove(originZ))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionScale(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionScaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionScale3dBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto scale = callFrame->argument(0).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originX = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originY = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originZ = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.scale3d(WTFMove(scale), WTFMove(originX), WTFMove(originY), WTFMove(originZ))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionScale3d(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionScale3dBody>(*lexicalGlobalObject, *callFrame, "scale3d");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionRotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto rotX = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotY = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotZ = callFrame->argument(2).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotate(WTFMove(rotX), WTFMove(rotY), WTFMove(rotZ))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionRotate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionRotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionRotateFromVectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotateFromVector(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionRotateFromVector(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionRotateFromVectorBody>(*lexicalGlobalObject, *callFrame, "rotateFromVector");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionRotateAxisAngleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto angle = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotateAxisAngle(WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(angle))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionRotateAxisAngle(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionRotateAxisAngleBody>(*lexicalGlobalObject, *callFrame, "rotateAxisAngle");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionSkewXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto sx = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.skewX(WTFMove(sx))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionSkewX(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionSkewXBody>(*lexicalGlobalObject, *callFrame, "skewX");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionSkewYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto sy = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.skewY(WTFMove(sy))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionSkewY(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionSkewYBody>(*lexicalGlobalObject, *callFrame, "skewY");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionMultiplyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto other = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.multiply(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionMultiply(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionMultiplyBody>(*lexicalGlobalObject, *callFrame, "multiply");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionFlipXBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.flipX()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionFlipX(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionFlipXBody>(*lexicalGlobalObject, *callFrame, "flipX");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionFlipYBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.flipY()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionFlipY(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionFlipYBody>(*lexicalGlobalObject, *callFrame, "flipY");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionInverseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.inverse()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionInverse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionInverseBody>(*lexicalGlobalObject, *callFrame, "inverse");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionTransformPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto point = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.transformPoint(WTFMove(point))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionTransformPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionTransformPointBody>(*lexicalGlobalObject, *callFrame, "transformPoint");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionToFloat32ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLFloat32Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toFloat32Array()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToFloat32Array(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionToFloat32ArrayBody>(*lexicalGlobalObject, *callFrame, "toFloat32Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionToFloat64ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLFloat64Array>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.toFloat64Array()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToFloat64Array(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionToFloat64ArrayBody>(*lexicalGlobalObject, *callFrame, "toFloat64Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionToStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrixReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.toString()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionToStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

JSC::JSObject* JSDOMMatrixReadOnly::serialize(JSGlobalObject& lexicalGlobalObject, JSDOMMatrixReadOnly& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto aValue = jsDOMMatrixReadOnlyAGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "a"), aValue);

    auto bValue = jsDOMMatrixReadOnlyBGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "b"), bValue);

    auto cValue = jsDOMMatrixReadOnlyCGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "c"), cValue);

    auto dValue = jsDOMMatrixReadOnlyDGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "d"), dValue);

    auto eValue = jsDOMMatrixReadOnlyEGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "e"), eValue);

    auto fValue = jsDOMMatrixReadOnlyFGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "f"), fValue);

    auto m11Value = jsDOMMatrixReadOnlyM11Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m11"), m11Value);

    auto m12Value = jsDOMMatrixReadOnlyM12Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m12"), m12Value);

    auto m13Value = jsDOMMatrixReadOnlyM13Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m13"), m13Value);

    auto m14Value = jsDOMMatrixReadOnlyM14Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m14"), m14Value);

    auto m21Value = jsDOMMatrixReadOnlyM21Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m21"), m21Value);

    auto m22Value = jsDOMMatrixReadOnlyM22Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m22"), m22Value);

    auto m23Value = jsDOMMatrixReadOnlyM23Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m23"), m23Value);

    auto m24Value = jsDOMMatrixReadOnlyM24Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m24"), m24Value);

    auto m31Value = jsDOMMatrixReadOnlyM31Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m31"), m31Value);

    auto m32Value = jsDOMMatrixReadOnlyM32Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m32"), m32Value);

    auto m33Value = jsDOMMatrixReadOnlyM33Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m33"), m33Value);

    auto m34Value = jsDOMMatrixReadOnlyM34Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m34"), m34Value);

    auto m41Value = jsDOMMatrixReadOnlyM41Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m41"), m41Value);

    auto m42Value = jsDOMMatrixReadOnlyM42Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m42"), m42Value);

    auto m43Value = jsDOMMatrixReadOnlyM43Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m43"), m43Value);

    auto m44Value = jsDOMMatrixReadOnlyM44Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "m44"), m44Value);

    auto is2DValue = jsDOMMatrixReadOnlyIs2DGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "is2D"), is2DValue);

    auto isIdentityValue = jsDOMMatrixReadOnlyIsIdentityGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "isIdentity"), isIdentityValue);

    return result;
}

static inline EncodedJSValue jsDOMMatrixReadOnlyPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMMatrixReadOnly* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSDOMMatrixReadOnly::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixReadOnlyPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrixReadOnly>::call<jsDOMMatrixReadOnlyPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSDOMMatrixReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMMatrixReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMMatrixReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMMatrixReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMMatrixReadOnly = static_cast<JSDOMMatrixReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMMatrixReadOnly->wrapped(), jsDOMMatrixReadOnly);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMMatrixReadOnly>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMMatrixReadOnly.
    static_assert(!std::is_polymorphic<DOMMatrixReadOnly>::value, "DOMMatrixReadOnly is polymorphic but the IDL claims it is not");
    return createWrapper<DOMMatrixReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMMatrixReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMMatrixReadOnly* JSDOMMatrixReadOnly::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMatrixReadOnly*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
