/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMimeType.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMPlugin.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsDOMMimeTypeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMimeTypeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMimeTypeType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeSuffixes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMMimeTypeEnabledPlugin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDOMMimeTypePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMMimeTypePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMimeTypePrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMimeTypePrototype>(vm.heap)) JSDOMMimeTypePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMimeTypePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMimeTypePrototype, JSDOMMimeTypePrototype::Base);

using JSDOMMimeTypeConstructor = JSDOMConstructorNotConstructable<JSDOMMimeType>;

template<> JSValue JSDOMMimeTypeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMMimeTypeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMMimeType::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MimeType"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDOMMimeTypeConstructor::s_info = { "MimeType", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMimeTypeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMMimeTypePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMimeTypeConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "suffixes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeSuffixes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "description", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "enabledPlugin", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMimeTypeEnabledPlugin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSDOMMimeTypePrototype::s_info = { "MimeTypePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMimeTypePrototype) };

void JSDOMMimeTypePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMimeType::info(), JSDOMMimeTypePrototypeTableValues, *this);
}

const ClassInfo JSDOMMimeType::s_info = { "MimeType", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMimeType) };

JSDOMMimeType::JSDOMMimeType(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMimeType>&& impl)
    : JSDOMWrapper<DOMMimeType>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMMimeType::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMMimeType>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMMimeType::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMMimeTypePrototype::create(vm, &globalObject, JSDOMMimeTypePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMMimeType::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMMimeType>(vm, globalObject);
}

JSValue JSDOMMimeType::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMimeTypeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMMimeType::destroy(JSC::JSCell* cell)
{
    JSDOMMimeType* thisObject = static_cast<JSDOMMimeType*>(cell);
    thisObject->JSDOMMimeType::~JSDOMMimeType();
}

template<> inline JSDOMMimeType* IDLAttribute<JSDOMMimeType>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMMimeType*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsDOMMimeTypeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMimeTypePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMMimeType::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMMimeTypeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMimeTypePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMMimeTypeTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsDOMMimeTypeType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeTypeTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsDOMMimeTypeSuffixesGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.suffixes());
    return result;
}

EncodedJSValue jsDOMMimeTypeSuffixes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeTypeSuffixesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "suffixes");
}

static inline JSValue jsDOMMimeTypeDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.description());
    return result;
}

EncodedJSValue jsDOMMimeTypeDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeTypeDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "description");
}

static inline JSValue jsDOMMimeTypeEnabledPluginGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMimeType& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMPlugin>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.enabledPlugin());
    return result;
}

EncodedJSValue jsDOMMimeTypeEnabledPlugin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMimeType>::get<jsDOMMimeTypeEnabledPluginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "enabledPlugin");
}

void JSDOMMimeType::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMMimeType*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMMimeTypeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMMimeTypeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMMimeType = static_cast<JSDOMMimeType*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMMimeType->wrapped(), jsDOMMimeType);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMMimeType@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11DOMMimeTypeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMMimeType>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7DOMMimeType@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11DOMMimeTypeE[2];
#endif

    // If this fails DOMMimeType does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<DOMMimeType>::value, "DOMMimeType is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // DOMMimeType has subclasses. If DOMMimeType has subclasses that get passed
    // to toJS() we currently require DOMMimeType you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<DOMMimeType>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMMimeType& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMMimeType* JSDOMMimeType::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMMimeType*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
