/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMQuad.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMQuad.h"
#include "JSDOMQuadInit.h"
#include "JSDOMRect.h"
#include "JSDOMRectInit.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMQuadConstructorFunctionFromRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMQuadConstructorFunctionFromQuad(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMQuadPrototypeFunctionGetBounds(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMQuadPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMQuadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMQuadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMQuadP1(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMQuadP2(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMQuadP3(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMQuadP4(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDOMQuadPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMQuadPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMQuadPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMQuadPrototype>(vm.heap)) JSDOMQuadPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMQuadPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMQuadPrototype, JSDOMQuadPrototype::Base);

using JSDOMQuadConstructor = JSDOMConstructor<JSDOMQuad>;

/* Hash table for constructor */

static const HashTableValue JSDOMQuadConstructorTableValues[] =
{
    { "fromRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMQuadConstructorFunctionFromRect), (intptr_t) (0) } },
    { "fromQuad", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMQuadConstructorFunctionFromQuad), (intptr_t) (0) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSDOMQuadConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMQuadConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto p1 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto p2 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto p3 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto p4 = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMQuad::create(WTFMove(p1), WTFMove(p2), WTFMove(p3), WTFMove(p4));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMQuad>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSDOMQuadConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMQuadConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMQuad::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMQuad"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMQuad::info(), JSDOMQuadConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMQuadConstructor::s_info = { "DOMQuad", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMQuadConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMQuadPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMQuadConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMQuadConstructor) } },
    { "p1", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMQuadP1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "p2", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMQuadP2), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "p3", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMQuadP3), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "p4", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMQuadP4), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getBounds", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMQuadPrototypeFunctionGetBounds), (intptr_t) (0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMQuadPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSDOMQuadPrototype::s_info = { "DOMQuadPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMQuadPrototype) };

void JSDOMQuadPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMQuad::info(), JSDOMQuadPrototypeTableValues, *this);
}

const ClassInfo JSDOMQuad::s_info = { "DOMQuad", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMQuad) };

JSDOMQuad::JSDOMQuad(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMQuad>&& impl)
    : JSDOMWrapper<DOMQuad>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMQuad::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMQuad>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMQuad::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMQuadPrototype::create(vm, &globalObject, JSDOMQuadPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMQuad::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMQuad>(vm, globalObject);
}

JSValue JSDOMQuad::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMQuadConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMQuad::destroy(JSC::JSCell* cell)
{
    JSDOMQuad* thisObject = static_cast<JSDOMQuad*>(cell);
    thisObject->JSDOMQuad::~JSDOMQuad();
}

template<> inline JSDOMQuad* IDLAttribute<JSDOMQuad>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMQuad*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMQuad* IDLOperation<JSDOMQuad>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMQuad*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMQuadConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMQuadPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMQuad::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMQuadConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMQuadPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMQuadP1Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p1());
    return result;
}

EncodedJSValue jsDOMQuadP1(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuadP1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "p1");
}

static inline JSValue jsDOMQuadP2Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p2());
    return result;
}

EncodedJSValue jsDOMQuadP2(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuadP2Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "p2");
}

static inline JSValue jsDOMQuadP3Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p3());
    return result;
}

EncodedJSValue jsDOMQuadP3(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuadP3Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "p3");
}

static inline JSValue jsDOMQuadP4Getter(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMPoint>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.p4());
    return result;
}

EncodedJSValue jsDOMQuadP4(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMQuad>::get<jsDOMQuadP4Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "p4");
}

static inline JSC::EncodedJSValue jsDOMQuadConstructorFunctionFromRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMRectInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMQuad>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), DOMQuad::fromRect(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMQuadConstructorFunctionFromRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMQuad>::callStatic<jsDOMQuadConstructorFunctionFromRectBody>(*lexicalGlobalObject, *callFrame, "fromRect");
}

static inline JSC::EncodedJSValue jsDOMQuadConstructorFunctionFromQuadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMQuadInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMQuad>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), DOMQuad::fromQuad(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMQuadConstructorFunctionFromQuad(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMQuad>::callStatic<jsDOMQuadConstructorFunctionFromQuadBody>(*lexicalGlobalObject, *callFrame, "fromQuad");
}

static inline JSC::EncodedJSValue jsDOMQuadPrototypeFunctionGetBoundsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMQuad>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getBounds()));
}

EncodedJSValue JSC_HOST_CALL jsDOMQuadPrototypeFunctionGetBounds(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMQuad>::call<jsDOMQuadPrototypeFunctionGetBoundsBody>(*lexicalGlobalObject, *callFrame, "getBounds");
}

JSC::JSObject* JSDOMQuad::serialize(JSGlobalObject& lexicalGlobalObject, JSDOMQuad& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto p1Value = jsDOMQuadP1Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    auto* p1SerializedValue = JSDOMPoint::serialize(lexicalGlobalObject, *jsCast<JSDOMPoint*>(p1Value), globalObject, throwScope);
    result->putDirect(vm, Identifier::fromString(vm, "p1"), p1SerializedValue);

    auto p2Value = jsDOMQuadP2Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    auto* p2SerializedValue = JSDOMPoint::serialize(lexicalGlobalObject, *jsCast<JSDOMPoint*>(p2Value), globalObject, throwScope);
    result->putDirect(vm, Identifier::fromString(vm, "p2"), p2SerializedValue);

    auto p3Value = jsDOMQuadP3Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    auto* p3SerializedValue = JSDOMPoint::serialize(lexicalGlobalObject, *jsCast<JSDOMPoint*>(p3Value), globalObject, throwScope);
    result->putDirect(vm, Identifier::fromString(vm, "p3"), p3SerializedValue);

    auto p4Value = jsDOMQuadP4Getter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    auto* p4SerializedValue = JSDOMPoint::serialize(lexicalGlobalObject, *jsCast<JSDOMPoint*>(p4Value), globalObject, throwScope);
    result->putDirect(vm, Identifier::fromString(vm, "p4"), p4SerializedValue);

    return result;
}

static inline EncodedJSValue jsDOMQuadPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMQuad* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSDOMQuad::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsDOMQuadPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMQuad>::call<jsDOMQuadPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSDOMQuad::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDOMQuad*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSDOMQuad::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDOMQuad*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSDOMQuad::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMQuad*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMQuadOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMQuadOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMQuad = static_cast<JSDOMQuad*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMQuad->wrapped(), jsDOMQuad);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMQuad>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMQuad.
    static_assert(!std::is_polymorphic<DOMQuad>::value, "DOMQuad is polymorphic but the IDL claims it is not");
    return createWrapper<DOMQuad>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMQuad& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMQuad* JSDOMQuad::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMQuad*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
