/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMQuadInit.h"

#include "JSDOMPointInit.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> DOMQuadInit convertDictionary<DOMQuadInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DOMQuadInit result;
    JSValue p1Value;
    if (isNullOrUndefined)
        p1Value = jsUndefined();
    else {
        p1Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p1"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!p1Value.isUndefined()) {
        result.p1 = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p1Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue p2Value;
    if (isNullOrUndefined)
        p2Value = jsUndefined();
    else {
        p2Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p2"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!p2Value.isUndefined()) {
        result.p2 = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p2Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue p3Value;
    if (isNullOrUndefined)
        p3Value = jsUndefined();
    else {
        p3Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p3"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!p3Value.isUndefined()) {
        result.p3 = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p3Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue p4Value;
    if (isNullOrUndefined)
        p4Value = jsUndefined();
    else {
        p4Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "p4"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!p4Value.isUndefined()) {
        result.p4 = convert<IDLDictionary<DOMPointInit>>(lexicalGlobalObject, p4Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
