/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMRectReadOnly.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMRectInit.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMRectReadOnlyConstructorFunctionFromRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMRectReadOnlyPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMRectReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMRectReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMRectReadOnlyX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyRight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyBottom(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMRectReadOnlyLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDOMRectReadOnlyPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMRectReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMRectReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMRectReadOnlyPrototype>(vm.heap)) JSDOMRectReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMRectReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMRectReadOnlyPrototype, JSDOMRectReadOnlyPrototype::Base);

using JSDOMRectReadOnlyConstructor = JSDOMConstructor<JSDOMRectReadOnly>;

/* Hash table for constructor */

static const HashTableValue JSDOMRectReadOnlyConstructorTableValues[] =
{
    { "fromRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMRectReadOnlyConstructorFunctionFromRect), (intptr_t) (0) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSDOMRectReadOnlyConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMRectReadOnlyConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMRectReadOnly::create(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMRectReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSDOMRectReadOnlyConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMRectReadOnlyConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMRectReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMRectReadOnly"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMRectReadOnly::info(), JSDOMRectReadOnlyConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMRectReadOnlyConstructor::s_info = { "DOMRectReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMRectReadOnlyConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMRectReadOnlyPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMRectReadOnlyConstructor) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "top", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "right", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyRight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bottom", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyBottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "left", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMRectReadOnlyLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMRectReadOnlyPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSDOMRectReadOnlyPrototype::s_info = { "DOMRectReadOnlyPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMRectReadOnlyPrototype) };

void JSDOMRectReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMRectReadOnly::info(), JSDOMRectReadOnlyPrototypeTableValues, *this);
}

const ClassInfo JSDOMRectReadOnly::s_info = { "DOMRectReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMRectReadOnly) };

JSDOMRectReadOnly::JSDOMRectReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMRectReadOnly>&& impl)
    : JSDOMWrapper<DOMRectReadOnly>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMRectReadOnly::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMRectReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMRectReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMRectReadOnlyPrototype::create(vm, &globalObject, JSDOMRectReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMRectReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMRectReadOnly>(vm, globalObject);
}

JSValue JSDOMRectReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMRectReadOnlyConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMRectReadOnly::destroy(JSC::JSCell* cell)
{
    JSDOMRectReadOnly* thisObject = static_cast<JSDOMRectReadOnly*>(cell);
    thisObject->JSDOMRectReadOnly::~JSDOMRectReadOnly();
}

template<> inline JSDOMRectReadOnly* IDLAttribute<JSDOMRectReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMRectReadOnly*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMRectReadOnly* IDLOperation<JSDOMRectReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMRectReadOnly*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMRectReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMRectReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMRectReadOnly::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMRectReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMRectReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMRectReadOnlyXGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.x());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline JSValue jsDOMRectReadOnlyYGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.y());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline JSValue jsDOMRectReadOnlyWidthGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.width());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline JSValue jsDOMRectReadOnlyHeightGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.height());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline JSValue jsDOMRectReadOnlyTopGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.top());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "top");
}

static inline JSValue jsDOMRectReadOnlyRightGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.right());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyRight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyRightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "right");
}

static inline JSValue jsDOMRectReadOnlyBottomGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.bottom());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyBottom(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyBottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bottom");
}

static inline JSValue jsDOMRectReadOnlyLeftGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.left());
    return result;
}

EncodedJSValue jsDOMRectReadOnlyLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnlyLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "left");
}

static inline JSC::EncodedJSValue jsDOMRectReadOnlyConstructorFunctionFromRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMRectInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMRectReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), DOMRectReadOnly::fromRect(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMRectReadOnlyConstructorFunctionFromRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMRectReadOnly>::callStatic<jsDOMRectReadOnlyConstructorFunctionFromRectBody>(*lexicalGlobalObject, *callFrame, "fromRect");
}

JSC::JSObject* JSDOMRectReadOnly::serialize(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto xValue = jsDOMRectReadOnlyXGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "x"), xValue);

    auto yValue = jsDOMRectReadOnlyYGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "y"), yValue);

    auto widthValue = jsDOMRectReadOnlyWidthGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "width"), widthValue);

    auto heightValue = jsDOMRectReadOnlyHeightGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "height"), heightValue);

    auto topValue = jsDOMRectReadOnlyTopGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "top"), topValue);

    auto rightValue = jsDOMRectReadOnlyRightGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "right"), rightValue);

    auto bottomValue = jsDOMRectReadOnlyBottomGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "bottom"), bottomValue);

    auto leftValue = jsDOMRectReadOnlyLeftGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "left"), leftValue);

    return result;
}

static inline EncodedJSValue jsDOMRectReadOnlyPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMRectReadOnly* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSDOMRectReadOnly::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsDOMRectReadOnlyPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMRectReadOnly>::call<jsDOMRectReadOnlyPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSDOMRectReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMRectReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMRectReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsDOMRectReadOnly = jsCast<JSDOMRectReadOnly*>(handle.slot()->asCell());
    DOMRectReadOnly* root = &jsDOMRectReadOnly->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from DOMRectReadOnly";
    return visitor.containsOpaqueRoot(root);
}

void JSDOMRectReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMRectReadOnly = static_cast<JSDOMRectReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMRectReadOnly->wrapped(), jsDOMRectReadOnly);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMRectReadOnly>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMRectReadOnly.
    static_assert(!std::is_polymorphic<DOMRectReadOnly>::value, "DOMRectReadOnly is polymorphic but the IDL claims it is not");
    return createWrapper<DOMRectReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMRectReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMRectReadOnly* JSDOMRectReadOnly::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMRectReadOnly*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
