/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMSelection.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSRange.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapseToEnd(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapseToStart(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionDeleteFromDocument(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionContainsNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSelectAllChildren(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionExtend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionGetRangeAt(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionRemoveAllRanges(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionAddRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionToString(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSetBaseAndExtent(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSetPosition(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionEmpty(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionModify(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMSelectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMSelectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMSelectionAnchorNode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionAnchorOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionFocusNode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionFocusOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionIsCollapsed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionRangeCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionBaseNode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionBaseOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionExtentNode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMSelectionExtentOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDOMSelectionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMSelectionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMSelectionPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMSelectionPrototype>(vm.heap)) JSDOMSelectionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMSelectionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMSelectionPrototype, JSDOMSelectionPrototype::Base);

using JSDOMSelectionConstructor = JSDOMConstructorNotConstructable<JSDOMSelection>;

template<> JSValue JSDOMSelectionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMSelectionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMSelection::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Selection"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDOMSelectionConstructor::s_info = { "Selection", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMSelectionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMSelectionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMSelectionConstructor) } },
    { "anchorNode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionAnchorNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "anchorOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionAnchorOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "focusNode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionFocusNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "focusOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionFocusOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isCollapsed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionIsCollapsed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionRangeCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "baseNode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionBaseNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "baseOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionBaseOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "extentNode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionExtentNode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "extentOffset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSelectionExtentOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "collapse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionCollapse), (intptr_t) (1) } },
    { "collapseToEnd", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionCollapseToEnd), (intptr_t) (0) } },
    { "collapseToStart", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionCollapseToStart), (intptr_t) (0) } },
    { "deleteFromDocument", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionDeleteFromDocument), (intptr_t) (0) } },
    { "containsNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionContainsNode), (intptr_t) (1) } },
    { "selectAllChildren", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionSelectAllChildren), (intptr_t) (1) } },
    { "extend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionExtend), (intptr_t) (1) } },
    { "getRangeAt", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionGetRangeAt), (intptr_t) (1) } },
    { "removeAllRanges", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionRemoveAllRanges), (intptr_t) (0) } },
    { "addRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionAddRange), (intptr_t) (1) } },
    { "toString", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionToString), (intptr_t) (0) } },
    { "setBaseAndExtent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionSetBaseAndExtent), (intptr_t) (4) } },
    { "setPosition", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionSetPosition), (intptr_t) (1) } },
    { "empty", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionEmpty), (intptr_t) (0) } },
    { "modify", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMSelectionPrototypeFunctionModify), (intptr_t) (0) } },
};

const ClassInfo JSDOMSelectionPrototype::s_info = { "SelectionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMSelectionPrototype) };

void JSDOMSelectionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMSelection::info(), JSDOMSelectionPrototypeTableValues, *this);
}

const ClassInfo JSDOMSelection::s_info = { "Selection", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMSelection) };

JSDOMSelection::JSDOMSelection(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMSelection>&& impl)
    : JSDOMWrapper<DOMSelection>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMSelection::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMSelection>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMSelection::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMSelectionPrototype::create(vm, &globalObject, JSDOMSelectionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMSelection::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMSelection>(vm, globalObject);
}

JSValue JSDOMSelection::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMSelectionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMSelection::destroy(JSC::JSCell* cell)
{
    JSDOMSelection* thisObject = static_cast<JSDOMSelection*>(cell);
    thisObject->JSDOMSelection::~JSDOMSelection();
}

template<> inline JSDOMSelection* IDLAttribute<JSDOMSelection>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMSelection*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMSelection* IDLOperation<JSDOMSelection>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMSelection*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMSelectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMSelectionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMSelection::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMSelectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMSelectionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMSelectionAnchorNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.anchorNode());
    return result;
}

EncodedJSValue jsDOMSelectionAnchorNode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionAnchorNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "anchorNode");
}

static inline JSValue jsDOMSelectionAnchorOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.anchorOffset());
    return result;
}

EncodedJSValue jsDOMSelectionAnchorOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionAnchorOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "anchorOffset");
}

static inline JSValue jsDOMSelectionFocusNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.focusNode());
    return result;
}

EncodedJSValue jsDOMSelectionFocusNode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionFocusNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "focusNode");
}

static inline JSValue jsDOMSelectionFocusOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.focusOffset());
    return result;
}

EncodedJSValue jsDOMSelectionFocusOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionFocusOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "focusOffset");
}

static inline JSValue jsDOMSelectionIsCollapsedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isCollapsed());
    return result;
}

EncodedJSValue jsDOMSelectionIsCollapsed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionIsCollapsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isCollapsed");
}

static inline JSValue jsDOMSelectionRangeCountGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.rangeCount());
    return result;
}

EncodedJSValue jsDOMSelectionRangeCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionRangeCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rangeCount");
}

static inline JSValue jsDOMSelectionTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsDOMSelectionType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsDOMSelectionBaseNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.baseNode());
    return result;
}

EncodedJSValue jsDOMSelectionBaseNode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionBaseNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "baseNode");
}

static inline JSValue jsDOMSelectionBaseOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.baseOffset());
    return result;
}

EncodedJSValue jsDOMSelectionBaseOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionBaseOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "baseOffset");
}

static inline JSValue jsDOMSelectionExtentNodeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.extentNode());
    return result;
}

EncodedJSValue jsDOMSelectionExtentNode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionExtentNodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "extentNode");
}

static inline JSValue jsDOMSelectionExtentOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMSelection& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.extentOffset());
    return result;
}

EncodedJSValue jsDOMSelectionExtentOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMSelection>::get<jsDOMSelectionExtentOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "extentOffset");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionCollapseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Selection", "collapse", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.collapse(WTFMove(node), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionCollapseBody>(*lexicalGlobalObject, *callFrame, "collapse");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionCollapseToEndBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.collapseToEnd());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapseToEnd(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionCollapseToEndBody>(*lexicalGlobalObject, *callFrame, "collapseToEnd");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionCollapseToStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.collapseToStart());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionCollapseToStart(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionCollapseToStartBody>(*lexicalGlobalObject, *callFrame, "collapseToStart");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionDeleteFromDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    impl.deleteFromDocument();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionDeleteFromDocument(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionDeleteFromDocumentBody>(*lexicalGlobalObject, *callFrame, "deleteFromDocument");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionContainsNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Selection", "containsNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto allowPartial = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.containsNode(*node, WTFMove(allowPartial))));
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionContainsNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionContainsNodeBody>(*lexicalGlobalObject, *callFrame, "containsNode");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionSelectAllChildrenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Selection", "selectAllChildren", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.selectAllChildren(*node);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSelectAllChildren(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionSelectAllChildrenBody>(*lexicalGlobalObject, *callFrame, "selectAllChildren");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionExtendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Selection", "extend", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.extend(*node, WTFMove(offset)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionExtend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionExtendBody>(*lexicalGlobalObject, *callFrame, "extend");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionGetRangeAtBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRangeAt(WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionGetRangeAt(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionGetRangeAtBody>(*lexicalGlobalObject, *callFrame, "getRangeAt");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionRemoveAllRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.removeAllRanges();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionRemoveAllRanges(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionRemoveAllRangesBody>(*lexicalGlobalObject, *callFrame, "removeAllRanges");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionAddRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Selection", "addRange", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.addRange(*range);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionAddRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionAddRangeBody>(*lexicalGlobalObject, *callFrame, "addRange");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionToStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.toString()));
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionToString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionToStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionSetBaseAndExtentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto baseNode = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "baseNode", "Selection", "setBaseAndExtent", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto baseOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto extentNode = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "extentNode", "Selection", "setBaseAndExtent", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto extentOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setBaseAndExtent(WTFMove(baseNode), WTFMove(baseOffset), WTFMove(extentNode), WTFMove(extentOffset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSetBaseAndExtent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionSetBaseAndExtentBody>(*lexicalGlobalObject, *callFrame, "setBaseAndExtent");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionSetPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Selection", "setPosition", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPosition(WTFMove(node), WTFMove(offset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionSetPosition(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionSetPositionBody>(*lexicalGlobalObject, *callFrame, "setPosition");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionEmptyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.empty();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionEmpty(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionEmptyBody>(*lexicalGlobalObject, *callFrame, "empty");
}

static inline JSC::EncodedJSValue jsDOMSelectionPrototypeFunctionModifyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMSelection>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto alter = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto granularity = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.modify(WTFMove(alter), WTFMove(direction), WTFMove(granularity));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMSelectionPrototypeFunctionModify(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMSelection>::call<jsDOMSelectionPrototypeFunctionModifyBody>(*lexicalGlobalObject, *callFrame, "modify");
}

void JSDOMSelection::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMSelection*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMSelectionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsDOMSelection = jsCast<JSDOMSelection*>(handle.slot()->asCell());
    auto* root = WTF::getPtr(jsDOMSelection->wrapped().window());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Window";
    return visitor.containsOpaqueRoot(root);
}

void JSDOMSelectionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMSelection = static_cast<JSDOMSelection*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMSelection->wrapped(), jsDOMSelection);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMSelection>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMSelection.
    static_assert(!std::is_polymorphic<DOMSelection>::value, "DOMSelection is polymorphic but the IDL claims it is not");
    return createWrapper<DOMSelection>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMSelection& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMSelection* JSDOMSelection::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMSelection*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
