/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "DOMWindow.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapper.h"

namespace WebCore {

class DOMWindow;

class JSWindowProxy;

class WEBCORE_EXPORT JSDOMWindow : public JSDOMWindowBase {
public:
    using Base = JSDOMWindowBase;
    using DOMWrapped = DOMWindow;
    static JSDOMWindow* create(JSC::VM& vm, JSC::Structure* structure, Ref<DOMWindow>&& impl, JSWindowProxy* proxy)
    {
        JSDOMWindow* ptr = new (NotNull, JSC::allocateCell<JSDOMWindow>(vm.heap)) JSDOMWindow(vm, structure, WTFMove(impl), proxy);
        ptr->finishCreation(vm, proxy);
        return ptr;
    }

    static DOMWindow* toWrapped(JSC::VM&, JSC::JSValue);
    static bool getOwnPropertySlot(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertySlotByIndex(JSC::JSObject*, JSC::JSGlobalObject*, unsigned propertyName, JSC::PropertySlot&);
    static void doPutPropertySecurityCheck(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::PutPropertySlot&);
    static void getOwnPropertyNames(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyNameArray&, JSC::EnumerationMode = JSC::EnumerationMode());
    static bool put(JSC::JSCell*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static bool putByIndex(JSC::JSCell*, JSC::JSGlobalObject*, unsigned propertyName, JSC::JSValue, bool shouldThrow);
    static bool defineOwnProperty(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, const JSC::PropertyDescriptor&, bool shouldThrow);
    static bool deleteProperty(JSC::JSCell*, JSC::JSGlobalObject*, JSC::PropertyName);
    static bool deletePropertyByIndex(JSC::JSCell*, JSC::JSGlobalObject*, unsigned);
    static JSC::JSValue getPrototype(JSC::JSObject*, JSC::JSGlobalObject*);
    static String toStringName(const JSC::JSObject*, JSC::JSGlobalObject*);
    static bool preventExtensions(JSC::JSObject*, JSC::JSGlobalObject*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::GlobalObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess> static JSC::IsoSubspace* subspaceFor(JSC::VM& vm) { return subspaceForImpl(vm); }
    static JSC::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);
    void visitAdditionalChildren(JSC::SlotVisitor&);

    static void visitOutputConstraints(JSCell*, JSC::SlotVisitor&);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue window(JSC::JSGlobalObject&) const;
    JSC::JSValue self(JSC::JSGlobalObject&) const;
    JSC::JSValue frames(JSC::JSGlobalObject&) const;
    void setOpener(JSC::JSGlobalObject&, JSC::JSValue);
    JSC::JSValue event(JSC::JSGlobalObject&) const;
    JSC::JSValue openDatabase(JSC::JSGlobalObject&) const;
    void setOpenDatabase(JSC::JSGlobalObject&, JSC::JSValue);

    // Custom functions
    JSC::JSValue showModalDialog(JSC::JSGlobalObject&, JSC::CallFrame&);
    JSC::JSValue queueMicrotask(JSC::JSGlobalObject&, JSC::CallFrame&);
    DOMWindow& wrapped() const
    {
        return static_cast<DOMWindow&>(Base::wrapped());
    }
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::HasPutPropertySecurityCheck | JSC::HasStaticPropertyTable | JSC::ImplementsHasInstance | JSC::ImplementsDefaultHasInstance | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::IsImmutablePrototypeExoticObject | JSC::OverridesGetOwnPropertySlot | JSC::OverridesGetPropertyNames;
protected:
    JSDOMWindow(JSC::VM&, JSC::Structure*, Ref<DOMWindow>&&, JSWindowProxy*);
    void finishCreation(JSC::VM&, JSWindowProxy*);
};


class JSDOMWindowPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMWindowPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMWindowPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMWindowPrototype>(vm.heap)) JSDOMWindowPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMWindowPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::HasStaticPropertyTable | JSC::IsImmutablePrototypeExoticObject;
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMWindowPrototype, JSDOMWindowPrototype::Base);

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionFocus(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionBlur(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionPostMessage(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMWindowClosed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
template<> struct JSDOMWrapperConverterTraits<DOMWindow> {
    using WrapperClass = JSDOMWindow;
    using ToWrappedReturnType = DOMWindow*;
};
template<> WindowPostMessageOptions convertDictionary<WindowPostMessageOptions>(JSC::JSGlobalObject&, JSC::JSValue);


} // namespace WebCore
