/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDataTransfer.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDataTransferItemList.h"
#include "JSElement.h"
#include "JSFileList.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetDragImage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionGetData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionClearData(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDataTransferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDataTransferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDataTransferDropEffect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDataTransferDropEffect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDataTransferEffectAllowed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDataTransferEffectAllowed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDataTransferItems(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDataTransferTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDataTransferFiles(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDataTransferPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDataTransferPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDataTransferPrototype* ptr = new (NotNull, JSC::allocateCell<JSDataTransferPrototype>(vm.heap)) JSDataTransferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDataTransferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDataTransferPrototype, JSDataTransferPrototype::Base);

using JSDataTransferConstructor = JSDOMConstructorNotConstructable<JSDataTransfer>;

template<> JSValue JSDataTransferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDataTransferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDataTransfer::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DataTransfer"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDataTransferConstructor::s_info = { "DataTransfer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDataTransferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDataTransferPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataTransferConstructor) } },
    { "dropEffect", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferDropEffect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataTransferDropEffect) } },
    { "effectAllowed", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferEffectAllowed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataTransferEffectAllowed) } },
    { "items", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferItems), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "types", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferTypes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "files", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferFiles), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setDragImage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDataTransferPrototypeFunctionSetDragImage), (intptr_t) (3) } },
    { "getData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDataTransferPrototypeFunctionGetData), (intptr_t) (1) } },
    { "setData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDataTransferPrototypeFunctionSetData), (intptr_t) (2) } },
    { "clearData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDataTransferPrototypeFunctionClearData), (intptr_t) (0) } },
};

const ClassInfo JSDataTransferPrototype::s_info = { "DataTransferPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDataTransferPrototype) };

void JSDataTransferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDataTransfer::info(), JSDataTransferPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().dataTransferItemsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("items"), strlen("items"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSDataTransfer::s_info = { "DataTransfer", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDataTransfer) };

JSDataTransfer::JSDataTransfer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DataTransfer>&& impl)
    : JSDOMWrapper<DataTransfer>(structure, globalObject, WTFMove(impl))
{
}

void JSDataTransfer::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DataTransfer>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDataTransfer::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDataTransferPrototype::create(vm, &globalObject, JSDataTransferPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDataTransfer::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDataTransfer>(vm, globalObject);
}

JSValue JSDataTransfer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataTransferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDataTransfer::destroy(JSC::JSCell* cell)
{
    JSDataTransfer* thisObject = static_cast<JSDataTransfer*>(cell);
    thisObject->JSDataTransfer::~JSDataTransfer();
}

template<> inline JSDataTransfer* IDLAttribute<JSDataTransfer>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDataTransfer*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDataTransfer* IDLOperation<JSDataTransfer>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDataTransfer*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDataTransferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDataTransferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDataTransfer::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDataTransferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDataTransferPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDataTransferDropEffectGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.dropEffect());
    return result;
}

EncodedJSValue jsDataTransferDropEffect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDataTransfer>::get<jsDataTransferDropEffectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dropEffect");
}

static inline bool setJSDataTransferDropEffectSetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDropEffect(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDataTransferDropEffect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDataTransfer>::set<setJSDataTransferDropEffectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "dropEffect");
}

static inline JSValue jsDataTransferEffectAllowedGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.effectAllowed());
    return result;
}

EncodedJSValue jsDataTransferEffectAllowed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDataTransfer>::get<jsDataTransferEffectAllowedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "effectAllowed");
}

static inline bool setJSDataTransferEffectAllowedSetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEffectAllowed(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDataTransferEffectAllowed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDataTransfer>::set<setJSDataTransferEffectAllowedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "effectAllowed");
}

static inline JSValue jsDataTransferItemsGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DataTransferItemList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.items());
    return result;
}

EncodedJSValue jsDataTransferItems(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDataTransfer>::get<jsDataTransferItemsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "items");
}

static inline JSValue jsDataTransferTypesGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.types());
    return result;
}

EncodedJSValue jsDataTransferTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDataTransfer>::get<jsDataTransferTypesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "types");
}

static inline JSValue jsDataTransferFilesGetter(JSGlobalObject& lexicalGlobalObject, JSDataTransfer& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<FileList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.files());
    return result;
}

EncodedJSValue jsDataTransferFiles(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDataTransfer>::get<jsDataTransferFilesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "files");
}

static inline JSC::EncodedJSValue jsDataTransferPrototypeFunctionSetDragImageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransfer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto image = convert<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "image", "DataTransfer", "setDragImage", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setDragImage(WTFMove(image), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetDragImage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDataTransfer>::call<jsDataTransferPrototypeFunctionSetDragImageBody>(*lexicalGlobalObject, *callFrame, "setDragImage");
}

static inline JSC::EncodedJSValue jsDataTransferPrototypeFunctionGetDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransfer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto format = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.getData(document, WTFMove(format))));
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionGetData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDataTransfer>::call<jsDataTransferPrototypeFunctionGetDataBody>(*lexicalGlobalObject, *callFrame, "getData");
}

static inline JSC::EncodedJSValue jsDataTransferPrototypeFunctionSetDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransfer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto format = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setData(WTFMove(format), WTFMove(data));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionSetData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDataTransfer>::call<jsDataTransferPrototypeFunctionSetDataBody>(*lexicalGlobalObject, *callFrame, "setData");
}

static inline JSC::EncodedJSValue jsDataTransferPrototypeFunctionClearDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDataTransfer>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto format = callFrame->argument(0).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.clearData(WTFMove(format));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferPrototypeFunctionClearData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDataTransfer>::call<jsDataTransferPrototypeFunctionClearDataBody>(*lexicalGlobalObject, *callFrame, "clearData");
}

void JSDataTransfer::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDataTransfer*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDataTransferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDataTransferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDataTransfer = static_cast<JSDataTransfer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDataTransfer->wrapped(), jsDataTransfer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DataTransfer>&& impl)
{
    return createWrapper<DataTransfer>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DataTransfer& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DataTransfer* JSDataTransfer::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDataTransfer*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
