/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDeprecatedCSSOMCounter.h"
#include "JSDeprecatedCSSOMRGBColor.h"
#include "JSDeprecatedCSSOMRect.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetFloatValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetFloatValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetStringValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetStringValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetCounterValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRectValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRGBColorValue(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMPrimitiveValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrimitiveType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeprecatedCSSOMPrimitiveValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMPrimitiveValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMPrimitiveValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMPrimitiveValuePrototype>(vm.heap)) JSDeprecatedCSSOMPrimitiveValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMPrimitiveValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMPrimitiveValuePrototype, JSDeprecatedCSSOMPrimitiveValuePrototype::Base);

using JSDeprecatedCSSOMPrimitiveValueConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMPrimitiveValue>;

/* Hash table for constructor */

static const HashTableValue JSDeprecatedCSSOMPrimitiveValueConstructorTableValues[] =
{
    { "CSS_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_NUMBER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_PERCENTAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_EMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CSS_EXS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "CSS_PX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CSS_CM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "CSS_MM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "CSS_IN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "CSS_PT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "CSS_PC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "CSS_DEG", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "CSS_RAD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "CSS_GRAD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "CSS_MS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "CSS_S", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "CSS_HZ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "CSS_KHZ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "CSS_DIMENSION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "CSS_STRING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(19) } },
    { "CSS_URI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(20) } },
    { "CSS_IDENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(21) } },
    { "CSS_ATTR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(22) } },
    { "CSS_COUNTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(23) } },
    { "CSS_RECT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(24) } },
    { "CSS_RGBCOLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(25) } },
    { "CSS_VW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(26) } },
    { "CSS_VH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(27) } },
    { "CSS_VMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(28) } },
    { "CSS_VMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(29) } },
};

static_assert(DeprecatedCSSOMPrimitiveValue::CSS_UNKNOWN == 0, "CSS_UNKNOWN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_NUMBER == 1, "CSS_NUMBER in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PERCENTAGE == 2, "CSS_PERCENTAGE in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_EMS == 3, "CSS_EMS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_EXS == 4, "CSS_EXS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PX == 5, "CSS_PX in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_CM == 6, "CSS_CM in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_MM == 7, "CSS_MM in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_IN == 8, "CSS_IN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PT == 9, "CSS_PT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_PC == 10, "CSS_PC in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_DEG == 11, "CSS_DEG in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RAD == 12, "CSS_RAD in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_GRAD == 13, "CSS_GRAD in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_MS == 14, "CSS_MS in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_S == 15, "CSS_S in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_HZ == 16, "CSS_HZ in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_KHZ == 17, "CSS_KHZ in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_DIMENSION == 18, "CSS_DIMENSION in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_STRING == 19, "CSS_STRING in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_URI == 20, "CSS_URI in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_IDENT == 21, "CSS_IDENT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_ATTR == 22, "CSS_ATTR in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_COUNTER == 23, "CSS_COUNTER in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RECT == 24, "CSS_RECT in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_RGBCOLOR == 25, "CSS_RGBCOLOR in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_VW == 26, "CSS_VW in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_VH == 27, "CSS_VH in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_VMIN == 28, "CSS_VMIN in DeprecatedCSSOMPrimitiveValue does not match value from IDL");
static_assert(DeprecatedCSSOMPrimitiveValue::CSS_VMAX == 29, "CSS_VMAX in DeprecatedCSSOMPrimitiveValue does not match value from IDL");

template<> JSValue JSDeprecatedCSSOMPrimitiveValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMValue::getConstructor(vm, &globalObject);
}

template<> void JSDeprecatedCSSOMPrimitiveValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMPrimitiveValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSPrimitiveValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDeprecatedCSSOMPrimitiveValue::info(), JSDeprecatedCSSOMPrimitiveValueConstructorTableValues, *this);
}

template<> const ClassInfo JSDeprecatedCSSOMPrimitiveValueConstructor::s_info = { "CSSPrimitiveValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMPrimitiveValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMPrimitiveValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMPrimitiveValueConstructor) } },
    { "primitiveType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMPrimitiveValuePrimitiveType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setFloatValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetFloatValue), (intptr_t) (0) } },
    { "getFloatValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetFloatValue), (intptr_t) (0) } },
    { "setStringValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetStringValue), (intptr_t) (0) } },
    { "getStringValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetStringValue), (intptr_t) (0) } },
    { "getCounterValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetCounterValue), (intptr_t) (0) } },
    { "getRectValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRectValue), (intptr_t) (0) } },
    { "getRGBColorValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRGBColorValue), (intptr_t) (0) } },
    { "CSS_UNKNOWN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_NUMBER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_PERCENTAGE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_EMS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "CSS_EXS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "CSS_PX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "CSS_CM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "CSS_MM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "CSS_IN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "CSS_PT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
    { "CSS_PC", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "CSS_DEG", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(11) } },
    { "CSS_RAD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(12) } },
    { "CSS_GRAD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(13) } },
    { "CSS_MS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(14) } },
    { "CSS_S", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(15) } },
    { "CSS_HZ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "CSS_KHZ", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(17) } },
    { "CSS_DIMENSION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(18) } },
    { "CSS_STRING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(19) } },
    { "CSS_URI", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(20) } },
    { "CSS_IDENT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(21) } },
    { "CSS_ATTR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(22) } },
    { "CSS_COUNTER", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(23) } },
    { "CSS_RECT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(24) } },
    { "CSS_RGBCOLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(25) } },
    { "CSS_VW", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(26) } },
    { "CSS_VH", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(27) } },
    { "CSS_VMIN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(28) } },
    { "CSS_VMAX", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(29) } },
};

const ClassInfo JSDeprecatedCSSOMPrimitiveValuePrototype::s_info = { "CSSPrimitiveValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValuePrototype) };

void JSDeprecatedCSSOMPrimitiveValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMPrimitiveValue::info(), JSDeprecatedCSSOMPrimitiveValuePrototypeTableValues, *this);
}

const ClassInfo JSDeprecatedCSSOMPrimitiveValue::s_info = { "CSSPrimitiveValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMPrimitiveValue) };

JSDeprecatedCSSOMPrimitiveValue::JSDeprecatedCSSOMPrimitiveValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMPrimitiveValue>&& impl)
    : JSDeprecatedCSSOMValue(structure, globalObject, WTFMove(impl))
{
}

void JSDeprecatedCSSOMPrimitiveValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMPrimitiveValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeprecatedCSSOMPrimitiveValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMPrimitiveValuePrototype::create(vm, &globalObject, JSDeprecatedCSSOMPrimitiveValuePrototype::createStructure(vm, &globalObject, JSDeprecatedCSSOMValue::prototype(vm, globalObject)));
}

JSObject* JSDeprecatedCSSOMPrimitiveValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMPrimitiveValue>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMPrimitiveValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMPrimitiveValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDeprecatedCSSOMPrimitiveValue* IDLAttribute<JSDeprecatedCSSOMPrimitiveValue>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeprecatedCSSOMPrimitiveValue*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDeprecatedCSSOMPrimitiveValue* IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDeprecatedCSSOMPrimitiveValue*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDeprecatedCSSOMPrimitiveValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMPrimitiveValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMPrimitiveValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeprecatedCSSOMPrimitiveValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMPrimitiveValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeprecatedCSSOMPrimitiveValuePrimitiveTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMPrimitiveValue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.primitiveType());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrimitiveType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMPrimitiveValue>::get<jsDeprecatedCSSOMPrimitiveValuePrimitiveTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "primitiveType");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetFloatValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto unitType = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto floatValue = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFloatValue(WTFMove(unitType), WTFMove(floatValue)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetFloatValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetFloatValueBody>(*lexicalGlobalObject, *callFrame, "setFloatValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetFloatValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto unitType = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnrestrictedFloat>(*lexicalGlobalObject, throwScope, impl.getFloatValue(WTFMove(unitType))));
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetFloatValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetFloatValueBody>(*lexicalGlobalObject, *callFrame, "getFloatValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetStringValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto stringType = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto stringValue = callFrame->argument(1).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setStringValue(WTFMove(stringType), WTFMove(stringValue)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetStringValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionSetStringValueBody>(*lexicalGlobalObject, *callFrame, "setStringValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetStringValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.getStringValue()));
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetStringValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetStringValueBody>(*lexicalGlobalObject, *callFrame, "getStringValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetCounterValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMCounter>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getCounterValue()));
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetCounterValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetCounterValueBody>(*lexicalGlobalObject, *callFrame, "getCounterValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRectValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRectValue()));
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRectValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRectValueBody>(*lexicalGlobalObject, *callFrame, "getRectValue");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRGBColorValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMRGBColor>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRGBColorValue()));
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRGBColorValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMPrimitiveValue>::call<jsDeprecatedCSSOMPrimitiveValuePrototypeFunctionGetRGBColorValueBody>(*lexicalGlobalObject, *callFrame, "getRGBColorValue");
}

void JSDeprecatedCSSOMPrimitiveValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMPrimitiveValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
