/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMValue.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsDeprecatedCSSOMValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMValueCssText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMValueCssText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMValueCssValueType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeprecatedCSSOMValuePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMValuePrototype>(vm.heap)) JSDeprecatedCSSOMValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMValuePrototype, JSDeprecatedCSSOMValuePrototype::Base);

using JSDeprecatedCSSOMValueConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMValue>;

/* Hash table for constructor */

static const HashTableValue JSDeprecatedCSSOMValueConstructorTableValues[] =
{
    { "CSS_INHERIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_PRIMITIVE_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_VALUE_LIST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_CUSTOM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

static_assert(DeprecatedCSSOMValue::CSS_INHERIT == 0, "CSS_INHERIT in DeprecatedCSSOMValue does not match value from IDL");
static_assert(DeprecatedCSSOMValue::CSS_PRIMITIVE_VALUE == 1, "CSS_PRIMITIVE_VALUE in DeprecatedCSSOMValue does not match value from IDL");
static_assert(DeprecatedCSSOMValue::CSS_VALUE_LIST == 2, "CSS_VALUE_LIST in DeprecatedCSSOMValue does not match value from IDL");
static_assert(DeprecatedCSSOMValue::CSS_CUSTOM == 3, "CSS_CUSTOM in DeprecatedCSSOMValue does not match value from IDL");

template<> JSValue JSDeprecatedCSSOMValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDeprecatedCSSOMValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMValue::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSValue"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDeprecatedCSSOMValue::info(), JSDeprecatedCSSOMValueConstructorTableValues, *this);
}

template<> const ClassInfo JSDeprecatedCSSOMValueConstructor::s_info = { "CSSValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMValuePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMValueConstructor) } },
    { "cssText", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMValueCssText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMValueCssText) } },
    { "cssValueType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMValueCssValueType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "CSS_INHERIT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_PRIMITIVE_VALUE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_VALUE_LIST", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_CUSTOM", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSDeprecatedCSSOMValuePrototype::s_info = { "CSSValuePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValuePrototype) };

void JSDeprecatedCSSOMValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMValue::info(), JSDeprecatedCSSOMValuePrototypeTableValues, *this);
}

const ClassInfo JSDeprecatedCSSOMValue::s_info = { "CSSValue", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValue) };

JSDeprecatedCSSOMValue::JSDeprecatedCSSOMValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMValue>&& impl)
    : JSDOMWrapper<DeprecatedCSSOMValue>(structure, globalObject, WTFMove(impl))
{
}

void JSDeprecatedCSSOMValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeprecatedCSSOMValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMValuePrototype::create(vm, &globalObject, JSDeprecatedCSSOMValuePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDeprecatedCSSOMValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMValue>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDeprecatedCSSOMValue::destroy(JSC::JSCell* cell)
{
    JSDeprecatedCSSOMValue* thisObject = static_cast<JSDeprecatedCSSOMValue*>(cell);
    thisObject->JSDeprecatedCSSOMValue::~JSDeprecatedCSSOMValue();
}

template<> inline JSDeprecatedCSSOMValue* IDLAttribute<JSDeprecatedCSSOMValue>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeprecatedCSSOMValue*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsDeprecatedCSSOMValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMValue::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeprecatedCSSOMValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMValuePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeprecatedCSSOMValueCssTextGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.cssText());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMValueCssText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMValue>::get<jsDeprecatedCSSOMValueCssTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cssText");
}

static inline bool setJSDeprecatedCSSOMValueCssTextSetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValue& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCssText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDeprecatedCSSOMValueCssText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDeprecatedCSSOMValue>::set<setJSDeprecatedCSSOMValueCssTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "cssText");
}

static inline JSValue jsDeprecatedCSSOMValueCssValueTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValue& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.cssValueType());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMValueCssValueType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMValue>::get<jsDeprecatedCSSOMValueCssValueTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cssValueType");
}

void JSDeprecatedCSSOMValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSDeprecatedCSSOMValueOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDeprecatedCSSOMValue = static_cast<JSDeprecatedCSSOMValue*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDeprecatedCSSOMValue->wrapped(), jsDeprecatedCSSOMValue);
}

DeprecatedCSSOMValue* JSDeprecatedCSSOMValue::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDeprecatedCSSOMValue*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
