/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDeprecatedCSSOMValueList.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/ArrayPrototype.h>
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/PropertyNameArray.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMValueListPrototypeFunctionItem(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDeprecatedCSSOMValueListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDeprecatedCSSOMValueListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDeprecatedCSSOMValueListLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDeprecatedCSSOMValueListPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDeprecatedCSSOMValueListPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDeprecatedCSSOMValueListPrototype* ptr = new (NotNull, JSC::allocateCell<JSDeprecatedCSSOMValueListPrototype>(vm.heap)) JSDeprecatedCSSOMValueListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDeprecatedCSSOMValueListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDeprecatedCSSOMValueListPrototype, JSDeprecatedCSSOMValueListPrototype::Base);

using JSDeprecatedCSSOMValueListConstructor = JSDOMConstructorNotConstructable<JSDeprecatedCSSOMValueList>;

template<> JSValue JSDeprecatedCSSOMValueListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMValue::getConstructor(vm, &globalObject);
}

template<> void JSDeprecatedCSSOMValueListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDeprecatedCSSOMValueList::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSValueList"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDeprecatedCSSOMValueListConstructor::s_info = { "CSSValueList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValueListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDeprecatedCSSOMValueListPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMValueListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDeprecatedCSSOMValueListConstructor) } },
    { "length", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeprecatedCSSOMValueListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDeprecatedCSSOMValueListPrototypeFunctionItem), (intptr_t) (1) } },
};

const ClassInfo JSDeprecatedCSSOMValueListPrototype::s_info = { "CSSValueListPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValueListPrototype) };

void JSDeprecatedCSSOMValueListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDeprecatedCSSOMValueList::info(), JSDeprecatedCSSOMValueListPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, globalObject()->arrayPrototype()->getDirect(vm, vm.propertyNames->builtinNames().valuesPrivateName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
}

const ClassInfo JSDeprecatedCSSOMValueList::s_info = { "CSSValueList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDeprecatedCSSOMValueList) };

JSDeprecatedCSSOMValueList::JSDeprecatedCSSOMValueList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DeprecatedCSSOMValueList>&& impl)
    : JSDeprecatedCSSOMValue(structure, globalObject, WTFMove(impl))
{
}

void JSDeprecatedCSSOMValueList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DeprecatedCSSOMValueList>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDeprecatedCSSOMValueList::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDeprecatedCSSOMValueListPrototype::create(vm, &globalObject, JSDeprecatedCSSOMValueListPrototype::createStructure(vm, &globalObject, JSDeprecatedCSSOMValue::prototype(vm, globalObject)));
}

JSObject* JSDeprecatedCSSOMValueList::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDeprecatedCSSOMValueList>(vm, globalObject);
}

JSValue JSDeprecatedCSSOMValueList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeprecatedCSSOMValueListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSDeprecatedCSSOMValueList::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMValueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (auto index = parseIndex(propertyName)) {
        if (index.value() < thisObject->wrapped().length()) {
            auto value = toJS<IDLInterface<DeprecatedCSSOMValue>>(*lexicalGlobalObject, *thisObject->globalObject(), thisObject->wrapped().item(index.value()));
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSDeprecatedCSSOMValueList::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMValueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        if (index < thisObject->wrapped().length()) {
            auto value = toJS<IDLInterface<DeprecatedCSSOMValue>>(*lexicalGlobalObject, *thisObject->globalObject(), thisObject->wrapped().item(index));
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSDeprecatedCSSOMValueList::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSDeprecatedCSSOMValueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(vm, i));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

template<> inline JSDeprecatedCSSOMValueList* IDLAttribute<JSDeprecatedCSSOMValueList>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDeprecatedCSSOMValueList*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDeprecatedCSSOMValueList* IDLOperation<JSDeprecatedCSSOMValueList>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDeprecatedCSSOMValueList*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDeprecatedCSSOMValueListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMValueListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDeprecatedCSSOMValueList::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDeprecatedCSSOMValueListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDeprecatedCSSOMValueListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDeprecatedCSSOMValueListLengthGetter(JSGlobalObject& lexicalGlobalObject, JSDeprecatedCSSOMValueList& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length());
    return result;
}

EncodedJSValue jsDeprecatedCSSOMValueListLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDeprecatedCSSOMValueList>::get<jsDeprecatedCSSOMValueListLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "length");
}

static inline JSC::EncodedJSValue jsDeprecatedCSSOMValueListPrototypeFunctionItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDeprecatedCSSOMValueList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DeprecatedCSSOMValue>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.item(WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsDeprecatedCSSOMValueListPrototypeFunctionItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDeprecatedCSSOMValueList>::call<jsDeprecatedCSSOMValueListPrototypeFunctionItemBody>(*lexicalGlobalObject, *callFrame, "item");
}

void JSDeprecatedCSSOMValueList::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDeprecatedCSSOMValueList*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
