/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocument.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "DOMJITAbstractHeapRepository.h"
#include "DOMJITIDLConvert.h"
#include "DOMJITIDLType.h"
#include "DOMJITIDLTypeFilter.h"
#include "DOMWindow.h"
#include "EventNames.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSComment.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMConvertXPathNSResolver.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMImplementation.h"
#include "JSDOMOperation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSDocumentTimeline.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSFontFaceSet.h"
#include "JSHTMLAllCollection.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLHeadElement.h"
#include "JSHTMLScriptElement.h"
#include "JSImageBitmapRenderingContext.h"
#include "JSLocation.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSSVGSVGElement.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSUndoManager.h"
#include "JSVisibilityState.h"
#include "JSWebAnimation.h"
#include "JSWebGLRenderingContext.h"
#include "JSWindowProxy.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "Quirks.h"
#include "RuntimeEnabledFeatures.h"
#include "SVGDocument.h"
#include "Settings.h"
#include <JavaScriptCore/FrameTracers.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/PointerPreparations.h>
#include <wtf/Variant.h>

#if ENABLE(FULLSCREEN_API)
#include "DocumentFullscreen.h"
#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "DocumentPictureInPicture.h"
#include "JSDOMOperationReturningPromise.h"
#endif

#if ENABLE(TOUCH_EVENTS)
#include "DocumentTouch.h"
#include "JSEventTarget.h"
#include "JSTouch.h"
#include "JSTouchList.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(Document::ReadyState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("loading"),
        MAKE_STATIC_STRING_IMPL("interactive"),
        MAKE_STATIC_STRING_IMPL("complete"),
    };
    static_assert(static_cast<size_t>(Document::ReadyState::Loading) == 0, "Document::ReadyState::Loading is not 0 as expected");
    static_assert(static_cast<size_t>(Document::ReadyState::Interactive) == 1, "Document::ReadyState::Interactive is not 1 as expected");
    static_assert(static_cast<size_t>(Document::ReadyState::Complete) == 2, "Document::ReadyState::Complete is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Document::ReadyState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Document::ReadyState> parseEnumeration<Document::ReadyState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "loading")
        return Document::ReadyState::Loading;
    if (stringValue == "interactive")
        return Document::ReadyState::Interactive;
    if (stringValue == "complete")
        return Document::ReadyState::Complete;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Document::ReadyState>()
{
    return "\"loading\", \"interactive\", \"complete\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionOpen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWrite(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWriteln(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionHasFocus(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExitPointerLock(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionClear(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaptureEvents(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionReleaseEvents(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetAnimations(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExitPictureInPicture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitExitFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitCancelFullScreen(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementsFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouch(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouchList(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JIT_OPERATION jsDocumentPrototypeFunctionGetElementByIdWithoutTypeCheck(JSC::JSGlobalObject*, JSDocument*, DOMJIT::IDLJSArgumentType<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionPrepend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAppend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentImplementation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDocumentURI(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCompatMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCharacterSet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCharset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentInputEncoding(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentContentType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDoctype(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDocumentElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentDomain(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentDomain(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentReferrer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCookie(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentCookie(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentLastModified(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentTitle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentTitle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentDir(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentDir(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentBody(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentBody(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentHead(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentImages(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentEmbeds(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentPlugins(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLinks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentForms(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentScripts(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentCurrentScript(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDefaultView(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentDesignMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentDesignMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentUndoManager(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentOnreadystatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnreadystatechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentScrollingElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsDocumentOnpointerlockchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerlockchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsDocumentOnpointerlockerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerlockerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentFonts(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentHidden(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentVisibilityState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentOnvisibilitychange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnvisibilitychange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentXMLEncoding(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentXMLVersion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentXMLVersion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentXMLStandalone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentXMLStandalone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnselectstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnselectstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnselectionchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnselectionchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentFgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentFgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentLinkColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentLinkColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentVlinkColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentVlinkColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentAlinkColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentAlinkColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentBgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentBgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentAnchors(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentApplets(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentAll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentAll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentTimeline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsDocumentPictureInPictureEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsDocumentOncopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOncopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOncut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnbeforecopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnbeforecopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnbeforecut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnbeforecut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnbeforeinput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnbeforeinput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnbeforepaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnbeforepaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentWebkitFullscreenEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentWebkitFullscreenElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentWebkitIsFullScreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentWebkitFullScreenKeyboardInputAllowed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentWebkitCurrentFullScreenElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentOnwebkitfullscreenchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwebkitfullscreenchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsDocumentOnwebkitfullscreenerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwebkitfullscreenerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentActiveElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentStyleSheets(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue jsDocumentPointerLockElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsDocumentPictureInPictureElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsDocumentOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncanplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOncanplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncanplaythrough(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOncanplaythrough(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncontextmenu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOncontextmenu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOncuechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOncuechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndblclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndblclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndrag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndrag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndragend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndragenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndragleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndragover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndragstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndragstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndrop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndrop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOndurationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOndurationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnemptied(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnemptied(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOninput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOninput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOninvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOninvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnkeydown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnkeydown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnkeypress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnkeypress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnkeyup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnkeyup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnloadeddata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnloadeddata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnloadedmetadata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnloadedmetadata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmousedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmousedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmouseenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmouseleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmousemove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmousemove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmouseout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmouseover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmouseup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmouseup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnmousewheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnmousewheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnplaying(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnplaying(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnratechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnratechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnrejectionhandled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnrejectionhandled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnreset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnreset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnseeked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnseeked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnseeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnseeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnselect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnselect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnstalled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnstalled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnsubmit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnsubmit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnsuspend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnsuspend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntimeupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntimeupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntoggle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntoggle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnunhandledrejection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnunhandledrejection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnvolumechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnvolumechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnwaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntransitionrun(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntransitionrun(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntransitionstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntransitionstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOntransitioncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntransitioncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnanimationcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnanimationcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOngotpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOngotpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnlostpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnlostpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointerdown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerdown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointermove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointermove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointerup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointercancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointercancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointerover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointerout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointerenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnpointerleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnpointerleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnsearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnsearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDocumentOnwheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntouchcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntouchend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchmove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntouchmove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntouchstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDocumentOntouchforcechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOntouchforcechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDocumentOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDocumentOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDocumentChildren(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentFirstElementChild(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentLastElementChild(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentChildElementCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDocumentRootElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

static const JSC::DOMJIT::Signature DOMJITSignatureForDocumentGetElementById(jsDocumentPrototypeFunctionGetElementByIdWithoutTypeCheck, JSDocument::info(), JSC::DOMJIT::Effect::forRead(DOMJIT::AbstractHeapRepository::DOM), DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Element>>>::value, DOMJIT::IDLArgumentTypeFilter<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>::value);

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForDocumentDocumentElement {
    jsDocumentDocumentElement,
#if ENABLE(JIT)
    &compileDocumentDocumentElementAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Element>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForDocumentBody {
    jsDocumentBody,
#if ENABLE(JIT)
    &compileDocumentBodyAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<HTMLElement>>>::value
};

class JSDocumentPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDocumentPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSDocumentPrototype>(vm.heap)) JSDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDocumentPrototype, JSDocumentPrototype::Base);

using JSDocumentConstructor = JSDOMConstructor<JSDocument>;

/* Hash table */

static const struct CompactHashIndex JSDocumentTableIndex[2] = {
    { 0, -1 },
    { -1, -1 },
};


static const HashTableValue JSDocumentTableValues[] =
{
    { "location", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentLocation) } },
};

static const HashTable JSDocumentTable = { 1, 1, true, JSDocument::info(), JSDocumentTableValues, JSDocumentTableIndex };
template<> EncodedJSValue JSC_HOST_CALL JSDocumentConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDocumentConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Document");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto object = Document::create(document);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Document>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSDocumentConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSDocumentConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDocument::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Document"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDocumentConstructor::s_info = { "Document", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDocumentPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentConstructor) } },
    { "implementation", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImplementation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "URL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "documentURI", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "compatMode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCompatMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "characterSet", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharacterSet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "charset", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "inputEncoding", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentInputEncoding), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "contentType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentContentType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "doctype", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDoctype), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "documentElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute), NoIntrinsic, { (intptr_t)static_cast<const JSC::DOMJIT::GetterSetter*>(&DOMJITAttributeForDocumentDocumentElement), (intptr_t) (0) } },
    { "domain", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDomain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentDomain) } },
    { "referrer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReferrer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cookie", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCookie), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentCookie) } },
    { "lastModified", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastModified), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "title", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTitle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentTitle) } },
    { "dir", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDir), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentDir) } },
    { "body", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute), NoIntrinsic, { (intptr_t)static_cast<const JSC::DOMJIT::GetterSetter*>(&DOMJITAttributeForDocumentBody), (intptr_t) (setJSDocumentBody) } },
    { "head", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHead), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "images", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImages), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "embeds", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentEmbeds), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "plugins", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPlugins), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "links", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLinks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "forms", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentForms), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scripts", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentScripts), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentScript", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCurrentScript), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultView", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultView), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "designMode", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDesignMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentDesignMode) } },
    { "undoManager", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentUndoManager), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onreadystatechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreadystatechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnreadystatechange) } },
    { "scrollingElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentScrollingElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(POINTER_LOCK)
    { "onpointerlockchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerlockchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerlockchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_LOCK)
    { "onpointerlockerror", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerlockerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerlockerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "fonts", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFonts), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "hidden", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHidden), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "visibilityState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentVisibilityState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onvisibilitychange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnvisibilitychange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnvisibilitychange) } },
    { "xmlEncoding", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLEncoding), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "xmlVersion", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLVersion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentXMLVersion) } },
    { "xmlStandalone", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLStandalone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentXMLStandalone) } },
    { "onselectstart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnselectstart) } },
    { "onselectionchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectionchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnselectionchange) } },
    { "fgColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentFgColor) } },
    { "linkColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLinkColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentLinkColor) } },
    { "vlinkColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentVlinkColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentVlinkColor) } },
    { "alinkColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAlinkColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentAlinkColor) } },
    { "bgColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentBgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentBgColor) } },
    { "anchors", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAnchors), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "applets", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentApplets), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "all", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentAll) } },
    { "timeline", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTimeline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "pictureInPictureEnabled", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPictureInPictureEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "oncopy", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncopy) } },
    { "oncut", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncut) } },
    { "onpaste", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpaste) } },
    { "onbeforecopy", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforecopy) } },
    { "onbeforecut", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforecut) } },
    { "onbeforeinput", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforeinput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforeinput) } },
    { "onbeforepaste", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforepaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnbeforepaste) } },
#if ENABLE(FULLSCREEN_API)
    { "webkitFullscreenEnabled", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitFullscreenEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitFullscreenElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitFullscreenElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitIsFullScreen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitIsFullScreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitFullScreenKeyboardInputAllowed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitFullScreenKeyboardInputAllowed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitCurrentFullScreenElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitCurrentFullScreenElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitfullscreenchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitfullscreenchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitfullscreenerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitfullscreenerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "activeElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentActiveElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "styleSheets", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentStyleSheets), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(POINTER_LOCK)
    { "pointerLockElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPointerLockElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "pictureInPictureElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPictureInPictureElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onabort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnabort) } },
    { "onblur", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnblur) } },
    { "oncanplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncanplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncanplay) } },
    { "oncanplaythrough", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncanplaythrough), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncanplaythrough) } },
    { "onchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnchange) } },
    { "onclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnclick) } },
    { "oncontextmenu", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncontextmenu), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncontextmenu) } },
    { "oncuechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncuechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOncuechange) } },
    { "ondblclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndblclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndblclick) } },
    { "ondrag", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndrag) } },
    { "ondragend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragend) } },
    { "ondragenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragenter) } },
    { "ondragleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragleave) } },
    { "ondragover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragover) } },
    { "ondragstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndragstart) } },
    { "ondrop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndrop) } },
    { "ondurationchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndurationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOndurationchange) } },
    { "onemptied", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnemptied), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnemptied) } },
    { "onended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnended) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnerror) } },
    { "onfocus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnfocus) } },
    { "oninput", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOninput) } },
    { "oninvalid", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninvalid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOninvalid) } },
    { "onkeydown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeydown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnkeydown) } },
    { "onkeypress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeypress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnkeypress) } },
    { "onkeyup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeyup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnkeyup) } },
    { "onload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnload) } },
    { "onloadeddata", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnloadeddata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnloadeddata) } },
    { "onloadedmetadata", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnloadedmetadata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnloadedmetadata) } },
    { "onloadstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnloadstart) } },
    { "onmousedown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmousedown) } },
    { "onmouseenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseenter) } },
    { "onmouseleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseleave) } },
    { "onmousemove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousemove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmousemove) } },
    { "onmouseout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseout) } },
    { "onmouseover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseover) } },
    { "onmouseup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmouseup) } },
    { "onmousewheel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousewheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnmousewheel) } },
    { "onpause", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpause), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpause) } },
    { "onplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnplay) } },
    { "onplaying", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnplaying), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnplaying) } },
    { "onprogress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnprogress) } },
    { "onratechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnratechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnratechange) } },
    { "onrejectionhandled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnrejectionhandled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnrejectionhandled) } },
    { "onreset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnreset) } },
    { "onresize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnresize) } },
    { "onscroll", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnscroll) } },
    { "onseeked", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnseeked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnseeked) } },
    { "onseeking", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnseeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnseeking) } },
    { "onselect", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnselect) } },
    { "onstalled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnstalled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnstalled) } },
    { "onsubmit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsubmit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsubmit) } },
    { "onsuspend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsuspend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsuspend) } },
    { "ontimeupdate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntimeupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntimeupdate) } },
    { "ontoggle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntoggle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntoggle) } },
    { "onunhandledrejection", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnunhandledrejection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnunhandledrejection) } },
    { "onvolumechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnvolumechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnvolumechange) } },
    { "onwaiting", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwaiting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwaiting) } },
    { "ontransitionend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntransitionend) } },
    { "ontransitionrun", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntransitionrun), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntransitionrun) } },
    { "ontransitionstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntransitionstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntransitionstart) } },
    { "ontransitioncancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntransitioncancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntransitioncancel) } },
    { "onanimationend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnanimationend) } },
    { "onanimationiteration", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnanimationiteration) } },
    { "onanimationstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnanimationstart) } },
    { "onanimationcancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnanimationcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnanimationcancel) } },
    { "ongotpointercapture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOngotpointercapture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOngotpointercapture) } },
    { "onlostpointercapture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnlostpointercapture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnlostpointercapture) } },
    { "onpointerdown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerdown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerdown) } },
    { "onpointermove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointermove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointermove) } },
    { "onpointerup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerup) } },
    { "onpointercancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointercancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointercancel) } },
    { "onpointerover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerover) } },
    { "onpointerout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerout) } },
    { "onpointerenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerenter) } },
    { "onpointerleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpointerleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnpointerleave) } },
    { "onsearch", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnsearch) } },
    { "onwheel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwheel) } },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchcancel) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchmove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchmove) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchstart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchforcechange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchforcechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOntouchforcechange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDocumentOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "children", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentChildren), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstElementChild", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFirstElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastElementChild", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "childElementCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentChildElementCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rootElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentRootElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getElementsByTagName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagName), (intptr_t) (1) } },
    { "getElementsByTagNameNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagNameNS), (intptr_t) (2) } },
    { "getElementsByClassName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetElementsByClassName), (intptr_t) (1) } },
    { "createElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateElement), (intptr_t) (1) } },
    { "createElementNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateElementNS), (intptr_t) (2) } },
    { "createDocumentFragment", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateDocumentFragment), (intptr_t) (0) } },
    { "createTextNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateTextNode), (intptr_t) (1) } },
    { "createCDATASection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateCDATASection), (intptr_t) (1) } },
    { "createComment", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateComment), (intptr_t) (1) } },
    { "createProcessingInstruction", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateProcessingInstruction), (intptr_t) (2) } },
    { "importNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionImportNode), (intptr_t) (1) } },
    { "adoptNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionAdoptNode), (intptr_t) (1) } },
    { "createAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateAttribute), (intptr_t) (1) } },
    { "createAttributeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateAttributeNS), (intptr_t) (2) } },
    { "createEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateEvent), (intptr_t) (1) } },
    { "createRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateRange), (intptr_t) (0) } },
    { "createNodeIterator", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateNodeIterator), (intptr_t) (1) } },
    { "createTreeWalker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateTreeWalker), (intptr_t) (1) } },
    { "getElementsByName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetElementsByName), (intptr_t) (1) } },
    { "open", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionOpen), (intptr_t) (0) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionClose), (intptr_t) (0) } },
    { "write", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionWrite), (intptr_t) (0) } },
    { "writeln", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionWriteln), (intptr_t) (0) } },
    { "hasFocus", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionHasFocus), (intptr_t) (0) } },
    { "execCommand", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionExecCommand), (intptr_t) (1) } },
    { "queryCommandEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQueryCommandEnabled), (intptr_t) (1) } },
    { "queryCommandIndeterm", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQueryCommandIndeterm), (intptr_t) (1) } },
    { "queryCommandState", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQueryCommandState), (intptr_t) (1) } },
    { "queryCommandSupported", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQueryCommandSupported), (intptr_t) (1) } },
    { "queryCommandValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQueryCommandValue), (intptr_t) (1) } },
    { "getSelection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetSelection), (intptr_t) (0) } },
    { "createExpression", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateExpression), (intptr_t) (1) } },
    { "createNSResolver", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateNSResolver), (intptr_t) (1) } },
    { "evaluate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionEvaluate), (intptr_t) (2) } },
#if ENABLE(POINTER_LOCK)
    { "exitPointerLock", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionExitPointerLock), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getOverrideStyle", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetOverrideStyle), (intptr_t) (0) } },
    { "caretRangeFromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCaretRangeFromPoint), (intptr_t) (0) } },
    { "getCSSCanvasContext", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetCSSCanvasContext), (intptr_t) (4) } },
    { "clear", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionClear), (intptr_t) (0) } },
    { "captureEvents", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCaptureEvents), (intptr_t) (0) } },
    { "releaseEvents", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionReleaseEvents), (intptr_t) (0) } },
    { "getAnimations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetAnimations), (intptr_t) (0) } },
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "exitPictureInPicture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionExitPictureInPicture), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitExitFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionWebkitExitFullscreen), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitCancelFullScreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionWebkitCancelFullScreen), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "elementFromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionElementFromPoint), (intptr_t) (2) } },
    { "elementsFromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionElementsFromPoint), (intptr_t) (2) } },
#if ENABLE(TOUCH_EVENTS)
    { "createTouch", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateTouch), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "createTouchList", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionCreateTouchList), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getElementById", static_cast<unsigned>(JSC::PropertyAttribute::Function | JSC::PropertyAttribute::DOMJITFunction), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionGetElementById), (intptr_t) static_cast<const JSC::DOMJIT::Signature*>(&DOMJITSignatureForDocumentGetElementById) } },
    { "prepend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionPrepend), (intptr_t) (0) } },
    { "append", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionAppend), (intptr_t) (0) } },
    { "querySelector", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQuerySelector), (intptr_t) (1) } },
    { "querySelectorAll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDocumentPrototypeFunctionQuerySelectorAll), (intptr_t) (1) } },
};

const ClassInfo JSDocumentPrototype::s_info = { "DocumentPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDocumentPrototype) };

void JSDocumentPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDocument::info(), JSDocumentPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("getAnimations"), strlen("getAnimations"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("exitPictureInPicture"), strlen("exitPictureInPicture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitExitFullscreen"), strlen("webkitExitFullscreen"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitCancelFullScreen"), strlen("webkitCancelFullScreen"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (!RuntimeEnabledFeatures::sharedFeatures().undoManagerAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("undoManager"), strlen("undoManager"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("timeline"), strlen("timeline"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("pictureInPictureEnabled"), strlen("pictureInPictureEnabled"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitFullscreenEnabled"), strlen("webkitFullscreenEnabled"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitFullscreenElement"), strlen("webkitFullscreenElement"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitIsFullScreen"), strlen("webkitIsFullScreen"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitFullScreenKeyboardInputAllowed"), strlen("webkitFullScreenKeyboardInputAllowed"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitCurrentFullScreenElement"), strlen("webkitCurrentFullScreenElement"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onwebkitfullscreenchange"), strlen("onwebkitfullscreenchange"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onwebkitfullscreenerror"), strlen("onwebkitfullscreenerror"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("pictureInPictureElement"), strlen("pictureInPictureElement"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchcancel"), strlen("ontouchcancel"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchend"), strlen("ontouchend"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchmove"), strlen("ontouchmove"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchstart"), strlen("ontouchstart"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(TOUCH_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ontouchforcechange"), strlen("ontouchforcechange"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSObject& unscopables = *constructEmptyObject(globalObject()->vm(), globalObject()->nullPrototypeObjectStructure());
    unscopables.putDirect(vm, Identifier::fromString(vm, "prepend"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "append"), jsBoolean(true));
    putDirectWithoutTransition(vm, vm.propertyNames->unscopablesSymbol, &unscopables, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::ReadOnly);
}

const ClassInfo JSDocument::s_info = { "Document", &Base::s_info, &JSDocumentTable
#if ENABLE(JIT)
, &checkSubClassSnippetForJSDocument
#else
, nullptr
#endif
, CREATE_METHOD_TABLE(JSDocument) };

JSDocument::JSDocument(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Document>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

void JSDocument::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, Document>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDocument::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDocumentPrototype::create(vm, &globalObject, JSDocumentPrototype::createStructure(vm, &globalObject, JSNode::prototype(vm, globalObject)));
}

JSObject* JSDocument::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDocument>(vm, globalObject);
}

JSValue JSDocument::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDocument* IDLAttribute<JSDocument>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDocument*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDocument* IDLOperation<JSDocument>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDocument*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDocumentConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDocumentPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDocument::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDocumentConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDocumentPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDocumentImplementationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMImplementation>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.implementation());
    return result;
}

EncodedJSValue jsDocumentImplementation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentImplementationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "implementation");
}

static inline JSValue jsDocumentURLGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.urlForBindings());
    return result;
}

EncodedJSValue jsDocumentURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "URL");
}

static inline JSValue jsDocumentDocumentURIGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.urlForBindings());
    return result;
}

EncodedJSValue jsDocumentDocumentURI(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDocumentURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "documentURI");
}

static inline JSValue jsDocumentCompatModeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.compatMode());
    return result;
}

EncodedJSValue jsDocumentCompatMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentCompatModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "compatMode");
}

static inline JSValue jsDocumentCharacterSetGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.characterSetWithUTF8Fallback());
    return result;
}

EncodedJSValue jsDocumentCharacterSet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentCharacterSetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "characterSet");
}

static inline JSValue jsDocumentCharsetGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.characterSetWithUTF8Fallback());
    return result;
}

EncodedJSValue jsDocumentCharset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentCharsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "charset");
}

static inline JSValue jsDocumentInputEncodingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.characterSetWithUTF8Fallback());
    return result;
}

EncodedJSValue jsDocumentInputEncoding(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentInputEncodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "inputEncoding");
}

static inline JSValue jsDocumentContentTypeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.contentType());
    return result;
}

EncodedJSValue jsDocumentContentType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentContentTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "contentType");
}

static inline JSValue jsDocumentDoctypeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<DocumentType>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.doctype());
    return result;
}

EncodedJSValue jsDocumentDoctype(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDoctypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "doctype");
}

static inline JSValue jsDocumentDocumentElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.documentElement());
    return result;
}

EncodedJSValue jsDocumentDocumentElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDocumentElementGetter>(*lexicalGlobalObject, thisValue, "documentElement");
}

static inline JSValue jsDocumentLocationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Location>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.location());
    return result;
}

EncodedJSValue jsDocumentLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentLocationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "location");
}

static inline bool setJSDocumentLocationSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("location"), strlen("location"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("href"), strlen("href"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSDocumentLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentLocationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "location");
}

static inline JSValue jsDocumentDomainGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.domain());
    return result;
}

EncodedJSValue jsDocumentDomain(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDomainGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "domain");
}

static inline bool setJSDocumentDomainSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDomain(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentDomain(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentDomainSetter>(*lexicalGlobalObject, thisValue, encodedValue, "domain");
}

static inline JSValue jsDocumentReferrerGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.referrer());
    return result;
}

EncodedJSValue jsDocumentReferrer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentReferrerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referrer");
}

static inline JSValue jsDocumentCookieGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.cookie());
    return result;
}

EncodedJSValue jsDocumentCookie(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentCookieGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cookie");
}

static inline bool setJSDocumentCookieSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCookie(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentCookie(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentCookieSetter>(*lexicalGlobalObject, thisValue, encodedValue, "cookie");
}

static inline JSValue jsDocumentLastModifiedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lastModified());
    return result;
}

EncodedJSValue jsDocumentLastModified(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentLastModifiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lastModified");
}

static inline JSValue jsDocumentReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<Document::ReadyState>>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsDocumentReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsDocumentTitleGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.title());
    return result;
}

EncodedJSValue jsDocumentTitle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentTitleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "title");
}

static inline bool setJSDocumentTitleSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTitle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentTitle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentTitleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "title");
}

static inline JSValue jsDocumentDirGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.dir());
    return result;
}

EncodedJSValue jsDocumentDir(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDirGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dir");
}

static inline bool setJSDocumentDirSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDir(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentDir(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentDirSetter>(*lexicalGlobalObject, thisValue, encodedValue, "dir");
}

static inline JSValue jsDocumentBodyGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<HTMLElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.bodyOrFrameset());
    return result;
}

EncodedJSValue jsDocumentBody(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentBodyGetter>(*lexicalGlobalObject, thisValue, "body");
}

static inline bool setJSDocumentBodySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<HTMLElement>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "Document", "body", "HTMLElement"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBodyOrFrameset(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentBody(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentBodySetter>(*lexicalGlobalObject, thisValue, encodedValue, "body");
}

static inline JSValue jsDocumentHeadGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<HTMLHeadElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.head());
    return result;
}

EncodedJSValue jsDocumentHead(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentHeadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "head");
}

static inline JSValue jsDocumentImagesGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.images());
    return result;
}

EncodedJSValue jsDocumentImages(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentImagesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "images");
}

static inline JSValue jsDocumentEmbedsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.embeds());
    return result;
}

EncodedJSValue jsDocumentEmbeds(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentEmbedsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "embeds");
}

static inline JSValue jsDocumentPluginsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.plugins());
    return result;
}

EncodedJSValue jsDocumentPlugins(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentPluginsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "plugins");
}

static inline JSValue jsDocumentLinksGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.links());
    return result;
}

EncodedJSValue jsDocumentLinks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentLinksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "links");
}

static inline JSValue jsDocumentFormsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.forms());
    return result;
}

EncodedJSValue jsDocumentForms(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentFormsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "forms");
}

static inline JSValue jsDocumentScriptsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.scripts());
    return result;
}

EncodedJSValue jsDocumentScripts(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentScriptsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scripts");
}

static inline JSValue jsDocumentCurrentScriptGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<HTMLScriptElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentScript());
    return result;
}

EncodedJSValue jsDocumentCurrentScript(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentCurrentScriptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentScript");
}

static inline JSValue jsDocumentDefaultViewGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.windowProxy());
    return result;
}

EncodedJSValue jsDocumentDefaultView(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDefaultViewGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "defaultView");
}

static inline JSValue jsDocumentDesignModeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.designMode());
    return result;
}

EncodedJSValue jsDocumentDesignMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentDesignModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "designMode");
}

static inline bool setJSDocumentDesignModeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDesignMode(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentDesignMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentDesignModeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "designMode");
}

static inline JSValue jsDocumentUndoManagerGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<UndoManager>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.undoManager());
    return result;
}

EncodedJSValue jsDocumentUndoManager(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentUndoManagerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "undoManager");
}

static inline JSValue jsDocumentOnreadystatechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().readystatechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnreadystatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnreadystatechangeGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onreadystatechange");
}

static inline bool setJSDocumentOnreadystatechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().readystatechangeEvent, value);
    return true;
}

bool setJSDocumentOnreadystatechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnreadystatechangeSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onreadystatechange");
}

static inline JSValue jsDocumentScrollingElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.scrollingElementForAPI());
    return result;
}

EncodedJSValue jsDocumentScrollingElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentScrollingElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollingElement");
}

#if ENABLE(POINTER_LOCK)
static inline JSValue jsDocumentOnpointerlockchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerlockchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerlockchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointerlockchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerlockchange");
}

#endif

#if ENABLE(POINTER_LOCK)
static inline bool setJSDocumentOnpointerlockchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerlockchangeEvent, value);
    return true;
}

bool setJSDocumentOnpointerlockchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointerlockchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerlockchange");
}

#endif

#if ENABLE(POINTER_LOCK)
static inline JSValue jsDocumentOnpointerlockerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerlockerrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerlockerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointerlockerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerlockerror");
}

#endif

#if ENABLE(POINTER_LOCK)
static inline bool setJSDocumentOnpointerlockerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerlockerrorEvent, value);
    return true;
}

bool setJSDocumentOnpointerlockerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointerlockerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerlockerror");
}

#endif

static inline JSValue jsDocumentFontsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<FontFaceSet>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fonts());
    return result;
}

EncodedJSValue jsDocumentFonts(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentFontsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fonts");
}

static inline JSValue jsDocumentHiddenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hidden());
    return result;
}

EncodedJSValue jsDocumentHidden(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentHiddenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hidden");
}

static inline JSValue jsDocumentVisibilityStateGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<VisibilityState>>(lexicalGlobalObject, throwScope, impl.visibilityState());
    return result;
}

EncodedJSValue jsDocumentVisibilityState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentVisibilityStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "visibilityState");
}

static inline JSValue jsDocumentOnvisibilitychangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().visibilitychangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnvisibilitychange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnvisibilitychangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onvisibilitychange");
}

static inline bool setJSDocumentOnvisibilitychangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().visibilitychangeEvent, value);
    return true;
}

bool setJSDocumentOnvisibilitychange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnvisibilitychangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onvisibilitychange");
}

static inline JSValue jsDocumentXMLEncodingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.xmlEncoding());
    return result;
}

EncodedJSValue jsDocumentXMLEncoding(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentXMLEncodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "xmlEncoding");
}

static inline JSValue jsDocumentXMLVersionGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.xmlVersion());
    return result;
}

EncodedJSValue jsDocumentXMLVersion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentXMLVersionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "xmlVersion");
}

static inline bool setJSDocumentXMLVersionSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setXMLVersion(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentXMLVersion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentXMLVersionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "xmlVersion");
}

static inline JSValue jsDocumentXMLStandaloneGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.xmlStandalone());
    return result;
}

EncodedJSValue jsDocumentXMLStandalone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentXMLStandaloneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "xmlStandalone");
}

static inline bool setJSDocumentXMLStandaloneSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setXMLStandalone(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentXMLStandalone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentXMLStandaloneSetter>(*lexicalGlobalObject, thisValue, encodedValue, "xmlStandalone");
}

static inline JSValue jsDocumentOnselectstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnselectstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnselectstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onselectstart");
}

static inline bool setJSDocumentOnselectstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectstartEvent, value);
    return true;
}

bool setJSDocumentOnselectstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnselectstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselectstart");
}

static inline JSValue jsDocumentOnselectionchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectionchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnselectionchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnselectionchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onselectionchange");
}

static inline bool setJSDocumentOnselectionchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectionchangeEvent, value);
    return true;
}

bool setJSDocumentOnselectionchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnselectionchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselectionchange");
}

static inline JSValue jsDocumentFgColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.fgColor());
    return result;
}

EncodedJSValue jsDocumentFgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentFgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fgColor");
}

static inline bool setJSDocumentFgColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFgColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentFgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentFgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "fgColor");
}

static inline JSValue jsDocumentLinkColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.linkColorForBindings());
    return result;
}

EncodedJSValue jsDocumentLinkColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentLinkColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "linkColor");
}

static inline bool setJSDocumentLinkColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLinkColorForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentLinkColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentLinkColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "linkColor");
}

static inline JSValue jsDocumentVlinkColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.vlinkColor());
    return result;
}

EncodedJSValue jsDocumentVlinkColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentVlinkColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "vlinkColor");
}

static inline bool setJSDocumentVlinkColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setVlinkColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentVlinkColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentVlinkColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "vlinkColor");
}

static inline JSValue jsDocumentAlinkColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.alinkColor());
    return result;
}

EncodedJSValue jsDocumentAlinkColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentAlinkColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "alinkColor");
}

static inline bool setJSDocumentAlinkColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlinkColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentAlinkColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentAlinkColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "alinkColor");
}

static inline JSValue jsDocumentBgColorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.bgColor());
    return result;
}

EncodedJSValue jsDocumentBgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentBgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bgColor");
}

static inline bool setJSDocumentBgColorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBgColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDocumentBgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentBgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "bgColor");
}

static inline JSValue jsDocumentAnchorsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.anchors());
    return result;
}

EncodedJSValue jsDocumentAnchors(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentAnchorsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "anchors");
}

static inline JSValue jsDocumentAppletsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.applets());
    return result;
}

EncodedJSValue jsDocumentApplets(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentAppletsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "applets");
}

static inline JSValue jsDocumentAllGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLAllCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.all());
    return result;
}

EncodedJSValue jsDocumentAll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentAllGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "all");
}

static inline bool setJSDocumentAllSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    // Shadowing a built-in property.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("all"), strlen("all")), value);
}

bool setJSDocumentAll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentAllSetter>(*lexicalGlobalObject, thisValue, encodedValue, "all");
}

static inline JSValue jsDocumentTimelineGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DocumentTimeline>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.timeline());
    return result;
}

EncodedJSValue jsDocumentTimeline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentTimelineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "timeline");
}

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsDocumentPictureInPictureEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentPictureInPicture::pictureInPictureEnabled(impl));
    return result;
}

EncodedJSValue jsDocumentPictureInPictureEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentPictureInPictureEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pictureInPictureEnabled");
}

#endif

static inline JSValue jsDocumentOncopyGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().copyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOncopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOncopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncopy");
}

static inline bool setJSDocumentOncopySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().copyEvent, value);
    return true;
}

bool setJSDocumentOncopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOncopySetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncopy");
}

static inline JSValue jsDocumentOncutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOncut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOncutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncut");
}

static inline bool setJSDocumentOncutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cutEvent, value);
    return true;
}

bool setJSDocumentOncut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOncutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncut");
}

static inline JSValue jsDocumentOnpasteGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pasteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpaste");
}

static inline bool setJSDocumentOnpasteSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pasteEvent, value);
    return true;
}

bool setJSDocumentOnpaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpaste");
}

static inline JSValue jsDocumentOnbeforecopyGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforecopyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnbeforecopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnbeforecopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforecopy");
}

static inline bool setJSDocumentOnbeforecopySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforecopyEvent, value);
    return true;
}

bool setJSDocumentOnbeforecopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnbeforecopySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforecopy");
}

static inline JSValue jsDocumentOnbeforecutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforecutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnbeforecut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnbeforecutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforecut");
}

static inline bool setJSDocumentOnbeforecutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforecutEvent, value);
    return true;
}

bool setJSDocumentOnbeforecut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnbeforecutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforecut");
}

static inline JSValue jsDocumentOnbeforeinputGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforeinputEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnbeforeinput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnbeforeinputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeinput");
}

static inline bool setJSDocumentOnbeforeinputSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeinputEvent, value);
    return true;
}

bool setJSDocumentOnbeforeinput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnbeforeinputSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeinput");
}

static inline JSValue jsDocumentOnbeforepasteGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforepasteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnbeforepaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnbeforepasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforepaste");
}

static inline bool setJSDocumentOnbeforepasteSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforepasteEvent, value);
    return true;
}

bool setJSDocumentOnbeforepaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnbeforepasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforepaste");
}

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentWebkitFullscreenEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitFullscreenEnabled(impl));
    return result;
}

EncodedJSValue jsDocumentWebkitFullscreenEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentWebkitFullscreenEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitFullscreenEnabled");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentWebkitFullscreenElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentFullscreen::webkitFullscreenElement(impl));
    return result;
}

EncodedJSValue jsDocumentWebkitFullscreenElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentWebkitFullscreenElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitFullscreenElement");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentWebkitIsFullScreenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitIsFullScreen(impl));
    return result;
}

EncodedJSValue jsDocumentWebkitIsFullScreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentWebkitIsFullScreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitIsFullScreen");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentWebkitFullScreenKeyboardInputAllowedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, WebCore::DocumentFullscreen::webkitFullScreenKeyboardInputAllowed(impl));
    return result;
}

EncodedJSValue jsDocumentWebkitFullScreenKeyboardInputAllowed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentWebkitFullScreenKeyboardInputAllowedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitFullScreenKeyboardInputAllowed");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentWebkitCurrentFullScreenElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DocumentFullscreen::webkitCurrentFullScreenElement(impl));
    return result;
}

EncodedJSValue jsDocumentWebkitCurrentFullScreenElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentWebkitCurrentFullScreenElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitCurrentFullScreenElement");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentOnwebkitfullscreenchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitfullscreenchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwebkitfullscreenchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwebkitfullscreenchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitfullscreenchange");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocumentOnwebkitfullscreenchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitfullscreenchangeEvent, value);
    return true;
}

bool setJSDocumentOnwebkitfullscreenchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwebkitfullscreenchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitfullscreenchange");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsDocumentOnwebkitfullscreenerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitfullscreenerrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwebkitfullscreenerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwebkitfullscreenerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitfullscreenerror");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSDocumentOnwebkitfullscreenerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitfullscreenerrorEvent, value);
    return true;
}

bool setJSDocumentOnwebkitfullscreenerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwebkitfullscreenerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitfullscreenerror");
}

#endif

static inline JSValue jsDocumentActiveElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeElement());
    return result;
}

EncodedJSValue jsDocumentActiveElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentActiveElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "activeElement");
}

static inline JSValue jsDocumentStyleSheetsGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StyleSheetList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.styleSheets());
    return result;
}

EncodedJSValue jsDocumentStyleSheets(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentStyleSheetsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "styleSheets");
}

#if ENABLE(POINTER_LOCK)
static inline JSValue jsDocumentPointerLockElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pointerLockElement());
    return result;
}

EncodedJSValue jsDocumentPointerLockElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentPointerLockElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pointerLockElement");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsDocumentPictureInPictureElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.pictureInPictureElement());
    return result;
}

EncodedJSValue jsDocumentPictureInPictureElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentPictureInPictureElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pictureInPictureElement");
}

#endif

static inline JSValue jsDocumentOnabortGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnabortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onabort");
}

static inline bool setJSDocumentOnabortSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().abortEvent, value);
    return true;
}

bool setJSDocumentOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onabort");
}

static inline JSValue jsDocumentOnblurGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnblurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onblur");
}

static inline bool setJSDocumentOnblurSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().blurEvent, value);
    return true;
}

bool setJSDocumentOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onblur");
}

static inline JSValue jsDocumentOncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOncanplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOncanplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncanplay");
}

static inline bool setJSDocumentOncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().canplayEvent, value);
    return true;
}

bool setJSDocumentOncanplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncanplay");
}

static inline JSValue jsDocumentOncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOncanplaythrough(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOncanplaythroughGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncanplaythrough");
}

static inline bool setJSDocumentOncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().canplaythroughEvent, value);
    return true;
}

bool setJSDocumentOncanplaythrough(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncanplaythrough");
}

static inline JSValue jsDocumentOnchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onchange");
}

static inline bool setJSDocumentOnchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().changeEvent, value);
    return true;
}

bool setJSDocumentOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onchange");
}

static inline JSValue jsDocumentOnclickGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onclick");
}

static inline bool setJSDocumentOnclickSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().clickEvent, value);
    return true;
}

bool setJSDocumentOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onclick");
}

static inline JSValue jsDocumentOncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOncontextmenu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOncontextmenuGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncontextmenu");
}

static inline bool setJSDocumentOncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().contextmenuEvent, value);
    return true;
}

bool setJSDocumentOncontextmenu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncontextmenu");
}

static inline JSValue jsDocumentOncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOncuechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOncuechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncuechange");
}

static inline bool setJSDocumentOncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cuechangeEvent, value);
    return true;
}

bool setJSDocumentOncuechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncuechange");
}

static inline JSValue jsDocumentOndblclickGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndblclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndblclickGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondblclick");
}

static inline bool setJSDocumentOndblclickSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dblclickEvent, value);
    return true;
}

bool setJSDocumentOndblclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondblclick");
}

static inline JSValue jsDocumentOndragGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndrag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndragGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondrag");
}

static inline bool setJSDocumentOndragSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragEvent, value);
    return true;
}

bool setJSDocumentOndrag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndragSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondrag");
}

static inline JSValue jsDocumentOndragendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndragend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndragendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragend");
}

static inline bool setJSDocumentOndragendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragendEvent, value);
    return true;
}

bool setJSDocumentOndragend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragend");
}

static inline JSValue jsDocumentOndragenterGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndragenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndragenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragenter");
}

static inline bool setJSDocumentOndragenterSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragenterEvent, value);
    return true;
}

bool setJSDocumentOndragenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragenter");
}

static inline JSValue jsDocumentOndragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndragleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndragleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragleave");
}

static inline bool setJSDocumentOndragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragleaveEvent, value);
    return true;
}

bool setJSDocumentOndragleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragleave");
}

static inline JSValue jsDocumentOndragoverGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndragover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndragoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragover");
}

static inline bool setJSDocumentOndragoverSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragoverEvent, value);
    return true;
}

bool setJSDocumentOndragover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragover");
}

static inline JSValue jsDocumentOndragstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndragstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndragstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondragstart");
}

static inline bool setJSDocumentOndragstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragstartEvent, value);
    return true;
}

bool setJSDocumentOndragstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragstart");
}

static inline JSValue jsDocumentOndropGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndrop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndropGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondrop");
}

static inline bool setJSDocumentOndropSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dropEvent, value);
    return true;
}

bool setJSDocumentOndrop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndropSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondrop");
}

static inline JSValue jsDocumentOndurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOndurationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOndurationchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondurationchange");
}

static inline bool setJSDocumentOndurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().durationchangeEvent, value);
    return true;
}

bool setJSDocumentOndurationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOndurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondurationchange");
}

static inline JSValue jsDocumentOnemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnemptied(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnemptiedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onemptied");
}

static inline bool setJSDocumentOnemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().emptiedEvent, value);
    return true;
}

bool setJSDocumentOnemptied(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onemptied");
}

static inline JSValue jsDocumentOnendedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onended");
}

static inline bool setJSDocumentOnendedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endedEvent, value);
    return true;
}

bool setJSDocumentOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onended");
}

static inline JSValue jsDocumentOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSDocumentOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSDocumentOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsDocumentOnfocusGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnfocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocus");
}

static inline bool setJSDocumentOnfocusSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusEvent, value);
    return true;
}

bool setJSDocumentOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocus");
}

static inline JSValue jsDocumentOninputGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOninput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOninputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oninput");
}

static inline bool setJSDocumentOninputSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().inputEvent, value);
    return true;
}

bool setJSDocumentOninput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninput");
}

static inline JSValue jsDocumentOninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOninvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOninvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oninvalid");
}

static inline bool setJSDocumentOninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().invalidEvent, value);
    return true;
}

bool setJSDocumentOninvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninvalid");
}

static inline JSValue jsDocumentOnkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnkeydown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnkeydownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onkeydown");
}

static inline bool setJSDocumentOnkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keydownEvent, value);
    return true;
}

bool setJSDocumentOnkeydown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeydown");
}

static inline JSValue jsDocumentOnkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnkeypress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnkeypressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onkeypress");
}

static inline bool setJSDocumentOnkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keypressEvent, value);
    return true;
}

bool setJSDocumentOnkeypress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeypress");
}

static inline JSValue jsDocumentOnkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnkeyup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnkeyupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onkeyup");
}

static inline bool setJSDocumentOnkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keyupEvent, value);
    return true;
}

bool setJSDocumentOnkeyup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeyup");
}

static inline JSValue jsDocumentOnloadGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onload");
}

static inline bool setJSDocumentOnloadSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadEvent, value);
    return true;
}

bool setJSDocumentOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onload");
}

static inline JSValue jsDocumentOnloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnloadeddata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnloadeddataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadeddata");
}

static inline bool setJSDocumentOnloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadeddataEvent, value);
    return true;
}

bool setJSDocumentOnloadeddata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadeddata");
}

static inline JSValue jsDocumentOnloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnloadedmetadata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnloadedmetadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadedmetadata");
}

static inline bool setJSDocumentOnloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadedmetadataEvent, value);
    return true;
}

bool setJSDocumentOnloadedmetadata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadedmetadata");
}

static inline JSValue jsDocumentOnloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnloadstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadstart");
}

static inline bool setJSDocumentOnloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadstartEvent, value);
    return true;
}

bool setJSDocumentOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadstart");
}

static inline JSValue jsDocumentOnmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmousedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmousedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmousedown");
}

static inline bool setJSDocumentOnmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousedownEvent, value);
    return true;
}

bool setJSDocumentOnmousedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousedown");
}

static inline JSValue jsDocumentOnmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmouseenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onmouseenter");
}

static inline bool setJSDocumentOnmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseenterEvent, value);
    return true;
}

bool setJSDocumentOnmouseenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseenter");
}

static inline JSValue jsDocumentOnmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmouseleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onmouseleave");
}

static inline bool setJSDocumentOnmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseleaveEvent, value);
    return true;
}

bool setJSDocumentOnmouseleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseleave");
}

static inline JSValue jsDocumentOnmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmousemove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmousemoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmousemove");
}

static inline bool setJSDocumentOnmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousemoveEvent, value);
    return true;
}

bool setJSDocumentOnmousemove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousemove");
}

static inline JSValue jsDocumentOnmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmouseout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmouseoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmouseout");
}

static inline bool setJSDocumentOnmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseoutEvent, value);
    return true;
}

bool setJSDocumentOnmouseout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseout");
}

static inline JSValue jsDocumentOnmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmouseover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmouseoverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmouseover");
}

static inline bool setJSDocumentOnmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseoverEvent, value);
    return true;
}

bool setJSDocumentOnmouseover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseover");
}

static inline JSValue jsDocumentOnmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmouseup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmouseupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmouseup");
}

static inline bool setJSDocumentOnmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseupEvent, value);
    return true;
}

bool setJSDocumentOnmouseup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseup");
}

static inline JSValue jsDocumentOnmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnmousewheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnmousewheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmousewheel");
}

static inline bool setJSDocumentOnmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousewheelEvent, value);
    return true;
}

bool setJSDocumentOnmousewheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousewheel");
}

static inline JSValue jsDocumentOnpauseGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpause");
}

static inline bool setJSDocumentOnpauseSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pauseEvent, value);
    return true;
}

bool setJSDocumentOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpause");
}

static inline JSValue jsDocumentOnplayGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onplay");
}

static inline bool setJSDocumentOnplaySetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().playEvent, value);
    return true;
}

bool setJSDocumentOnplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onplay");
}

static inline JSValue jsDocumentOnplayingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnplaying(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnplayingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onplaying");
}

static inline bool setJSDocumentOnplayingSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().playingEvent, value);
    return true;
}

bool setJSDocumentOnplaying(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onplaying");
}

static inline JSValue jsDocumentOnprogressGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnprogressGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onprogress");
}

static inline bool setJSDocumentOnprogressSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().progressEvent, value);
    return true;
}

bool setJSDocumentOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onprogress");
}

static inline JSValue jsDocumentOnratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnratechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnratechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onratechange");
}

static inline bool setJSDocumentOnratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().ratechangeEvent, value);
    return true;
}

bool setJSDocumentOnratechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onratechange");
}

static inline JSValue jsDocumentOnrejectionhandledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().rejectionhandledEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnrejectionhandled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnrejectionhandledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onrejectionhandled");
}

static inline bool setJSDocumentOnrejectionhandledSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().rejectionhandledEvent, value);
    return true;
}

bool setJSDocumentOnrejectionhandled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnrejectionhandledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onrejectionhandled");
}

static inline JSValue jsDocumentOnresetGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnreset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnresetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onreset");
}

static inline bool setJSDocumentOnresetSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resetEvent, value);
    return true;
}

bool setJSDocumentOnreset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onreset");
}

static inline JSValue jsDocumentOnresizeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnresizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onresize");
}

static inline bool setJSDocumentOnresizeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resizeEvent, value);
    return true;
}

bool setJSDocumentOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresize");
}

static inline JSValue jsDocumentOnscrollGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnscrollGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onscroll");
}

static inline bool setJSDocumentOnscrollSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().scrollEvent, value);
    return true;
}

bool setJSDocumentOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onscroll");
}

static inline JSValue jsDocumentOnseekedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnseeked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnseekedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onseeked");
}

static inline bool setJSDocumentOnseekedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().seekedEvent, value);
    return true;
}

bool setJSDocumentOnseeked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onseeked");
}

static inline JSValue jsDocumentOnseekingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnseeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnseekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onseeking");
}

static inline bool setJSDocumentOnseekingSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().seekingEvent, value);
    return true;
}

bool setJSDocumentOnseeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onseeking");
}

static inline JSValue jsDocumentOnselectGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnselect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnselectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onselect");
}

static inline bool setJSDocumentOnselectSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectEvent, value);
    return true;
}

bool setJSDocumentOnselect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselect");
}

static inline JSValue jsDocumentOnstalledGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnstalled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnstalledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onstalled");
}

static inline bool setJSDocumentOnstalledSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().stalledEvent, value);
    return true;
}

bool setJSDocumentOnstalled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstalled");
}

static inline JSValue jsDocumentOnsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnsubmit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnsubmitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsubmit");
}

static inline bool setJSDocumentOnsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().submitEvent, value);
    return true;
}

bool setJSDocumentOnsubmit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsubmit");
}

static inline JSValue jsDocumentOnsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnsuspend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnsuspendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsuspend");
}

static inline bool setJSDocumentOnsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().suspendEvent, value);
    return true;
}

bool setJSDocumentOnsuspend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsuspend");
}

static inline JSValue jsDocumentOntimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntimeupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntimeupdateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontimeupdate");
}

static inline bool setJSDocumentOntimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().timeupdateEvent, value);
    return true;
}

bool setJSDocumentOntimeupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontimeupdate");
}

static inline JSValue jsDocumentOntoggleGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntoggle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntoggleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontoggle");
}

static inline bool setJSDocumentOntoggleSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().toggleEvent, value);
    return true;
}

bool setJSDocumentOntoggle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontoggle");
}

static inline JSValue jsDocumentOnunhandledrejectionGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().unhandledrejectionEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnunhandledrejection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnunhandledrejectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onunhandledrejection");
}

static inline bool setJSDocumentOnunhandledrejectionSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unhandledrejectionEvent, value);
    return true;
}

bool setJSDocumentOnunhandledrejection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnunhandledrejectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunhandledrejection");
}

static inline JSValue jsDocumentOnvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnvolumechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnvolumechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onvolumechange");
}

static inline bool setJSDocumentOnvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().volumechangeEvent, value);
    return true;
}

bool setJSDocumentOnvolumechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onvolumechange");
}

static inline JSValue jsDocumentOnwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwaitingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwaiting");
}

static inline bool setJSDocumentOnwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().waitingEvent, value);
    return true;
}

bool setJSDocumentOnwaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwaiting");
}

static inline JSValue jsDocumentOntransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitionend");
}

static inline bool setJSDocumentOntransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionendEvent, value);
    return true;
}

bool setJSDocumentOntransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionend");
}

static inline JSValue jsDocumentOntransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntransitionrun(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntransitionrunGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitionrun");
}

static inline bool setJSDocumentOntransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionrunEvent, value);
    return true;
}

bool setJSDocumentOntransitionrun(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionrun");
}

static inline JSValue jsDocumentOntransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntransitionstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntransitionstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitionstart");
}

static inline bool setJSDocumentOntransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionstartEvent, value);
    return true;
}

bool setJSDocumentOntransitionstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionstart");
}

static inline JSValue jsDocumentOntransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntransitioncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntransitioncancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontransitioncancel");
}

static inline bool setJSDocumentOntransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitioncancelEvent, value);
    return true;
}

bool setJSDocumentOntransitioncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitioncancel");
}

static inline JSValue jsDocumentOnanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationend");
}

static inline bool setJSDocumentOnanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationendEvent, value);
    return true;
}

bool setJSDocumentOnanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationend");
}

static inline JSValue jsDocumentOnanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationiteration");
}

static inline bool setJSDocumentOnanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationiterationEvent, value);
    return true;
}

bool setJSDocumentOnanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationiteration");
}

static inline JSValue jsDocumentOnanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationstart");
}

static inline bool setJSDocumentOnanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationstartEvent, value);
    return true;
}

bool setJSDocumentOnanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationstart");
}

static inline JSValue jsDocumentOnanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnanimationcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnanimationcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onanimationcancel");
}

static inline bool setJSDocumentOnanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationcancelEvent, value);
    return true;
}

bool setJSDocumentOnanimationcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationcancel");
}

static inline JSValue jsDocumentOngotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOngotpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOngotpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ongotpointercapture");
}

static inline bool setJSDocumentOngotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gotpointercaptureEvent, value);
    return true;
}

bool setJSDocumentOngotpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOngotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongotpointercapture");
}

static inline JSValue jsDocumentOnlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnlostpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnlostpointercaptureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onlostpointercapture");
}

static inline bool setJSDocumentOnlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().lostpointercaptureEvent, value);
    return true;
}

bool setJSDocumentOnlostpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onlostpointercapture");
}

static inline JSValue jsDocumentOnpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerdown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointerdownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerdown");
}

static inline bool setJSDocumentOnpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerdownEvent, value);
    return true;
}

bool setJSDocumentOnpointerdown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerdown");
}

static inline JSValue jsDocumentOnpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointermove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointermoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointermove");
}

static inline bool setJSDocumentOnpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointermoveEvent, value);
    return true;
}

bool setJSDocumentOnpointermove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointermove");
}

static inline JSValue jsDocumentOnpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointerupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerup");
}

static inline bool setJSDocumentOnpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerupEvent, value);
    return true;
}

bool setJSDocumentOnpointerup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerup");
}

static inline JSValue jsDocumentOnpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointercancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointercancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointercancel");
}

static inline bool setJSDocumentOnpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointercancelEvent, value);
    return true;
}

bool setJSDocumentOnpointercancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointercancel");
}

static inline JSValue jsDocumentOnpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointeroverGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerover");
}

static inline bool setJSDocumentOnpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointeroverEvent, value);
    return true;
}

bool setJSDocumentOnpointerover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerover");
}

static inline JSValue jsDocumentOnpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointeroutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerout");
}

static inline bool setJSDocumentOnpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointeroutEvent, value);
    return true;
}

bool setJSDocumentOnpointerout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerout");
}

static inline JSValue jsDocumentOnpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointerenterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerenter");
}

static inline bool setJSDocumentOnpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerenterEvent, value);
    return true;
}

bool setJSDocumentOnpointerenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerenter");
}

static inline JSValue jsDocumentOnpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnpointerleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnpointerleaveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpointerleave");
}

static inline bool setJSDocumentOnpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerleaveEvent, value);
    return true;
}

bool setJSDocumentOnpointerleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerleave");
}

static inline JSValue jsDocumentOnsearchGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().searchEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnsearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnsearchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsearch");
}

static inline bool setJSDocumentOnsearchSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().searchEvent, value);
    return true;
}

bool setJSDocumentOnsearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnsearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsearch");
}

static inline JSValue jsDocumentOnwheelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwheelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwheel");
}

static inline bool setJSDocumentOnwheelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().wheelEvent, value);
    return true;
}

bool setJSDocumentOnwheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwheel");
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocumentOntouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntouchcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntouchcancelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchcancel");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocumentOntouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchcancelEvent, value);
    return true;
}

bool setJSDocumentOntouchcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchcancel");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocumentOntouchendGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntouchend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntouchendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchend");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocumentOntouchendSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchendEvent, value);
    return true;
}

bool setJSDocumentOntouchend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchend");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocumentOntouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntouchmove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntouchmoveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchmove");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocumentOntouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchmoveEvent, value);
    return true;
}

bool setJSDocumentOntouchmove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchmove");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocumentOntouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntouchstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntouchstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchstart");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocumentOntouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchstartEvent, value);
    return true;
}

bool setJSDocumentOntouchstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchstart");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDocumentOntouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOntouchforcechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOntouchforcechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ontouchforcechange");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDocumentOntouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchforcechangeEvent, value);
    return true;
}

bool setJSDocumentOntouchforcechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOntouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchforcechange");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDocumentOnwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwebkitmouseforcechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDocumentOnwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, value);
    return true;
}

bool setJSDocumentOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDocumentOnwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwebkitmouseforcedownGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDocumentOnwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, value);
    return true;
}

bool setJSDocumentOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDocumentOnwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwebkitmouseforcewillbeginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDocumentOnwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
    return true;
}

bool setJSDocumentOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDocumentOnwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDocumentOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentOnwebkitmouseforceupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitmouseforceup");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDocumentOnwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforceupEvent, value);
    return true;
}

bool setJSDocumentOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDocument>::set<setJSDocumentOnwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforceup");
}

#endif

static inline JSValue jsDocumentChildrenGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.children());
    return result;
}

EncodedJSValue jsDocumentChildren(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentChildrenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "children");
}

static inline JSValue jsDocumentFirstElementChildGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.firstElementChild());
    return result;
}

EncodedJSValue jsDocumentFirstElementChild(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentFirstElementChildGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "firstElementChild");
}

static inline JSValue jsDocumentLastElementChildGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lastElementChild());
    return result;
}

EncodedJSValue jsDocumentLastElementChild(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentLastElementChildGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lastElementChild");
}

static inline JSValue jsDocumentChildElementCountGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.childElementCount());
    return result;
}

EncodedJSValue jsDocumentChildElementCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentChildElementCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "childElementCount");
}

static inline JSValue jsDocumentRootElementGetter(JSGlobalObject& lexicalGlobalObject, JSDocument& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<SVGSVGElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::SVGDocument::rootElement(impl));
    return result;
}

EncodedJSValue jsDocumentRootElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDocument>::get<jsDocumentRootElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rootElement");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetElementsByTagNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByTagName(WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetElementsByTagNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByTagName");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetElementsByTagNameNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByTagNameNS(WTFMove(namespaceURI), WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetElementsByTagNameNSBody>(*lexicalGlobalObject, *callFrame, "getElementsByTagNameNS");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetElementsByClassNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto classNames = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByClassName(WTFMove(classNames))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetElementsByClassNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByClassName");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Element>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createElementForBindings(WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateElementBody>(*lexicalGlobalObject, *callFrame, "createElement");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateElementNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Element>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createElementNS(WTFMove(namespaceURI), WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateElementNSBody>(*lexicalGlobalObject, *callFrame, "createElementNS");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateDocumentFragmentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createDocumentFragment()));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateDocumentFragmentBody>(*lexicalGlobalObject, *callFrame, "createDocumentFragment");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateTextNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto data = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Text>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createTextNode(WTFMove(data))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateTextNodeBody>(*lexicalGlobalObject, *callFrame, "createTextNode");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateCDATASectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto data = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<CDATASection>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createCDATASection(WTFMove(data))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateCDATASectionBody>(*lexicalGlobalObject, *callFrame, "createCDATASection");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateCommentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto data = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Comment>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createComment(WTFMove(data))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateCommentBody>(*lexicalGlobalObject, *callFrame, "createComment");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateProcessingInstructionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<ProcessingInstruction>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createProcessingInstruction(WTFMove(target), WTFMove(data))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateProcessingInstructionBody>(*lexicalGlobalObject, *callFrame, "createProcessingInstruction");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionImportNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Document", "importNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto deep = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.importNode(*node, WTFMove(deep))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionImportNodeBody>(*lexicalGlobalObject, *callFrame, "importNode");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionAdoptNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Document", "adoptNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.adoptNode(*node)));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionAdoptNodeBody>(*lexicalGlobalObject, *callFrame, "adoptNode");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAttribute(WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateAttributeBody>(*lexicalGlobalObject, *callFrame, "createAttribute");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateAttributeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createAttributeNS(WTFMove(namespaceURI), WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateAttributeNSBody>(*lexicalGlobalObject, *callFrame, "createAttributeNS");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Event>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createEvent(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateEventBody>(*lexicalGlobalObject, *callFrame, "createEvent");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createRange()));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateRangeBody>(*lexicalGlobalObject, *callFrame, "createRange");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateNodeIteratorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto root = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root", "Document", "createNodeIterator", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto whatToShow = callFrame->argument(1).isUndefined() ? 0xFFFFFFFF : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto filter = convert<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(*lexicalGlobalObject, callFrame->argument(2), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "filter", "Document", "createNodeIterator"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<NodeIterator>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createNodeIterator(*root, WTFMove(whatToShow), WTFMove(filter))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateNodeIteratorBody>(*lexicalGlobalObject, *callFrame, "createNodeIterator");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateTreeWalkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto root = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root", "Document", "createTreeWalker", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto whatToShow = callFrame->argument(1).isUndefined() ? 0xFFFFFFFF : convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto filter = convert<IDLNullable<IDLCallbackInterface<JSNodeFilter>>>(*lexicalGlobalObject, callFrame->argument(2), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "filter", "Document", "createTreeWalker"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TreeWalker>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createTreeWalker(*root, WTFMove(whatToShow), WTFMove(filter))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateTreeWalkerBody>(*lexicalGlobalObject, *callFrame, "createTreeWalker");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetElementsByNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto elementName = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByName(WTFMove(elementName))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetElementsByNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByName");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionOpen1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto unused1 = callFrame->argument(0).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto unused2 = callFrame->argument(1).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Document>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openForBindings(responsibleDocument(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->vm(), *callFrame), WTFMove(unused1), WTFMove(unused2))));
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionOpen2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto features = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WindowProxy>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.openForBindings(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), WTFMove(url), WTFMove(name), WTFMove(features))));
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionOpenOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsDocumentPrototypeFunctionOpen1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsDocumentPrototypeFunctionOpen1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsDocumentPrototypeFunctionOpen1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsDocumentPrototypeFunctionOpen2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionOpen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionOpenOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "open");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.closeForBindings());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionWriteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto text = convertVariadicArguments<IDLDOMString>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.write(responsibleDocument(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->vm(), *callFrame), WTFMove(text)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWrite(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionWriteBody>(*lexicalGlobalObject, *callFrame, "write");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionWritelnBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto text = convertVariadicArguments<IDLDOMString>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.writeln(responsibleDocument(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->vm(), *callFrame), WTFMove(text)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWriteln(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionWritelnBody>(*lexicalGlobalObject, *callFrame, "writeln");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionHasFocusBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.hasFocus()));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionHasFocus(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionHasFocusBody>(*lexicalGlobalObject, *callFrame, "hasFocus");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionExecCommandBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto commandId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto showUI = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto value = callFrame->argument(2).isUndefined() ? String() : convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.execCommand(WTFMove(commandId), WTFMove(showUI), WTFMove(value))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionExecCommandBody>(*lexicalGlobalObject, *callFrame, "execCommand");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQueryCommandEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto commandId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.queryCommandEnabled(WTFMove(commandId))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQueryCommandEnabledBody>(*lexicalGlobalObject, *callFrame, "queryCommandEnabled");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQueryCommandIndetermBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto commandId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.queryCommandIndeterm(WTFMove(commandId))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQueryCommandIndetermBody>(*lexicalGlobalObject, *callFrame, "queryCommandIndeterm");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQueryCommandStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto commandId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.queryCommandState(WTFMove(commandId))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQueryCommandStateBody>(*lexicalGlobalObject, *callFrame, "queryCommandState");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQueryCommandSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto commandId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.queryCommandSupported(WTFMove(commandId))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQueryCommandSupportedBody>(*lexicalGlobalObject, *callFrame, "queryCommandSupported");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQueryCommandValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto commandId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.queryCommandValue(WTFMove(commandId))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQueryCommandValueBody>(*lexicalGlobalObject, *callFrame, "queryCommandValue");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetSelectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLNullable<IDLInterface<DOMSelection>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSelection()));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetSelectionBody>(*lexicalGlobalObject, *callFrame, "getSelection");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateExpressionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto expression = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto resolver = convert<IDLNullable<IDLXPathNSResolver<XPathNSResolver>>>(*lexicalGlobalObject, callFrame->argument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "resolver", "Document", "createExpression", "XPathNSResolver"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<XPathExpression>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createExpression(WTFMove(expression), WTFMove(resolver))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateExpressionBody>(*lexicalGlobalObject, *callFrame, "createExpression");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateNSResolverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto nodeResolver = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "nodeResolver", "Document", "createNSResolver", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLXPathNSResolver<XPathNSResolver>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createNSResolver(*nodeResolver)));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateNSResolverBody>(*lexicalGlobalObject, *callFrame, "createNSResolver");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionEvaluateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto expression = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto contextNode = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "contextNode", "Document", "evaluate", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto resolver = convert<IDLNullable<IDLXPathNSResolver<XPathNSResolver>>>(*lexicalGlobalObject, callFrame->argument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "resolver", "Document", "evaluate", "XPathNSResolver"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto inResult = convert<IDLNullable<IDLInterface<XPathResult>>>(*lexicalGlobalObject, callFrame->argument(4), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 4, "inResult", "Document", "evaluate", "XPathResult"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<XPathResult>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.evaluate(WTFMove(expression), *contextNode, WTFMove(resolver), WTFMove(type), WTFMove(inResult))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionEvaluateBody>(*lexicalGlobalObject, *callFrame, "evaluate");
}

#if ENABLE(POINTER_LOCK)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionExitPointerLockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.exitPointerLock();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExitPointerLock(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionExitPointerLockBody>(*lexicalGlobalObject, *callFrame, "exitPointerLock");
}

#endif

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetOverrideStyleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto element = convert<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Document", "getOverrideStyle", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pseudoElement = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<CSSStyleDeclaration>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getOverrideStyle(WTFMove(element), WTFMove(pseudoElement))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetOverrideStyleBody>(*lexicalGlobalObject, *callFrame, "getOverrideStyle");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCaretRangeFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.caretRangeFromPoint(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCaretRangeFromPointBody>(*lexicalGlobalObject, *callFrame, "caretRangeFromPoint");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetCSSCanvasContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto contextId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
#if ENABLE(WEBGL)
	return JSValue::encode(toJS<IDLNullable<IDLUnion<IDLInterface<WebGLRenderingContext>, IDLInterface<ImageBitmapRenderingContext>, IDLInterface<CanvasRenderingContext2D>>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getCSSCanvasContext(WTFMove(contextId), WTFMove(name), WTFMove(width), WTFMove(height))));
#else
	return throwVMError(lexicalGlobalObject, throwScope, createError(lexicalGlobalObject, "WEBGL was disabled"));
#endif // #if ENABLE(WEBGL)
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetCSSCanvasContextBody>(*lexicalGlobalObject, *callFrame, "getCSSCanvasContext");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionClearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clear();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionClear(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionClearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCaptureEventsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.captureEvents();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaptureEvents(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCaptureEventsBody>(*lexicalGlobalObject, *callFrame, "captureEvents");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionReleaseEventsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.releaseEvents();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionReleaseEvents(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionReleaseEventsBody>(*lexicalGlobalObject, *callFrame, "releaseEvents");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<WebAnimation>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAnimations()));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetAnimations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetAnimationsBody>(*lexicalGlobalObject, *callFrame, "getAnimations");
}

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionExitPictureInPictureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSDocument>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    WebCore::DocumentPictureInPicture::exitPictureInPicture(impl, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExitPictureInPicture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSDocument>::call<jsDocumentPrototypeFunctionExitPictureInPictureBody>(*lexicalGlobalObject, *callFrame, "exitPictureInPicture");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionWebkitExitFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    WebCore::DocumentFullscreen::webkitExitFullscreen(impl);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitExitFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionWebkitExitFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitExitFullscreen");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionWebkitCancelFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    WebCore::DocumentFullscreen::webkitCancelFullScreen(impl);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitCancelFullScreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionWebkitCancelFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitCancelFullScreen");
}

#endif

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionElementFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.elementFromPoint(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionElementFromPointBody>(*lexicalGlobalObject, *callFrame, "elementFromPoint");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionElementsFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.elementsFromPoint(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementsFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionElementsFromPointBody>(*lexicalGlobalObject, *callFrame, "elementsFromPoint");
}

#if ENABLE(TOUCH_EVENTS)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateTouchBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto window = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "window", "Document", "createTouch", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto target = convert<IDLNullable<IDLInterface<EventTarget>>>(*lexicalGlobalObject, callFrame->argument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "target", "Document", "createTouch", "EventTarget"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto identifier = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto screenX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto screenY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto webkitRadiusX = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto webkitRadiusY = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto webkitRotationAngle = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->argument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto webkitForce = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->argument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Touch>>(*lexicalGlobalObject, *castedThis->globalObject(), WebCore::DocumentTouch::createTouch(impl, WTFMove(window), WTFMove(target), WTFMove(identifier), WTFMove(pageX), WTFMove(pageY), WTFMove(screenX), WTFMove(screenY), WTFMove(webkitRadiusX), WTFMove(webkitRadiusY), WTFMove(webkitRotationAngle), WTFMove(webkitForce))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouch(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateTouchBody>(*lexicalGlobalObject, *callFrame, "createTouch");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionCreateTouchListBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto touches = convertVariadicArguments<IDLInterface<Touch>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<TouchList>>(*lexicalGlobalObject, *castedThis->globalObject(), WebCore::DocumentTouch::createTouchList(impl, WTFMove(touches))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouchList(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionCreateTouchListBody>(*lexicalGlobalObject, *callFrame, "createTouchList");
}

#endif

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionGetElementByIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto elementId = convert<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementById(WTFMove(elementId))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionGetElementByIdBody>(*lexicalGlobalObject, *callFrame, "getElementById");
}

JSC::EncodedJSValue JIT_OPERATION jsDocumentPrototypeFunctionGetElementByIdWithoutTypeCheck(JSC::JSGlobalObject* lexicalGlobalObject, JSDocument* castedThis, DOMJIT::IDLJSArgumentType<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>> encodedElementId)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    IGNORE_WARNINGS_BEGIN("frame-address")
    CallFrame* callFrame = DECLARE_CALL_FRAME(vm);
    IGNORE_WARNINGS_END
    JSC::JITOperationPrologueCallFrameTracer tracer(vm, callFrame);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto elementId = DOMJIT::DirectConverter<IDLRequiresExistingAtomStringAdaptor<IDLDOMString>>::directConvert(*lexicalGlobalObject, encodedElementId);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementById(WTFMove(elementId))));
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionPrependBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.prepend(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionPrepend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionPrependBody>(*lexicalGlobalObject, *callFrame, "prepend");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionAppendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.append(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAppend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionAppendBody>(*lexicalGlobalObject, *callFrame, "append");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQuerySelectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.querySelector(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQuerySelectorBody>(*lexicalGlobalObject, *callFrame, "querySelector");
}

static inline JSC::EncodedJSValue jsDocumentPrototypeFunctionQuerySelectorAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDocument>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.querySelectorAll(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDocument>::call<jsDocumentPrototypeFunctionQuerySelectorAllBody>(*lexicalGlobalObject, *callFrame, "querySelectorAll");
}

void JSDocument::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSDocument::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

Document* JSDocument::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDocument*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
