/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTShaderTextureLOD.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSEXTShaderTextureLODPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTShaderTextureLODPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTShaderTextureLODPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTShaderTextureLODPrototype>(vm.heap)) JSEXTShaderTextureLODPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTShaderTextureLODPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTShaderTextureLODPrototype, JSEXTShaderTextureLODPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTShaderTextureLODPrototype::s_info = { "EXTShaderTextureLODPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTShaderTextureLODPrototype) };

const ClassInfo JSEXTShaderTextureLOD::s_info = { "EXTShaderTextureLOD", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTShaderTextureLOD) };

JSEXTShaderTextureLOD::JSEXTShaderTextureLOD(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTShaderTextureLOD>&& impl)
    : JSDOMWrapper<EXTShaderTextureLOD>(structure, globalObject, WTFMove(impl))
{
}

void JSEXTShaderTextureLOD::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, EXTShaderTextureLOD>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSEXTShaderTextureLOD::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSEXTShaderTextureLODPrototype::create(vm, &globalObject, JSEXTShaderTextureLODPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSEXTShaderTextureLOD::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTShaderTextureLOD>(vm, globalObject);
}

void JSEXTShaderTextureLOD::destroy(JSC::JSCell* cell)
{
    JSEXTShaderTextureLOD* thisObject = static_cast<JSEXTShaderTextureLOD*>(cell);
    thisObject->JSEXTShaderTextureLOD::~JSEXTShaderTextureLOD();
}

void JSEXTShaderTextureLOD::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTShaderTextureLOD*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTShaderTextureLODOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsEXTShaderTextureLOD = jsCast<JSEXTShaderTextureLOD*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsEXTShaderTextureLOD->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from EXTShaderTextureLOD";
    return visitor.containsOpaqueRoot(root);
}

void JSEXTShaderTextureLODOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTShaderTextureLOD = static_cast<JSEXTShaderTextureLOD*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEXTShaderTextureLOD->wrapped(), jsEXTShaderTextureLOD);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTShaderTextureLOD@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19EXTShaderTextureLODE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTShaderTextureLOD>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7EXTShaderTextureLOD@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19EXTShaderTextureLODE[2];
#endif

    // If this fails EXTShaderTextureLOD does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<EXTShaderTextureLOD>::value, "EXTShaderTextureLOD is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // EXTShaderTextureLOD has subclasses. If EXTShaderTextureLOD has subclasses that get passed
    // to toJS() we currently require EXTShaderTextureLOD you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<EXTShaderTextureLOD>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTShaderTextureLOD& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTShaderTextureLOD* JSEXTShaderTextureLOD::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTShaderTextureLOD*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
