/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "DOMJITAbstractHeapRepository.h"
#include "DOMJITIDLConvert.h"
#include "DOMJITIDLType.h"
#include "DOMJITIDLTypeFilter.h"
#include "Document.h"
#include "EventNames.h"
#include "HTMLNames.h"
#include "JSAttr.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMRect.h"
#include "JSDOMRectList.h"
#include "JSDOMTokenList.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSEventListener.h"
#include "JSGetAnimationsOptions.h"
#include "JSHTMLCollection.h"
#include "JSHTMLSlotElement.h"
#include "JSKeyframeAnimationOptions.h"
#include "JSNamedNodeMap.h"
#include "JSNodeList.h"
#include "JSScrollIntoViewOptions.h"
#include "JSScrollToOptions.h"
#include "JSShadowRoot.h"
#include "JSShadowRootMode.h"
#include "JSWebAnimation.h"
#include "Quirks.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/FrameTracers.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

template<> Element::ShadowRootInit convertDictionary<Element::ShadowRootInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Element::ShadowRootInit result;
    JSValue delegatesFocusValue;
    if (isNullOrUndefined)
        delegatesFocusValue = jsUndefined();
    else {
        delegatesFocusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delegatesFocus"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!delegatesFocusValue.isUndefined()) {
        result.delegatesFocus = convert<IDLBoolean>(lexicalGlobalObject, delegatesFocusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.delegatesFocus = false;
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modeValue.isUndefined()) {
        result.mode = convert<IDLEnumeration<ShadowRootMode>>(lexicalGlobalObject, modeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "mode", "ShadowRootInit", "ShadowRootMode");
        return { };
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionHasAttributesWithoutTypeCheck(JSC::JSGlobalObject*, JSElement*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNames(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionGetAttributeWithoutTypeCheck(JSC::JSGlobalObject*, JSElement*, DOMJIT::IDLJSArgumentType<IDLDOMString>);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionToggleAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttribute(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionGetAttributeNodeWithoutTypeCheck(JSC::JSGlobalObject*, JSElement*, DOMJIT::IDLJSArgumentType<IDLDOMString>);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNodeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNodeNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAttachShadow(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionClosest(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionMatches(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitMatchesSelector(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionGetElementsByTagNameWithoutTypeCheck(JSC::JSGlobalObject*, JSElement*, DOMJIT::IDLJSArgumentType<IDLDOMString>);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagNameNS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByClassName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionInsertAdjacentElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionInsertAdjacentText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetClientRects(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetBoundingClientRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoView(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScroll(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollBy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionInsertAdjacentHTML(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullScreen(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(POINTER_EVENTS)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetPointerCapture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(POINTER_EVENTS)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionReleasePointerCapture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(POINTER_EVENTS)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasPointerCapture(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRequestPointerLock(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoViewIfNeeded(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAnimate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAnimations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBefore(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAfter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionReplaceWith(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemove(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionPrepend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAppend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelector(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelectorAll(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementNamespaceURI(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementPrefix(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementLocalName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementTagName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementClassName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementClassName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementClassList(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementClassList(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementSlot(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementSlot(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementPart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementPart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAttributes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementShadowRoot(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementScrollTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementScrollTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementScrollLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementScrollLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementScrollWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementScrollHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementClientHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementInnerHTML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementInnerHTML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOuterHTML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOuterHTML(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnselectstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnselectstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsElementOngesturechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOngesturechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsElementOngestureend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOngestureend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsElementOngesturestart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOngesturestart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnwebkitanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkitanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkitanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnwebkittransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkittransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsElementOnwebkitfullscreenchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitfullscreenchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsElementOnwebkitfullscreenerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitfullscreenerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementOnfocusin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnfocusin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnfocusout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnfocusout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforeload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnbeforeload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsElementOnwebkitneedkey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitneedkey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
JSC::EncodedJSValue jsElementOnwebkitpresentationmodechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitpresentationmodechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsElementOnwebkitcurrentplaybacktargetiswirelesschanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitcurrentplaybacktargetiswirelesschanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsElementOnwebkitplaybacktargetavailabilitychanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnwebkitplaybacktargetavailabilitychanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsElementRole(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementRole(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaAtomic(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaAtomic(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaAutoComplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaAutoComplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaBusy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaBusy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaChecked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaChecked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaColCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaColCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaColIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaColIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaColSpan(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaColSpan(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaCurrent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaCurrent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaExpanded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaExpanded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaHasPopup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaHasPopup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaHidden(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaHidden(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaInvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaInvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaKeyShortcuts(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaKeyShortcuts(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaLevel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaLevel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaLive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaLive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaModal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaModal(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaMultiLine(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaMultiLine(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaMultiSelectable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaMultiSelectable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaOrientation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaOrientation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaPlaceholder(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaPlaceholder(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaPosInSet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaPosInSet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaPressed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaPressed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaReadOnly(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaReadOnly(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaRelevant(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaRelevant(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaRequired(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaRequired(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaRoleDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaRoleDescription(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaRowCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaRowCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaRowIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaRowIndex(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaRowSpan(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaRowSpan(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaSelected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaSelected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaSetSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaSetSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaSort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaSort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaValueMax(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaValueMax(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaValueMin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaValueMin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaValueNow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaValueNow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementAriaValueText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementAriaValueText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOncopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOncut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOncut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnpaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnpaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforecopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnbeforecopy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforecut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnbeforecut(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforeinput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnbeforeinput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementOnbeforepaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSElementOnbeforepaste(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsElementPreviousElementSibling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementNextElementSibling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementChildren(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementFirstElementChild(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementLastElementChild(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementChildElementCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsElementAssignedSlot(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

static const JSC::DOMJIT::Signature DOMJITSignatureForElementHasAttributes(jsElementPrototypeFunctionHasAttributesWithoutTypeCheck, JSElement::info(), JSC::DOMJIT::Effect::forRead(DOMJIT::AbstractHeapRepository::DOM), DOMJIT::IDLResultTypeFilter<IDLBoolean>::value);

static const JSC::DOMJIT::Signature DOMJITSignatureForElementGetAttribute(jsElementPrototypeFunctionGetAttributeWithoutTypeCheck, JSElement::info(), JSC::DOMJIT::Effect::forRead(DOMJIT::AbstractHeapRepository::DOM), DOMJIT::IDLResultTypeFilter<IDLNullable<IDLDOMString>>::value, DOMJIT::IDLArgumentTypeFilter<IDLDOMString>::value);

static const JSC::DOMJIT::Signature DOMJITSignatureForElementGetAttributeNode(jsElementPrototypeFunctionGetAttributeNodeWithoutTypeCheck, JSElement::info(), JSC::DOMJIT::Effect::forRead(DOMJIT::AbstractHeapRepository::DOM), DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Attr>>>::value, DOMJIT::IDLArgumentTypeFilter<IDLDOMString>::value);

static const JSC::DOMJIT::Signature DOMJITSignatureForElementGetElementsByTagName(jsElementPrototypeFunctionGetElementsByTagNameWithoutTypeCheck, JSElement::info(), JSC::DOMJIT::Effect::forRead(DOMJIT::AbstractHeapRepository::DOM), DOMJIT::IDLResultTypeFilter<IDLInterface<HTMLCollection>>::value, DOMJIT::IDLArgumentTypeFilter<IDLDOMString>::value);

class JSElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSElementPrototype>(vm.heap)) JSElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSElementPrototype, JSElementPrototype::Base);

using JSElementConstructor = JSDOMConstructorNotConstructable<JSElement>;

template<> JSValue JSElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSNode::getConstructor(vm, &globalObject);
}

template<> void JSElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Element"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSElementConstructor::s_info = { "Element", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementConstructor) } },
    { "namespaceURI", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementNamespaceURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "prefix", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementPrefix), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "localName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementLocalName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tagName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementTagName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementId) } },
    { "className", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClassName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementClassName) } },
    { "classList", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClassList), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementClassList) } },
    { "slot", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementSlot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementSlot) } },
    { "part", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementPart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementPart) } },
    { "attributes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAttributes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shadowRoot", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementShadowRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scrollTop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementScrollTop) } },
    { "scrollLeft", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementScrollLeft) } },
    { "scrollWidth", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scrollHeight", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementScrollHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientTop", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientLeft", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientWidth", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientHeight", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementClientHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "innerHTML", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementInnerHTML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementInnerHTML) } },
    { "outerHTML", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOuterHTML), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOuterHTML) } },
    { "onselectstart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnselectstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnselectstart) } },
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongesturechange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOngesturechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOngesturechange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongestureend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOngestureend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOngestureend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongesturestart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOngesturestart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOngesturestart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onwebkitanimationend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitanimationend) } },
    { "onwebkitanimationiteration", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitanimationiteration) } },
    { "onwebkitanimationstart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitanimationstart) } },
    { "onwebkittransitionend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkittransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkittransitionend) } },
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitfullscreenchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitfullscreenchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitfullscreenerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitfullscreenerror) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onfocusin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnfocusin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnfocusin) } },
    { "onfocusout", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnfocusout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnfocusout) } },
    { "onbeforeload", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforeload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforeload) } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "onwebkitneedkey", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitneedkey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitneedkey) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    { "onwebkitpresentationmodechanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitpresentationmodechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitpresentationmodechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "onwebkitcurrentplaybacktargetiswirelesschanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitcurrentplaybacktargetiswirelesschanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitcurrentplaybacktargetiswirelesschanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "onwebkitplaybacktargetavailabilitychanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnwebkitplaybacktargetavailabilitychanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnwebkitplaybacktargetavailabilitychanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "role", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementRole), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementRole) } },
    { "ariaAtomic", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaAtomic), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaAtomic) } },
    { "ariaAutoComplete", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaAutoComplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaAutoComplete) } },
    { "ariaBusy", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaBusy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaBusy) } },
    { "ariaChecked", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaChecked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaChecked) } },
    { "ariaColCount", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaColCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaColCount) } },
    { "ariaColIndex", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaColIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaColIndex) } },
    { "ariaColSpan", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaColSpan), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaColSpan) } },
    { "ariaCurrent", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaCurrent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaCurrent) } },
    { "ariaDisabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaDisabled) } },
    { "ariaExpanded", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaExpanded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaExpanded) } },
    { "ariaHasPopup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaHasPopup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaHasPopup) } },
    { "ariaHidden", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaHidden), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaHidden) } },
    { "ariaInvalid", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaInvalid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaInvalid) } },
    { "ariaKeyShortcuts", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaKeyShortcuts), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaKeyShortcuts) } },
    { "ariaLabel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaLabel) } },
    { "ariaLevel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaLevel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaLevel) } },
    { "ariaLive", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaLive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaLive) } },
    { "ariaModal", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaModal), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaModal) } },
    { "ariaMultiLine", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaMultiLine), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaMultiLine) } },
    { "ariaMultiSelectable", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaMultiSelectable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaMultiSelectable) } },
    { "ariaOrientation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaOrientation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaOrientation) } },
    { "ariaPlaceholder", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaPlaceholder), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaPlaceholder) } },
    { "ariaPosInSet", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaPosInSet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaPosInSet) } },
    { "ariaPressed", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaPressed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaPressed) } },
    { "ariaReadOnly", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaReadOnly), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaReadOnly) } },
    { "ariaRelevant", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaRelevant), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaRelevant) } },
    { "ariaRequired", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaRequired), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaRequired) } },
    { "ariaRoleDescription", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaRoleDescription), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaRoleDescription) } },
    { "ariaRowCount", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaRowCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaRowCount) } },
    { "ariaRowIndex", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaRowIndex), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaRowIndex) } },
    { "ariaRowSpan", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaRowSpan), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaRowSpan) } },
    { "ariaSelected", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaSelected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaSelected) } },
    { "ariaSetSize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaSetSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaSetSize) } },
    { "ariaSort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaSort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaSort) } },
    { "ariaValueMax", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaValueMax), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaValueMax) } },
    { "ariaValueMin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaValueMin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaValueMin) } },
    { "ariaValueNow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaValueNow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaValueNow) } },
    { "ariaValueText", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAriaValueText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementAriaValueText) } },
    { "oncopy", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncopy) } },
    { "oncut", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOncut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOncut) } },
    { "onpaste", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnpaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnpaste) } },
    { "onbeforecopy", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforecopy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforecopy) } },
    { "onbeforecut", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforecut), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforecut) } },
    { "onbeforeinput", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforeinput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforeinput) } },
    { "onbeforepaste", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementOnbeforepaste), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSElementOnbeforepaste) } },
    { "previousElementSibling", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementPreviousElementSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextElementSibling", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementNextElementSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "children", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementChildren), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "firstElementChild", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementFirstElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lastElementChild", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementLastElementChild), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "childElementCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementChildElementCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "assignedSlot", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsElementAssignedSlot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "hasAttributes", static_cast<unsigned>(JSC::PropertyAttribute::Function | JSC::PropertyAttribute::DOMJITFunction), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionHasAttributes), (intptr_t) static_cast<const JSC::DOMJIT::Signature*>(&DOMJITSignatureForElementHasAttributes) } },
    { "getAttributeNames", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetAttributeNames), (intptr_t) (0) } },
    { "getAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function | JSC::PropertyAttribute::DOMJITFunction), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetAttribute), (intptr_t) static_cast<const JSC::DOMJIT::Signature*>(&DOMJITSignatureForElementGetAttribute) } },
    { "getAttributeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetAttributeNS), (intptr_t) (2) } },
    { "setAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionSetAttribute), (intptr_t) (2) } },
    { "setAttributeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionSetAttributeNS), (intptr_t) (3) } },
    { "removeAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionRemoveAttribute), (intptr_t) (1) } },
    { "removeAttributeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionRemoveAttributeNS), (intptr_t) (2) } },
    { "toggleAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionToggleAttribute), (intptr_t) (1) } },
    { "hasAttribute", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionHasAttribute), (intptr_t) (1) } },
    { "hasAttributeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionHasAttributeNS), (intptr_t) (2) } },
    { "getAttributeNode", static_cast<unsigned>(JSC::PropertyAttribute::Function | JSC::PropertyAttribute::DOMJITFunction), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetAttributeNode), (intptr_t) static_cast<const JSC::DOMJIT::Signature*>(&DOMJITSignatureForElementGetAttributeNode) } },
    { "getAttributeNodeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetAttributeNodeNS), (intptr_t) (2) } },
    { "setAttributeNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionSetAttributeNode), (intptr_t) (1) } },
    { "setAttributeNodeNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionSetAttributeNodeNS), (intptr_t) (1) } },
    { "removeAttributeNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionRemoveAttributeNode), (intptr_t) (1) } },
    { "attachShadow", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionAttachShadow), (intptr_t) (1) } },
    { "closest", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionClosest), (intptr_t) (1) } },
    { "matches", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionMatches), (intptr_t) (1) } },
    { "webkitMatchesSelector", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionWebkitMatchesSelector), (intptr_t) (1) } },
    { "getElementsByTagName", static_cast<unsigned>(JSC::PropertyAttribute::Function | JSC::PropertyAttribute::DOMJITFunction), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetElementsByTagName), (intptr_t) static_cast<const JSC::DOMJIT::Signature*>(&DOMJITSignatureForElementGetElementsByTagName) } },
    { "getElementsByTagNameNS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetElementsByTagNameNS), (intptr_t) (2) } },
    { "getElementsByClassName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetElementsByClassName), (intptr_t) (1) } },
    { "insertAdjacentElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionInsertAdjacentElement), (intptr_t) (2) } },
    { "insertAdjacentText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionInsertAdjacentText), (intptr_t) (2) } },
    { "getClientRects", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetClientRects), (intptr_t) (0) } },
    { "getBoundingClientRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetBoundingClientRect), (intptr_t) (0) } },
    { "scrollIntoView", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionScrollIntoView), (intptr_t) (0) } },
    { "scroll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionScroll), (intptr_t) (0) } },
    { "scrollTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionScrollTo), (intptr_t) (0) } },
    { "scrollBy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionScrollBy), (intptr_t) (0) } },
    { "insertAdjacentHTML", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionInsertAdjacentHTML), (intptr_t) (2) } },
#if ENABLE(FULLSCREEN_API)
    { "webkitRequestFullScreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionWebkitRequestFullScreen), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitRequestFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionWebkitRequestFullscreen), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_EVENTS)
    { "setPointerCapture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionSetPointerCapture), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_EVENTS)
    { "releasePointerCapture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionReleasePointerCapture), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_EVENTS)
    { "hasPointerCapture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionHasPointerCapture), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_LOCK)
    { "requestPointerLock", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionRequestPointerLock), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "scrollIntoViewIfNeeded", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionScrollIntoViewIfNeeded), (intptr_t) (0) } },
    { "animate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionAnimate), (intptr_t) (1) } },
    { "getAnimations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionGetAnimations), (intptr_t) (0) } },
    { "before", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionBefore), (intptr_t) (0) } },
    { "after", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionAfter), (intptr_t) (0) } },
    { "replaceWith", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionReplaceWith), (intptr_t) (0) } },
    { "remove", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionRemove), (intptr_t) (0) } },
    { "prepend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionPrepend), (intptr_t) (0) } },
    { "append", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionAppend), (intptr_t) (0) } },
    { "querySelector", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionQuerySelector), (intptr_t) (1) } },
    { "querySelectorAll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsElementPrototypeFunctionQuerySelectorAll), (intptr_t) (1) } },
};

const ClassInfo JSElementPrototype::s_info = { "ElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSElementPrototype) };

void JSElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSElement::info(), JSElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().shadowDOMEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("attachShadow"), strlen("attachShadow"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitRequestFullScreen"), strlen("webkitRequestFullScreen"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitRequestFullscreen"), strlen("webkitRequestFullscreen"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(POINTER_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().pointerEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("setPointerCapture"), strlen("setPointerCapture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(POINTER_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().pointerEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("releasePointerCapture"), strlen("releasePointerCapture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(POINTER_EVENTS)
    if (!RuntimeEnabledFeatures::sharedFeatures().pointerEventsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("hasPointerCapture"), strlen("hasPointerCapture"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("animate"), strlen("animate"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("getAnimations"), strlen("getAnimations"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().shadowDOMEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("slot"), strlen("slot"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().cssShadowPartsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("part"), strlen("part"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().shadowDOMEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("shadowRoot"), strlen("shadowRoot"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onwebkitfullscreenchange"), strlen("onwebkitfullscreenchange"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(FULLSCREEN_API)
    if (!(downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().fullScreenEnabled() && !downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisableElementFullscreenQuirk())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onwebkitfullscreenerror"), strlen("onwebkitfullscreenerror"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!RuntimeEnabledFeatures::sharedFeatures().legacyEncryptedMediaAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onwebkitneedkey"), strlen("onwebkitneedkey"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("role"), strlen("role"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaAtomic"), strlen("ariaAtomic"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaAutoComplete"), strlen("ariaAutoComplete"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaBusy"), strlen("ariaBusy"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaChecked"), strlen("ariaChecked"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaColCount"), strlen("ariaColCount"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaColIndex"), strlen("ariaColIndex"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaColSpan"), strlen("ariaColSpan"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaCurrent"), strlen("ariaCurrent"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaDisabled"), strlen("ariaDisabled"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaExpanded"), strlen("ariaExpanded"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaHasPopup"), strlen("ariaHasPopup"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaHidden"), strlen("ariaHidden"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaInvalid"), strlen("ariaInvalid"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaKeyShortcuts"), strlen("ariaKeyShortcuts"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaLabel"), strlen("ariaLabel"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaLevel"), strlen("ariaLevel"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaLive"), strlen("ariaLive"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaModal"), strlen("ariaModal"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaMultiLine"), strlen("ariaMultiLine"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaMultiSelectable"), strlen("ariaMultiSelectable"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaOrientation"), strlen("ariaOrientation"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaPlaceholder"), strlen("ariaPlaceholder"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaPosInSet"), strlen("ariaPosInSet"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaPressed"), strlen("ariaPressed"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaReadOnly"), strlen("ariaReadOnly"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaRelevant"), strlen("ariaRelevant"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaRequired"), strlen("ariaRequired"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaRoleDescription"), strlen("ariaRoleDescription"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaRowCount"), strlen("ariaRowCount"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaRowIndex"), strlen("ariaRowIndex"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaRowSpan"), strlen("ariaRowSpan"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaSelected"), strlen("ariaSelected"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaSetSize"), strlen("ariaSetSize"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaSort"), strlen("ariaSort"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaValueMax"), strlen("ariaValueMax"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaValueMin"), strlen("ariaValueMin"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaValueNow"), strlen("ariaValueNow"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().ariaReflectionEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("ariaValueText"), strlen("ariaValueText"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().shadowDOMEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("assignedSlot"), strlen("assignedSlot"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSObject& unscopables = *constructEmptyObject(globalObject()->vm(), globalObject()->nullPrototypeObjectStructure());
    unscopables.putDirect(vm, Identifier::fromString(vm, "before"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "after"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "replaceWith"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "remove"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "prepend"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "append"), jsBoolean(true));
    unscopables.putDirect(vm, Identifier::fromString(vm, "slot"), jsBoolean(true));
    putDirectWithoutTransition(vm, vm.propertyNames->unscopablesSymbol, &unscopables, JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::ReadOnly);
}

const ClassInfo JSElement::s_info = { "Element", &Base::s_info, nullptr
#if ENABLE(JIT)
, &checkSubClassSnippetForJSElement
#else
, nullptr
#endif
, CREATE_METHOD_TABLE(JSElement) };

JSElement::JSElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Element>&& impl)
    : JSNode(structure, globalObject, WTFMove(impl))
{
}

void JSElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, Element>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSElementPrototype::create(vm, &globalObject, JSElementPrototype::createStructure(vm, &globalObject, JSNode::prototype(vm, globalObject)));
}

JSObject* JSElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSElement>(vm, globalObject);
}

JSValue JSElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSElement* IDLAttribute<JSElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSElement* IDLOperation<JSElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsElementNamespaceURIGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.namespaceURI());
    return result;
}

EncodedJSValue jsElementNamespaceURI(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementNamespaceURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "namespaceURI");
}

static inline JSValue jsElementPrefixGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.prefix());
    return result;
}

EncodedJSValue jsElementPrefix(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementPrefixGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "prefix");
}

static inline JSValue jsElementLocalNameGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.localName());
    return result;
}

EncodedJSValue jsElementLocalName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementLocalNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "localName");
}

static inline JSValue jsElementTagNameGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.tagName());
    return result;
}

EncodedJSValue jsElementTagName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementTagNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "tagName");
}

static inline JSValue jsElementIdGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getIdAttribute());
    return result;
}

EncodedJSValue jsElementId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline bool setJSElementIdSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::idAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementIdSetter>(*lexicalGlobalObject, thisValue, encodedValue, "id");
}

static inline JSValue jsElementClassNameGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::classAttr));
    return result;
}

EncodedJSValue jsElementClassName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementClassNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "className");
}

static inline bool setJSElementClassNameSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::classAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementClassName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementClassNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "className");
}

static inline JSValue jsElementClassListGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMTokenList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.classList());
    return result;
}

EncodedJSValue jsElementClassList(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementClassListGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "classList");
}

static inline bool setJSElementClassListSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("classList"), strlen("classList"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("value"), strlen("value"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSElementClassList(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementClassListSetter>(*lexicalGlobalObject, thisValue, encodedValue, "classList");
}

static inline JSValue jsElementSlotGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::slotAttr));
    return result;
}

EncodedJSValue jsElementSlot(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementSlotGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "slot");
}

static inline bool setJSElementSlotSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::slotAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementSlot(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementSlotSetter>(*lexicalGlobalObject, thisValue, encodedValue, "slot");
}

static inline JSValue jsElementPartGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMTokenList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.part());
    return result;
}

EncodedJSValue jsElementPart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementPartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "part");
}

static inline bool setJSElementPartSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("part"), strlen("part"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("value"), strlen("value"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSElementPart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementPartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "part");
}

static inline JSValue jsElementAttributesGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NamedNodeMap>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.attributes());
    return result;
}

EncodedJSValue jsElementAttributes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAttributesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "attributes");
}

static inline JSValue jsElementShadowRootGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ShadowRoot>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.shadowRootForBindings(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)));
    return result;
}

EncodedJSValue jsElementShadowRoot(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementShadowRootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowRoot");
}

static inline JSValue jsElementScrollTopGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.scrollTop());
    return result;
}

EncodedJSValue jsElementScrollTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementScrollTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollTop");
}

static inline bool setJSElementScrollTopSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setScrollTop(WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementScrollTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementScrollTopSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollTop");
}

static inline JSValue jsElementScrollLeftGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.scrollLeft());
    return result;
}

EncodedJSValue jsElementScrollLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementScrollLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollLeft");
}

static inline bool setJSElementScrollLeftSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setScrollLeft(WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementScrollLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementScrollLeftSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollLeft");
}

static inline JSValue jsElementScrollWidthGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.scrollWidth());
    return result;
}

EncodedJSValue jsElementScrollWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementScrollWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollWidth");
}

static inline JSValue jsElementScrollHeightGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.scrollHeight());
    return result;
}

EncodedJSValue jsElementScrollHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementScrollHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollHeight");
}

static inline JSValue jsElementClientTopGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.clientTop());
    return result;
}

EncodedJSValue jsElementClientTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementClientTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientTop");
}

static inline JSValue jsElementClientLeftGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.clientLeft());
    return result;
}

EncodedJSValue jsElementClientLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementClientLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientLeft");
}

static inline JSValue jsElementClientWidthGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.clientWidth());
    return result;
}

EncodedJSValue jsElementClientWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementClientWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientWidth");
}

static inline JSValue jsElementClientHeightGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.clientHeight());
    return result;
}

EncodedJSValue jsElementClientHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementClientHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientHeight");
}

static inline JSValue jsElementInnerHTMLGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.innerHTML());
    return result;
}

EncodedJSValue jsElementInnerHTML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementInnerHTMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "innerHTML");
}

static inline bool setJSElementInnerHTMLSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setInnerHTML(WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementInnerHTML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementInnerHTMLSetter>(*lexicalGlobalObject, thisValue, encodedValue, "innerHTML");
}

static inline JSValue jsElementOuterHTMLGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.outerHTML());
    return result;
}

EncodedJSValue jsElementOuterHTML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOuterHTMLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "outerHTML");
}

static inline bool setJSElementOuterHTMLSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setOuterHTML(WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementOuterHTML(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOuterHTMLSetter>(*lexicalGlobalObject, thisValue, encodedValue, "outerHTML");
}

static inline JSValue jsElementOnselectstartGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnselectstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnselectstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onselectstart");
}

static inline bool setJSElementOnselectstartSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectstartEvent, value);
    return true;
}

bool setJSElementOnselectstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnselectstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselectstart");
}

#if ENABLE(IOS_GESTURE_EVENTS)
static inline JSValue jsElementOngesturechangeGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gesturechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOngesturechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOngesturechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ongesturechange");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline bool setJSElementOngesturechangeSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gesturechangeEvent, value);
    return true;
}

bool setJSElementOngesturechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOngesturechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongesturechange");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline JSValue jsElementOngestureendGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gestureendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOngestureend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOngestureendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ongestureend");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline bool setJSElementOngestureendSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gestureendEvent, value);
    return true;
}

bool setJSElementOngestureend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOngestureendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongestureend");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline JSValue jsElementOngesturestartGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gesturestartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOngesturestart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOngesturestartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ongesturestart");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline bool setJSElementOngesturestartSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gesturestartEvent, value);
    return true;
}

bool setJSElementOngesturestart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOngesturestartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongesturestart");
}

#endif

static inline JSValue jsElementOnwebkitanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationEndEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitanimationendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitanimationend");
}

static inline bool setJSElementOnwebkitanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitAnimationEndEvent, value);
    return true;
}

bool setJSElementOnwebkitanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitanimationend");
}

static inline JSValue jsElementOnwebkitanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationIterationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitanimationiterationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitanimationiteration");
}

static inline bool setJSElementOnwebkitanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitAnimationIterationEvent, value);
    return true;
}

bool setJSElementOnwebkitanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitanimationiteration");
}

static inline JSValue jsElementOnwebkitanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationStartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitanimationstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitanimationstart");
}

static inline bool setJSElementOnwebkitanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitAnimationStartEvent, value);
    return true;
}

bool setJSElementOnwebkitanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitanimationstart");
}

static inline JSValue jsElementOnwebkittransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitTransitionEndEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkittransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkittransitionendGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkittransitionend");
}

static inline bool setJSElementOnwebkittransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitTransitionEndEvent, value);
    return true;
}

bool setJSElementOnwebkittransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkittransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkittransitionend");
}

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsElementOnwebkitfullscreenchangeGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitfullscreenchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitfullscreenchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitfullscreenchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitfullscreenchange");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSElementOnwebkitfullscreenchangeSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitfullscreenchangeEvent, value);
    return true;
}

bool setJSElementOnwebkitfullscreenchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitfullscreenchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitfullscreenchange");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsElementOnwebkitfullscreenerrorGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitfullscreenerrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitfullscreenerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitfullscreenerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitfullscreenerror");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline bool setJSElementOnwebkitfullscreenerrorSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitfullscreenerrorEvent, value);
    return true;
}

bool setJSElementOnwebkitfullscreenerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitfullscreenerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitfullscreenerror");
}

#endif

static inline JSValue jsElementOnfocusinGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().focusinEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnfocusin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnfocusinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocusin");
}

static inline bool setJSElementOnfocusinSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusinEvent, value);
    return true;
}

bool setJSElementOnfocusin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnfocusinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocusin");
}

static inline JSValue jsElementOnfocusoutGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().focusoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnfocusout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnfocusoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onfocusout");
}

static inline bool setJSElementOnfocusoutSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusoutEvent, value);
    return true;
}

bool setJSElementOnfocusout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnfocusoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocusout");
}

static inline JSValue jsElementOnbeforeloadGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforeloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnbeforeload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnbeforeloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeload");
}

static inline bool setJSElementOnbeforeloadSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeloadEvent, value);
    return true;
}

bool setJSElementOnbeforeload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnbeforeloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeload");
}

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSValue jsElementOnwebkitneedkeyGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitneedkeyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitneedkey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitneedkeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitneedkey");
}

#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline bool setJSElementOnwebkitneedkeySetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitneedkeyEvent, value);
    return true;
}

bool setJSElementOnwebkitneedkey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitneedkeySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitneedkey");
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSValue jsElementOnwebkitpresentationmodechangedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitpresentationmodechangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitpresentationmodechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitpresentationmodechangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitpresentationmodechanged");
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline bool setJSElementOnwebkitpresentationmodechangedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitpresentationmodechangedEvent, value);
    return true;
}

bool setJSElementOnwebkitpresentationmodechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitpresentationmodechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitpresentationmodechanged");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsElementOnwebkitcurrentplaybacktargetiswirelesschangedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitcurrentplaybacktargetiswirelesschangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitcurrentplaybacktargetiswirelesschanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitcurrentplaybacktargetiswirelesschangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitcurrentplaybacktargetiswirelesschanged");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline bool setJSElementOnwebkitcurrentplaybacktargetiswirelesschangedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitcurrentplaybacktargetiswirelesschangedEvent, value);
    return true;
}

bool setJSElementOnwebkitcurrentplaybacktargetiswirelesschanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitcurrentplaybacktargetiswirelesschangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitcurrentplaybacktargetiswirelesschanged");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsElementOnwebkitplaybacktargetavailabilitychangedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitplaybacktargetavailabilitychangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnwebkitplaybacktargetavailabilitychanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnwebkitplaybacktargetavailabilitychangedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwebkitplaybacktargetavailabilitychanged");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline bool setJSElementOnwebkitplaybacktargetavailabilitychangedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitplaybacktargetavailabilitychangedEvent, value);
    return true;
}

bool setJSElementOnwebkitplaybacktargetavailabilitychanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnwebkitplaybacktargetavailabilitychangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitplaybacktargetavailabilitychanged");
}

#endif

static inline JSValue jsElementRoleGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::roleAttr));
    return result;
}

EncodedJSValue jsElementRole(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementRoleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "role");
}

static inline bool setJSElementRoleSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::roleAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementRole(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementRoleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "role");
}

static inline JSValue jsElementAriaAtomicGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_atomicAttr));
    return result;
}

EncodedJSValue jsElementAriaAtomic(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaAtomicGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaAtomic");
}

static inline bool setJSElementAriaAtomicSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_atomicAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaAtomic(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaAtomicSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaAtomic");
}

static inline JSValue jsElementAriaAutoCompleteGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_autocompleteAttr));
    return result;
}

EncodedJSValue jsElementAriaAutoComplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaAutoCompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaAutoComplete");
}

static inline bool setJSElementAriaAutoCompleteSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_autocompleteAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaAutoComplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaAutoCompleteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaAutoComplete");
}

static inline JSValue jsElementAriaBusyGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_busyAttr));
    return result;
}

EncodedJSValue jsElementAriaBusy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaBusyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaBusy");
}

static inline bool setJSElementAriaBusySetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_busyAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaBusy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaBusySetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaBusy");
}

static inline JSValue jsElementAriaCheckedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_checkedAttr));
    return result;
}

EncodedJSValue jsElementAriaChecked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaCheckedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaChecked");
}

static inline bool setJSElementAriaCheckedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_checkedAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaChecked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaCheckedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaChecked");
}

static inline JSValue jsElementAriaColCountGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_colcountAttr));
    return result;
}

EncodedJSValue jsElementAriaColCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaColCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaColCount");
}

static inline bool setJSElementAriaColCountSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_colcountAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaColCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaColCountSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaColCount");
}

static inline JSValue jsElementAriaColIndexGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_colindexAttr));
    return result;
}

EncodedJSValue jsElementAriaColIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaColIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaColIndex");
}

static inline bool setJSElementAriaColIndexSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_colindexAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaColIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaColIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaColIndex");
}

static inline JSValue jsElementAriaColSpanGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_colspanAttr));
    return result;
}

EncodedJSValue jsElementAriaColSpan(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaColSpanGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaColSpan");
}

static inline bool setJSElementAriaColSpanSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_colspanAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaColSpan(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaColSpanSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaColSpan");
}

static inline JSValue jsElementAriaCurrentGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_currentAttr));
    return result;
}

EncodedJSValue jsElementAriaCurrent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaCurrentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaCurrent");
}

static inline bool setJSElementAriaCurrentSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_currentAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaCurrent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaCurrentSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaCurrent");
}

static inline JSValue jsElementAriaDisabledGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_disabledAttr));
    return result;
}

EncodedJSValue jsElementAriaDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaDisabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaDisabled");
}

static inline bool setJSElementAriaDisabledSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_disabledAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaDisabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaDisabled");
}

static inline JSValue jsElementAriaExpandedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_expandedAttr));
    return result;
}

EncodedJSValue jsElementAriaExpanded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaExpandedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaExpanded");
}

static inline bool setJSElementAriaExpandedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_expandedAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaExpanded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaExpandedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaExpanded");
}

static inline JSValue jsElementAriaHasPopupGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_haspopupAttr));
    return result;
}

EncodedJSValue jsElementAriaHasPopup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaHasPopupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaHasPopup");
}

static inline bool setJSElementAriaHasPopupSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_haspopupAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaHasPopup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaHasPopupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaHasPopup");
}

static inline JSValue jsElementAriaHiddenGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_hiddenAttr));
    return result;
}

EncodedJSValue jsElementAriaHidden(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaHiddenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaHidden");
}

static inline bool setJSElementAriaHiddenSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_hiddenAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaHidden(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaHiddenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaHidden");
}

static inline JSValue jsElementAriaInvalidGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_invalidAttr));
    return result;
}

EncodedJSValue jsElementAriaInvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaInvalidGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaInvalid");
}

static inline bool setJSElementAriaInvalidSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_invalidAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaInvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaInvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaInvalid");
}

static inline JSValue jsElementAriaKeyShortcutsGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_keyshortcutsAttr));
    return result;
}

EncodedJSValue jsElementAriaKeyShortcuts(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaKeyShortcutsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaKeyShortcuts");
}

static inline bool setJSElementAriaKeyShortcutsSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_keyshortcutsAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaKeyShortcuts(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaKeyShortcutsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaKeyShortcuts");
}

static inline JSValue jsElementAriaLabelGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_labelAttr));
    return result;
}

EncodedJSValue jsElementAriaLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaLabel");
}

static inline bool setJSElementAriaLabelSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_labelAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaLabelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaLabel");
}

static inline JSValue jsElementAriaLevelGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_levelAttr));
    return result;
}

EncodedJSValue jsElementAriaLevel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaLevelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaLevel");
}

static inline bool setJSElementAriaLevelSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_levelAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaLevel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaLevelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaLevel");
}

static inline JSValue jsElementAriaLiveGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_liveAttr));
    return result;
}

EncodedJSValue jsElementAriaLive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaLiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaLive");
}

static inline bool setJSElementAriaLiveSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_liveAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaLive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaLiveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaLive");
}

static inline JSValue jsElementAriaModalGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_modalAttr));
    return result;
}

EncodedJSValue jsElementAriaModal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaModalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaModal");
}

static inline bool setJSElementAriaModalSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_modalAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaModal(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaModalSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaModal");
}

static inline JSValue jsElementAriaMultiLineGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_multilineAttr));
    return result;
}

EncodedJSValue jsElementAriaMultiLine(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaMultiLineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaMultiLine");
}

static inline bool setJSElementAriaMultiLineSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_multilineAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaMultiLine(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaMultiLineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaMultiLine");
}

static inline JSValue jsElementAriaMultiSelectableGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_multiselectableAttr));
    return result;
}

EncodedJSValue jsElementAriaMultiSelectable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaMultiSelectableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaMultiSelectable");
}

static inline bool setJSElementAriaMultiSelectableSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_multiselectableAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaMultiSelectable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaMultiSelectableSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaMultiSelectable");
}

static inline JSValue jsElementAriaOrientationGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_orientationAttr));
    return result;
}

EncodedJSValue jsElementAriaOrientation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaOrientationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaOrientation");
}

static inline bool setJSElementAriaOrientationSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_orientationAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaOrientation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaOrientationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaOrientation");
}

static inline JSValue jsElementAriaPlaceholderGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_placeholderAttr));
    return result;
}

EncodedJSValue jsElementAriaPlaceholder(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaPlaceholderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaPlaceholder");
}

static inline bool setJSElementAriaPlaceholderSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_placeholderAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaPlaceholder(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaPlaceholderSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaPlaceholder");
}

static inline JSValue jsElementAriaPosInSetGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_posinsetAttr));
    return result;
}

EncodedJSValue jsElementAriaPosInSet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaPosInSetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaPosInSet");
}

static inline bool setJSElementAriaPosInSetSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_posinsetAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaPosInSet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaPosInSetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaPosInSet");
}

static inline JSValue jsElementAriaPressedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_pressedAttr));
    return result;
}

EncodedJSValue jsElementAriaPressed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaPressedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaPressed");
}

static inline bool setJSElementAriaPressedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_pressedAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaPressed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaPressedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaPressed");
}

static inline JSValue jsElementAriaReadOnlyGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_readonlyAttr));
    return result;
}

EncodedJSValue jsElementAriaReadOnly(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaReadOnlyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaReadOnly");
}

static inline bool setJSElementAriaReadOnlySetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_readonlyAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaReadOnly(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaReadOnlySetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaReadOnly");
}

static inline JSValue jsElementAriaRelevantGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_relevantAttr));
    return result;
}

EncodedJSValue jsElementAriaRelevant(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaRelevantGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaRelevant");
}

static inline bool setJSElementAriaRelevantSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_relevantAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaRelevant(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaRelevantSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaRelevant");
}

static inline JSValue jsElementAriaRequiredGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_requiredAttr));
    return result;
}

EncodedJSValue jsElementAriaRequired(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaRequiredGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaRequired");
}

static inline bool setJSElementAriaRequiredSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_requiredAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaRequired(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaRequiredSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaRequired");
}

static inline JSValue jsElementAriaRoleDescriptionGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_roledescriptionAttr));
    return result;
}

EncodedJSValue jsElementAriaRoleDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaRoleDescriptionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaRoleDescription");
}

static inline bool setJSElementAriaRoleDescriptionSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_roledescriptionAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaRoleDescription(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaRoleDescriptionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaRoleDescription");
}

static inline JSValue jsElementAriaRowCountGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_rowcountAttr));
    return result;
}

EncodedJSValue jsElementAriaRowCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaRowCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaRowCount");
}

static inline bool setJSElementAriaRowCountSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_rowcountAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaRowCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaRowCountSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaRowCount");
}

static inline JSValue jsElementAriaRowIndexGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_rowindexAttr));
    return result;
}

EncodedJSValue jsElementAriaRowIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaRowIndexGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaRowIndex");
}

static inline bool setJSElementAriaRowIndexSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_rowindexAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaRowIndex(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaRowIndexSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaRowIndex");
}

static inline JSValue jsElementAriaRowSpanGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_rowspanAttr));
    return result;
}

EncodedJSValue jsElementAriaRowSpan(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaRowSpanGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaRowSpan");
}

static inline bool setJSElementAriaRowSpanSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_rowspanAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaRowSpan(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaRowSpanSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaRowSpan");
}

static inline JSValue jsElementAriaSelectedGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_selectedAttr));
    return result;
}

EncodedJSValue jsElementAriaSelected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaSelectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaSelected");
}

static inline bool setJSElementAriaSelectedSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_selectedAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaSelected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaSelectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaSelected");
}

static inline JSValue jsElementAriaSetSizeGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_setsizeAttr));
    return result;
}

EncodedJSValue jsElementAriaSetSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaSetSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaSetSize");
}

static inline bool setJSElementAriaSetSizeSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_setsizeAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaSetSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaSetSizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaSetSize");
}

static inline JSValue jsElementAriaSortGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_sortAttr));
    return result;
}

EncodedJSValue jsElementAriaSort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaSortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaSort");
}

static inline bool setJSElementAriaSortSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_sortAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaSort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaSortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaSort");
}

static inline JSValue jsElementAriaValueMaxGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_valuemaxAttr));
    return result;
}

EncodedJSValue jsElementAriaValueMax(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaValueMaxGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaValueMax");
}

static inline bool setJSElementAriaValueMaxSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_valuemaxAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaValueMax(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaValueMaxSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaValueMax");
}

static inline JSValue jsElementAriaValueMinGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_valueminAttr));
    return result;
}

EncodedJSValue jsElementAriaValueMin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaValueMinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaValueMin");
}

static inline bool setJSElementAriaValueMinSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_valueminAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaValueMin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaValueMinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaValueMin");
}

static inline JSValue jsElementAriaValueNowGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_valuenowAttr));
    return result;
}

EncodedJSValue jsElementAriaValueNow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaValueNowGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaValueNow");
}

static inline bool setJSElementAriaValueNowSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_valuenowAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaValueNow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaValueNowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaValueNow");
}

static inline JSValue jsElementAriaValueTextGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::aria_valuetextAttr));
    return result;
}

EncodedJSValue jsElementAriaValueText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAriaValueTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ariaValueText");
}

static inline bool setJSElementAriaValueTextSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::aria_valuetextAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSElementAriaValueText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementAriaValueTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ariaValueText");
}

static inline JSValue jsElementOncopyGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().copyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOncopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOncopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncopy");
}

static inline bool setJSElementOncopySetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().copyEvent, value);
    return true;
}

bool setJSElementOncopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOncopySetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncopy");
}

static inline JSValue jsElementOncutGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOncut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOncutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oncut");
}

static inline bool setJSElementOncutSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cutEvent, value);
    return true;
}

bool setJSElementOncut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOncutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncut");
}

static inline JSValue jsElementOnpasteGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pasteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnpaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnpasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onpaste");
}

static inline bool setJSElementOnpasteSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pasteEvent, value);
    return true;
}

bool setJSElementOnpaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnpasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpaste");
}

static inline JSValue jsElementOnbeforecopyGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforecopyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnbeforecopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnbeforecopyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforecopy");
}

static inline bool setJSElementOnbeforecopySetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforecopyEvent, value);
    return true;
}

bool setJSElementOnbeforecopy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnbeforecopySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforecopy");
}

static inline JSValue jsElementOnbeforecutGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforecutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnbeforecut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnbeforecutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforecut");
}

static inline bool setJSElementOnbeforecutSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforecutEvent, value);
    return true;
}

bool setJSElementOnbeforecut(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnbeforecutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforecut");
}

static inline JSValue jsElementOnbeforeinputGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforeinputEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnbeforeinput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnbeforeinputGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforeinput");
}

static inline bool setJSElementOnbeforeinputSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeinputEvent, value);
    return true;
}

bool setJSElementOnbeforeinput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnbeforeinputSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeinput");
}

static inline JSValue jsElementOnbeforepasteGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().beforepasteEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsElementOnbeforepaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementOnbeforepasteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onbeforepaste");
}

static inline bool setJSElementOnbeforepasteSetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforepasteEvent, value);
    return true;
}

bool setJSElementOnbeforepaste(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSElement>::set<setJSElementOnbeforepasteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforepaste");
}

static inline JSValue jsElementPreviousElementSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.previousElementSibling());
    return result;
}

EncodedJSValue jsElementPreviousElementSibling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementPreviousElementSiblingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "previousElementSibling");
}

static inline JSValue jsElementNextElementSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.nextElementSibling());
    return result;
}

EncodedJSValue jsElementNextElementSibling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementNextElementSiblingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "nextElementSibling");
}

static inline JSValue jsElementChildrenGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCollection>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.children());
    return result;
}

EncodedJSValue jsElementChildren(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementChildrenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "children");
}

static inline JSValue jsElementFirstElementChildGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.firstElementChild());
    return result;
}

EncodedJSValue jsElementFirstElementChild(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementFirstElementChildGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "firstElementChild");
}

static inline JSValue jsElementLastElementChildGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lastElementChild());
    return result;
}

EncodedJSValue jsElementLastElementChild(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementLastElementChildGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lastElementChild");
}

static inline JSValue jsElementChildElementCountGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.childElementCount());
    return result;
}

EncodedJSValue jsElementChildElementCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementChildElementCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "childElementCount");
}

static inline JSValue jsElementAssignedSlotGetter(JSGlobalObject& lexicalGlobalObject, JSElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<HTMLSlotElement>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.assignedSlotForBindings());
    return result;
}

EncodedJSValue jsElementAssignedSlot(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSElement>::get<jsElementAssignedSlotGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "assignedSlot");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionHasAttributesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.hasAttributes()));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionHasAttributesBody>(*lexicalGlobalObject, *callFrame, "hasAttributes");
}

JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionHasAttributesWithoutTypeCheck(JSC::JSGlobalObject* lexicalGlobalObject, JSElement* castedThis)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    IGNORE_WARNINGS_BEGIN("frame-address")
    CallFrame* callFrame = DECLARE_CALL_FRAME(vm);
    IGNORE_WARNINGS_END
    JSC::JITOperationPrologueCallFrameTracer tracer(vm, callFrame);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.hasAttributes()));
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetAttributeNamesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAttributeNames()));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNames(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetAttributeNamesBody>(*lexicalGlobalObject, *callFrame, "getAttributeNames");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getAttribute(WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetAttributeBody>(*lexicalGlobalObject, *callFrame, "getAttribute");
}

JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionGetAttributeWithoutTypeCheck(JSC::JSGlobalObject* lexicalGlobalObject, JSElement* castedThis, DOMJIT::IDLJSArgumentType<IDLDOMString> encodedQualifiedName)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    IGNORE_WARNINGS_BEGIN("frame-address")
    CallFrame* callFrame = DECLARE_CALL_FRAME(vm);
    IGNORE_WARNINGS_END
    JSC::JITOperationPrologueCallFrameTracer tracer(vm, callFrame);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto qualifiedName = DOMJIT::DirectConverter<IDLDOMString>::directConvert(*lexicalGlobalObject, encodedQualifiedName);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getAttribute(WTFMove(qualifiedName))));
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetAttributeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getAttributeNS(WTFMove(namespaceURI), WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetAttributeNSBody>(*lexicalGlobalObject, *callFrame, "getAttributeNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionSetAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto value = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAttribute(WTFMove(qualifiedName), WTFMove(value)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionSetAttributeBody>(*lexicalGlobalObject, *callFrame, "setAttribute");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionSetAttributeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto value = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setAttributeNS(WTFMove(namespaceURI), WTFMove(qualifiedName), WTFMove(value)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionSetAttributeNSBody>(*lexicalGlobalObject, *callFrame, "setAttributeNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionRemoveAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.removeAttribute(WTFMove(qualifiedName));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionRemoveAttributeBody>(*lexicalGlobalObject, *callFrame, "removeAttribute");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionRemoveAttributeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.removeAttributeNS(WTFMove(namespaceURI), WTFMove(localName));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionRemoveAttributeNSBody>(*lexicalGlobalObject, *callFrame, "removeAttributeNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionToggleAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto force = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLBoolean>::ReturnType>() : Optional<Converter<IDLBoolean>::ReturnType>(convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.toggleAttribute(WTFMove(qualifiedName), WTFMove(force))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionToggleAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionToggleAttributeBody>(*lexicalGlobalObject, *callFrame, "toggleAttribute");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionHasAttributeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasAttribute(WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttribute(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionHasAttributeBody>(*lexicalGlobalObject, *callFrame, "hasAttribute");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionHasAttributeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasAttributeNS(WTFMove(namespaceURI), WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionHasAttributeNSBody>(*lexicalGlobalObject, *callFrame, "hasAttributeNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetAttributeNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAttributeNode(WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetAttributeNodeBody>(*lexicalGlobalObject, *callFrame, "getAttributeNode");
}

JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionGetAttributeNodeWithoutTypeCheck(JSC::JSGlobalObject* lexicalGlobalObject, JSElement* castedThis, DOMJIT::IDLJSArgumentType<IDLDOMString> encodedQualifiedName)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    IGNORE_WARNINGS_BEGIN("frame-address")
    CallFrame* callFrame = DECLARE_CALL_FRAME(vm);
    IGNORE_WARNINGS_END
    JSC::JITOperationPrologueCallFrameTracer tracer(vm, callFrame);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto qualifiedName = DOMJIT::DirectConverter<IDLDOMString>::directConvert(*lexicalGlobalObject, encodedQualifiedName);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAttributeNode(WTFMove(qualifiedName))));
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetAttributeNodeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAttributeNodeNS(WTFMove(namespaceURI), WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNodeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetAttributeNodeNSBody>(*lexicalGlobalObject, *callFrame, "getAttributeNodeNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionSetAttributeNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto attr = convert<IDLInterface<Attr>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "attr", "Element", "setAttributeNode", "Attr"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setAttributeNode(*attr)));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionSetAttributeNodeBody>(*lexicalGlobalObject, *callFrame, "setAttributeNode");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionSetAttributeNodeNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto attr = convert<IDLInterface<Attr>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "attr", "Element", "setAttributeNodeNS", "Attr"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Attr>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setAttributeNodeNS(*attr)));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNodeNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionSetAttributeNodeNSBody>(*lexicalGlobalObject, *callFrame, "setAttributeNodeNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionRemoveAttributeNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto attr = convert<IDLInterface<Attr>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "attr", "Element", "removeAttributeNode", "Attr"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Attr>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.removeAttributeNode(*attr)));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionRemoveAttributeNodeBody>(*lexicalGlobalObject, *callFrame, "removeAttributeNode");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionAttachShadowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto init = convert<IDLDictionary<Element::ShadowRootInit>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<ShadowRoot>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.attachShadow(WTFMove(init))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAttachShadow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionAttachShadowBody>(*lexicalGlobalObject, *callFrame, "attachShadow");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionClosestBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.closest(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionClosest(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionClosestBody>(*lexicalGlobalObject, *callFrame, "closest");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionMatchesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.matches(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionMatches(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionMatchesBody>(*lexicalGlobalObject, *callFrame, "matches");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionWebkitMatchesSelectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.matches(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitMatchesSelector(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionWebkitMatchesSelectorBody>(*lexicalGlobalObject, *callFrame, "webkitMatchesSelector");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetElementsByTagNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByTagName(WTFMove(qualifiedName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetElementsByTagNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByTagName");
}

JSC::EncodedJSValue JIT_OPERATION jsElementPrototypeFunctionGetElementsByTagNameWithoutTypeCheck(JSC::JSGlobalObject* lexicalGlobalObject, JSElement* castedThis, DOMJIT::IDLJSArgumentType<IDLDOMString> encodedQualifiedName)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    IGNORE_WARNINGS_BEGIN("frame-address")
    CallFrame* callFrame = DECLARE_CALL_FRAME(vm);
    IGNORE_WARNINGS_END
    JSC::JITOperationPrologueCallFrameTracer tracer(vm, callFrame);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto qualifiedName = DOMJIT::DirectConverter<IDLDOMString>::directConvert(*lexicalGlobalObject, encodedQualifiedName);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByTagName(WTFMove(qualifiedName))));
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetElementsByTagNameNSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByTagNameNS(WTFMove(namespaceURI), WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagNameNS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetElementsByTagNameNSBody>(*lexicalGlobalObject, *callFrame, "getElementsByTagNameNS");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetElementsByClassNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLCollection>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getElementsByClassName(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByClassName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetElementsByClassNameBody>(*lexicalGlobalObject, *callFrame, "getElementsByClassName");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionInsertAdjacentElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto where = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "element", "Element", "insertAdjacentElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.insertAdjacentElement(WTFMove(where), *element)));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionInsertAdjacentElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionInsertAdjacentElementBody>(*lexicalGlobalObject, *callFrame, "insertAdjacentElement");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionInsertAdjacentTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto where = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto data = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.insertAdjacentText(WTFMove(where), WTFMove(data)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionInsertAdjacentText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionInsertAdjacentTextBody>(*lexicalGlobalObject, *callFrame, "insertAdjacentText");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetClientRectsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRectList>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getClientRects()));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetClientRects(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetClientRectsBody>(*lexicalGlobalObject, *callFrame, "getClientRects");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetBoundingClientRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getBoundingClientRect()));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetBoundingClientRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetBoundingClientRectBody>(*lexicalGlobalObject, *callFrame, "getBoundingClientRect");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollIntoViewBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto arg = callFrame->argument(0).isUndefined() ? Optional<Converter<IDLUnion<IDLBoolean, IDLDictionary<ScrollIntoViewOptions>>>::ReturnType>() : Optional<Converter<IDLUnion<IDLBoolean, IDLDictionary<ScrollIntoViewOptions>>>::ReturnType>(convert<IDLUnion<IDLBoolean, IDLDictionary<ScrollIntoViewOptions>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollIntoView(WTFMove(arg));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoView(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionScrollIntoViewBody>(*lexicalGlobalObject, *callFrame, "scrollIntoView");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScroll1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto options = convert<IDLDictionary<ScrollToOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollTo(WTFMove(options));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScroll2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsElementPrototypeFunctionScroll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsElementPrototypeFunctionScroll1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsElementPrototypeFunctionScroll2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScroll(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionScrollOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "scroll");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollTo1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto options = convert<IDLDictionary<ScrollToOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollTo(WTFMove(options));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollTo2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollToOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsElementPrototypeFunctionScrollTo1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsElementPrototypeFunctionScrollTo1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsElementPrototypeFunctionScrollTo2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionScrollToOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "scrollTo");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollBy1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto option = convert<IDLDictionary<ScrollToOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollBy(WTFMove(option));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollBy2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollBy(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollByOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsElementPrototypeFunctionScrollBy1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsElementPrototypeFunctionScrollBy1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsElementPrototypeFunctionScrollBy2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollBy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionScrollByOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "scrollBy");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionInsertAdjacentHTMLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto position = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.insertAdjacentHTML(WTFMove(position), WTFMove(text)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionInsertAdjacentHTML(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionInsertAdjacentHTMLBody>(*lexicalGlobalObject, *callFrame, "insertAdjacentHTML");
}

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsElementPrototypeFunctionWebkitRequestFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.webkitRequestFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullScreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionWebkitRequestFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitRequestFullScreen");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsElementPrototypeFunctionWebkitRequestFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.webkitRequestFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitRequestFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionWebkitRequestFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitRequestFullscreen");
}

#endif

#if ENABLE(POINTER_EVENTS)
static inline JSC::EncodedJSValue jsElementPrototypeFunctionSetPointerCaptureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pointerId = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPointerCapture(WTFMove(pointerId)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionSetPointerCapture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionSetPointerCaptureBody>(*lexicalGlobalObject, *callFrame, "setPointerCapture");
}

#endif

#if ENABLE(POINTER_EVENTS)
static inline JSC::EncodedJSValue jsElementPrototypeFunctionReleasePointerCaptureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pointerId = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.releasePointerCapture(WTFMove(pointerId)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionReleasePointerCapture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionReleasePointerCaptureBody>(*lexicalGlobalObject, *callFrame, "releasePointerCapture");
}

#endif

#if ENABLE(POINTER_EVENTS)
static inline JSC::EncodedJSValue jsElementPrototypeFunctionHasPointerCaptureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pointerId = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasPointerCapture(WTFMove(pointerId))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionHasPointerCapture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionHasPointerCaptureBody>(*lexicalGlobalObject, *callFrame, "hasPointerCapture");
}

#endif

#if ENABLE(POINTER_LOCK)
static inline JSC::EncodedJSValue jsElementPrototypeFunctionRequestPointerLockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.requestPointerLock();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRequestPointerLock(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionRequestPointerLockBody>(*lexicalGlobalObject, *callFrame, "requestPointerLock");
}

#endif

static inline JSC::EncodedJSValue jsElementPrototypeFunctionScrollIntoViewIfNeededBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto centerIfNeeded = callFrame->argument(0).isUndefined() ? true : convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.scrollIntoViewIfNeeded(WTFMove(centerIfNeeded));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoViewIfNeeded(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionScrollIntoViewIfNeededBody>(*lexicalGlobalObject, *callFrame, "scrollIntoViewIfNeeded");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionAnimateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto keyframes = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeAnimationOptions>>>::ReturnType>() : Optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeAnimationOptions>>>::ReturnType>(convert<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeAnimationOptions>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebAnimation>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.animate(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(keyframes), WTFMove(options))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAnimate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionAnimateBody>(*lexicalGlobalObject, *callFrame, "animate");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionGetAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto options = convert<IDLDictionary<GetAnimationsOptions>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<WebAnimation>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAnimations(WTFMove(options))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAnimations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionGetAnimationsBody>(*lexicalGlobalObject, *callFrame, "getAnimations");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionBeforeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.before(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionBefore(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionBeforeBody>(*lexicalGlobalObject, *callFrame, "before");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionAfterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.after(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAfter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionAfterBody>(*lexicalGlobalObject, *callFrame, "after");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionReplaceWithBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.replaceWith(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionReplaceWith(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionReplaceWithBody>(*lexicalGlobalObject, *callFrame, "replaceWith");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionRemoveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.remove());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionRemove(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionRemoveBody>(*lexicalGlobalObject, *callFrame, "remove");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionPrependBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.prepend(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionPrepend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionPrependBody>(*lexicalGlobalObject, *callFrame, "prepend");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionAppendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    auto nodes = convertVariadicArguments<IDLUnion<IDLInterface<Node>, IDLDOMString>>(*lexicalGlobalObject, *callFrame, 0);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.append(WTFMove(nodes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionAppend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionAppendBody>(*lexicalGlobalObject, *callFrame, "append");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionQuerySelectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.querySelector(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelector(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionQuerySelectorBody>(*lexicalGlobalObject, *callFrame, "querySelector");
}

static inline JSC::EncodedJSValue jsElementPrototypeFunctionQuerySelectorAllBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto selectors = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<NodeList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.querySelectorAll(WTFMove(selectors))));
}

EncodedJSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelectorAll(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSElement>::call<jsElementPrototypeFunctionQuerySelectorAllBody>(*lexicalGlobalObject, *callFrame, "querySelectorAll");
}

void JSElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

Element* JSElement::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSElement*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
