/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEventSource.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> EventSource::Init convertDictionary<EventSource::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    EventSource::Init result;
    JSValue withCredentialsValue;
    if (isNullOrUndefined)
        withCredentialsValue = jsUndefined();
    else {
        withCredentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "withCredentials"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!withCredentialsValue.isUndefined()) {
        result.withCredentials = convert<IDLBoolean>(lexicalGlobalObject, withCredentialsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.withCredentials = false;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsEventSourcePrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsEventSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSEventSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventSourceURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceUrl(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceWithCredentials(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsEventSourceOnopen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSEventSourceOnopen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventSourceOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSEventSourceOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsEventSourceOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSEventSourceOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSEventSourcePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEventSourcePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEventSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSEventSourcePrototype>(vm.heap)) JSEventSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEventSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEventSourcePrototype, JSEventSourcePrototype::Base);

using JSEventSourceConstructor = JSDOMConstructor<JSEventSource>;

/* Hash table for constructor */

static const HashTableValue JSEventSourceConstructorTableValues[] =
{
    { "CONNECTING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPEN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CLOSED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

static_assert(EventSource::CONNECTING == 0, "CONNECTING in EventSource does not match value from IDL");
static_assert(EventSource::OPEN == 1, "OPEN in EventSource does not match value from IDL");
static_assert(EventSource::CLOSED == 2, "CLOSED in EventSource does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL JSEventSourceConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSEventSourceConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "EventSource");
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventSourceInitDict = convert<IDLDictionary<EventSource::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = EventSource::create(*context, WTFMove(url), WTFMove(eventSourceInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<EventSource>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSEventSourceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSEventSourceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSEventSource::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("EventSource"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSEventSource::info(), JSEventSourceConstructorTableValues, *this);
}

template<> const ClassInfo JSEventSourceConstructor::s_info = { "EventSource", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEventSourceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSEventSourcePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceConstructor) } },
    { "URL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "withCredentials", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceWithCredentials), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onopen", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceOnopen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceOnopen) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceOnmessage) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSourceOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventSourceOnerror) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsEventSourcePrototypeFunctionClose), (intptr_t) (0) } },
    { "CONNECTING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "OPEN", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CLOSED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
};

const ClassInfo JSEventSourcePrototype::s_info = { "EventSourcePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEventSourcePrototype) };

void JSEventSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEventSource::info(), JSEventSourcePrototypeTableValues, *this);
}

const ClassInfo JSEventSource::s_info = { "EventSource", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEventSource) };

JSEventSource::JSEventSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EventSource>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSEventSource::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, EventSource>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSEventSource::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSEventSourcePrototype::create(vm, &globalObject, JSEventSourcePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSEventSource::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEventSource>(vm, globalObject);
}

JSValue JSEventSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEventSourceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSEventSource* IDLAttribute<JSEventSource>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSEventSource*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSEventSource* IDLOperation<JSEventSource>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSEventSource*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsEventSourceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSEventSourcePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSEventSource::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSEventSourceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSEventSourcePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsEventSourceURLGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url());
    return result;
}

EncodedJSValue jsEventSourceURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "URL");
}

static inline JSValue jsEventSourceUrlGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url());
    return result;
}

EncodedJSValue jsEventSourceUrl(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceUrlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "url");
}

static inline JSValue jsEventSourceWithCredentialsGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.withCredentials());
    return result;
}

EncodedJSValue jsEventSourceWithCredentials(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceWithCredentialsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "withCredentials");
}

static inline JSValue jsEventSourceReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsEventSourceReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsEventSourceOnopenGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().openEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsEventSourceOnopen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceOnopenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onopen");
}

static inline bool setJSEventSourceOnopenSetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().openEvent, value);
    return true;
}

bool setJSEventSourceOnopen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSEventSource>::set<setJSEventSourceOnopenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onopen");
}

static inline JSValue jsEventSourceOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsEventSourceOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceOnmessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSEventSourceOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSEventSourceOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSEventSource>::set<setJSEventSourceOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsEventSourceOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsEventSourceOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSEventSource>::get<jsEventSourceOnerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSEventSourceOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSEventSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().errorEvent, value);
    return true;
}

bool setJSEventSourceOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSEventSource>::set<setJSEventSourceOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSC::EncodedJSValue jsEventSourcePrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEventSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventSourcePrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSEventSource>::call<jsEventSourcePrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

void JSEventSource::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEventSource*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSEventSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsEventSource = jsCast<JSEventSource*>(handle.slot()->asCell());
    if (jsEventSource->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsEventSource->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSEventSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEventSource = static_cast<JSEventSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEventSource->wrapped(), jsEventSource);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EventSource@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11EventSourceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EventSource>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7EventSource@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11EventSourceE[2];
#endif

    // If this fails EventSource does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<EventSource>::value, "EventSource is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // EventSource has subclasses. If EventSource has subclasses that get passed
    // to toJS() we currently require EventSource you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<EventSource>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EventSource& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EventSource* JSEventSource::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEventSource*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
