/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSFetchEvent.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchRequest.h"
#include "JSFetchResponse.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> FetchEvent::Init convertDictionary<FetchEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FetchEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue clientIdValue;
    if (isNullOrUndefined)
        clientIdValue = jsUndefined();
    else {
        clientIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientIdValue.isUndefined()) {
        result.clientId = convert<IDLDOMString>(lexicalGlobalObject, clientIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientId = emptyString();
    JSValue requestValue;
    if (isNullOrUndefined)
        requestValue = jsUndefined();
    else {
        requestValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "request"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requestValue.isUndefined()) {
        result.request = convert<IDLInterface<FetchRequest>>(lexicalGlobalObject, requestValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "request", "FetchEventInit", "FetchRequest");
        return { };
    }
    JSValue reservedClientIdValue;
    if (isNullOrUndefined)
        reservedClientIdValue = jsUndefined();
    else {
        reservedClientIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "reservedClientId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!reservedClientIdValue.isUndefined()) {
        result.reservedClientId = convert<IDLDOMString>(lexicalGlobalObject, reservedClientIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.reservedClientId = emptyString();
    JSValue targetClientIdValue;
    if (isNullOrUndefined)
        targetClientIdValue = jsUndefined();
    else {
        targetClientIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetClientId"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetClientIdValue.isUndefined()) {
        result.targetClientId = convert<IDLDOMString>(lexicalGlobalObject, targetClientIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.targetClientId = emptyString();
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFetchEventPrototypeFunctionRespondWith(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFetchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFetchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFetchEventRequest(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchEventClientId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchEventReservedClientId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchEventTargetClientId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSFetchEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFetchEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchEventPrototype>(vm.heap)) JSFetchEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchEventPrototype, JSFetchEventPrototype::Base);

using JSFetchEventConstructor = JSDOMConstructor<JSFetchEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSFetchEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSFetchEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<FetchEvent::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = FetchEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSFetchEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSExtendableEvent::getConstructor(vm, &globalObject);
}

template<> void JSFetchEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFetchEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FetchEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFetchEventConstructor::s_info = { "FetchEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFetchEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFetchEventConstructor) } },
    { "request", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchEventRequest), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clientId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchEventClientId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "reservedClientId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchEventReservedClientId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "targetClientId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchEventTargetClientId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "respondWith", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchEventPrototypeFunctionRespondWith), (intptr_t) (1) } },
};

const ClassInfo JSFetchEventPrototype::s_info = { "FetchEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchEventPrototype) };

void JSFetchEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchEvent::info(), JSFetchEventPrototypeTableValues, *this);
}

const ClassInfo JSFetchEvent::s_info = { "FetchEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchEvent) };

JSFetchEvent::JSFetchEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchEvent>&& impl)
    : JSExtendableEvent(structure, globalObject, WTFMove(impl))
{
}

void JSFetchEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, FetchEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSFetchEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFetchEventPrototype::create(vm, &globalObject, JSFetchEventPrototype::createStructure(vm, &globalObject, JSExtendableEvent::prototype(vm, globalObject)));
}

JSObject* JSFetchEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFetchEvent>(vm, globalObject);
}

JSValue JSFetchEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSFetchEvent* IDLAttribute<JSFetchEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSFetchEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSFetchEvent* IDLOperation<JSFetchEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFetchEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFetchEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFetchEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFetchEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsFetchEventRequestGetter(JSGlobalObject& lexicalGlobalObject, JSFetchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<FetchRequest>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.request());
    return result;
}

EncodedJSValue jsFetchEventRequest(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchEvent>::get<jsFetchEventRequestGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "request");
}

static inline JSValue jsFetchEventClientIdGetter(JSGlobalObject& lexicalGlobalObject, JSFetchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.clientId());
    return result;
}

EncodedJSValue jsFetchEventClientId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchEvent>::get<jsFetchEventClientIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "clientId");
}

static inline JSValue jsFetchEventReservedClientIdGetter(JSGlobalObject& lexicalGlobalObject, JSFetchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.reservedClientId());
    return result;
}

EncodedJSValue jsFetchEventReservedClientId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchEvent>::get<jsFetchEventReservedClientIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "reservedClientId");
}

static inline JSValue jsFetchEventTargetClientIdGetter(JSGlobalObject& lexicalGlobalObject, JSFetchEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.targetClientId());
    return result;
}

EncodedJSValue jsFetchEventTargetClientId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchEvent>::get<jsFetchEventTargetClientIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "targetClientId");
}

static inline JSC::EncodedJSValue jsFetchEventPrototypeFunctionRespondWithBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFetchEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto r = convert<IDLPromise<IDLInterface<FetchResponse>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.respondWith(r.releaseNonNull()));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchEventPrototypeFunctionRespondWith(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFetchEvent>::call<jsFetchEventPrototypeFunctionRespondWithBody>(*lexicalGlobalObject, *callFrame, "respondWith");
}

void JSFetchEvent::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSFetchEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSFetchEvent::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSFetchEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSFetchEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFetchEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FetchEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10FetchEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FetchEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7FetchEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10FetchEventE[2];
#endif

    // If this fails FetchEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<FetchEvent>::value, "FetchEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // FetchEvent has subclasses. If FetchEvent has subclasses that get passed
    // to toJS() we currently require FetchEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<FetchEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FetchEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FetchEvent* JSFetchEvent::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchEvent*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
