/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchReferrerPolicy.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchReferrerPolicy enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("no-referrer"),
        MAKE_STATIC_STRING_IMPL("no-referrer-when-downgrade"),
        MAKE_STATIC_STRING_IMPL("same-origin"),
        MAKE_STATIC_STRING_IMPL("origin"),
        MAKE_STATIC_STRING_IMPL("strict-origin"),
        MAKE_STATIC_STRING_IMPL("origin-when-cross-origin"),
        MAKE_STATIC_STRING_IMPL("strict-origin-when-cross-origin"),
        MAKE_STATIC_STRING_IMPL("unsafe-url"),
    };
    static_assert(static_cast<size_t>(FetchReferrerPolicy::EmptyString) == 0, "FetchReferrerPolicy::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::NoReferrer) == 1, "FetchReferrerPolicy::NoReferrer is not 1 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::NoReferrerWhenDowngrade) == 2, "FetchReferrerPolicy::NoReferrerWhenDowngrade is not 2 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::SameOrigin) == 3, "FetchReferrerPolicy::SameOrigin is not 3 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::Origin) == 4, "FetchReferrerPolicy::Origin is not 4 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::StrictOrigin) == 5, "FetchReferrerPolicy::StrictOrigin is not 5 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::OriginWhenCrossOrigin) == 6, "FetchReferrerPolicy::OriginWhenCrossOrigin is not 6 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::StrictOriginWhenCrossOrigin) == 7, "FetchReferrerPolicy::StrictOriginWhenCrossOrigin is not 7 as expected");
    static_assert(static_cast<size_t>(FetchReferrerPolicy::UnsafeUrl) == 8, "FetchReferrerPolicy::UnsafeUrl is not 8 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FetchReferrerPolicy enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FetchReferrerPolicy> parseEnumeration<FetchReferrerPolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue.isEmpty())
        return FetchReferrerPolicy::EmptyString;
    if (stringValue == "no-referrer")
        return FetchReferrerPolicy::NoReferrer;
    if (stringValue == "no-referrer-when-downgrade")
        return FetchReferrerPolicy::NoReferrerWhenDowngrade;
    if (stringValue == "same-origin")
        return FetchReferrerPolicy::SameOrigin;
    if (stringValue == "origin")
        return FetchReferrerPolicy::Origin;
    if (stringValue == "strict-origin")
        return FetchReferrerPolicy::StrictOrigin;
    if (stringValue == "origin-when-cross-origin")
        return FetchReferrerPolicy::OriginWhenCrossOrigin;
    if (stringValue == "strict-origin-when-cross-origin")
        return FetchReferrerPolicy::StrictOriginWhenCrossOrigin;
    if (stringValue == "unsafe-url")
        return FetchReferrerPolicy::UnsafeUrl;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FetchReferrerPolicy>()
{
    return "\"\", \"no-referrer\", \"no-referrer-when-downgrade\", \"same-origin\", \"origin\", \"strict-origin\", \"origin-when-cross-origin\", \"strict-origin-when-cross-origin\", \"unsafe-url\"";
}

} // namespace WebCore
