/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchRequestMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchRequestMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("navigate"),
        MAKE_STATIC_STRING_IMPL("same-origin"),
        MAKE_STATIC_STRING_IMPL("no-cors"),
        MAKE_STATIC_STRING_IMPL("cors"),
    };
    static_assert(static_cast<size_t>(FetchRequestMode::Navigate) == 0, "FetchRequestMode::Navigate is not 0 as expected");
    static_assert(static_cast<size_t>(FetchRequestMode::SameOrigin) == 1, "FetchRequestMode::SameOrigin is not 1 as expected");
    static_assert(static_cast<size_t>(FetchRequestMode::NoCors) == 2, "FetchRequestMode::NoCors is not 2 as expected");
    static_assert(static_cast<size_t>(FetchRequestMode::Cors) == 3, "FetchRequestMode::Cors is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FetchRequestMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FetchRequestMode> parseEnumeration<FetchRequestMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "navigate")
        return FetchRequestMode::Navigate;
    if (stringValue == "same-origin")
        return FetchRequestMode::SameOrigin;
    if (stringValue == "no-cors")
        return FetchRequestMode::NoCors;
    if (stringValue == "cors")
        return FetchRequestMode::Cors;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FetchRequestMode>()
{
    return "\"navigate\", \"same-origin\", \"no-cors\", \"cors\"";
}

} // namespace WebCore
