/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFetchResponse.h"

#include "ActiveDOMObject.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFetchHeaders.h"
#include "JSFetchResponse.h"
#include "JSReadableStream.h"
#include "JSURLSearchParams.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FetchResponse::Type enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("basic"),
        MAKE_STATIC_STRING_IMPL("cors"),
        MAKE_STATIC_STRING_IMPL("default"),
        MAKE_STATIC_STRING_IMPL("error"),
        MAKE_STATIC_STRING_IMPL("opaque"),
        MAKE_STATIC_STRING_IMPL("opaqueredirect"),
    };
    static_assert(static_cast<size_t>(FetchResponse::Type::Basic) == 0, "FetchResponse::Type::Basic is not 0 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Cors) == 1, "FetchResponse::Type::Cors is not 1 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Default) == 2, "FetchResponse::Type::Default is not 2 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Error) == 3, "FetchResponse::Type::Error is not 3 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Opaque) == 4, "FetchResponse::Type::Opaque is not 4 as expected");
    static_assert(static_cast<size_t>(FetchResponse::Type::Opaqueredirect) == 5, "FetchResponse::Type::Opaqueredirect is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FetchResponse::Type enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FetchResponse::Type> parseEnumeration<FetchResponse::Type>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "basic")
        return FetchResponse::Type::Basic;
    if (stringValue == "cors")
        return FetchResponse::Type::Cors;
    if (stringValue == "default")
        return FetchResponse::Type::Default;
    if (stringValue == "error")
        return FetchResponse::Type::Error;
    if (stringValue == "opaque")
        return FetchResponse::Type::Opaque;
    if (stringValue == "opaqueredirect")
        return FetchResponse::Type::Opaqueredirect;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FetchResponse::Type>()
{
    return "\"basic\", \"cors\", \"default\", \"error\", \"opaque\", \"opaqueredirect\"";
}

template<> FetchResponse::Init convertDictionary<FetchResponse::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    FetchResponse::Init result;
    JSValue headersValue;
    if (isNullOrUndefined)
        headersValue = jsUndefined();
    else {
        headersValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headers"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headersValue.isUndefined()) {
        result.headers = convert<IDLUnion<IDLSequence<IDLSequence<IDLByteString>>, IDLRecord<IDLByteString, IDLByteString>>>(lexicalGlobalObject, headersValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue statusValue;
    if (isNullOrUndefined)
        statusValue = jsUndefined();
    else {
        statusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "status"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!statusValue.isUndefined()) {
        result.status = convert<IDLUnsignedShort>(lexicalGlobalObject, statusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.status = 200;
    JSValue statusTextValue;
    if (isNullOrUndefined)
        statusTextValue = jsUndefined();
    else {
        statusTextValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "statusText"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!statusTextValue.isUndefined()) {
        result.statusText = convert<IDLByteString>(lexicalGlobalObject, statusTextValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.statusText = emptyString();
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponseConstructorFunctionError(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponseConstructorFunctionRedirect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionClone(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionArrayBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionBlob(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionFormData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionJson(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionText(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFetchResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFetchResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFetchResponseType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseUrl(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseRedirected(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseOk(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseStatusText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseHeaders(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseBody(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFetchResponseBodyUsed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSFetchResponsePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFetchResponsePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFetchResponsePrototype* ptr = new (NotNull, JSC::allocateCell<JSFetchResponsePrototype>(vm.heap)) JSFetchResponsePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFetchResponsePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFetchResponsePrototype, JSFetchResponsePrototype::Base);

using JSFetchResponseConstructor = JSDOMConstructor<JSFetchResponse>;

/* Hash table for constructor */

static const HashTableValue JSFetchResponseConstructorTableValues[] =
{
    { "error", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponseConstructorFunctionError), (intptr_t) (0) } },
    { "redirect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponseConstructorFunctionRedirect), (intptr_t) (1) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSFetchResponseConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSFetchResponseConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "Response");
    auto body = callFrame->argument(0).isUndefined() ? WTF::nullopt : convert<IDLNullable<IDLUnion<IDLInterface<Blob>, IDLArrayBufferView, IDLArrayBuffer, IDLInterface<DOMFormData>, IDLInterface<URLSearchParams>, IDLInterface<ReadableStream>, IDLUSVString>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto init = convert<IDLDictionary<FetchResponse::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = FetchResponse::create(*context, WTFMove(body), WTFMove(init));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSFetchResponseConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFetchResponseConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFetchResponse::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Response"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSFetchResponse::info(), JSFetchResponseConstructorTableValues, *this);
}

template<> const ClassInfo JSFetchResponseConstructor::s_info = { "Response", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchResponseConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFetchResponsePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFetchResponseConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "url", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseUrl), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "redirected", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseRedirected), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "status", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ok", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseOk), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "statusText", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseStatusText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "headers", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseHeaders), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "body", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseBody), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "bodyUsed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFetchResponseBodyUsed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "clone", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponsePrototypeFunctionClone), (intptr_t) (0) } },
    { "arrayBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponsePrototypeFunctionArrayBuffer), (intptr_t) (0) } },
    { "blob", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponsePrototypeFunctionBlob), (intptr_t) (0) } },
    { "formData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponsePrototypeFunctionFormData), (intptr_t) (0) } },
    { "json", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponsePrototypeFunctionJson), (intptr_t) (0) } },
    { "text", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFetchResponsePrototypeFunctionText), (intptr_t) (0) } },
};

const ClassInfo JSFetchResponsePrototype::s_info = { "ResponsePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchResponsePrototype) };

void JSFetchResponsePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFetchResponse::info(), JSFetchResponsePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("arrayBuffer"), strlen("arrayBuffer"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("blob"), strlen("blob"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("formData"), strlen("formData"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("json"), strlen("json"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("text"), strlen("text"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("body"), strlen("body"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("bodyUsed"), strlen("bodyUsed"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSFetchResponse::s_info = { "Response", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFetchResponse) };

JSFetchResponse::JSFetchResponse(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FetchResponse>&& impl)
    : JSDOMWrapper<FetchResponse>(structure, globalObject, WTFMove(impl))
{
}

void JSFetchResponse::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FetchResponse>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFetchResponse::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFetchResponsePrototype::create(vm, &globalObject, JSFetchResponsePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSFetchResponse::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFetchResponse>(vm, globalObject);
}

JSValue JSFetchResponse::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFetchResponseConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFetchResponse::destroy(JSC::JSCell* cell)
{
    JSFetchResponse* thisObject = static_cast<JSFetchResponse*>(cell);
    thisObject->JSFetchResponse::~JSFetchResponse();
}

template<> inline JSFetchResponse* IDLAttribute<JSFetchResponse>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSFetchResponse*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSFetchResponse* IDLOperation<JSFetchResponse>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFetchResponse*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFetchResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFetchResponse::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFetchResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFetchResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsFetchResponseTypeGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FetchResponse::Type>>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsFetchResponseType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsFetchResponseUrlGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url());
    return result;
}

EncodedJSValue jsFetchResponseUrl(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseUrlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "url");
}

static inline JSValue jsFetchResponseRedirectedGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.redirected());
    return result;
}

EncodedJSValue jsFetchResponseRedirected(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseRedirectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "redirected");
}

static inline JSValue jsFetchResponseStatusGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.status());
    return result;
}

EncodedJSValue jsFetchResponseStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseStatusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "status");
}

static inline JSValue jsFetchResponseOkGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ok());
    return result;
}

EncodedJSValue jsFetchResponseOk(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseOkGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ok");
}

static inline JSValue jsFetchResponseStatusTextGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLByteString>(lexicalGlobalObject, throwScope, impl.statusText());
    return result;
}

EncodedJSValue jsFetchResponseStatusText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseStatusTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "statusText");
}

static inline JSValue jsFetchResponseHeadersGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<FetchHeaders>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.headers());
    return result;
}

EncodedJSValue jsFetchResponseHeaders(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseHeadersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "headers");
}

static inline JSValue jsFetchResponseBodyGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<ReadableStream>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.readableStream(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)));
    return result;
}

EncodedJSValue jsFetchResponseBody(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseBodyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "body");
}

static inline JSValue jsFetchResponseBodyUsedGetter(JSGlobalObject& lexicalGlobalObject, JSFetchResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.bodyUsed());
    return result;
}

EncodedJSValue jsFetchResponseBodyUsed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFetchResponse>::get<jsFetchResponseBodyUsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bodyUsed");
}

static inline JSC::EncodedJSValue jsFetchResponseConstructorFunctionErrorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), FetchResponse::error(*context)));
}

EncodedJSValue JSC_HOST_CALL jsFetchResponseConstructorFunctionError(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFetchResponse>::callStatic<jsFetchResponseConstructorFunctionErrorBody>(*lexicalGlobalObject, *callFrame, "error");
}

static inline JSC::EncodedJSValue jsFetchResponseConstructorFunctionRedirectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto status = callFrame->argument(1).isUndefined() ? 302 : convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, FetchResponse::redirect(*context, WTFMove(url), WTFMove(status))));
}

EncodedJSValue JSC_HOST_CALL jsFetchResponseConstructorFunctionRedirect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFetchResponse>::callStatic<jsFetchResponseConstructorFunctionRedirectBody>(*lexicalGlobalObject, *callFrame, "redirect");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunctionCloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFetchResponse>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FetchResponse>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.clone(*context)));
}

EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionClone(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFetchResponse>::call<jsFetchResponsePrototypeFunctionCloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunctionArrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.arrayBuffer(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionArrayBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunctionArrayBufferBody>(*lexicalGlobalObject, *callFrame, "arrayBuffer");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunctionBlobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.blob(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionBlob(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunctionBlobBody>(*lexicalGlobalObject, *callFrame, "blob");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunctionFormDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.formData(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionFormData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunctionFormDataBody>(*lexicalGlobalObject, *callFrame, "formData");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunctionJsonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.json(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionJson(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunctionJsonBody>(*lexicalGlobalObject, *callFrame, "json");
}

static inline JSC::EncodedJSValue jsFetchResponsePrototypeFunctionTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFetchResponse>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.text(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFetchResponsePrototypeFunctionText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFetchResponse>::call<jsFetchResponsePrototypeFunctionTextBody>(*lexicalGlobalObject, *callFrame, "text");
}

void JSFetchResponse::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFetchResponse*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFetchResponseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFetchResponse = jsCast<JSFetchResponse*>(handle.slot()->asCell());
    if (jsFetchResponse->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFetchResponseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFetchResponse = static_cast<JSFetchResponse*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFetchResponse->wrapped(), jsFetchResponse);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FetchResponse@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13FetchResponseE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FetchResponse>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7FetchResponse@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13FetchResponseE[2];
#endif

    // If this fails FetchResponse does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<FetchResponse>::value, "FetchResponse is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // FetchResponse has subclasses. If FetchResponse has subclasses that get passed
    // to toJS() we currently require FetchResponse you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<FetchResponse>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FetchResponse& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FetchResponse* JSFetchResponse::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFetchResponse*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
