/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "FileSystemDirectoryEntry.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMWrapper.h"
#include "JSFileSystemEntry.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSFileSystemDirectoryEntry : public JSFileSystemEntry {
public:
    using Base = JSFileSystemEntry;
    using DOMWrapped = FileSystemDirectoryEntry;
    static JSFileSystemDirectoryEntry* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<FileSystemDirectoryEntry>&& impl)
    {
        JSFileSystemDirectoryEntry* ptr = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryEntry>(globalObject->vm().heap)) JSFileSystemDirectoryEntry(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    FileSystemDirectoryEntry& wrapped() const
    {
        return static_cast<FileSystemDirectoryEntry&>(Base::wrapped());
    }
protected:
    JSFileSystemDirectoryEntry(JSC::Structure*, JSDOMGlobalObject&, Ref<FileSystemDirectoryEntry>&&);

    void finishCreation(JSC::VM&);
};

class JSFileSystemDirectoryEntryOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, FileSystemDirectoryEntry*)
{
    static NeverDestroyed<JSFileSystemDirectoryEntryOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(FileSystemDirectoryEntry* wrappableObject)
{
    return wrappableObject;
}


template<> struct JSDOMWrapperConverterTraits<FileSystemDirectoryEntry> {
    using WrapperClass = JSFileSystemDirectoryEntry;
    using ToWrappedReturnType = FileSystemDirectoryEntry*;
};
template<> FileSystemDirectoryEntry::Flags convertDictionary<FileSystemDirectoryEntry::Flags>(JSC::JSGlobalObject&, JSC::JSValue);


} // namespace WebCore
