/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemDirectoryReader.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileSystemEntriesCallback.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryReaderPrototypeFunctionReadEntries(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFileSystemDirectoryReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFileSystemDirectoryReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSFileSystemDirectoryReaderPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemDirectoryReaderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemDirectoryReaderPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryReaderPrototype>(vm.heap)) JSFileSystemDirectoryReaderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemDirectoryReaderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryReaderPrototype, JSFileSystemDirectoryReaderPrototype::Base);

using JSFileSystemDirectoryReaderConstructor = JSDOMConstructorNotConstructable<JSFileSystemDirectoryReader>;

template<> JSValue JSFileSystemDirectoryReaderConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileSystemDirectoryReaderConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemDirectoryReader::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FileSystemDirectoryReader"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFileSystemDirectoryReaderConstructor::s_info = { "FileSystemDirectoryReader", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryReaderConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFileSystemDirectoryReaderPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileSystemDirectoryReaderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFileSystemDirectoryReaderConstructor) } },
    { "readEntries", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFileSystemDirectoryReaderPrototypeFunctionReadEntries), (intptr_t) (1) } },
};

const ClassInfo JSFileSystemDirectoryReaderPrototype::s_info = { "FileSystemDirectoryReaderPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryReaderPrototype) };

void JSFileSystemDirectoryReaderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemDirectoryReader::info(), JSFileSystemDirectoryReaderPrototypeTableValues, *this);
}

const ClassInfo JSFileSystemDirectoryReader::s_info = { "FileSystemDirectoryReader", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryReader) };

JSFileSystemDirectoryReader::JSFileSystemDirectoryReader(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemDirectoryReader>&& impl)
    : JSDOMWrapper<FileSystemDirectoryReader>(structure, globalObject, WTFMove(impl))
{
}

void JSFileSystemDirectoryReader::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FileSystemDirectoryReader>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFileSystemDirectoryReader::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFileSystemDirectoryReaderPrototype::create(vm, &globalObject, JSFileSystemDirectoryReaderPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSFileSystemDirectoryReader::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemDirectoryReader>(vm, globalObject);
}

JSValue JSFileSystemDirectoryReader::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemDirectoryReaderConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFileSystemDirectoryReader::destroy(JSC::JSCell* cell)
{
    JSFileSystemDirectoryReader* thisObject = static_cast<JSFileSystemDirectoryReader*>(cell);
    thisObject->JSFileSystemDirectoryReader::~JSFileSystemDirectoryReader();
}

template<> inline JSFileSystemDirectoryReader* IDLOperation<JSFileSystemDirectoryReader>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFileSystemDirectoryReader*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFileSystemDirectoryReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryReaderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemDirectoryReader::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFileSystemDirectoryReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryReaderPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryReaderPrototypeFunctionReadEntriesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryReader>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto successCallback = convert<IDLCallbackFunction<JSFileSystemEntriesCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback", "FileSystemDirectoryReader", "readEntries"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto errorCallback = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, callFrame->argument(1), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback", "FileSystemDirectoryReader", "readEntries"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.readEntries(*context, successCallback.releaseNonNull(), WTFMove(errorCallback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileSystemDirectoryReaderPrototypeFunctionReadEntries(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFileSystemDirectoryReader>::call<jsFileSystemDirectoryReaderPrototypeFunctionReadEntriesBody>(*lexicalGlobalObject, *callFrame, "readEntries");
}

void JSFileSystemDirectoryReader::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemDirectoryReader*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemDirectoryReaderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFileSystemDirectoryReader = jsCast<JSFileSystemDirectoryReader*>(handle.slot()->asCell());
    if (jsFileSystemDirectoryReader->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemDirectoryReaderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemDirectoryReader = static_cast<JSFileSystemDirectoryReader*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFileSystemDirectoryReader->wrapped(), jsFileSystemDirectoryReader);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileSystemDirectoryReader@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25FileSystemDirectoryReaderE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FileSystemDirectoryReader>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7FileSystemDirectoryReader@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore25FileSystemDirectoryReaderE[2];
#endif

    // If this fails FileSystemDirectoryReader does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<FileSystemDirectoryReader>::value, "FileSystemDirectoryReader is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // FileSystemDirectoryReader has subclasses. If FileSystemDirectoryReader has subclasses that get passed
    // to toJS() we currently require FileSystemDirectoryReader you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<FileSystemDirectoryReader>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FileSystemDirectoryReader& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FileSystemDirectoryReader* JSFileSystemDirectoryReader::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileSystemDirectoryReader*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
