/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFillMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FillMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("forwards"),
        MAKE_STATIC_STRING_IMPL("backwards"),
        MAKE_STATIC_STRING_IMPL("both"),
        MAKE_STATIC_STRING_IMPL("auto"),
    };
    static_assert(static_cast<size_t>(FillMode::None) == 0, "FillMode::None is not 0 as expected");
    static_assert(static_cast<size_t>(FillMode::Forwards) == 1, "FillMode::Forwards is not 1 as expected");
    static_assert(static_cast<size_t>(FillMode::Backwards) == 2, "FillMode::Backwards is not 2 as expected");
    static_assert(static_cast<size_t>(FillMode::Both) == 3, "FillMode::Both is not 3 as expected");
    static_assert(static_cast<size_t>(FillMode::Auto) == 4, "FillMode::Auto is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FillMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FillMode> parseEnumeration<FillMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "none")
        return FillMode::None;
    if (stringValue == "forwards")
        return FillMode::Forwards;
    if (stringValue == "backwards")
        return FillMode::Backwards;
    if (stringValue == "both")
        return FillMode::Both;
    if (stringValue == "auto")
        return FillMode::Auto;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FillMode>()
{
    return "\"none\", \"forwards\", \"backwards\", \"both\", \"auto\"";
}

} // namespace WebCore
