/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFontFaceSet.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMIterator.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSFontFace.h"
#include "JSFontFaceSet.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FontFaceSet::LoadStatus enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("loading"),
        MAKE_STATIC_STRING_IMPL("loaded"),
    };
    static_assert(static_cast<size_t>(FontFaceSet::LoadStatus::Loading) == 0, "FontFaceSet::LoadStatus::Loading is not 0 as expected");
    static_assert(static_cast<size_t>(FontFaceSet::LoadStatus::Loaded) == 1, "FontFaceSet::LoadStatus::Loaded is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, FontFaceSet::LoadStatus enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<FontFaceSet::LoadStatus> parseEnumeration<FontFaceSet::LoadStatus>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "loading")
        return FontFaceSet::LoadStatus::Loading;
    if (stringValue == "loaded")
        return FontFaceSet::LoadStatus::Loaded;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<FontFaceSet::LoadStatus>()
{
    return "\"loading\", \"loaded\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionHas(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionAdd(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionDelete(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionClear(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionLoad(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionCheck(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionSymbolIterator(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionEntries(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionKeys(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionValues(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionForEach(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsFontFaceSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceSetOnloading(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceSetOnloading(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetOnloadingdone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceSetOnloadingdone(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetOnloadingerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSFontFaceSetOnloadingerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsFontFaceSetReady(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsFontFaceSetStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSFontFaceSetPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFontFaceSetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontFaceSetPrototype* ptr = new (NotNull, JSC::allocateCell<JSFontFaceSetPrototype>(vm.heap)) JSFontFaceSetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFontFaceSetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFontFaceSetPrototype, JSFontFaceSetPrototype::Base);

using JSFontFaceSetConstructor = JSDOMConstructor<JSFontFaceSet>;

template<> EncodedJSValue JSC_HOST_CALL JSFontFaceSetConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSFontFaceSetConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "FontFaceSet");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto initialFaces = convert<IDLSequence<IDLInterface<FontFace>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = FontFaceSet::create(document, WTFMove(initialFaces));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<FontFaceSet>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSFontFaceSetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSFontFaceSetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSFontFaceSet::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("FontFaceSet"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSFontFaceSetConstructor::s_info = { "FontFaceSet", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceSetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSFontFaceSetPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetConstructor) } },
    { "size", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onloading", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetOnloading), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetOnloading) } },
    { "onloadingdone", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetOnloadingdone), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetOnloadingdone) } },
    { "onloadingerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetOnloadingerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSFontFaceSetOnloadingerror) } },
    { "ready", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetReady), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "status", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFontFaceSetStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "has", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionHas), (intptr_t) (1) } },
    { "add", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionAdd), (intptr_t) (1) } },
    { "delete", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionDelete), (intptr_t) (1) } },
    { "clear", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionClear), (intptr_t) (0) } },
    { "load", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionLoad), (intptr_t) (1) } },
    { "check", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionCheck), (intptr_t) (1) } },
    { "entries", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionEntries), (intptr_t) (0) } },
    { "keys", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionKeys), (intptr_t) (0) } },
    { "values", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionValues), (intptr_t) (0) } },
    { "forEach", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsFontFaceSetPrototypeFunctionForEach), (intptr_t) (1) } },
};

const ClassInfo JSFontFaceSetPrototype::s_info = { "FontFaceSetPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceSetPrototype) };

void JSFontFaceSetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFontFaceSet::info(), JSFontFaceSetPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, getDirect(vm, vm.propertyNames->builtinNames().entriesPublicName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
}

const ClassInfo JSFontFaceSet::s_info = { "FontFaceSet", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceSet) };

JSFontFaceSet::JSFontFaceSet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FontFaceSet>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSFontFaceSet::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, FontFaceSet>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSFontFaceSet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSFontFaceSetPrototype::create(vm, &globalObject, JSFontFaceSetPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSFontFaceSet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFontFaceSet>(vm, globalObject);
}

JSValue JSFontFaceSet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFontFaceSetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSFontFaceSet* IDLAttribute<JSFontFaceSet>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSFontFaceSet*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSFontFaceSet* IDLOperation<JSFontFaceSet>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSFontFaceSet*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsFontFaceSetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFontFaceSetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFontFaceSet::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSFontFaceSetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFontFaceSetPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsFontFaceSetSizeGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.size());
    return result;
}

EncodedJSValue jsFontFaceSetSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSetSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "size");
}

static inline JSValue jsFontFaceSetOnloadingGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsFontFaceSetOnloading(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSetOnloadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloading");
}

static inline bool setJSFontFaceSetOnloadingSetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadingEvent, value);
    return true;
}

bool setJSFontFaceSetOnloading(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFaceSet>::set<setJSFontFaceSetOnloadingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloading");
}

static inline JSValue jsFontFaceSetOnloadingdoneGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadingdoneEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsFontFaceSetOnloadingdone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSetOnloadingdoneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadingdone");
}

static inline bool setJSFontFaceSetOnloadingdoneSetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadingdoneEvent, value);
    return true;
}

bool setJSFontFaceSetOnloadingdone(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFaceSet>::set<setJSFontFaceSetOnloadingdoneSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadingdone");
}

static inline JSValue jsFontFaceSetOnloadingerrorGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadingerrorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsFontFaceSetOnloadingerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSetOnloadingerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onloadingerror");
}

static inline bool setJSFontFaceSetOnloadingerrorSetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadingerrorEvent, value);
    return true;
}

bool setJSFontFaceSetOnloadingerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSFontFaceSet>::set<setJSFontFaceSetOnloadingerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadingerror");
}

static inline JSValue jsFontFaceSetReadyGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLPromise<IDLInterface<FontFaceSet>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ready());
    return result;
}

EncodedJSValue jsFontFaceSetReady(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSetReadyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, "ready");
}

static inline JSValue jsFontFaceSetStatusGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<FontFaceSet::LoadStatus>>(lexicalGlobalObject, throwScope, impl.status());
    return result;
}

EncodedJSValue jsFontFaceSetStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSetStatusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "status");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunctionHasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto font = convert<IDLInterface<FontFace>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "font", "FontFaceSet", "has", "FontFace"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.has(*font)));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionHas(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionHasBody>(*lexicalGlobalObject, *callFrame, "has");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunctionAddBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto font = convert<IDLInterface<FontFace>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "font", "FontFaceSet", "add", "FontFace"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<FontFaceSet>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.add(*font)));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionAdd(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionAddBody>(*lexicalGlobalObject, *callFrame, "add");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunctionDeleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto font = convert<IDLInterface<FontFace>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "font", "FontFaceSet", "delete", "FontFace"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.remove(*font)));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionDelete(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionDeleteBody>(*lexicalGlobalObject, *callFrame, "delete");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunctionClearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clear();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionClear(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionClearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunctionLoadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFontFaceSet>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto font = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto text = callFrame->argument(1).isUndefined() ? " "_s : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.load(WTFMove(font), WTFMove(text), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionLoad(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionLoadBody>(*lexicalGlobalObject, *callFrame, "load");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunctionCheckBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto font = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto text = callFrame->argument(1).isUndefined() ? " "_s : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.check(WTFMove(font), WTFMove(text))));
}

EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionCheck(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionCheckBody>(*lexicalGlobalObject, *callFrame, "check");
}

struct FontFaceSetIteratorTraits {
    static constexpr JSDOMIteratorType type = JSDOMIteratorType::Set;
    using KeyType = void;
    using ValueType = IDLInterface<FontFace>;
};

using FontFaceSetIterator = JSDOMIterator<JSFontFaceSet, FontFaceSetIteratorTraits>;
using FontFaceSetIteratorPrototype = JSDOMIteratorPrototype<JSFontFaceSet, FontFaceSetIteratorTraits>;

template<>
const JSC::ClassInfo FontFaceSetIterator::s_info = { "FontFaceSet Iterator", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FontFaceSetIterator) };

template<>
const JSC::ClassInfo FontFaceSetIteratorPrototype::s_info = { "FontFaceSet Iterator", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FontFaceSetIteratorPrototype) };

static inline EncodedJSValue jsFontFaceSetPrototypeFunctionEntriesCaller(JSGlobalObject*, CallFrame*, JSFontFaceSet* thisObject, JSC::ThrowScope&)
{
    return JSValue::encode(iteratorCreate<FontFaceSetIterator>(*thisObject, IterationKind::Values));
}

JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionEntries(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionEntriesCaller>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunctionKeysCaller(JSGlobalObject*, CallFrame*, JSFontFaceSet* thisObject, JSC::ThrowScope&)
{
    return JSValue::encode(iteratorCreate<FontFaceSetIterator>(*thisObject, IterationKind::Keys));
}

JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionKeys(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionKeysCaller>(*lexicalGlobalObject, *callFrame, "keys");
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunctionValuesCaller(JSGlobalObject*, CallFrame*, JSFontFaceSet* thisObject, JSC::ThrowScope&)
{
    return JSValue::encode(iteratorCreate<FontFaceSetIterator>(*thisObject, IterationKind::Values));
}

JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionValues(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionValuesCaller>(*lexicalGlobalObject, *callFrame, "values");
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunctionForEachCaller(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame, JSFontFaceSet* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(iteratorForEach<FontFaceSetIterator>(*lexicalGlobalObject, *callFrame, *thisObject, throwScope));
}

JSC::EncodedJSValue JSC_HOST_CALL jsFontFaceSetPrototypeFunctionForEach(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunctionForEachCaller>(*lexicalGlobalObject, *callFrame, "forEach");
}

void JSFontFaceSet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFontFaceSet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSFontFaceSetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsFontFaceSet = jsCast<JSFontFaceSet*>(handle.slot()->asCell());
    if (jsFontFaceSet->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsFontFaceSet->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFontFaceSetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFontFaceSet = static_cast<JSFontFaceSet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsFontFaceSet->wrapped(), jsFontFaceSet);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FontFaceSet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11FontFaceSetE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FontFaceSet>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7FontFaceSet@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11FontFaceSetE[2];
#endif

    // If this fails FontFaceSet does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<FontFaceSet>::value, "FontFaceSet is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // FontFaceSet has subclasses. If FontFaceSet has subclasses that get passed
    // to toJS() we currently require FontFaceSet you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<FontFaceSet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FontFaceSet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FontFaceSet* JSFontFaceSet::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFontFaceSet*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
